from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class SeriesParallel(BaseWidget):
    """ 
:warning: **Autogenerated class**

The series in parallel coordinate system.


**Introduction about Parallel coordinates**


[Parallel Coordinates](https://en.wikipedia.org/wiki/Parallel_coordinates) is a common way of visualizing high-dimensional geometry and analyzing multivariate data.


For example, [series-parallel.data](#series-parallel.data) is the following data:



```
[
    [1,  55,  9,   56,  0.46,  18,  6,  'good'],
    [2,  25,  11,  21,  0.65,  34,  9,  'excellent'],
    [3,  56,  7,   63,  0.3,   14,  5,  'good'],
    [4,  33,  7,   29,  0.33,  16,  6,  'excellent'],
    { // Data item can also be an Object, so that perticular settings of its line can be set here.
        value: [5,  42,  24,  44,  0.76,  40,  16, 'excellent']
        lineStyle: {...},
    }
    ...
]

```

In data above, each row is a "data item", and each column represents a "dimension". For example, the meanings of columns above are: "data", "AQI", "PM2.5", "PM10", "carbon monoxide level", "nitrogen dioxide level", and "sulfur dioxide level".


Parallel coordinates are often used to visualize multi-dimension data shown above. Each axis represents a dimension (namely, a column), and each line represents a data item. Data can be brush-selected on axes. For example:



**Brief about Configuration**


Basic configuration parallel coordinates is shown as follow:



```
option = {
    parallelAxis: [                     // Definitions of axes.
        {dim: 0, name: schema[0].text}, // Each axis has a 'dim' attribute, representing dimension index in data.
        {dim: 1, name: schema[1].text},
        {dim: 2, name: schema[2].text},
        {dim: 3, name: schema[3].text},
        {dim: 4, name: schema[4].text},
        {dim: 5, name: schema[5].text},
        {dim: 6, name: schema[6].text},
        {dim: 7, name: schema[7].text,
            type: 'category',           // Also supports category data.
            data: ['Excellent', 'good', 'light pollution', 'moderate pollution', 'heavy pollution', 'severe pollution']
        }
    ],
    parallel: {                         // Definition of a parallel coordinate system.
        left: '5%',                     // Location of parallel coordinate system.
        right: '13%',
        bottom: '10%',
        top: '20%',
        parallelAxisDefault: {          // A pattern for axis definition, which can avoid repeating in `parallelAxis`.
            type: 'value',
            nameLocation: 'end',
            nameGap: 20
        }
    },
    series: [                           // Here the three series sharing the same parallel coordinate system.
        {
            name: 'Beijing',
            type: 'parallel',           // The type of this series is 'parallel'
            data: [
                [1,  55,  9,   56,  0.46,  18,  6,  'good'],
                [2,  25,  11,  21,  0.65,  34,  9,  'excellent'],
                ...
            ]
        },
        {
            name: 'Shanghai',
            type: 'parallel',
            data: [
                [3,  56,  7,   63,  0.3,   14,  5,  'good'],
                [4,  33,  7,   29,  0.33,  16,  6,  'excellent'],
                ...
            ]
        },
        {
            name: 'Guangzhou',
            type: 'parallel',
            data: [
                [4,  33,  7,   29,  0.33,  16,  6,  'excellent'],
                [5,  42,  24,  44,  0.76,  40,  16, 'excellent'],
                ...
            ]
        }
    ]
};

```

Three components are involved here: [parallel](#parallel), [parallelAxis](#parallelAxis), [series-parallel](#series-parallel)


- [parallel](#parallel)


 This component is the coordinate system. One or more series (like "Beijing", "Shanghai", and "Guangzhou" in the above example) can share one coordinate system.


 Like other coordinate systems, multiple parallel coordinate systems can be created in one echarts instance.


 Position setting is also carried out here.
- [parallelAxis](#parallelAxis)


 This is axis configuration. Multiple axes are needed in parallel coordinates.


 [parallelAxis.parallelIndex](#parallelAxis.parallelIndex) is used to specify which coordinate system this axis belongs to. The first coordinate system is used by default.
- [series-parallel](#series-parallel)


 This is the definition of parallel series, which will be drawn on parallel coordinate system.


 [parallelAxis.parallelIndex](#parallelAxis.parallelIndex) is used to specify which coordinate system this axis belongs to. The first coordinate system is used by default.


**Notes and Best Practices**


When configuring multiple [parallelAxis](#parallelAxis), there might be some common attributes in each axis configuration. To avoid writing them repeatedly, they can be put under [parallel.parallelAxisDefault](#parallel.parallelAxisDefault). Before initializing axis, configurations in [parallel.parallelAxisDefault](#parallel.parallelAxisDefault) will be merged into [parallelAxis](#parallelAxis) to generate the final axis configuration.


**If data is too large and cause bad performance**


It is suggested to set [series-parallel.lineStyle.width](#series-parallel.lineStyle.width) to be `0.5` (or less), which may improve performance significantly.


**Display High-Dimension Data**


When dimension number is extremely large, say, more than 50 dimensions, there will be more than 50 axes, which may hardly display in a page.


In this case, you may use [parallel.axisExpandable](#parallel.axisExpandable) to improve the display. See this example:




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("SeriesParallelModel").tag(sync=True)
    
    type = Unicode("parallel", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `'parallel'`


 Use parallel coordinates, with [parallelIndex](#series-parallel.parallelIndex) to assign the corresponding parallel coordinate components.""").tag(sync=True)
    
    parallelIndex = Float(None, allow_none=True, help="""Index of [parallel coordinates](#parallel) to combine with, which is useful for multiple parallel axes in one chart.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    colorBy = Unicode(None, allow_none=True, help="""> Since `v5.2.0`


The policy to take color from [option.color](#color). Valid values:


* `'series'`: assigns the colors in the palette by series, so that all data in the same series are in the same color;
* `'data'`: assigns colors in the palette according to data items, with each data item using a different color.""").tag(sync=True)
    
    lineStyle = Dict(default_value=None, allow_none=True, help="""Line style.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, ).tag(sync=True)
    
    inactiveOpacity = Float(None, allow_none=True, help="""When perform brush selection, the unselected lines will be set as this transparency rate (which could darken those lines).""").tag(sync=True)
    
    activeOpacity = Float(None, allow_none=True, help="""When perform brush selection, the selected lines will be set as this transparency rate (which could highlight those lines).""").tag(sync=True)
    
    realtime = Bool(None, allow_none=True, help="""Whether to update view in realtime.""").tag(sync=True)
    
    smooth = Union([Bool(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Whether to smooth the line. It defaults to be `false` and can be set as `true` or the values from 0 to 1 which indicating the smoothness.""").tag(sync=True)
    
    progressive = Float(None, allow_none=True, help="""`progressive` specifies the amount of graphic elements that can be rendered within a frame (about 16ms) if "progressive rendering" enabled.


When data amount is from thousand to more than 10 million, it will take too long time to render all of the graphic elements. Since ECharts 4, "progressive rendering" is supported in its workflow, which processes and renders data chunk by chunk alone with each frame, avoiding to block the UI thread of the browser.


Set `progressive: 0` to disable progressive permanently. By default, progressive is auto-enabled when data amount is bigger than `progressiveThreshold`.""").tag(sync=True)
    
    progressiveThreshold = Float(None, allow_none=True, help="""If current data amount is over the threshold, "progressive rendering" is enabled.""").tag(sync=True)
    
    progressiveChunkMode = Unicode(None, allow_none=True, help="""Chunk approach, optional values:


* `'sequential'`: slice data by data index.
* `'mod'`: slice data by mod, which make the data items of each chunk coming from all over the data, bringing better visual effect while progressive rendering.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""For example, [series-parallel.data](#series-parallel.data) is the following data:



```
[
    [1,  55,  9,   56,  0.46,  18,  6,  'good'],
    [2,  25,  11,  21,  0.65,  34,  9,  'excellent'],
    [3,  56,  7,   63,  0.3,   14,  5,  'good'],
    [4,  33,  7,   29,  0.33,  16,  6,  'excellent'],
    { // Data item can also be an Object, so that perticular settings of its line can be set here.
        value: [5,  42,  24,  44,  0.76,  40,  16, 'excellent']
        lineStyle: {...},
    }
    ...
]

```

In data above, each row is a "data item", and each column represents a "dimension". For example, the meanings of columns above are: "data", "AQI", "PM2.5", "PM10", "carbon monoxide level", "nitrogen dioxide level", and "sulfur dioxide level".""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in parallel.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in parallel, which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationThreshold = Float(None, allow_none=True, help="""Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    animationDurationUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Time for animation to complete, which supports callback function for different data to have different animation effect:



```
animationDurationUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""Easing method used for animation.""").tag(sync=True)
    
    animationDelayUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating animation, which supports callback function for different data to have different animation effects.


For example:



```
animationDelayUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
        
