from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Sunburst(BaseWidget):
    """ 
:warning: **Autogenerated class**

[Sunburst Chart](https://en.wikipedia.org/wiki/Pie_chart#Ring_chart,_sunburst_chart,_and_multilevel_pie_chart) is composed of multiple pie charts. From the view of data structure, inner rings are the parent nodes of outer rings. Therefore, it can show the partial-overall relationship as [Pie](#series-pie) charts, and also level relation as [Treemap](#series-treemap) charts.


**For example:**




**Data Drilling**


The sunburst chart supports data drilling by default, which means when a user clicks a sector, it will be used as the root node, and there will be a circle in the center used to return to the parent node. If data drilling is not needed, it can be disabled by [series-sunburst.nodeClick](#series-sunburst.nodeClick).



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("SunburstModel").tag(sync=True)
    
    type = Unicode("sunburst", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    center = Any(None, allow_none=True, help="""Center position of Sunburst chart, the first of which is the horizontal position, and the second is the vertical position.


Percentage is supported. When set in percentage, the item is relative to the container width, and the second item to the height.


**Example:** 



```
// Set to absolute pixel values
center: [400, 300]
// Set to relative percent
center: ['50%', '50%']

```""").tag(sync=True)
    
    radius = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Radius of Sunburst chart. Value can be:


* `number`: Specify outside radius directly.
* `string`: For example, `'20%'`, means that the outside radius is 20% of the viewport size (the little one between width and height of the chart container).


* `Array.<number|string>`: The first item specifies the inside radius, and the second item specifies the outside radius. Each item follows the definitions above.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""The data structure of [series-sunburst.data](#series-sunburst.data) is like tree. For example:



```
[{
    name: 'parent1',
    value: 10,          // value of parent node can be left unset, and sum of
                        // children values will be used in this case.
                        // If is set, and is larger than sum of children nodes,
                        // the reset can be used for other parts in parent.
    children: [{
        value: 5,
        name: 'child1',
        children: [{
            value: 2,
            name: 'grandchild1',
            itemStyle: {
                // every data can have its own itemStyle,
                // which will overwrites series.itemStyle and level.itemStyle
            },
            label: {
                // label style, the same to above
            }
        }]
    }, {
        value: 3,
        name: 'child2'
    }],
    itemStyle: {
        // itemStyle of parent1, which will not be inherited for children
    },
    label: {
        // label of parent1, which will not be inherited for children
    }
}, {
    name: 'parent2',
    value: 4
}]

```""").tag(sync=True)
    
    nodeClick = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The action of clicking a sector, which can be:


* `false`: nothing happens.
* `'rootToNode'`: use the clicked sector as root.
* `'link'`：if [link](#series-sunburst.data.link) is set, the page will redirect to it.""").tag(sync=True)
    
    sort = Union([Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Sorting method that sectors use based on [`value`](#series-sunburst.data.value), which is the sum of children when not set. The default value `'desc'` states for descending order, while it can also be set to be `'asc'` for ascending order, or `null` for not sorting, or callback function like:



```
function(nodeA, nodeB) {
    return nodeA.getValue() - nodeB.getValue();
}

```""").tag(sync=True)
    
    renderLabelForZeroData = Bool(None, allow_none=True, help="""If there is no `name`, whether need to render it.""").tag(sync=True)
    
    clockwise = Bool(None, allow_none=True, help="""Whether the layout of sectors of sunburst chart is clockwise.""").tag(sync=True)
    
    startAngle = Float(None, allow_none=True, help="""The start angle, which range is [0, 360].""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""To specify the style of the label of the sector.


**Priority：[series.data.label](#series-sunburst.data.label) > [series.levels.label](#series-sunburst.levels.label) > [series.label](#series-sunburst.label)。**


Text label of sunburst chart, to explain some data information about graphic item like value, name and so on. `label` is placed under `itemStyle` in ECharts 2.x. In ECharts 3, to make the configuration structure flatter, `label`is taken to be at the same level with `itemStyle`, and has `emphasis` as `itemStyle` does.""").tag(sync=True)
    
    labelLine = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configuration of label guide line.""").tag(sync=True)
    
    labelLayout = Union([Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Unified layout configuration of labels.


It provide a chance to adjust the labels' `(x, y)` position, alignment based on the original layout each series provides.


This option can be a callback with following parameters.



```
// corresponding index of data
dataIndex: number
// corresponding type of data. Only available in graph, in which it can be 'node' or 'edge'
dataType?: string
// corresponding index of series
seriesIndex: number
// Displayed text of label.
text: string
// Bounding rectangle of label.
labelRect: {x: number, y: number, width: number, height: number}
// Horizontal alignment of label.
align: 'left' | 'center' | 'right'
// Vertical alignment of label.
verticalAlign: 'top' | 'middle' | 'bottom'
// Bounding rectangle of the element corresponding to.
rect: {x: number, y: number, width: number, height: number}
// Default points array of labelLine. Currently only provided in pie and funnel series.
// It's null in other series.
labelLinePoints?: number[][]

```

**Example:**


Align the labels on the right. Left 10px margin to the edge.



```
labelLayout(params) {
    return {
        x: params.rect.x + 10,
        y: params.rect.y + params.rect.height / 2,
        verticalAlign: 'middle',
        align: 'left'
    }
}

```

Set the text size based on the size of element bounding rectangle.



```

labelLayout(params) {
    return {
        fontSize: Math.max(params.rect.width / 10, 5)
    };
}

```""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""To specify the style of the sector of the sunburst chart.


You can specify the style of all sectors with [series.itemStyle](#series-sunburst.itemStyle), or specify the style of each level of sectors with [series.levels.itemStyle](#series-sunburst.levels.itemStyle), or specify a specific style for each sector with [series.data.itemStyle](#series-sunburst.data.itemStyle). The priority is from low to high, that is, if [series.data.itemStyle](#series-sunburst.data.itemStyle) is defined, it will override [series.itemStyle](#series-sunburst.itemStyle) and [series.levels.itemStyle](#series-sunburst.levels.itemStyle).


**Priority：[series.data.itemStyle](#series-sunburst.data.itemStyle) > [series.levels.itemStyle](#series-sunburst.levels.itemStyle) > [series.itemStyle](#series-sunburst.itemStyle)。**""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Configurations of emphasis state.""").tag(sync=True)
    
    blur = Dict(default_value=None, allow_none=True, help="""Configurations of blur state. Available when [emphasis.focus](#series-sunburst.emphasis.focus) is set.""").tag(sync=True)
    
    select = Dict(default_value=None, allow_none=True, help="""Configurations of select state. Available when [selectedMode](#series-sunburst.selectedMode) is set.""").tag(sync=True)
    
    selectedMode = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Selected mode. It is enabled by default, and you may set it to be `false` to disable it.


Besides, it can be set to `'single'`, `'multiple'` or `'series'`, for single selection, multiple selections and whole series selection.



> `'series'` is supported since v5.3.0""").tag(sync=True)
    
    levels = Any(None, allow_none=True, help="""**Multiple levels**


Sunburst chart has a leveled structure. To make it convenient, we provide a `levels` option, which is an array. The first element of it is for returning to parent node when data mining. The following elements are for levels from center to outside.


For example, if we don't want the data mining, and want to set the most inside sector to be red, and text to be blue, we can set the option like:



```
series: {
    // ...
    levels: [
        {
            // Blank setting for data mining
        },
        {
            // The most inside level
            itemStyle: {
                color: 'red'
            },
            label: {
                color: 'blue'
            }
        },
        {
            // The second level
        }
    ]
}

```""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in this series.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationThreshold = Float(None, allow_none=True, help="""Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    animationDurationUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Time for animation to complete, which supports callback function for different data to have different animation effect:



```
animationDurationUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""Easing method used for animation.""").tag(sync=True)
    
    animationDelayUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating animation, which supports callback function for different data to have different animation effects.


For example:



```
animationDelayUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
        
