from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Treemap(BaseWidget):
    """ 
:warning: **Autogenerated class**

[Treemap](https://en.wikipedia.org/wiki/Treemapping) is a common way to present "hierarchical data" or "tree data". It primarily highlights the important nodes at all hierarchies in 『Tree』with area.


**Example:**



**Visual Mapping:**


treemap maps the numerical values to area.


Moreover, it is able to map some dimensions of data to other visual channel, like colors, lightness of colors and etc.


About visual encoding, see details in [series-treemap.levels](#series-treemap.levels).


**Drill Down:**


The feature `drill down` means: when clicking a tree node, this node will be set as root and its children will be shown. When [leafDepth](#series-treemap.leafDepth) is set, this feature is enabled.


**An example about drill down:**



Notice: There are some difference in treemap configuration between ECharts3 and ECharts2. Some immature configuration ways are no longer supported:


- The position method using `center/size` is no longer supported, and `left/top/bottom/right/width/height` are used to position treemap, as other components do.
- The configuration item `breadcrumb` is moved outside `itemStyle/itemStyle.emphasis`, and it is in the same level with `itemStyle` now.
- The configuration item `root` is not available temporarily.User can zoom treemap to see some tiny or deep descendants, or using [leafDepth](#series-treemap.leafDepth) to enable the feature of "drill down".
- The configuration item `label` is moved outside the `itemStyle/itemStyle.emphasis`, and it is in the same level with `itemStyle` now.
- The configuration items `itemStyle.childBorderWidth` and `itemStyle.childBorderColor` are not supported anymore (because in this way only 2 levels can be defined). [series-treemap.levels](#series-treemap.levels) is used to define all levels now.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("TreemapModel").tag(sync=True)
    
    type = Unicode("treemap", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between treemap component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between treemap component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between treemap component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between treemap component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Width of treemap component.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Height of treemap component.""").tag(sync=True)
    
    squareRatio = Float(None, allow_none=True, help="""The expected square ratio. Layout would approach the ratio as close as possible.


It defaults to be the golden ratio: `0.5 * (1 + Math.sqrt(5))`.""").tag(sync=True)
    
    leafDepth = Float(None, allow_none=True, help="""When `leafDepth` is set, the feature "drill down" is enabled, which means when clicking a tree node, this node will be set as root and its children will be shown.


`leafDepth` represents how many levels are shown at most. For example, when `leafDepth` is set to `1`, only one level will be shown.


`leafDepth` is `null`/`undefined` by default, which means that "drill down" is disabled.


**An example about drill down:**""").tag(sync=True)
    
    drillDownIcon = Unicode(None, allow_none=True, help="""Marker when the node is able to be drilled down.""").tag(sync=True)
    
    roam = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Whether to enable dragging roam (move and zoom). Optional values are:


* `false`: roam is disabled.
* `'scale'` or `'zoom'`: zoom only.
* `'move'` or `'pan'`: move (translation) only.
* `true`: both zoom and move (translation) are available.""").tag(sync=True)
    
    nodeClick = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The behaviour when clicking a node. Optional values are:


* `false`: Do nothing after clicked.
* `'zoomToNode'`: Zoom to clicked node.
* `'link'`: If there is [link](#series-treemap.data.link) in node data, do hyperlink jump after clicked.""").tag(sync=True)
    
    zoomToNodeRatio = Float(None, allow_none=True, help="""The treemap will be auto zoomed to a appropriate ratio when a node is clicked (when [nodeClick](#series-treemap.nodeClick) is set as `'zoomToNode'` and no drill down happens). This configuration item indicates the ratio.""").tag(sync=True)
    
    visualDimension = Float(None, allow_none=True, help="""`treemap` is able to map any dimensions of data to visual.


The value of [series-treemap.data](#series-treemap.data) can be an array. And each item of the array represents a "dimension". `visualDimension` specifies the dimension on which visual mapping will be performed.


About visual encoding, see details in [series-treemap.levels](#series-treemap.levels).



> Tps: In treemap, `visualDimension` attribute could appear in more than one places:



> * It could appear in [sereis-treemap](#series-treemap), indicating the unified setting of the series.



> * It could appear in each array element of [series-treemap.levels](#series-treemap.levels), indicating the unified setting of each level of the tree.



> * It could appear in each node of [series-treemap.data](#series-treemap.data), indicating the particular setting of each node.""").tag(sync=True)
    
    visualMin = Float(None, allow_none=True, help="""The minimal value of current level. Auto-statistics by default.


When [colorMappingBy](#series-treemap.levels.colorMappingBy) is set to `'value'`, you are able to specify extent manually for visual mapping by specifying `visualMin` or `visualMax`.""").tag(sync=True)
    
    visualMax = Float(None, allow_none=True, help="""The maximal value of current level. Auto-statistics by default.


When [colorMappingBy](#series-treemap.levels.colorMappingBy) is set to `'value'`, you are able to specify extent manually for visual mapping by specifying `visualMin` or `visualMax`.""").tag(sync=True)
    
    colorAlpha = Any(None, allow_none=True, help="""It indicates the range of transparent rate (color alpha) for nodes of the series


.
The range of values is 0 ~ 1.


For example, `colorAlpha` can be `[0.3, 1]`.


About visual encoding, see details in [series-treemap.levels](#series-treemap.levels).



> Tps: In treemap, `colorAlpha` attribute could appear in more than one places:



> * It could appear in [sereis-treemap](#series-treemap), indicating the unified setting of the series.



> * It could appear in each array element of [series-treemap.levels](#series-treemap.levels), indicating the unified setting of each level of the tree.



> * It could appear in each node of [series-treemap.data](#series-treemap.data), indicating the particular setting of each node.""").tag(sync=True)
    
    colorSaturation = Float(None, allow_none=True, help="""It indicates the range of saturation (color alpha) for nodes of the series.


The range of values is 0 ~ 1.


For example, `colorSaturation` can be `[0.3, 1]`.


About visual encoding, see details in [series-treemap.levels](#series-treemap.levels).



> Tps: In treemap, `colorSaturation` attribute could appear in more than one places:



> * It could appear in [sereis-treemap](#series-treemap), indicating the unified setting of the series.



> * It could appear in each array element of [series-treemap.levels](#series-treemap.levels), indicating the unified setting of each level of the tree.



> * It could appear in each node of [series-treemap.data](#series-treemap.data), indicating the particular setting of each node.""").tag(sync=True)
    
    colorMappingBy = Unicode(None, allow_none=True, help="""Specify the rule according to which each node obtain color from [color list](#series-treemap.levels.color). Optional values:


* `'value'`:


Map [series-treemap.data.value](#series-treemap.data.value) to color.


In this way, the color of each node indicate its value.


[visualDimension](#series-treemap.levels.visualDimension) can be used to specify which dimension of [data](#series-treemap.data) is used to perform visual mapping.


* `'index'`:


Map the `index` (ordinal number) of nodes to color. Namely, in a level, the first node is mapped to the first color of [color list](#series-treemap.levels.color), and the second node gets the second color.


In this way, adjacent nodes are distinguished by color.


* `'id'`:


Map [series-treemap.data.id](#series-treemap.data.id) to color.


Since `id` is used to identify node, if user call `setOption` to modify the tree, each node will remain the original color before and after `setOption` called. See this [example](https://echarts.apache.org/examples/en/editor.html?c=treemap-obama&edit=1&reset=1).


About visual encoding, see details in [series-treemap.levels](#series-treemap.levels).



> Tps: In treemap, `colorMappingBy` attribute could appear in more than one places:



> * It could appear in [sereis-treemap](#series-treemap), indicating the unified setting of the series.



> * It could appear in each array element of [series-treemap.levels](#series-treemap.levels), indicating the unified setting of each level of the tree.



> * It could appear in each node of [series-treemap.data](#series-treemap.data), indicating the particular setting of each node.""").tag(sync=True)
    
    visibleMin = Float(None, allow_none=True, help="""A node will not be shown when its area size is smaller than this value (unit: px square).


In this way, tiny nodes will be hidden, otherwise they will huddle together. When user zoom the treemap, the area size will increase and the rectangle will be shown if the area size is larger than this threshold.


About visual encoding, see details in [series-treemap.levels](#series-treemap.levels).



> Tps: In treemap, `visibleMin` attribute could appear in more than one places:



> * It could appear in [sereis-treemap](#series-treemap), indicating the unified setting of the series.



> * It could appear in each array element of [series-treemap.levels](#series-treemap.levels), indicating the unified setting of each level of the tree.



> * It could appear in each node of [series-treemap.data](#series-treemap.data), indicating the particular setting of each node.""").tag(sync=True)
    
    childrenVisibleMin = Float(None, allow_none=True, help="""Children will not be shown when area size of a node is smaller than this value (unit: px square).


This can hide the details of nodes when the rectangular area is not large enough. When users zoom nodes, the child node would show if the area is larger than this threshold.


About visual encoding, see details in [series-treemap.levels](#series-treemap.levels).



> Tps: In treemap, `childrenVisibleMin` attribute could appear in more than one places:



> * It could appear in [sereis-treemap](#series-treemap), indicating the unified setting of the series.



> * It could appear in each array element of [series-treemap.levels](#series-treemap.levels), indicating the unified setting of each level of the tree.



> * It could appear in each node of [series-treemap.data](#series-treemap.data), indicating the particular setting of each node.""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""`label` describes the style of the label in each node.



> Tps: In treemap, `label` attribute could appear in more than one places:



> * It could appear in [sereis-treemap](#series-treemap), indicating the unified setting of the series.



> * It could appear in each array element of [series-treemap.levels](#series-treemap.levels), indicating the unified setting of each level of the tree.



> * It could appear in each node of [series-treemap.data](#series-treemap.data), indicating the particular setting of each node.""").tag(sync=True)
    
    upperLabel = Dict(default_value=None, allow_none=True, help="""`upperLabel` is used to specify whether show label when the node has children. When [upperLabel.show](#series-treemap.upperLabel.show) is set as `true`, the feature that "show parent label" is enabled.


The same as [series-treemap.label](#series-treemap.label), the option `upperLabel` can be placed at the root of [series-treemap](#series-treemap) directly, or in [series-treemap.level](#series-treemap.level), or in each item of [series-treemap.data](#series-treemap.data).


Specifically, [series-treemap.label](#series-treemap.label) specifies the style when a node is a leaf, while `upperLabel` specifies the style when a node has children, in which case the label is displayed in the inner top of the node.


See:




> Tps: In treemap, `label` attribute could appear in more than one places:



> * It could appear in [sereis-treemap](#series-treemap), indicating the unified setting of the series.



> * It could appear in each array element of [series-treemap.levels](#series-treemap.levels), indicating the unified setting of each level of the tree.



> * It could appear in each node of [series-treemap.data](#series-treemap.data), indicating the particular setting of each node.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""> Tps: In treemap, `itemStyle` attribute could appear in more than one places:



> * It could appear in [sereis-treemap](#series-treemap), indicating the unified setting of the series.



> * It could appear in each array element of [series-treemap.levels](#series-treemap.levels), indicating the unified setting of each level of the tree.



> * It could appear in each node of [series-treemap.data](#series-treemap.data), indicating the particular setting of each node.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Emphasis state.""").tag(sync=True)
    
    blur = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Blur state.""").tag(sync=True)
    
    select = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Select state.""").tag(sync=True)
    
    selectedMode = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Selected mode. It is enabled by default, and you may set it to be `false` to disable it.


Besides, it can be set to `'single'`, `'multiple'` or `'series'`, for single selection, multiple selections and whole series selection.



> `'series'` is supported since v5.3.0""").tag(sync=True)
    
    breadcrumb = Dict(default_value=None, allow_none=True, help="""To show the path of the current node.""").tag(sync=True)
    
    labelLine = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configuration of label guide line.""").tag(sync=True)
    
    labelLayout = Union([Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Unified layout configuration of labels.


It provide a chance to adjust the labels' `(x, y)` position, alignment based on the original layout each series provides.


This option can be a callback with following parameters.



```
// corresponding index of data
dataIndex: number
// corresponding type of data. Only available in graph, in which it can be 'node' or 'edge'
dataType?: string
// corresponding index of series
seriesIndex: number
// Displayed text of label.
text: string
// Bounding rectangle of label.
labelRect: {x: number, y: number, width: number, height: number}
// Horizontal alignment of label.
align: 'left' | 'center' | 'right'
// Vertical alignment of label.
verticalAlign: 'top' | 'middle' | 'bottom'
// Bounding rectangle of the element corresponding to.
rect: {x: number, y: number, width: number, height: number}
// Default points array of labelLine. Currently only provided in pie and funnel series.
// It's null in other series.
labelLinePoints?: number[][]

```

**Example:**


Align the labels on the right. Left 10px margin to the edge.



```
labelLayout(params) {
    return {
        x: params.rect.x + 10,
        y: params.rect.y + params.rect.height / 2,
        verticalAlign: 'middle',
        align: 'left'
    }
}

```

Set the text size based on the size of element bounding rectangle.



```

labelLayout(params) {
    return {
        fontSize: Math.max(params.rect.width / 10, 5)
    };
}

```""").tag(sync=True)
    
    levels = Any(None, allow_none=True, help="""**Multiple Levels Configuration**


treemap adopts 4-level configuration:



```
"each node" --> "each level" --> "each series".

```
That is, we can configurate each node, can also configurate each level of the tree, or set overall configurations on each series. The highest priority is node configuration.


`levels` is configurations on each levels, which is used most.


For example:



```
// Notice that in fact the data structure is not "tree", but is "forest".
data: [
    {
        name: 'nodeA',
        children: [
            {name: 'nodeAA'},
            {name: 'nodeAB'},
        ]
    },
    {
        name: 'nodeB',
        children: [
            {name: 'nodeBA'}
        ]
    }
],
levels: [
    {...}, // configurations of the top level of the data structure "forest"
        // (the level that contains 'nodeA', 'nodeB' shown above).
    {...}, // configurations of the next level
        // (the level that contains 'nodeAA', 'nodeAB', 'nodeBA' shown above)
    {...}, // configurations of the next level
    ...
]

```

**The Rules about Visual Mapping**


When designing a treemap, we primarily focus on how to visually distinguish "different levels", "different categories in the same level", which requires appropriate settings of "rectangular color", "border thickness", "border color" and even "color saturation of rectangular" and so on on each level.


See [example](https://echarts.apache.org/examples/en/editor.html?c=treemap-disk&edit=1&reset=1). The top level is divided into several parts by colors "red", "green", "blue", and etc ... In each color block, `colorSaturation` is used to distinguish nodes in sublevel. The border color of the top level is "white", while the border color of the sublevel is the color that based on the current block color and processed by `borderColorSaturation`.


`treemap` uses this rule of visual configuration: each level computes its visual value based on the configurations (`color`, `colorSaturation`, `borderColor`, `borderColorSaturation`) on this level. If there is no certain configuration in a node, it inherits the configuration from its parent.


In this way, this effect can be configured: set a `color` list on the parent level, and set `colorSaturation` on the child level, and then each node in the parent level would obtain a color from the `color` list, and each node in the child level would obtain a value from `colorSaturation` and compound it with the color inherited from its parent node to get its final color.


**Dimensions and "Extra Visual Mapping"**


See the example below: every `value` field is set as an Array, in which each item in the array represents a dimension respectively.



```
[
    {
        value: [434, 6969, 8382],
        children: [
            {
                value: [1212, 4943, 5453],
                id: 'someid-1',
                name: 'description of this node',
                children: [...]
            },
            {
                value: [4545, 192, 439],
                id: 'someid-2',
                name: 'description of this node',
                children: [...]
            },
            ...
        ]
    },
    {
        value: [23, 59, 12],
        children: [...]
    },
    ...
]

```

`treemap` will map the first dimension (the first item of the array) to "area". If we want to express more information, we could map another dimension (specified by [series-treemap.visualDimension](#series-treemap.viusalDimension)) to another visual types, such as `colorSaturation` and so on. See the [example](https://echarts.apache.org/examples/en/editor.html?c=treemap-obama&edit=1&reset=1) and select the legend 'Growth'.


**How to avoid confusion by setting border/gap of node**


If all of the border/gaps are set with the same color, confusion might occur when rectangulars in different levels display at the same time.


See the [example](https://echarts.apache.org/examples/en/editor.html?c=doc-example/treemap-borderColor&edit=1&reset=1). Notice that the child rectangles in the red area are in the deeper level than rectangles that are saparated by white gap. So in the red area, basically we set gap color with red, and use `borderColorSaturation` to lift the saturation.


**Explanation about borderWidth, gapWidth, borderColor**


![](documents/asset/img/treemap-border-gap.png)""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""the the data format of [series-treemap.data](#series-treemap.data) is a forest. For example:



```
[ // Tips, the top level is an array.
    {
        value: 1212,
        children: [
            {
                value: 2323,    // The value of this node, indicating the area size.
                                // it could also be an array, such as [2323, 43, 55], in which the first item of array indicates the area size.
                                // The other items of the array can be used for extra visual mapping. See details in series-treemap.levels.
                id: 'someid-1', // id is not mandatory.
                                // But if using API, id is used to locate node.
                name: 'description of this node', // show the description text in rectangle.
                children: [...],
                label: {        // The label config of this node (if necessary).
                    ...         // see series-treemap.label.
                },
                itemStyle: {    // the itemStyle of this node (if necessary).
                    ...         // the see series-treemap.itemStyle.
                }
            },
            {
                value: 4545,
                id: 'someid-2',
                name: 'description of this node',
                children: [
                    {
                        value: 5656,
                        id: 'someid-3',
                        name: 'description of this node',
                        children: [...]
                    },
                    ...
                ]
            }
        ]
    },
    {
        value: [23, 59, 12]
        // if there is no children, here could be nothing.
    },
    ...
]

```""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in this series.""").tag(sync=True)
    
        
