from traitlets import (
    Unicode, Float, Union, Any,
)
from ..basewidget import BaseWidget


class TextStyle(BaseWidget):
    """ 
:warning: **Autogenerated class**

Global font style.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("TextStyleModel").tag(sync=True)
    
    color = Any(None, allow_none=True, help="""text color.""").tag(sync=True)
    
    fontStyle = Unicode(None, allow_none=True, help="""font style.


Options are:


* `'normal'`
* `'italic'`
* `'oblique'`""").tag(sync=True)
    
    fontWeight = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""font thick weight.


Options are:


* `'normal'`
* `'bold'`
* `'bolder'`
* `'lighter'`
* 100 | 200 | 300 | 400...""").tag(sync=True)
    
    fontFamily = Unicode(None, allow_none=True, help="""font family.


Can also be 'serif' , 'monospace', ...""").tag(sync=True)
    
    fontSize = Float(None, allow_none=True, help="""font size.""").tag(sync=True)
    
    lineHeight = Float(None, allow_none=True, help="""Line height of the text fragment.


If `lineHeight` is not set in `rich`, `lineHeight` in parent level will be used. For example:



```
{
    lineHeight: 56,
    rich: {
        a: {
            // `lineHeight` is not set, then it will be 56
        }
    }
}

```""").tag(sync=True)
    
    width = Float(None, allow_none=True, help="""Width of text block.""").tag(sync=True)
    
    height = Float(None, allow_none=True, help="""Height of text block.""").tag(sync=True)
    
    textBorderColor = Any(None, allow_none=True, help="""Stroke color of the text.""").tag(sync=True)
    
    textBorderWidth = Float(None, allow_none=True, help="""Stroke line width of the text.""").tag(sync=True)
    
    textBorderType = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Stroke line type of the text.


Possible values are:


* `'solid'`
* `'dashed'`
* `'dotted'`


Since `v5.0.0`, it can also be a number or a number array to specify the [dash array](https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray) of the line. With 
`textBorderDashOffset`
, we can make the line style more flexible.


For example：



```
{

textBorderType: [5, 10],

textBorderDashOffset: 5
}

```""").tag(sync=True)
    
    textBorderDashOffset = Float(None, allow_none=True, help="""> Since `v5.0.0`


To set the line dash offset. With 
`textBorderType`
, we can make the line style more flexible.


Refer to MDN [lineDashOffset](https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/lineDashOffset) for more details.""").tag(sync=True)
    
    textShadowColor = Any(None, allow_none=True, help="""Shadow color of the text itself.""").tag(sync=True)
    
    textShadowBlur = Float(None, allow_none=True, help="""Shadow blue of the text itself.""").tag(sync=True)
    
    textShadowOffsetX = Float(None, allow_none=True, help="""Shadow X offset of the text itself.""").tag(sync=True)
    
    textShadowOffsetY = Float(None, allow_none=True, help="""Shadow Y offset of the text itself.""").tag(sync=True)
    
    overflow = Unicode(None, allow_none=True, help="""Determine how to display the text when it's overflow. Available when `width` is set.


* `'truncate'` Truncate the text and trailing with `ellipsis`.
* `'break'` Break by word
* `'breakAll'` Break by character.""").tag(sync=True)
    
    ellipsis = Unicode(None, allow_none=True, help="""Ellipsis to be displayed when `overflow` is set to `truncate`.


* `'truncate'` Truncate the overflow lines.""").tag(sync=True)
    
        
