from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Timeline(BaseWidget):
    """ 
:warning: **Autogenerated class**

`timeline` component, which provides functions like switching and playing between multiple ECharts `options`.


Here is an example:



Different from other cases, `timeline` component requires multiple options. We call first the parameter of `setOption` as `ECOption`, and call the traditional single ECharts option as `ECUnitOption`.


- In the case that `timeline` and `media query` are not set, an `ECUnitOption` is an `ECOption`.
- In the case that `timeline` or `media query` are set, an `ECOption` is made up with several `ECUnitOption`s.
	- The properties at the root of `ECOption` form an `ECUnitOption`, which is also called `baseOption`, representing the default settings.
	- Each item of the array `options` form an `ECUnitOption`, which can be also called `switchableOption`, representing options for each time tick.
- `baseOption` and one `switchableOption` are used to calculate the `finalOption`, based on which the chart will be final rendered.


For example:



```
myChart.setOption({
    // This is the properties of `baseOption`.
    timeline: {
        ...,
        // each item in `timeline.data` corresponds to each
        // `option` in `options` array.
        data: ['2002-01-01', '2003-01-01', '2004-01-01']
    },
    title: {
        subtext: ' Data is from National Bureau of Statistics '
    },
    grid: { ... },
    xAxis: [ ... ],
    yAxis: [ ... ],
    series: [{
        // other configurations of series 1
        type: 'bar',
        ...
    }, {
        // other configurations of series 2
        type: 'line',
        ...
    }, {
        // other configurations of series 3
        type: 'pie',
        ...
    }],
    // `switchableOption`s:
    options: [{
        // it is an option corresponding to '2002-01-01'
        title: {
        text: 'the statistics of the year 2002'
        },
        series: [
            { data: [] }, // the data of series 1
            { data: [] }, // the data of series 2
            { data: [] }  // the data of series 3
        ]
    }, {
        // it is an option corresponding to '2003-01-01'
        title: {
            text: 'the statistics of the year 2003'
        },
        series: [
            { data: [] },
            { data: [] },
            { data: [] }
        ]
    }, {
        // it is an option corresponding to '2004-01-01'
        title: {
            text: 'the statistics of the year 2004'
        },
        series: [
            { data: [] },
            { data: [] },
            { data: [] }
        ]
    }]
});

```

  

**How the `finalOption` calculated?**


When initializing, a `switchableOption` corresponding to the current time tick are merged into `baseOption` to form the `finalOption`. Each time the current tick changed, the new `switchableOption` corresponding to the new time tick are merged into the `finalOption`.


There are two merging strategy.


- By default, use `NORMAL_MERGE`.
- If [timeline.replaceMerge](#option.html#timeline.replaceMerge) is set, use `REPLACE_MERGE`. See [setOption](#api.html#echartsInstance.setOption) for more details of `REPLACE_MERGE`.


  

**Compatibility with ECharts 4:**


We also support these equivalent setting styles:



```
option = {
    baseOption: {
        timeline: {},
        series: [],
        // ... other properties of baseOption.
    },
    options: []
};

```


    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("TimelineModel").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""Whether to show the `timeline` component. It would not show with a setting of `false`, but its functions still remain.""").tag(sync=True)
    
    type = Unicode(None, allow_none=True, help="""This attribute has only one valid value as `slider` by now. You don't have to change it.""").tag(sync=True)
    
    axisType = Unicode(None, allow_none=True, help="""Type of axis, whose values may be:


* `'value'`
 Numeric axis, which is suitable for continuous data.
* `'category'`
 Category axis, which is suitable for category data.
* `'time'`
 Time axis, which is suitable for continuous time data. Compared with value axis, time axis is equipped with time formatting function and has a different method when calculating axis ticks. For example, for time axis, axis ticks may vary in choosing unit as month, week, date, or hour based on the range of data.""").tag(sync=True)
    
    currentIndex = Float(None, allow_none=True, help="""Indicates which is the currently selected item. For instance, if `currentIndex` is `0`, it indicates that the currently selected item is `timeline.data[0]` (namely, using `options[0]`).""").tag(sync=True)
    
    autoPlay = Bool(None, allow_none=True, help="""Whether to play automatically.""").tag(sync=True)
    
    rewind = Bool(None, allow_none=True, help="""Whether supports playing reversely.""").tag(sync=True)
    
    loop = Bool(None, allow_none=True, help="""Whether to loop playing.""").tag(sync=True)
    
    playInterval = Float(None, allow_none=True, help="""Indicates play speed (gap time between two state), whose unit is millisecond.""").tag(sync=True)
    
    realtime = Bool(None, allow_none=True, help="""Whether the view updates in real time during dragging the control dot.""").tag(sync=True)
    
    replaceMerge = Union([Any(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""When initializing, a `switchableOption` corresponding to the current time tick are merged into `baseOption` to form the `finalOption`. Each time the current tick changed, the new `switchableOption` corresponding to the new time tick are merged into the `finalOption`.


There are two merging strategy.


* By default, use `NORMAL_MERGE`.
* If [timeline.replaceMerge](#option.html#timeline.replaceMerge) is set, use `REPLACE_MERGE`. See [setOption](#api.html#echartsInstance.setOption) for more details of `REPLACE_MERGE`.


  



The value of `replaceMerge` can be a `mainType` of a component, like `replaceMerge: 'xAxis'`, or an array of `mainType`s, like `replaceMerge: ['xAxis', 'series']`.


`replaceMerge` is usually used in this scenario: if users intending to replace all of the current series with the new series corresponding to the next time tick without any merging, users can set: `replaceMerge: 'series'`, and make sure that the series are in different id or no id.


See this [example](https://echarts.apache.org/examples/en/editor.html?c=doc-example/timeline-dynamic-series&edit=1&reset=1).""").tag(sync=True)
    
    controlPosition = Unicode(None, allow_none=True, help="""Position of the play button, whose valid values are `'left'` and `'right'`.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between timeline component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between timeline component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between timeline component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between timeline component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    padding = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""timeline space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.


Examples:



```
// Set padding to be 5
padding: 5
// Set the top and bottom paddings to be 5, and left and right paddings to be 10
padding: [5, 10]
// Set each of the four paddings separately
padding: [
    5,  // up
    10, // right
    5,  // down
    10, // left
]

```""").tag(sync=True)
    
    orient = Unicode(None, allow_none=True, help="""Orientation of the component, whose valid values are:


* `'vertical'`: vertical layout.
* `'horizontal'`: horizontal layout.""").tag(sync=True)
    
    inverse = Bool(None, allow_none=True, help="""* Whether to put the `timeline` component reversely, which makes the elements in the front to be at the end.""").tag(sync=True)
    
    symbol = Unicode(None, allow_none=True, help="""Symbol of timeline.


Icon types provided by ECharts includes


`'circle'`, `'rect'`, `'roundRect'`, `'triangle'`, `'diamond'`, `'pin'`, `'arrow'`, `'none'`


It can be set to an image with `'image://url'` , in which URL is the link to an image, or `dataURI` of an image.


An image URL example:



```
'image://http://example.website/a/b.png'

```
A `dataURI` example:



```
'image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7'

```
Icons can be set to arbitrary vector path via `'path://'` in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to [SVG PathData](http://www.w3.org/TR/SVG/paths.html#PathData) for more information about the format of the path. You may export vector paths from tools like Adobe 


For example:



```
'path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z'

```""").tag(sync=True)
    
    symbolSize = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""timeline symbol size. It can be set to single numbers like `10`, or use an array to represent width and height. For example, `[20, 10]` means symbol width is `20`, and height is`10`.""").tag(sync=True)
    
    symbolRotate = Float(None, allow_none=True, help="""Rotate degree of timeline symbol. The negative value represents clockwise. Note that when `symbol` is set to be `'arrow'` in `markLine`, `symbolRotate` value will be ignored, and compulsively use tangent angle.""").tag(sync=True)
    
    symbolKeepAspect = Bool(None, allow_none=True, help="""Whether to keep aspect for symbols in the form of `path://`.""").tag(sync=True)
    
    symbolOffset = Any(None, allow_none=True, help="""Offset of timeline symbol relative to original position. By default, symbol will be put in the center position of data. But if symbol is from user-defined vector path or image, you may not expect symbol to be in center. In this case, you may use this attribute to set offset to default position. It can be in absolute pixel value, or in relative percentage value.


For example, `[0, '-50%']` means to move upside side position of symbol height. It can be used to make the arrow in the bottom to be at data position when symbol is pin.""").tag(sync=True)
    
    lineStyle = Dict(default_value=None, allow_none=True, ).tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""Label axis, `emphasis` is the highlighted style of text. For instance, text style in `emphasis` would be used when mouse hovers or legend connects.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Graphic style of timeline , `emphasis` is the style when it is highlighted, like being hovered by mouse, or highlighted via legend connect.""").tag(sync=True)
    
    checkpointStyle = Dict(default_value=None, allow_none=True, help="""Style of the selected item (`checkpoint`).""").tag(sync=True)
    
    controlStyle = Dict(default_value=None, allow_none=True, help="""The style of *control button*, which includes: *play button*, *previous button*, and *next button*.""").tag(sync=True)
    
    progress = Dict(default_value=None, allow_none=True, help="""Styles of line, labels and symbols in progress.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, ).tag(sync=True)
    
    data = Any(None, allow_none=True, help="""`timeline` data. Each item of `Array` can be a instant value. If you need to set style individually for a data item, the `data` item should be written as `Object`. In then `Object`, the attribute of `value` is numerical value. Other attributes, such as shown the examples below, could cover the attribute configurations in `timeline`.


as follows:



```
[
    '2002-01-01',
    '2003-01-01',
    '2004-01-01',
    {
        value: '2005-01-01',
        tooltip: {          // enables `tooltip` to be displayed as mouse hovering to this item.
            formatter: '{b} xxxx'
        },
        symbol: 'diamond',  // the special setting of this item's symbol.
        symbolSize: 16      // the special setting of this item's size.
    },
    '2006-01-01',
    '2007-01-01',
    '2008-01-01',
    '2009-01-01',
    '2010-01-01',
    {
        value: '2011-01-01',
        tooltip: {          // enables `tooltip` to be displayed as mouse hovering to this item.
            formatter: function (params) {
                return params.name + 'xxxx';
            }
        },
        symbol: 'diamond',
        symbolSize: 18
    },
]

```""").tag(sync=True)
    
        
