from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Title(BaseWidget):
    """ 
:warning: **Autogenerated class**

Title component, including main title and subtitle.


In ECharts 2.x, a single instance of ECharts could contains one title component at most. However, in ECharts 3, there could be one or more than one title components. It is more useful when multiple diagrams in one instance all need titles.


**Here are some instances of different animation easing functions, among which every instance has a title component:** 




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("TitleModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""Set this to `false` to prevent the title from showing""").tag(sync=True)
    
    text = Unicode(None, allow_none=True, help="""The main title text, supporting for `\n` for newlines.""").tag(sync=True)
    
    link = Unicode(None, allow_none=True, help="""The hyper link of main title text.""").tag(sync=True)
    
    target = Unicode(None, allow_none=True, help="""Open the hyper link of main title in specified tab.


**options:** 


* `'self'` opening it in current tab
* `'blank'` opening it in a new tab""").tag(sync=True)
    
    textStyle = Dict(default_value=None, allow_none=True, ).tag(sync=True)
    
    subtext = Unicode(None, allow_none=True, help="""Subtitle text, supporting for `\n` for newlines.""").tag(sync=True)
    
    sublink = Unicode(None, allow_none=True, help="""The hyper link of subtitle text.""").tag(sync=True)
    
    subtarget = Unicode(None, allow_none=True, help="""Open the hyper link of subtitle in specified tab, options:


* `'self'` opening it in current tab
* `'blank'` opening it in a new tab""").tag(sync=True)
    
    subtextStyle = Dict(default_value=None, allow_none=True, ).tag(sync=True)
    
    textAlign = Unicode(None, allow_none=True, help="""The horizontal align of the component (including "text" and "subtext").


Optional values: `'auto'`, `'left'`, `'right'`, `'center'`.""").tag(sync=True)
    
    textVerticalAlign = Unicode(None, allow_none=True, help="""The vertical align of the component (including "text" and "subtext").


Optional values: `'auto'`, `'top'`, `'bottom'`, `'middle'`.""").tag(sync=True)
    
    triggerEvent = Bool(None, allow_none=True, help="""Set this to `true` to enable triggering events""").tag(sync=True)
    
    padding = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""title space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.


Examples:



```
// Set padding to be 5
padding: 5
// Set the top and bottom paddings to be 5, and left and right paddings to be 10
padding: [5, 10]
// Set each of the four paddings separately
padding: [
    5,  // up
    10, // right
    5,  // down
    10, // left
]

```""").tag(sync=True)
    
    itemGap = Float(None, allow_none=True, help="""The gap between the main title and subtitle.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between title component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between title component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between title component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between title component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    backgroundColor = Any(None, allow_none=True, help="""Background color of title, which is transparent by default.



> Color can be represented in RGB, for example `'rgb(128, 128, 128)'`. RGBA can be used when you need alpha channel, for example `'rgba(128, 128, 128, 0.5)'`. You may also use hexadecimal format, for example `'#ccc'`.""").tag(sync=True)
    
    borderColor = Any(None, allow_none=True, help="""Border color of title. Support the same color format as backgroundColor.""").tag(sync=True)
    
    borderWidth = Float(None, allow_none=True, help="""Border width of title.""").tag(sync=True)
    
    borderRadius = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The radius of rounded corner. Its unit is px. And it supports use array to respectively specify the 4 corner radiuses.


For example:



```
borderRadius: 5, // consistently set the size of 4 rounded corners
borderRadius: [5, 5, 0, 0] // (clockwise upper left, upper right, bottom right and bottom left)

```""").tag(sync=True)
    
    shadowBlur = Float(None, allow_none=True, help="""Size of shadow blur. This attribute should be used along with `shadowColor`,`shadowOffsetX`, `shadowOffsetY` to set shadow to component.


For example:



```
{
    shadowColor: 'rgba(0, 0, 0, 0.5)',
    shadowBlur: 10
}

```

**Attention**: This property works only if `show: true` is configured and `backgroundColor` is defined other than `transparent`.""").tag(sync=True)
    
    shadowColor = Any(None, allow_none=True, help="""Shadow color. Support same format as `color`.


**Attention**: This property works only if `show: true` configured.""").tag(sync=True)
    
    shadowOffsetX = Float(None, allow_none=True, help="""Offset distance on the horizontal direction of shadow.


**Attention**: This property works only if `show: true` configured.""").tag(sync=True)
    
    shadowOffsetY = Float(None, allow_none=True, help="""Offset distance on the vertical direction of shadow.


**Attention**: This property works only if `show: true` configured.""").tag(sync=True)
    
        
