from ipywidgets import (
    widget_serialization
)
from traitlets import (
    Unicode, Instance, List, Union,
)
from ..basewidget import BaseWidget

from .visualmapitems.continuous import Continuous
from .visualmapitems.piecewise import Piecewise

class VisualMap(BaseWidget):
    """ 
:warning: **Autogenerated class**

`visualMap` is a type of component for visual encoding, which maps the data to visual channels, including:


- `symbol`: Type of symbol.
- `symbolSize`: Symbol size.
- `color`: Symbol color.
- `colorAlpha`: Symbol alpha channel.
- `opacity`: Opacity of symbol and others (like labels).
- `colorLightness`: Lightness in [HSL](https://en.wikipedia.org/wiki/HSL_and_HSV).
- `colorSaturation`: Saturation in [HSL](https://en.wikipedia.org/wiki/HSL_and_HSV).
- `colorHue`: Hue in [HSL](https://en.wikipedia.org/wiki/HSL_and_HSV).


Multiple `visualMap` component could be defined in a chart instance, which enable that different dimensions of a series data are mapped to different visual channels.


`visualMap` could be defined as [Piecewise (visualMapPiecewise)](#visualMap-piecewise) or [Continuous (visualMapContinuous)](#visualMap-continuous), which is distinguished by the property `type`. For instance:



```
option = {
    visualMap: [
        { // the first visualMap component
            type: 'continuous', // defined to be continuous visualMap
            ...
        },
        { // the second visualMap component
            type: 'piecewise', // defined to be piecewise visualMap
            ...
        }
    ],
    ...
};

```

  

**✦ Configure mapping ✦**


The dimension of [series.data](#series.data) can be specified by [visualMap.dimension](#visualMap.dimension), from which the value can be retrieved and mapped onto visual channels, which can be defined in [visualMap.inRange](#visualMap.inRange) and [visualMap.outOfRange](#visualMap.outOfRange).


  

In series that controlled by visualMap, if a data item needs to escape from controlled by visualMap, you can set like this:



```
series: {
    type: '...',
    data: [
        {name: 'Shanghai', value: 251},
        {name: 'Haikou', value: 21},
        // Mark as `visualMap: false`, then this item does not controlled by visualMap any more,
        // and series visual config (like color, symbol, ...) can be used to this item.
        {name: 'Beijing', value: 821, },
        ...
    ]
}

```
  

**✦ The relationship between visualMap of ECharts3 and dataRange of ECharts2 ✦**


`visualMap` is renamed from the `dataRange` of ECharts2, and the scope of functionalities are extended a lot. The configurations of `dataRange` are still compatible in ECharts3, which automatically convert them to `visualMap`. It is recommended to use `visualMap` instead of `dataRange` in ECharts3.


  

**✦ The detailed configurations of visualMap are elaborated as follows. ✦**


  

  




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("VisualMapModel").tag(sync=True)
    
    visualMap = List(trait=Union([Instance(Continuous, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Piecewise, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),]), allow_none=True, default_value=None).tag(sync=True, **widget_serialization)
    
        
