from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class XAxis(BaseWidget):
    """ 
:warning: **Autogenerated class**

The x axis in cartesian(rectangular) coordinate. Usually a single grid component can place at most 2 x axis, one on the bottom and another on the top. [offset](#xAxis.offset) can be used to avoid overlap when you need to put more than two x axis.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("XAxisModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""Set this to `false` to prevent the axis from showing.""").tag(sync=True)
    
    gridIndex = Float(None, allow_none=True, help="""The index of grid which the x axis belongs to. Defaults to be in the first grid.""").tag(sync=True)
    
    alignTicks = Bool(None, allow_none=True, help="""> Since `v5.3.0`


`alignTicks` turned on to automatically align ticks when multiple numeric x axes. Only available for axes of type `'value'` and `'log'`.""").tag(sync=True)
    
    position = Unicode(None, allow_none=True, help="""The position of x axis.


options:


* `'top'`
* `'bottom'`


The first x axis in grid defaults to be on the bottom of the grid, and the second x axis is on the other side against the first x axis.  
Notice: Set `xAxis.axisLine.onZero` to `false` to activate this option.""").tag(sync=True)
    
    offset = Float(None, allow_none=True, help="""Offset of x axis relative to default position. Useful when multiple x axis has same [position](#xAxis.position) value.  
Notice: Set `xAxis.axisLine.onZero` to `false` to activate this option.""").tag(sync=True)
    
    type = Unicode(None, allow_none=True, help="""Type of axis.


Option:


* `'value'`
 Numerical axis, suitable for continuous data.
* `'category'`
 Category axis, suitable for discrete category data. Category data can be auto retrieved from [series.data](#series.data) or [dataset.source](#dataset.source), or can be specified via [xAxis.data](#xAxis.data).
* `'time'`
 Time axis, suitable for continuous time series data. As compared to value axis, it has a better formatting for time and a different tick calculation method. For example, it decides to use month, week, day or hour for tick based on the range of span.
* `'log'`
 Log axis, suitable for log data. Stacked bar or line series with `type: 'log'` axes may lead to significant visual errors and may have unintended effects in certain circumstances. Their use should be avoided.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Name of axis.""").tag(sync=True)
    
    nameLocation = Unicode(None, allow_none=True, help="""Location of axis name.


**Options:** 


* `'start'`
* `'middle'` or `'center'`
* `'end'`""").tag(sync=True)
    
    nameTextStyle = Dict(default_value=None, allow_none=True, help="""Text style of axis name.""").tag(sync=True)
    
    nameGap = Float(None, allow_none=True, help="""Gap between axis name and axis line.""").tag(sync=True)
    
    nameRotate = Float(None, allow_none=True, help="""Rotation of axis name.""").tag(sync=True)
    
    nameTruncate = Dict(default_value=None, allow_none=True, help="""Truncation of the axis name.""").tag(sync=True)
    
    inverse = Bool(None, allow_none=True, help="""Set this to `true` to invert the axis.
This is a new option available from Echarts 3 and newer.""").tag(sync=True)
    
    boundaryGap = Union([Bool(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The boundary gap on both sides of a coordinate axis. The setting and behavior of category axes and non-category axes are different.


The `boundaryGap` of category axis can be set to either `true` or `false`. Default value is set to be `true`, in which case [axisTick](#xAxis.axisTick) is served only as a separation line, and labels and data appear only in the center part of two [axis ticks](#xAxis.axisTick), which is called *band*.


For non-category axis, including time, numerical value, and log axes, `boundaryGap` is an array of two values, representing the spanning range between minimum and maximum value. The value can be set in numeric value or relative percentage, which becomes invalid after setting [min](#xAxis.min) and [max](#xAxis.max).
**Example:** 



```
boundaryGap: ['20%', '20%']

```""").tag(sync=True)
    
    min = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The minimum value of axis.


It can be set to a special value `'dataMin'` so that the minimum value on this axis is set to be the minimum label.


It will be automatically computed to make sure axis tick is equally distributed when not set.


In category axis, it can also be set as the ordinal number. For example, if a catergory axis has `data: ['categoryA', 'categoryB', 'categoryC']`, and the ordinal `2` represents `'categoryC'`. Moreover, it can be set as negative number, like `-3`.


If `min` is specified as a function, it should return a min value, like:



```
min: function (value) {
    return value.min - 20;
}

```

`value` is an object, containing the `min` value and `max` value of the data. This function should return the min value of axis, or return `null`/`undefined` to make echarts use the auto calculated min value (`null`/`undefined` return is only supported since `v4.8.0`).""").tag(sync=True)
    
    max = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The maximum value of axis.


It can be set to a special value `'dataMax'` so that the minimum value on this axis is set to be the maximum label.


It will be automatically computed to make sure axis tick is equally distributed when not set.


In category axis, it can also be set as the ordinal number. For example, if a catergory axis has `data: ['categoryA', 'categoryB', 'categoryC']`, and the ordinal `2` represents `'categoryC'`. Moreover, it can be set as negative number, like `-3`.


If `max` is specified as a function, it should return a max value, like:



```
max: function (value) {
    return value.max - 20;
}

```

`value` is an object, containing the `min` value and `max` value of the data. This function should return the max value of axis, or return `null`/`undefined` to make echarts use the auto calculated max value (`null`/`undefined` return is only supported since `v4.8.0`).""").tag(sync=True)
    
    scale = Bool(None, allow_none=True, help="""It is available only in numerical axis, i.e., [type](#xAxis.type): 'value'.


It specifies whether not to contain zero position of axis compulsively. When it is set to be `true`, the axis may not contain zero position, which is useful in the scatter chart for both value axes.


This configuration item is unavailable when the [min](#xAxis.min) and [max](#xAxis.max) are set.""").tag(sync=True)
    
    splitNumber = Float(None, allow_none=True, help="""Number of segments that the axis is split into. Note that this number serves only as a recommendation, and the true segments may be adjusted based on readability.


This is unavailable for category axis.""").tag(sync=True)
    
    minInterval = Float(None, allow_none=True, help="""Minimum gap between split lines.


For example, it can be set to be `1` to make sure axis label is show as integer.



```
{
    minInterval: 1
}

```

It is available only for axis of [type](#xAxis.type) 'value' or 'time'.""").tag(sync=True)
    
    maxInterval = Float(None, allow_none=True, help="""Maximum gap between split lines.


For example, in time axis ([type](#xAxis.type) is 'time'), it can be set to be `3600 * 24 * 1000` to make sure that the gap between axis labels is less than or equal to one day.



```
{
    maxInterval: 3600 * 1000 * 24
}

```

It is available only for axis of [type](#xAxis.type) 'value' or 'time'.""").tag(sync=True)
    
    interval = Float(None, allow_none=True, help="""Compulsively set segmentation interval for axis.


As [splitNumber](#xAxis.splitNumber) is a recommendation value, the calculated tick may not be the same as expected. In this case, interval should be used along with [min](#xAxis.min) and [max](#xAxis.max) to compulsively set tickings. But in most cases, we do not suggest using this, our automatic calculation is enough for most situations.


This is unavailable for category axis. Timestamp should be passed for [type](#xAxis.type): 'time' axis. Logged value should be passed for [type](#xAxis.type): 'log' axis.""").tag(sync=True)
    
    logBase = Float(None, allow_none=True, help="""Base of logarithm, which is valid only for numeric axes with [type](#xAxis.type): 'log'.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Set this to `true`, to prevent interaction with the axis.""").tag(sync=True)
    
    triggerEvent = Bool(None, allow_none=True, help="""Set this to `true` to enable triggering events.


Parameters of the event include:



```
{
    // Component type: xAxis, yAxis, radiusAxis, angleAxis
    // Each of which has an attribute for index, e.g., xAxisIndex for xAxis
    componentType: string,
    // Value on axis before being formatted.
    // Click on value label to trigger event.
    value: '',
    // Name of axis.
    // Click on laben name to trigger event.
    name: ''
}

```""").tag(sync=True)
    
    axisLine = Dict(default_value=None, allow_none=True, help="""Settings related to axis line.""").tag(sync=True)
    
    axisTick = Dict(default_value=None, allow_none=True, help="""Settings related to axis tick.""").tag(sync=True)
    
    minorTick = Dict(default_value=None, allow_none=True, help="""> Since `v4.6.0`


Settings related minor ticks.


Note: `minorTick` is not available in the `category` type axis.


Examples:


1) Using minor ticks in function plotting.



2) Using minor ticks in log axis.""").tag(sync=True)
    
    axisLabel = Dict(default_value=None, allow_none=True, help="""Settings related to axis label.""").tag(sync=True)
    
    splitLine = Dict(default_value=None, allow_none=True, help="""Split line of axis in [grid](#grid) area.""").tag(sync=True)
    
    minorSplitLine = Dict(default_value=None, allow_none=True, help="""> Since `v4.6.0`


Minor split lines of axis in the [grid](#grid) area。It will align to the [minorTick](#xAxis.minorTick)""").tag(sync=True)
    
    splitArea = Dict(default_value=None, allow_none=True, help="""Split area of axis in [grid](#grid) area, not shown by default.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""Category data, available in [type](#xAxis.type): 'category' axis.


If [type](#xAxis.type) is not specified, but `axis.data` is specified, the [type](#xAxis.type) is auto set as `'category'`.


If [type](#xAxis.type) is specified as `'category'`, but `axis.data` is not specified, `axis.data` will be auto collected from [series.data](#series.data). It brings convenience, but we should notice that `axis.data` provides then value range of the `'category'` axis. If it is auto collected from [series.data](#series.data), Only the values appearing in [series.data](#series.data) can be collected. For example, if [series.data](#series.data) is empty, nothing will be collected.


Example:



```
// Name list of all categories
data: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
// Each item could also be a specific configuration item.
// In this case, `value` is used as the category name.
data: [{
    value: 'Monday',
    // Highlight Monday
    textStyle: {
        fontSize: 20,
        color: 'red'
    }
}, 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']

```""").tag(sync=True)
    
    axisPointer = Dict(default_value=None, allow_none=True, help="""axisPointer settings on the axis.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationThreshold = Float(None, allow_none=True, help="""Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    animationDurationUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Time for animation to complete, which supports callback function for different data to have different animation effect:



```
animationDurationUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""Easing method used for animation.""").tag(sync=True)
    
    animationDelayUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating animation, which supports callback function for different data to have different animation effects.


For example:



```
animationDelayUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in x axis.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in x axis, which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
        
