from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class YAxis3D(BaseWidget):
    """ 
:warning: **Autogenerated class**

The Y-axis in a 3D cartesian coordinate system.
You can use [grid3DIndex](#yAxis3D.grid3DIndex) to index [3D cartesian coordinate system](#grid3D).


The [axisLine](#yAxis3D.axisLine), [axisTick](#yAxis3D.axisTick), [axisLabel](#yAxis3D.axisLabel), [splitLine](#yAxis3D.splitLine), [splitArea](#yAxis3D.splitArea), [axisPointer](#yAxis3D.axisPointer) set separately on [yAxis3D](#yAxis3D) will cover the corresponding configuration items under [grid3D](#grid3D).



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("YAxis3DModel").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""Whether to display the y-axis.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""The name of the axis.""").tag(sync=True)
    
    grid3DIndex = Float(None, allow_none=True, help="""The index of the [grid3D](#grid3D) component used by the axis. The default is to use the first [grid3D](#grid3D) component.""").tag(sync=True)
    
    nameTextStyle = Dict(default_value=None, allow_none=True, help="""Text style of axis name.""").tag(sync=True)
    
    nameGap = Float(None, allow_none=True, help="""The gap between the axis name and axis line. Note the distance is in 3D space, not the screen pixel value.""").tag(sync=True)
    
    type = Unicode(None, allow_none=True, help="""The type of the axis.


Optional:


* `'value'`
 The value axis. Suitable for continuous data.
* `'category'`
 The category axis. Suitable for the discrete category data. For this type, the category data must be set through [data](#yAxis3D.data).
* `'time'`
 The timeline. Suitable for the continuous timing data. The time axis has a time format compared to the value axis, and the scale calculation is also different. For example, the scale of the month, week, day, and hour ranges can be determined according to the range of the span.
* `'log'`
 Logarithmic axis. Suitable for the logarithmic data.""").tag(sync=True)
    
    min = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The minimum value of axis.


It can be set to a special value `'dataMin'` so that the minimum value on this axis is set to be the minimum label.


It will be automatically computed to make sure the axis tick is equally distributed when not set.


In the category axis, it can also be set as the ordinal number. For example, if a category axis has `data: ['categoryA', 'categoryB', 'categoryC']`, and the ordinal `2` represents `'categoryC'`. Moreover, it can be set as a negative number, like `-3`.""").tag(sync=True)
    
    max = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The maximum value of the axis.


It can be set to a special value `'dataMax'` so that the minimum value on this axis is set to be the maximum label.


It will be automatically computed to make sure the axis tick is equally distributed when not set.


In the category axis, it can also be set as the ordinal number. For example, if a category axis has `data: ['categoryA', 'categoryB', 'categoryC']`, and the ordinal `2` represents `'categoryC'`. Moreover, it can be set as a negative number, like `-3`.""").tag(sync=True)
    
    scale = Bool(None, allow_none=True, help="""It is available only in numerical axis, i.e., [type](#yAxis3D.type): 'value'.


It specifies whether not to contain zero position of axis compulsively. When it is set to be `true`, the axis may not contain zero position, which is useful in the scatter chart for both value axes.


This configuration item is unavailable when the [min](#yAxis3D.min) and [max](#yAxis3D.max) are set.""").tag(sync=True)
    
    splitNumber = Float(None, allow_none=True, help="""The number of segments that the axis is split into. Note that this number serves only as a recommendation, and the true segments may be adjusted based on readability.


This is unavailable for the category axis.""").tag(sync=True)
    
    minInterval = Float(None, allow_none=True, help="""Minimum gap between split lines.


For example, it can be set to be `1` to make sure the axis label is shown as an integer.



```
{
    minInterval: 1
}

```

It is available only for axis of [type](#yAxis3D.type) 'value' or 'time'.""").tag(sync=True)
    
    interval = Float(None, allow_none=True, help="""Compulsively set segmentation interval for axis.


As [splitNumber](#yAxis3D.splitNumber) is a recommendation value, the calculated tick may not be the same as expected. In this case, interval should be used along with [min](#yAxis3D.min) and [max](#yAxis3D.max) to compulsively set tickings. But in most cases, we do not suggest using this, out automatic calculation is enough for most situations.


This is unavailable for category axis. Timestamp should be passed for [type](#yAxis3D.type): 'time' axis. Logged value should be passed for [type](#yAxis3D.type): 'log' axis.""").tag(sync=True)
    
    logBase = Float(None, allow_none=True, help="""Base of logarithm, which is valid only for numeric axes with [type](#yAxis3D.type): 'log'.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""Category data, available in [type](#yAxis3D.type): 'category' axis.


If [type](#yAxis3D.type) is specified as `'category'`, but `axis.data` is not specified, `axis.data` will be auto collected from [series.data](#series.data). It brings convenience, but we should notice that `axis.data` provides then value range of the `'category'` axis. If it is auto collected from [series.data](#series.data), Only the values appearing in [series.data](#series.data) can be collected. For example, if [series.data](#series.data) is empty, nothing will be collected.


Example:



```
// Name list of all categories
data: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
// Each item could also be a specific configuration item.
// In this case, `value` is used as the category name.
data: [{
    value: 'Monday',
    // Highlight Monday
    textStyle: {
        fontSize: 20,
        color: 'red'
    }
}, 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']

```""").tag(sync=True)
    
    axisLine = Dict(default_value=None, allow_none=True, help="""Settings related to axis line.""").tag(sync=True)
    
    axisLabel = Dict(default_value=None, allow_none=True, help="""Settings related to axis label.""").tag(sync=True)
    
    axisTick = Dict(default_value=None, allow_none=True, help="""Settings related to axis tick.""").tag(sync=True)
    
    splitLine = Dict(default_value=None, allow_none=True, help="""Settings related to axis line.""").tag(sync=True)
    
    splitArea = Dict(default_value=None, allow_none=True, help="""Split area of axis in [grid](#grid) area.""").tag(sync=True)
    
    axisPointer = Dict(default_value=None, allow_none=True, help="""Configurations for axis pointer.""").tag(sync=True)
    
        
