## ⚠️ Важное предупреждение

**Я НЕ РЕКОМЕНДУЮ использовать эту библиотеку в продакшн-среде или для важных задач по следующим причинам:**

1. **Низкое качество кода** - Библиотека была написана неопытным разработчиком ("рукожопом") и содержит множество потенциальных проблем
2. **Нестабильность сервиса** - gpt4free.pro может быть крайне нестабильным, закрыться в любой момент или иметь дополнительные недокументированные ограничения
3. **Отсутствие документации API** - Официальной документации по API нет, поэтому поведение может быть непредсказуемым
4. **Частые ошибки** - Сервис может возвращать непонятные ошибки без внятного описания

## 📋 О проекте

Эта библиотека предоставляет Python-интерфейс для бесплатного использования различных AI-моделей через сервис gpt4free.pro. Она позволяет генерировать текст и изображения без необходимости API-ключей.

### Поддерживаемые возможности:
- ✅ Текстовая генерация (чат)
- ✅ Генерация изображений
- ✅ Стриминг ответов
- ✅ Синхронный и асинхронный интерфейсы
- ✅ Поддержка мультимодальных сообщений

## ⚠️ Ограничения сервиса

**Важные ограничения, о которых нужно знать:**

- **Текстовая генерация**: ~5 запросов в минуту
- **Генерация изображений**: ~1 запрос в 30 секунд
- **Нестабильность**: Сервис может быть недоступен в любое время
- **Непредсказуемые ошибки**: Могут возникать без очевидных причин

## 🚀 Быстрый старт

### Установка

```python
# Установите библиотеку (если она доступна через pip)
pip install g4fpro
```

### Базовое использование

```python
from g4fpro import Chat, AsyncChat, ImageGenerator, Messages

# Инициализация чата
chat = Chat()

# Простой текстовый запрос
response = chat.generate("Привет, как дела?")
print(response['choices'][0]['message']['content'])
```

## 📖 Детальная документация

### Класс Chat (синхронный)

Основной класс для синхронной текстовой генерации.

```python
chat = Chat()

response = chat.generate(
    message="Расскажи о космосе",
    model="gpt-4o-mini",
    # Следующие параметры МОГУТ НЕ РАБОТАТЬ из-за ограничений gpt4free.pro:
    temperature=0.7,        # Может игнорироваться
    top_p=0.9,              # Может игнорироваться  
    max_tokens=500,         # Может игнорироваться
    presence_penalty=0.1,   # Может игнорироваться
    frequency_penalty=0.1,  # Может игнорироваться
    stop=["\n", "###"]      # Может игнорироваться
)
```

### Класс AsyncChat (асинхронный)

Асинхронная версия для текстовой генерации.

```python
async_chat = AsyncChat()

# Асинхронная генерация
response = await async_chat.generate("Привет!")

# Стриминг
async for chunk in async_chat.generate_stream("Расскажи историю:"):
    print(chunk, end="", flush=True)
```

### Класс ImageGenerator

Генерация изображений по текстовому описанию.

```python
image_gen = ImageGenerator()

# Получить URL изображений
urls = image_gen.generate_urls("Красивый закат над морем", model="sdxl")

# Сохранить изображения
paths = image_gen.save_images(
    prompt="Кот в шляпе", 
    save_path="images/cat",
    n=2  # количество изображений
)
```

### Класс AsyncImageGenerator

Асинхронная генерация изображений.

```python
async_image_gen = AsyncImageGenerator()

# Асинхронная генерация
urls = await async_image_gen.generate_urls("Город будущего")
```

### Класс Messages

Утилита для работы с мультимодальными сообщениями.

```python
messages = Messages()

# Текстовое сообщение
messages.add_text_message("user", "Привет!")

# Сообщение с изображением по URL
messages.add_url_image_message(
    "user", 
    "https://example.com/image.jpg",
    "Что изображено на этой картинке?"
)

# Сообщение с локальным изображением
messages.add_file_image_message(
    "user",
    "path/to/image.png", 
    "Проанализируй это изображение"
)

# Использование с чатом
response = chat.generate(messages)
```

### Класс Models

Получение информации о доступных моделях.

```python
# Все модели
all_models = Models.get_all_models()

# Только чат-модели
chat_models = Models.get_chat_models()

# Только модели для генерации изображений
image_models = Models.get_image_models()

# Асинхронные методы
chat_models = await Models.get_chat_models_async()
```

## 📝 Важные замечания

### По параметрам генерации:

Следующие параметры **могут не работать** или игнорироваться сервисом gpt4free.pro:

- `temperature` - контроль случайности
- `top_p` - nucleus sampling
- `max_tokens` - ограничение длины ответа
- `presence_penalty` - штраф за повторение тем
- `frequency_penalty` - штраф за частоту токенов
- `stop` - стоп-последовательности

**Рекомендация:** Используйте только обязательные параметры (`message`, `model`), так как остальные могут не поддерживаться.