"""
APIs provided by dimension-server1-1

generated by api_code_gen.py
  - **filename** : ``dimension.py``
  - **json timestamp** : ``2022-09-02 19:26:55``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.dimension import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable

import deepfos.api.dimension as last_ver

__all__ = ['DimensionAPI']


class DimQueryAPI(ChildAPI):
    endpoint = '/basic/dimension/refactor'
    
    @post('get-dimension-member')
    def get_dimension_member(self, vo: DimensionByIdOrNameVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-维度成员单个查询
    
        维度成员批量查询，通用接口 by 维度成员id或name根据id或
        name或id+name查询维度成员
        """
        return {'body': vo}
    
    @post('get-dimension-member-by-ids')
    def get_dimension_member_by_ids(self, vo: DimensionByIdsVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-维度成员批量查询
    
        维度成员批量查询，通用接口 by 维度成员id
        """
        return {'body': vo}
    
    @post('get-dimension-member-for-table')
    def get_dimension_member_for_table(self, vo: DimensionForTableVo) -> Union[DimensionForTableCleanDto, Awaitable[DimensionForTableCleanDto]]:
        """
        【★】维度-数据-维度成员表格清单查询
    
        维度成员批量查询，通用接口 （维度表格编辑视图 - 全量/增量编辑处使
        用）剔除了被动共享的维度成员
        """
        return {'body': vo}
    
    @post('get-dimension-member-list-access')
    def get_dimension_member_list_access(self, vo: DimensionAccessVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-维度成员平铺查询 - 不分页
    
        维度成员不分层级搜索，通用不分页查询- 1.查询维度
        (dimensionName)下维度成员 如传了维度表达式
        (dimensionExpression) 则根据表达式限制查询范围
        - 2.模糊搜索：根据关键字(searchValue)&搜索类型
        (searchType)模糊搜索- 3.是否返回维度成员路径
        (member)是处理成员在树形结构中的路径 反参中以path返回具体
        路径  PS.若未传fieldList则默认查询所有字段，若想查询当前
        语言 可传description若未传fieldList则默认查询所有
        字段，若想查询当前语言 可传description
        """
        return {'body': vo}
    
    @post('get-dimension-tree')
    def get_dimension_tree(self, vo: DimensionTreeVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-维度树查询 - 不分页
    
        树形不分页查询，通用查询 - 1.查询维度
        (dimensionName)下维度成员 如传了维度表达式
        (dimensionExpression) 则根据表达式限制查询范围 
        - 2.查询逻辑:根据当前选中节点(parentNodeId)查询下一
        层信息    PS.若未传当前选中节点(parentNodeId) 默
        认从根节点开始查询       若未传fieldList则默认查询所有
        字段，若想查询当前语言 可传description
        """
        return {'body': vo}
    
    @get('localCache')
    def localCache(self, key: str = None, operationType: int = None, value: int = None) -> Union[str, Awaitable[str]]:
        """
        localCache
    
        """
        return {'param': {'key': key, 'operationType': operationType, 'value': value}}
    
    @post('select-dimension-expression')
    def select_dimension_expression(self, vo: DimensionExpressionVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-表达式查询维度成员
    
        通过表达式查询维度成员 所有方法的成员统一返回- 1.当方法中的成员不
        存在时 通过参数是否忽略不存在成员
        (ignoreIllegalMember)决定是报错提示 还是忽略这个
        方法  PS.若未传fieldList则默认查询所有字段，若想查询当前
        语言 可传description
        """
        return {'body': vo}
    
    @post('select-dimension-expression-grouping-by-function')
    def select_dimension_expression_grouping_by_function(self, vo: DimensionExpressionVo) -> Union[Dict, Awaitable[Dict]]:
        """
        【★】维度-数据-表达式查询维度成员 - 根据方法分组
    
        通过表达式查询维度成员 - 根据方法分组- 1.当方法中的成员不存在时
         通过参数是否忽略不存在成员
        (ignoreIllegalMember)决定是报错提示 还是忽略这个
        方法  PS.若未传fieldList则默认查询所有字段，若想查询当前
        语言 可传description
        """
        return {'body': vo}


class DimDataAPI(ChildAPI):
    endpoint = '/dimension-member'
    
    @get('export-dimension-member')
    def export_dimension_member(self, dimensionName: str = None, folderId: str = None, path: str = None) -> Union[Any, Awaitable[Any]]:
        """
        【★】维度-数据-导出
    
        导出Excel维度成员
        """
        return {'param': {'dimensionName': dimensionName, 'folderId': folderId, 'path': path}}
    
    @post('import-dimension-member')
    def import_dimension_member(self, uploadFile: str, dimensionName: str = None, folderId: str = None, increment: str = None, path: str = None) -> Union[ResultObj, Awaitable[ResultObj]]:
        """
        【★】维度-数据-导入
    
        Excel导入维度成员
        """
        return {
          'body': uploadFile,
          'param': {
              'dimensionName': dimensionName,
              'folderId': folderId,
              'increment': increment,
              'path': path,
          },
        }


class DimCompatAPI(ChildAPI):
    endpoint = '/'
    
    @post('dimension-save/dimension-member-change-save')
    def incremental(self, dimension: DimensionMemberChangeSaveSw) -> Union[List[Dict], Awaitable[List[Dict]]]:
        """
        【旧改新】维度树形增量编辑成员
    
        给页面提供可拖拉拽的增加编辑删除的增量编辑接口
        """
        return {'body': dimension}
    
    @post('dimension/member/save-dimension-member')
    def save(self, members: DimensionMemberSaveDto) -> Union[ResultObj, Awaitable[ResultObj]]:
        """
        【旧改新】保存维度成员信息
    
        全量及增量编辑维度成员
        """
        return {'body': members}


class DimCheckAPI(last_ver.DimCheckAPI):
    endpoint = '/dimension/check'
    
    @post('expresses/contains/member')
    def expresses_contains_member(self, param: MembersAndExpressDto) -> Union[Dict[str, List[str]], Awaitable[Dict[str, List[str]]]]:
        """
        维度-校验-批量维度成员匹配表达式
    
        批量维度成员匹配表达式
        """
        return {'body': param}


class Extra(ChildAPI):
    endpoint = '/'
    
    @post('dimension/custom/get-around-dimension')
    def dimension_custom_get_around_dimension(self, dto: AroundDimensionDto) -> Union[Any, Awaitable[Any]]:
        """
        【特殊】获取前后第n个维度成员
    
        获取前后第n个维度成员
        """
        return {'body': dto}
    
    @post('dimension/custom/get-dimension-description')
    def dimension_custom_get_dimension_description(self, expr_list: List[DimensionDescriptionDto]) -> Union[List[DimensionDescriptionReDto], Awaitable[List[DimensionDescriptionReDto]]]:
        """
        【特殊】获取维度成员描述
    
        获取维度成员描述
        """
        return {'body': expr_list}
    
    @post('dimension/custom/get-dimension-member-by-level')
    def dimension_custom_get_dimension_member_by_level(self, dto: DimensionMemberByLevelDto) -> Union[Any, Awaitable[Any]]:
        """
        【特殊】通过层级获取维度成员
    
        通过层级获取维度成员
        """
        return {'body': dto}
    
    @post('dimension/custom/get-dimension-member-by-parent')
    def dimension_custom_get_dimension_member_by_parent(self, dto: DimensionMemberByParentDto) -> Union[List, Awaitable[List]]:
        """
        【特殊】根据父级属性查维度成员
    
        根据父级属性查维度成员
        """
        return {'body': dto}
    
    @post('dimension/custom/get-more-level-member')
    def dimension_custom_get_more_level_member(self, dto: MoreLevelMemberDto) -> Union[Any, Awaitable[Any]]:
        """
        【特殊】POV的多层级显示
    
        POV的多层级显示
        """
        return {'body': dto}
    
    @post('dimension/custom/get-ud-value-by-express')
    def dimension_custom_get_ud_value_by_express(self, dto: UdValueByExpressDto) -> Union[Any, Awaitable[Any]]:
        """
        【特殊】根据表达式获取维度自定义属性
    
        根据表达式获取维度自定义属性
        """
        return {'body': dto}
    
    @post('dimension/custom/select-dimension-member-list')
    def dimension_custom_select_dimension_member_list(self, dto: DimensionMemberListDto) -> Union[Any, Awaitable[Any]]:
        """
        【旧改新】查询维度成员列表
    
        查询维度成员列表
        """
        return {'body': dto}
    
    @get('dimension/info/relation')
    def get_relation(self, elementName: str, folderId: str = None, path: str = None) -> Union[List[RelationVo], Awaitable[List[RelationVo]]]:
        """
        【特殊】获取维度关联元素清单
    
        获取维度关联元素清单
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}
    
    @post('dimension/info/relation')
    def save_relation(self, vo: DimensionRelationVo) -> Union[bool, Awaitable[bool]]:
        """
        【特殊】保存维度关联元素清单
    
        保存维度关联元素清单
        """
        return {'body': vo}
    
    @post('dimension/info/save-dimension-info-and-ud')
    def dimension_info_save_dimension_info_and_ud(self, dimensionData: str) -> Union[str, Awaitable[str]]:
        """
        【旧改新】维度新建及编辑
    
        维度新建及编辑
        """
        return {'body': dimensionData}
    
    @post('dimension/query/date-dimension')
    def dimension_query_date_dimension(self, params: DateDimensionDto) -> Union[Any, Awaitable[Any]]:
        """
        【特殊】获取期间维度
    
        获取期间维度
        """
        return {'body': params}
    
    @get('dimension/query/find-dimension-type')
    def dimension_query_find_dimension_type(self, folderId: str, path: str = None) -> Union[List[Dict[str, Any]], Awaitable[List[Dict[str, Any]]]]:
        """
        【特殊】查询可新建的维度类型
    
        查询可新建的维度类型
        """
        return {'param': {'folderId': folderId, 'path': path}}
    
    @post('dimension/query/get-access-dimension-member-list')
    def dimension_query_get_access_dimension_member_list(self, allParam: DimensionMemberQuerySw) -> Union[Any, Awaitable[Any]]:
        """
        【旧改新】维度成员不分层级搜索
    
        维度成员不分层级搜索，通用查询
        """
        return {'body': allParam}
    
    @post('dimension/query/get-all-year-period-of-sceanrio')
    def dimension_query_get_all_year_period_of_sceanrio(self, dto: AllYearPeriodOfSceanrioDto) -> Union[Any, Awaitable[Any]]:
        """
        【特殊】根据开始结束年期间返回所有组合
    
        根据开始结束年期间返回所有组合
        """
        return {'body': dto}
    
    @post('dimension/query/get-authorized-dimension-member-level')
    def dimension_query_get_authorized_dimension_member_level(self, dto: DimensionMemberLevelAuthorizedDto) -> Union[List, Awaitable[List]]:
        """
        【废】【特殊】维度成员层级搜索
    
        【废弃】维度成员层级搜索--树形展示，通用查询
        """
        return {'body': dto}
    
    @post('dimension/query/get-dimension-list')
    def dimension_query_get_dimension_list(self, dimensions: List[ElementBaseInfoParam]) -> Union[List[Dimension], Awaitable[List[Dimension]]]:
        """
        【特殊】获取维度信息
    
        批量获取维度信息
        """
        return {'body': dimensions}
    
    @post('dimension/query/get-member-level')
    def dimension_query_get_member_level(self, allParam: MemberLevelDto) -> Union[List, Awaitable[List]]:
        """
        【特殊】维度成员层级查询
    
        维度成员层级查询
        """
        return {'body': allParam}
    
    @post('dimension/query/get-open-period-config')
    def dimension_query_get_open_period_config(self, param: ElementBaseQueryParam) -> Union[Any, Awaitable[Any]]:
        """
        【特殊】查询期间维度配置列表
    
        查询期间维度配置列表
        """
        return {'body': param}
    
    @get('dimension/query/get-period-by-level')
    def dimension_query_get_period_by_level(self, periodLevel: str, dimensionName: str, folderId: str = None, path: str = None) -> Union[List, Awaitable[List]]:
        """
        【特殊】根据期间层级查询期间维度成员
    
        根据期间层级查询期间维度成员
        """
        return {
          'param': {
              'dimensionName': dimensionName,
              'folderId': folderId,
              'path': path,
              'periodLevel': periodLevel,
          },
        }
    
    @post('dimension/query/get-view-by-express')
    def dimension_query_get_view_by_express(self, dto: ViewExpressDto) -> Union[List[ViewDto], Awaitable[List[ViewDto]]]:
        """
        【特殊】根据view表达式,period维度名,folderId查询view成员
    
        根据view表达式,period维度名
        ,folderId,express查询view成员
        """
        return {'body': dto}
    
    @post('dimension/query/get-view-by-express-batch')
    def dimension_query_get_view_by_express_batch(self, dtos: List[ViewExpressDto]) -> Union[List[ViewExpressResultDto], Awaitable[List[ViewExpressResultDto]]]:
        """
        【特殊】批量查询view成员
    
        批量根据view表达式,period维度名
        ,folderId,express查询view成员
        """
        return {'body': dtos}
    
    @post('dimension/query/get-view-by-period')
    def dimension_query_get_view_by_period(self, dto: ElementQueryBaseDto) -> Union[List[ViewDto], Awaitable[List[ViewDto]]]:
        """
        【特殊】根据period维度名,folderId查询所有view维度成员
    
        根据period维度名,folderId查询所有view维度成员
        """
        return {'body': dto}
    
    @post('dimension/query/open-dimension-info-by-id')
    def dimension_query_open_dimension_info_by_id(self, dto: ElementBaseInfoDto) -> Union[Dimension, Awaitable[Dimension]]:
        """
        【旧改新】打开维度主体信息
    
        查看维度主体信息
        """
        return {'body': dto}
    
    @get('dimension/query/select-dimension-member')
    def dimension_query_select_dimension_member(self, dimensionName: str, folderId: str = None, id: str = None, memberName: str = None, path: str = None, resultString: str = None) -> Union[Dict[str, Any], Awaitable[Dict[str, Any]]]:
        """
        【旧改新】查询单个维度成员信息
    
        查询单个维度成员信息
        """
        return {
          'param': {
              'dimensionName': dimensionName,
              'folderId': folderId,
              'id': id,
              'memberName': memberName,
              'path': path,
              'resultString': resultString,
          },
        }
    
    @post('dimension/query/select-dimension-member-by-name-function')
    def dimension_query_select_dimension_member_by_name_function(self, dto: DimensionMemberByNameFunctionDto) -> Union[List[DimensionMemberBean], Awaitable[List[DimensionMemberBean]]]:
        """
        【旧改新】通过表达式查询维度成员
    
        通过表达式查询维度成员
        """
        return {'body': dto}
    
    @post('dimension/query/select-dimension-member-by-name-function-batch')
    def dimension_query_select_dimension_member_by_name_function_batch(self, dtoList: List[DimensionMemberByNameFunctionDto]) -> Union[List[ResponseResult], Awaitable[List[ResponseResult]]]:
        """
        【旧改新】通过表达式查询维度成员 - 批量
    
        通过表达式查询维度成员
        """
        return {'body': dtoList}
    
    @post('finance/dimension/check-and-save-dimension-member')
    def finance_dimension_check_and_save_dimension_member(self, dimensionMemberCheckSaveObj: DimensionMemberCheckSaveObj) -> Union[bool, Awaitable[bool]]:
        """
        【旧改新】校验维度成员是否存在并保存
    
        校验维度成员是否存在并保存
        """
        return {'body': dimensionMemberCheckSaveObj}
    
    @post('finance/dimension/save-dimension-and-member')
    def finance_dimension_save_dimension_and_member(self, dimensionInfoAndMemberObjList: List[Dict]) -> Union[bool, Awaitable[bool]]:
        """
        【旧改新】保存维度和成员
    
        保存维度和成员
        """
        return {'body': dimensionInfoAndMemberObjList}
    
    @post('finance/dimension/save-verify')
    def finance_dimension_save_verify(self, datas: List[Dict]) -> Union[Any, Awaitable[Any]]:
        """
        【特殊】校验维度是否存在
    
        校验维度是否存在
        """
        return {'body': datas}
    
    @get('refactor/dimension/member/judge-field-empty')
    def refactor_dimension_member_judge_field_empty(self, fieldName: str, dimensionName: str, folderId: str = None, path: str = None) -> Union[bool, Awaitable[bool]]:
        """
        维度-数据-判断维度数据某列是否有值
    
        判断维度成员某列是否有值
        """
        return {
          'param': {
              'dimensionName': dimensionName,
              'fieldName': fieldName,
              'folderId': folderId,
              'path': path,
          },
        }
    
    @post('dimension/info/build-period-config-and-member')
    def dimension_info_build_period_config_and_member(self, dto: PeriodConfigDto) -> Union[bool, Awaitable[bool]]:
        """
        维度-编辑-编辑期间层级
    
        编辑期间层级生成对应period成员与view视图
        """
        return {'body': dto}
    
    @post('refactor/dimension/info/get-view-by-period')
    def refactor_dimension_info_get_view_by_period(self, dto: ElementQueryBaseDto) -> Union[List[NewViewDto], Awaitable[List[NewViewDto]]]:
        """
        维度-编辑-获取期间属性view成员
    
        根据period维度名,folderId查询所有view维度成员
        """
        return {'body': dto}
    
    @post('refactor/dimension/info/query')
    def refactor_dimension_info_query(self, param: ElementBaseInfoParam) -> Union[NewDimension, Awaitable[NewDimension]]:
        """
        维度-编辑-获取主体信息
    
        获取维度主体信息
        """
        return {'body': param}
    
    @post('refactor/dimension/info/save')
    def refactor_dimension_info_save(self, dimension: NewDimensionReq) -> Union[str, Awaitable[str]]:
        """
        维度-编辑-主体新建及编辑保存
    
        维度新建及编辑：-保存维度主体信息，包括层级管理信息，ud信息，以及其
        他类型维度特有配置信息，自动生成对应数据表
        """
        return {'body': dimension}
    
    @post('refactor/dimension/info/update-view-member')
    def refactor_dimension_info_update_view_member(self, dto: UpdateViewMemberDto) -> Union[bool, Awaitable[bool]]:
        """
        维度-编辑-更新view成员描述
    
        更新view成员描述
        """
        return {'body': dto}


class DimSaveAPI(ChildAPI):
    endpoint = '/refactor/dimension/member'
    
    @post('save')
    def save(self, dto: NewDimensionMemberSaveDto) -> Union[ResultObj, Awaitable[ResultObj]]:
        """
        save
    
        """
        return {'body': dto}
    
    @post('tree/save')
    def tree_save(self, dto: DimensionMemberTreeSaveDto) -> Union[DimensionTreeSaveResultDto, Awaitable[DimensionTreeSaveResultDto]]:
        """
        【★】维度-数据-树形增量编辑维度接口
    
        给页面提供可拖拉拽的增加编辑删除的增量编辑接口
        """
        return {'body': dto}


class DimensionAPI(DynamicRootAPI, builtin=True):
    """维度组件接口"""
    module_type = 'DIM'
    default_version = (1, 0)
    multi_version = True
    cls_name = 'DimensionAPI'
    module_name = 'deepfos.api.V1_1.dimension'
    api_version = (1, 1)

    @cached_property
    def query(self) -> DimQueryAPI:
        """
        维度数据相关接口-查询
        """
        return DimQueryAPI(self)

    @cached_property
    def data(self) -> DimDataAPI:
        """
        维度数据相关接口-导入导出
        """
        return DimDataAPI(self)

    @cached_property
    def compat(self) -> DimCompatAPI:
        """
        维度旧改新接口
        """
        return DimCompatAPI(self)

    @cached_property
    def check(self) -> DimCheckAPI:
        """
        维度校验相关
        """
        return DimCheckAPI(self)

    @cached_property
    def extra(self) -> Extra:
        """
        维度其他接口
        """
        return Extra(self)

    @cached_property
    def save(self) -> DimSaveAPI:
        """
        维度数据相关接口-保存
        """
        return DimSaveAPI(self)


