"""
Models used by /dimension-server1-1

generated by model_code_gen.py
  - **filename** : ``dimension.py``
  - **json timestamp** : ``2022-09-02 19:26:55``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'AroundDimensionDto',
    'DateDimensionDto',
    'DimensionByIdOrNameVo',
    'DimensionByIdsVo',
    'DimensionDescriptionDto',
    'DimensionDescriptionReDto',
    'DimensionExpressAndMemberDto',
    'DimensionExpressDto',
    'DimensionExpressExistsResult',
    'DimensionForTableVo',
    'DimensionInfoSw',
    'DimensionLevelManageObj',
    'DimensionMemberBean',
    'DimensionMemberByLevelDto',
    'DimensionMemberByNameFunctionDto',
    'DimensionMemberByParentDto',
    'DimensionMemberChangeFromNode',
    'DimensionMemberChangeObj',
    'DimensionMemberCheckSaveObj',
    'DimensionMemberLevelAuthorizedDto',
    'DimensionMemberListDto',
    'DimensionMemberNewDto',
    'DimensionMemberOperationDto',
    'DimensionMemberOperationSw',
    'DimensionMemberQuerySw',
    'DimensionMemberTreeSaveDto',
    'DimensionPeriodLevelObj',
    'DimensionTreeErrorDto',
    'DimensionTreeSaveResultDto',
    'DimensionViewObj',
    'ElementBaseInfoDto',
    'ElementBaseInfoParam',
    'ElementBaseQueryParam',
    'ElementDetailVo',
    'ElementDetailVoReq',
    'ElementQueryBaseDto',
    'Error',
    'LevelManageDto',
    'MemberInExpressAndRsDto',
    'MemberInExpressAndRsResult',
    'MemberLevelDto',
    'MembersAndExpressDto',
    'MoreLevelMemberDto',
    'NewDimensionMemberSaveDto',
    'NewViewDto',
    'OpenErrorDto',
    'PeriodConfig',
    'PeriodConfigDto',
    'PeriodParameter',
    'PeriodParameterReq',
    'RelationDimension',
    'RelationVoReq',
    'RelationVo',
    'ResponseResult',
    'ResultObj',
    'RsInfoDto',
    'UdValueByExpressDto',
    'UpdateViewMemberDto',
    'ViewDto',
    'ViewExpressDto',
    'ViewExpressResultDto',
    'YearPeriodDto',
    'AllYearPeriodOfSceanrioDto',
    'Dimension',
    'DimensionAccessVo',
    'DimensionChangeSaveResult',
    'DimensionExpressionVo',
    'DimensionMemberChangeSaveSw',
    'DimensionRelationVo',
    'DimensionTreeVo',
    'DimensionUdDto',
    'DimensionUdDtoReq',
    'DimensionUdObj',
    'NewDimension',
    'NewDimensionReq',
    'DimensionForTableCleanDto',
    'DimensionInfoObj',
    'DimensionInfoAndMemberObj',
    'DimensionMemberSaveDto',
    'DimensionMembersDto'
]


class AroundDimensionDto(BaseModel):
    """Around Dimension Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/custom/get-around-dimension``
    """
    #: 查询表达式
    dimension_express: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: resultString
    resultString: Optional[str] = None
    #: 排序:0-正序,1-倒叙
    reverse_order: Optional[str] = None


class DateDimensionDto(BaseModel):
    """Date Dimension Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/query/date-dimension``
    """
    #: dimensionMemberNames
    dimensionMemberNames: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: resultString
    resultString: Optional[str] = None


class DimensionByIdOrNameVo(BaseModel):
    """Dimension By Id Or Name Vo

    .. admonition:: 引用接口

        - **POST** ``/basic/dimension/refactor/get-dimension-member``
    """
    #: 维度名
    dimensionName: Optional[str] = None
    #: 返回列
    fieldList: Optional[List[str]] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 维度成员id 
    id: Optional[int] = None
    #: 维度成员name 
    name: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None


class DimensionByIdsVo(BaseModel):
    """Dimension By Ids Vo

    .. admonition:: 引用接口

        - **POST** ``/basic/dimension/refactor/get-dimension-member-by-ids``
    """
    #: 维度名
    dimensionName: Optional[str] = None
    #: 返回列
    fieldList: Optional[List[str]] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 维度成员id 
    ids: Optional[List[int]] = None
    #: 元素路径
    path: Optional[str] = None


class DimensionDescriptionDto(BaseModel):
    """Dimension Description Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/custom/get-dimension-description``
    """
    #: 维度表达式
    express: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 维度成员名
    name: Optional[str] = None
    #: path
    path: Optional[str] = None


class DimensionDescriptionReDto(BaseModel):
    #: description
    description: Optional[str] = None
    #: 维度表达式
    express: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 维度成员名
    name: Optional[str] = None
    #: path
    path: Optional[str] = None


class DimensionExpressAndMemberDto(BaseModel):
    """Dimension Express And Member Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/check/member/express/contains``
        - **POST** ``/dimension/check/member/multi/express/contains``
    """
    #: 维度名
    dimensionName: Optional[str] = None
    #: 维度表达式
    express: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 维度成员列表
    members: Optional[List[str]] = None
    #: 是否需要返回存在的成员列表，此参数可不传
    needExistMember: Optional[bool] = None
    #: path
    path: Optional[str] = None


class DimensionExpressDto(BaseModel):
    """Dimension Express Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/check/member/exists/batch/express``
        - **POST** ``/dimension/check/member/exists/express``
    """
    #: 维度名
    dimensionName: Optional[str] = None
    #: 维度表达式
    express: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None


class DimensionExpressExistsResult(BaseModel):
    #: 维度名
    dimensionName: Optional[str] = None
    #: 错误信息，报错的时候有值
    errorMessage: Optional[str] = None
    #: 存在的维度成员,needExistMember为true时返回
    existingMembers: Optional[List[str]] = None
    #: 维度表达式
    express: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 是否都存在(于表达式)
    isAllExists: Optional[bool] = None
    #: 不存在的维度成员,isAllExists为false时有值
    nonexistentMembers: Optional[List[str]] = None
    #: path
    path: Optional[str] = None


class DimensionForTableVo(BaseModel):
    """Dimension For Table Vo

    .. admonition:: 引用接口

        - **POST** ``/basic/dimension/refactor/get-dimension-member-for-table``
    """
    #: 维度名
    dimensionName: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None


class DimensionInfoSw(BaseModel):
    #: 文件夹id
    folderId: Optional[str] = None
    #: 值为1只进行校验，不保存
    isOnlyCheck: Optional[str] = None
    #: 维度名
    name: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None


class DimensionLevelManageObj(BaseModel):
    #: level
    level: Optional[int] = None
    #: levelName
    levelName: Optional[str] = None
    #: multilingual
    multilingual: Optional[Any] = None


class DimensionMemberBean(BaseModel):
    #: 支付类型,科目类型特有
    accounttype: Optional[str] = None
    #: 实际天数,期间类型特有
    actualDate: Optional[str] = None
    #: 实际年份,年份类型特有
    actualYear: Optional[str] = None
    #: 比重
    aggweight: Optional[float] = None
    #: 数据长度,科目类型特有
    dataLength: Optional[int] = None
    #: 数据精度,科目类型特有
    dataPrecision: Optional[int] = None
    #: 数据类型,科目类型特有
    datatype: Optional[str] = None
    #: 结束期间
    end_period: Optional[str] = None
    #: 结束年份
    end_year: Optional[str] = None
    #: 流类型,科目类型特有
    flowtype: Optional[str] = None
    #: 公式
    formula: Optional[str] = None
    #: 半年,期间类型特有
    halfyear: Optional[str] = None
    #: 维度成员id
    id: Optional[int] = None
    #: 父节点,科目类型特有
    inputOnParentNode: Optional[bool] = None
    #: 自上而下,版本类型特有
    isTopDown: Optional[bool] = None
    #: 是否生效
    is_active: Optional[bool] = None
    #: 是否叶子节点
    is_base: Optional[bool] = None
    #: 是否计算
    is_calculated: Optional[bool] = None
    #: 是否模块化
    is_modula: Optional[bool] = None
    #: 层级
    level: Optional[int] = None
    #: 本位币,实体类型特有
    local_currency: Optional[str] = None
    #: 月,期间类型特有
    month: Optional[str] = None
    #: 多语言描述
    multilingual: Optional[dict] = None
    #: 成员编码
    name: Optional[str] = None
    #: 父节点编码
    parent_name: Optional[str] = None
    #: 期间级别,期间类型特有
    period_level: Optional[int] = None
    #: 季度,期间类型特有
    quarter: Optional[str] = None
    #: 是否共享节点
    sharedmember: Optional[bool] = None
    #: 排序字段
    sort_col: Optional[str] = None
    #: 开始期间
    start_period: Optional[str] = None
    #: 开始年份
    start_year: Optional[str] = None
    #: 自定义ud属性
    #: ud1
    ud1: Optional[str] = None
    #: ud2
    ud2: Optional[str] = None
    #: ud3
    ud3: Optional[str] = None
    #: ud4
    ud4: Optional[str] = None
    #: ud5
    ud5: Optional[str] = None
    #: ud6
    ud6: Optional[str] = None
    #: ud7
    ud7: Optional[str] = None
    #: ud8
    ud8: Optional[str] = None
    #: ud9
    ud9: Optional[str] = None
    #: ud10
    ud10: Optional[str] = None
    #: ud11
    ud11: Optional[str] = None
    #: ud12
    ud12: Optional[str] = None
    #: ud13
    ud13: Optional[str] = None
    #: ud14
    ud14: Optional[str] = None
    #: ud15
    ud15: Optional[str] = None
    #: ud16
    ud16: Optional[str] = None
    #: ud17
    ud17: Optional[str] = None
    #: ud18
    ud18: Optional[str] = None
    #: ud19
    ud19: Optional[str] = None
    #: ud20
    ud20: Optional[str] = None
    #: ud21
    ud21: Optional[str] = None
    #: ud22
    ud22: Optional[str] = None
    #: ud23
    ud23: Optional[str] = None
    #: ud24
    ud24: Optional[str] = None
    #: ud25
    ud25: Optional[str] = None
    #: ud26
    ud26: Optional[str] = None
    #: ud27
    ud27: Optional[str] = None
    #: ud28
    ud28: Optional[str] = None
    #: ud29
    ud29: Optional[str] = None
    #: ud30
    ud30: Optional[str] = None
    #: ud31
    ud31: Optional[str] = None
    #: ud32
    ud32: Optional[str] = None
    #: ud33
    ud33: Optional[str] = None
    #: ud34
    ud34: Optional[str] = None
    #: ud35
    ud35: Optional[str] = None
    #: ud36
    ud36: Optional[str] = None
    #: ud37
    ud37: Optional[str] = None
    #: ud38
    ud38: Optional[str] = None
    #: ud39
    ud39: Optional[str] = None
    #: ud40
    ud40: Optional[str] = None
    #: ud41
    ud41: Optional[str] = None
    #: ud42
    ud42: Optional[str] = None
    #: ud43
    ud43: Optional[str] = None
    #: ud44
    ud44: Optional[str] = None
    #: ud45
    ud45: Optional[str] = None
    #: ud46
    ud46: Optional[str] = None
    #: ud47
    ud47: Optional[str] = None
    #: ud48
    ud48: Optional[str] = None
    #: ud49
    ud49: Optional[str] = None
    #: ud50
    ud50: Optional[str] = None
    #: ud51
    ud51: Optional[str] = None
    #: ud52
    ud52: Optional[str] = None
    #: ud53
    ud53: Optional[str] = None
    #: ud54
    ud54: Optional[str] = None
    #: ud55
    ud55: Optional[str] = None
    #: ud56
    ud56: Optional[str] = None
    #: ud57
    ud57: Optional[str] = None
    #: ud58
    ud58: Optional[str] = None
    #: ud59
    ud59: Optional[str] = None
    #: ud60
    ud60: Optional[str] = None
    #: 周,期间类型特有
    week: Optional[str] = None


class DimensionMemberByLevelDto(BaseModel):
    """Dimension Member By Level Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/custom/get-dimension-member-by-level``
    """
    #: 维度表达式
    dimensionMemberNames: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 返回数据格式:0-list,1-map
    outFormat: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: resultString
    resultString: Optional[str] = None
    #: 排序:0-正序,1-倒叙
    reverse_order: Optional[str] = None
    #: 展示层级
    showLevel: Optional[str] = None


class DimensionMemberByNameFunctionDto(BaseModel):
    """Dimension Member By Name Function Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/query/select-dimension-member-by-name-function``
        - **POST** ``/dimension/query/select-dimension-member-by-name-function-batch``
    """
    #: 【废弃】是否校验表达式
    check_express: Optional[str] = None
    #: 维度表达式
    dimensionMemberNames: Optional[str] = None
    #: 是否去重
    duplicate: Optional[bool] = None
    #: folderId
    folderId: Optional[str] = None
    #: 是否忽略不存在的维度成员
    ignoreIllegalMember: Optional[bool] = None
    #: 返回数据格式:0-list,1-map
    outFormat: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: 返回字段
    resultString: Optional[str] = None
    #: 排序:0-正序,1-倒叙
    reverse_order: Optional[str] = None
    #: 角色方案角色
    role: Optional[str] = None
    #: 角色方案文件夹id
    roleFolderId: Optional[str] = None
    #: 角色方案路径
    rolePath: Optional[str] = None
    #: 角色方案角色组
    rolegroup: Optional[str] = None
    #: 角色方案行号
    rsMapping: Optional[int] = None
    #: 角色方案名
    rsName: Optional[str] = None
    #: 【废弃】是否前端调用
    web: Optional[str] = None


class DimensionMemberByParentDto(BaseModel):
    """Dimension Member By Parent Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/custom/get-dimension-member-by-parent``
    """
    #: 维度表达式
    dimensionMemberNames: Optional[str] = None
    #: dimension_name
    dimension_name: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: resultString
    resultString: Optional[str] = None
    #: 排序:0-正序,1-倒叙
    reverse_order: Optional[str] = None
    #: 自定义字段名称
    ud_name: Optional[str] = None


class DimensionMemberChangeFromNode(BaseModel):
    #: name
    name: Optional[str] = None
    #: parentName
    parentName: Optional[str] = None


class DimensionMemberChangeObj(BaseModel):
    #: access
    access: Optional[bool] = None
    #: base
    base: Optional[bool] = None
    #: fromNode
    fromNode: Optional[DimensionMemberChangeFromNode] = None
    #: id
    id: Optional[int] = None
    #: index
    index: Optional[int] = None
    #: key
    key: Optional[str] = None
    #: multilingual
    multilingual: Optional[Any] = None
    #: name
    name: Optional[str] = None
    #: operation
    operation: Optional[str] = None
    #: parentKey
    parentKey: Optional[str] = None
    #: parentName
    parentName: Optional[str] = None
    #: sharedmember
    sharedmember: Optional[bool] = None


class DimensionMemberCheckSaveObj(BaseModel):
    """Dimension Member Check Save Obj

    .. admonition:: 引用接口

        - **POST** ``/finance/dimension/check-and-save-dimension-member``
    """
    #: dimensions
    dimensions: Optional[Any] = None
    #: typeMap
    typeMap: Optional[Any] = None


class DimensionMemberLevelAuthorizedDto(BaseModel):
    """Dimension Member Level Authorized Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/query/get-authorized-dimension-member-level``
    """
    #: dimensionExpression
    dimensionExpression: Optional[str] = None
    #: dimensionName
    dimensionName: Optional[str] = None
    #: 维度name展示样式:0-维度成员名,1-维度成员描述，2-维度成员名-维度成员描述
    displayType: Optional[str] = None
    #: 是否返回维度信息:0-不返回,1-返回
    edit: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 当前维度成员id,返回该节点下级成员列表
    id: Optional[int] = None
    #: 当前维度成员名,返回该节点下级成员列表
    name: Optional[str] = None
    #: 父级节点是否可选:true-可选,false-不可选
    parentClick: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: resultString
    resultString: Optional[str] = None
    #: 角色方案角色
    role: Optional[str] = None
    #: 角色方案文件夹id
    roleFolderId: Optional[str] = None
    #: 角色方案路径
    rolePath: Optional[str] = None
    #: 角色方案角色组
    rolegroup: Optional[str] = None
    #: 角色方案行号
    rsMapping: Optional[int] = None
    #: 角色方案名
    rsName: Optional[str] = None
    #: searchValue
    searchValue: Optional[str] = None


class DimensionMemberListDto(BaseModel):
    """Dimension Member List Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/custom/select-dimension-member-list``
    """
    #: folderId
    folderId: Optional[str] = None
    #: name
    name: Optional[str] = None
    #: path
    path: Optional[str] = None


class DimensionMemberNewDto(BaseModel):
    #: 科目类型，科目类特有属性
    accountType: Optional[str] = None
    #: 实际日期，期间类特有属性
    actualDate: Optional[str] = None
    #: 实际年份，年份类特有属性
    actualYear: Optional[str] = None
    #: 计算权重
    aggweight: Optional[float] = None
    #: 数据长度，科目类特有属性
    dataLength: Optional[int] = None
    #: 数据精度，科目类特有属性
    dataPrecision: Optional[int] = None
    #: 数据类型，科目类特有属性
    dataType: Optional[str] = None
    #: 描述，保存不传，查询时根据语言展示特定描述
    description: Optional[str] = None
    #: 结束期间，场景类特有属性
    endPeriod: Optional[str] = None
    #: 结束年份，场景类特有属性
    endYear: Optional[str] = None
    #: 科目类特有属性
    flowType: Optional[str] = None
    #: 半年，期间类特有属性
    halfYear: Optional[str] = None
    #: 主键id，保存维度成员时不需填写
    id: Optional[int] = None
    #: 父节点继承，科目类特有属性
    inputOnParentNode: Optional[bool] = None
    #: 是否有效
    isActive: Optional[bool] = None
    #: 是否向上汇总，版本类特有属性
    isTopDown: Optional[bool] = None
    #: 成员层级，保存不需要传
    level: Optional[int] = None
    #: 本位币，实体类特有属性
    localCurrency: Optional[str] = None
    #: 月，期间类特有属性
    month: Optional[str] = None
    #: 多语言描述
    multilingual: Optional[Any] = None
    #: 成员编码,必填
    name: Optional[str] = None
    #: 父级成员id，后端生成，保存不填
    parentId: Optional[int] = None
    #: 父级成员编码，必填
    parentName: Optional[str] = None
    #: 期间层级，期间类特有属性
    periodLevel: Optional[int] = None
    #: 季度，期间类特有属性
    quarter: Optional[str] = None
    #: 是否共享节点
    sharedMember: Optional[bool] = None
    #: 排序字段，保存不需要传
    sortCol: Optional[str] = None
    #: 开始期间，场景类特有属性
    startPeriod: Optional[str] = None
    #: 开始年份，场景类特有属性
    startYear: Optional[str] = None
    #: 自定义ud属性
    #: ud1
    ud1: Optional[str] = None
    #: ud2
    ud2: Optional[str] = None
    #: ud3
    ud3: Optional[str] = None
    #: ud4
    ud4: Optional[str] = None
    #: ud5
    ud5: Optional[str] = None
    #: ud6
    ud6: Optional[str] = None
    #: ud7
    ud7: Optional[str] = None
    #: ud8
    ud8: Optional[str] = None
    #: ud9
    ud9: Optional[str] = None
    #: ud10
    ud10: Optional[str] = None
    #: ud11
    ud11: Optional[str] = None
    #: ud12
    ud12: Optional[str] = None
    #: ud13
    ud13: Optional[str] = None
    #: ud14
    ud14: Optional[str] = None
    #: ud15
    ud15: Optional[str] = None
    #: ud16
    ud16: Optional[str] = None
    #: ud17
    ud17: Optional[str] = None
    #: ud18
    ud18: Optional[str] = None
    #: ud19
    ud19: Optional[str] = None
    #: ud20
    ud20: Optional[str] = None
    #: ud21
    ud21: Optional[str] = None
    #: ud22
    ud22: Optional[str] = None
    #: ud23
    ud23: Optional[str] = None
    #: ud24
    ud24: Optional[str] = None
    #: ud25
    ud25: Optional[str] = None
    #: ud26
    ud26: Optional[str] = None
    #: ud27
    ud27: Optional[str] = None
    #: ud28
    ud28: Optional[str] = None
    #: ud29
    ud29: Optional[str] = None
    #: ud30
    ud30: Optional[str] = None
    #: ud31
    ud31: Optional[str] = None
    #: ud32
    ud32: Optional[str] = None
    #: ud33
    ud33: Optional[str] = None
    #: ud34
    ud34: Optional[str] = None
    #: ud35
    ud35: Optional[str] = None
    #: ud36
    ud36: Optional[str] = None
    #: ud37
    ud37: Optional[str] = None
    #: ud38
    ud38: Optional[str] = None
    #: ud39
    ud39: Optional[str] = None
    #: ud40
    ud40: Optional[str] = None
    #: ud41
    ud41: Optional[str] = None
    #: ud42
    ud42: Optional[str] = None
    #: ud43
    ud43: Optional[str] = None
    #: ud44
    ud44: Optional[str] = None
    #: ud45
    ud45: Optional[str] = None
    #: ud46
    ud46: Optional[str] = None
    #: ud47
    ud47: Optional[str] = None
    #: ud48
    ud48: Optional[str] = None
    #: ud49
    ud49: Optional[str] = None
    #: ud50
    ud50: Optional[str] = None
    #: ud51
    ud51: Optional[str] = None
    #: ud52
    ud52: Optional[str] = None
    #: ud53
    ud53: Optional[str] = None
    #: ud54
    ud54: Optional[str] = None
    #: ud55
    ud55: Optional[str] = None
    #: ud56
    ud56: Optional[str] = None
    #: ud57
    ud57: Optional[str] = None
    #: ud58
    ud58: Optional[str] = None
    #: ud59
    ud59: Optional[str] = None
    #: ud60
    ud60: Optional[str] = None
    #: 周，期间类特有属性
    week: Optional[str] = None


class DimensionMemberOperationDto(BaseModel):
    #: 科目类型，科目类特有属性
    accountType: Optional[str] = None
    #: 实际日期，期间类特有属性
    actualDate: Optional[str] = None
    #: 实际年份，年份类特有属性
    actualYear: Optional[str] = None
    #: 计算权重
    aggweight: Optional[float] = None
    #: 数据长度，科目类特有属性
    dataLength: Optional[int] = None
    #: 数据精度，科目类特有属性
    dataPrecision: Optional[int] = None
    #: 数据类型，科目类特有属性
    dataType: Optional[str] = None
    #: 结束期间，场景类特有属性
    endPeriod: Optional[str] = None
    #: 结束年份，场景类特有属性
    endYear: Optional[str] = None
    #: 科目类特有属性
    flowType: Optional[str] = None
    #: 半年，期间类特有属性
    halfYear: Optional[str] = None
    #: 主键id，保存维度成员时不需填写
    id: Optional[int] = None
    #: 排序，指该节点在同一个父节点下的排序，从0开始
    index: Optional[int] = None
    #: 父节点继承，科目类特有属性
    inputOnParentNode: Optional[bool] = None
    #: 是否有效
    isActive: Optional[bool] = None
    #: 是否向上汇总，版本类特有属性
    isTopDown: Optional[bool] = None
    #: 成员层级，保存不需要传
    level: Optional[int] = None
    #: 本位币，实体类特有属性
    localCurrency: Optional[str] = None
    #: 月，期间类特有属性
    month: Optional[str] = None
    #: 多语言描述
    multilingual: Optional[Any] = None
    #: 成员编码,必填
    name: Optional[str] = None
    #: 操作类型
    operation: Optional[str] = None
    #: 原成员编码
    originName: Optional[str] = None
    #: 原父节点编码
    originParentName: Optional[str] = None
    #: 父级成员id，后端生成，保存不填
    parentId: Optional[int] = None
    #: 父级成员编码，必填
    parentName: Optional[str] = None
    #: 期间层级，期间类特有属性
    periodLevel: Optional[int] = None
    #: 季度，期间类特有属性
    quarter: Optional[str] = None
    #: 是否共享节点
    sharedMember: Optional[bool] = None
    #: 排序字段，保存不需要传
    sortCol: Optional[str] = None
    #: 开始期间，场景类特有属性
    startPeriod: Optional[str] = None
    #: 开始年份，场景类特有属性
    startYear: Optional[str] = None
    #: 自定义ud属性
    #: ud1
    ud1: Optional[str] = None
    #: ud2
    ud2: Optional[str] = None
    #: ud3
    ud3: Optional[str] = None
    #: ud4
    ud4: Optional[str] = None
    #: ud5
    ud5: Optional[str] = None
    #: ud6
    ud6: Optional[str] = None
    #: ud7
    ud7: Optional[str] = None
    #: ud8
    ud8: Optional[str] = None
    #: ud9
    ud9: Optional[str] = None
    #: ud10
    ud10: Optional[str] = None
    #: ud11
    ud11: Optional[str] = None
    #: ud12
    ud12: Optional[str] = None
    #: ud13
    ud13: Optional[str] = None
    #: ud14
    ud14: Optional[str] = None
    #: ud15
    ud15: Optional[str] = None
    #: ud16
    ud16: Optional[str] = None
    #: ud17
    ud17: Optional[str] = None
    #: ud18
    ud18: Optional[str] = None
    #: ud19
    ud19: Optional[str] = None
    #: ud20
    ud20: Optional[str] = None
    #: ud21
    ud21: Optional[str] = None
    #: ud22
    ud22: Optional[str] = None
    #: ud23
    ud23: Optional[str] = None
    #: ud24
    ud24: Optional[str] = None
    #: ud25
    ud25: Optional[str] = None
    #: ud26
    ud26: Optional[str] = None
    #: ud27
    ud27: Optional[str] = None
    #: ud28
    ud28: Optional[str] = None
    #: ud29
    ud29: Optional[str] = None
    #: ud30
    ud30: Optional[str] = None
    #: ud31
    ud31: Optional[str] = None
    #: ud32
    ud32: Optional[str] = None
    #: ud33
    ud33: Optional[str] = None
    #: ud34
    ud34: Optional[str] = None
    #: ud35
    ud35: Optional[str] = None
    #: ud36
    ud36: Optional[str] = None
    #: ud37
    ud37: Optional[str] = None
    #: ud38
    ud38: Optional[str] = None
    #: ud39
    ud39: Optional[str] = None
    #: ud40
    ud40: Optional[str] = None
    #: ud41
    ud41: Optional[str] = None
    #: ud42
    ud42: Optional[str] = None
    #: ud43
    ud43: Optional[str] = None
    #: ud44
    ud44: Optional[str] = None
    #: ud45
    ud45: Optional[str] = None
    #: ud46
    ud46: Optional[str] = None
    #: ud47
    ud47: Optional[str] = None
    #: ud48
    ud48: Optional[str] = None
    #: ud49
    ud49: Optional[str] = None
    #: ud50
    ud50: Optional[str] = None
    #: ud51
    ud51: Optional[str] = None
    #: ud52
    ud52: Optional[str] = None
    #: ud53
    ud53: Optional[str] = None
    #: ud54
    ud54: Optional[str] = None
    #: ud55
    ud55: Optional[str] = None
    #: ud56
    ud56: Optional[str] = None
    #: ud57
    ud57: Optional[str] = None
    #: ud58
    ud58: Optional[str] = None
    #: ud59
    ud59: Optional[str] = None
    #: ud60
    ud60: Optional[str] = None
    #: 周，期间类特有属性
    week: Optional[str] = None


class DimensionMemberOperationSw(BaseModel):
    #: 支付类型,科目类型特有
    accounttype: Optional[str] = None
    #: 实际天数,期间类型特有
    actualDate: Optional[str] = None
    #: 实际年份,年份类型特有
    actualYear: Optional[str] = None
    #: 比重
    aggweight: Optional[float] = None
    #: 数据长度,科目类型特有
    dataLength: Optional[int] = None
    #: 数据精度,科目类型特有
    dataPrecision: Optional[int] = None
    #: 数据类型,科目类型特有
    datatype: Optional[str] = None
    #: 结束期间
    end_period: Optional[str] = None
    #: 结束年份
    end_year: Optional[str] = None
    #: 流类型,科目类型特有
    flowtype: Optional[str] = None
    #: 公式
    formula: Optional[str] = None
    #: 半年,期间类型特有
    halfyear: Optional[str] = None
    #: 维度成员id
    id: Optional[int] = None
    #: 排序，指该节点在同一个父节点下的排序，从0开始
    index: Optional[int] = None
    #: 父节点,科目类型特有
    inputOnParentNode: Optional[bool] = None
    #: 自上而下,版本类型特有
    isTopDown: Optional[bool] = None
    #: 是否生效
    is_active: Optional[bool] = None
    #: 是否叶子节点
    is_base: Optional[bool] = None
    #: 是否计算
    is_calculated: Optional[bool] = None
    #: 是否模块化
    is_modula: Optional[bool] = None
    #: 层级
    level: Optional[int] = None
    #: 本位币,实体类型特有
    local_currency: Optional[str] = None
    #: 月,期间类型特有
    month: Optional[str] = None
    #: 多语言描述
    multilingual: Optional[Any] = None
    #: 成员编码
    name: Optional[str] = None
    #: 操作类型
    operation: Optional[str] = None
    #: 原成员编码
    origin_name: Optional[str] = None
    #: 原父节点编码
    origin_parent_name: Optional[str] = None
    #: 父节点编码
    parent_name: Optional[str] = None
    #: 期间级别,期间类型特有
    period_level: Optional[int] = None
    #: 季度,期间类型特有
    quarter: Optional[str] = None
    #: 是否共享节点
    sharedmember: Optional[bool] = None
    #: 排序字段
    sort_col: Optional[str] = None
    #: 开始期间
    start_period: Optional[str] = None
    #: 开始年份
    start_year: Optional[str] = None
    #: 自定义ud属性
    #: ud1
    ud1: Optional[str] = None
    #: ud2
    ud2: Optional[str] = None
    #: ud3
    ud3: Optional[str] = None
    #: ud4
    ud4: Optional[str] = None
    #: ud5
    ud5: Optional[str] = None
    #: ud6
    ud6: Optional[str] = None
    #: ud7
    ud7: Optional[str] = None
    #: ud8
    ud8: Optional[str] = None
    #: ud9
    ud9: Optional[str] = None
    #: ud10
    ud10: Optional[str] = None
    #: ud11
    ud11: Optional[str] = None
    #: ud12
    ud12: Optional[str] = None
    #: ud13
    ud13: Optional[str] = None
    #: ud14
    ud14: Optional[str] = None
    #: ud15
    ud15: Optional[str] = None
    #: ud16
    ud16: Optional[str] = None
    #: ud17
    ud17: Optional[str] = None
    #: ud18
    ud18: Optional[str] = None
    #: ud19
    ud19: Optional[str] = None
    #: ud20
    ud20: Optional[str] = None
    #: ud21
    ud21: Optional[str] = None
    #: ud22
    ud22: Optional[str] = None
    #: ud23
    ud23: Optional[str] = None
    #: ud24
    ud24: Optional[str] = None
    #: ud25
    ud25: Optional[str] = None
    #: ud26
    ud26: Optional[str] = None
    #: ud27
    ud27: Optional[str] = None
    #: ud28
    ud28: Optional[str] = None
    #: ud29
    ud29: Optional[str] = None
    #: ud30
    ud30: Optional[str] = None
    #: ud31
    ud31: Optional[str] = None
    #: ud32
    ud32: Optional[str] = None
    #: ud33
    ud33: Optional[str] = None
    #: ud34
    ud34: Optional[str] = None
    #: ud35
    ud35: Optional[str] = None
    #: ud36
    ud36: Optional[str] = None
    #: ud37
    ud37: Optional[str] = None
    #: ud38
    ud38: Optional[str] = None
    #: ud39
    ud39: Optional[str] = None
    #: ud40
    ud40: Optional[str] = None
    #: ud41
    ud41: Optional[str] = None
    #: ud42
    ud42: Optional[str] = None
    #: ud43
    ud43: Optional[str] = None
    #: ud44
    ud44: Optional[str] = None
    #: ud45
    ud45: Optional[str] = None
    #: ud46
    ud46: Optional[str] = None
    #: ud47
    ud47: Optional[str] = None
    #: ud48
    ud48: Optional[str] = None
    #: ud49
    ud49: Optional[str] = None
    #: ud50
    ud50: Optional[str] = None
    #: ud51
    ud51: Optional[str] = None
    #: ud52
    ud52: Optional[str] = None
    #: ud53
    ud53: Optional[str] = None
    #: ud54
    ud54: Optional[str] = None
    #: ud55
    ud55: Optional[str] = None
    #: ud56
    ud56: Optional[str] = None
    #: ud57
    ud57: Optional[str] = None
    #: ud58
    ud58: Optional[str] = None
    #: ud59
    ud59: Optional[str] = None
    #: ud60
    ud60: Optional[str] = None
    #: 周,期间类型特有
    week: Optional[str] = None


class DimensionMemberQuerySw(BaseModel):
    """Dimension Member Query Sw

    .. admonition:: 引用接口

        - **POST** ``/dimension/query/get-access-dimension-member-list``
    """
    #: 维度展示方式 0名称 1描述 2名称-描述 
    dimensionDisplay: Optional[str] = None
    #: 维度表达式 
    dimensionExpression: Optional[str] = None
    #: 维度名
    dimensionName: Optional[str] = None
    #: 是否去重
    duplicate: Optional[bool] = None
    #: 【废弃】启用多表达式分页
    enablePager: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 【废弃】维度成员id 
    id: Optional[str] = None
    #: 分页长度
    length: Optional[int] = None
    #: 是否返回成员路径
    memberPath: Optional[bool] = None
    #: 【废弃】维度成员名
    name: Optional[str] = None
    #: 1：不分页 
    noPage: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None
    #: 【废弃】期间
    period: Optional[str] = None
    #: 返回字段
    resultString: Optional[str] = None
    #: 角色方案角色
    role: Optional[str] = None
    #: 角色方案文件夹id
    roleFolderId: Optional[str] = None
    #: 角色方案路径
    rolePath: Optional[str] = None
    #: 角色方案角色组
    rolegroup: Optional[str] = None
    #: 角色方案行号
    rsMapping: Optional[int] = None
    #: 角色方案名
    rsName: Optional[str] = None
    #: 搜索值
    searchValue: Optional[str] = None
    #: 分页起始
    start: Optional[int] = None
    #: 【废弃】年份
    year: Optional[str] = None


class DimensionMemberTreeSaveDto(BaseModel):
    """Dimension Member Tree Save Dto

    .. admonition:: 引用接口

        - **POST** ``/refactor/dimension/member/tree/save``
    """
    #: 成员操作列表
    dimensionMemberList: Optional[List[DimensionMemberOperationDto]] = None
    #: 维度名
    dimensionName: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None


class DimensionPeriodLevelObj(BaseModel):
    #: isActive
    isActive: Optional[int] = None
    #: periodLevel
    periodLevel: Optional[str] = None


class DimensionTreeErrorDto(BaseModel):
    #: dimensionMember
    dimensionMember: Optional[str] = None
    #: errorCode
    errorCode: Optional[str] = None
    #: errorMessage
    errorMessage: Optional[str] = None
    #: fieldName
    fieldName: Optional[str] = None


class DimensionTreeSaveResultDto(BaseModel):
    #: code
    code: Optional[str] = None
    #: dimensionName
    dimensionName: Optional[str] = None
    #: errors
    errors: Optional[List[DimensionTreeErrorDto]] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None


class DimensionViewObj(BaseModel):
    #: is_access
    is_access: Optional[bool] = None
    #: is_active
    is_active: Optional[bool] = None
    #: multilingual
    multilingual: Optional[Any] = None
    #: name
    name: Optional[str] = None
    #: value
    value: Optional[str] = None


class ElementBaseInfoDto(BaseModel):
    """Element Base Info Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/check/member/exists``
        - **POST** ``/dimension/check/member/exists/single``
        - **POST** ``/dimension/query/open-dimension-info-by-id``
    """
    #: elementName
    elementName: Optional[str] = None
    #: elementType
    elementType: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: memberName
    memberName: Optional[str] = None
    #: memberNames
    memberNames: Optional[List[str]] = None
    #: moduleId
    moduleId: Optional[str] = None
    #: path
    path: Optional[str] = None


class ElementBaseInfoParam(BaseModel):
    """Element Base Info Param

    .. admonition:: 引用接口

        - **POST** ``/dimension/check/exists``
        - **POST** ``/dimension/query/get-dimension-list``
        - **POST** ``/refactor/dimension/info/query``
    """
    #: 元素具体名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 文件夹
    path: Optional[str] = None


class ElementBaseQueryParam(BaseModel):
    """Element Base Query Param

    .. admonition:: 引用接口

        - **POST** ``/dimension/query/get-open-period-config``
    """
    #: 元素具体名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None


class ElementDetailVo(BaseModel):
    #: 绝对相对标志
    absoluteTag: Optional[bool] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 绝对路径
    path: Optional[str] = None
    #: 相对路径
    relativePath: Optional[str] = None
    #: 元素服务名,前端新建不需要传
    serverName: Optional[str] = None


class ElementDetailVoReq(BaseModel):
    #: 绝对相对标志
    absoluteTag: Optional[bool] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 绝对路径
    path: Optional[str] = None
    #: 相对路径
    relativePath: Optional[str] = None
    #: 元素服务名,前端新建不需要传
    serverName: Optional[str] = None


class ElementQueryBaseDto(BaseModel):
    """Element Query Base Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/query/get-view-by-period``
        - **POST** ``/refactor/dimension/info/get-view-by-period``
    """
    #: elementName
    elementName: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: showAll
    showAll: Optional[bool] = None


class Error(BaseModel):
    #: code
    code: Any = None
    #: msg
    msg: Optional[str] = None


class LevelManageDto(BaseModel):
    #: 多语言key,内部使用
    language: Optional[str] = None
    #: 层级
    level: int
    #: 层级名称
    levelName: str
    #: 多语言描述
    multilingual: Optional[Any] = None
    #: 视图
    view: Optional[str] = None


class MemberInExpressAndRsDto(BaseModel):
    """Member In Express And Rs Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/check/member/multi/express-rs/contains``
    """
    #: 维度表达式
    express: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 维度成员列表
    members: Optional[List[str]] = None
    #: path
    path: Optional[str] = None
    #: 角色方案角色
    role: Optional[str] = None
    #: 角色方案名文件夹id
    roleFolderId: Optional[str] = None
    #: 角色方案角色组
    rolegroup: Optional[str] = None
    #: 角色方案行号
    rsMapping: Optional[int] = None
    #: 角色方案名 非必传 决定是否需要权限校验
    rsName: Optional[str] = None


class MemberInExpressAndRsResult(BaseModel):
    #: 错误信息，报错的时候有值
    errorMessage: Optional[str] = None
    #: 表达式存在（且有权限）的成员 
    existingAuthorizedMembers: Optional[List[str]] = None
    #: 维度表达式
    express: Optional[str] = None
    #: 是否表达式都包含 且 满足权限
    flag: Optional[bool] = None
    #: folderId
    folderId: Optional[str] = None
    #: 表达式存在但无权限的成员 
    noAuthorizedMembers: Optional[List[str]] = None
    #: 表达式不存在的成员
    nonexistentMembers: Optional[List[str]] = None
    #: path
    path: Optional[str] = None
    #: 角色
    role: Optional[str] = None
    #: 角色方案folderId
    roleFolderId: Optional[str] = None
    #: 角色组
    rolegroup: Optional[str] = None
    #: 角色方案行号
    rsMapping: Optional[int] = None
    #: 角色方案名
    rsName: Optional[str] = None


class MemberLevelDto(BaseModel):
    """Member Level Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/query/get-member-level``
    """
    #: 不确定作用
    code: Optional[str] = None
    #: defaultSelected
    defaultSelected: Optional[str] = None
    #: dimensionExpression
    dimensionExpression: Optional[str] = None
    #: dimensionName
    dimensionName: Optional[str] = None
    #: 维度name展示样式:0-维度成员名,1-维度成员描述，2-维度成员名-维度成员描述
    displayType: Optional[str] = None
    #: 是否返回维度信息:0-不返回,1-返回
    edit: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 不确定作用
    has_access: Optional[str] = None
    #: 当前维度成员id,返回该节点下级成员列表
    id: Optional[int] = None
    #: 当前维度成员名,返回该节点下级成员列表
    name: Optional[str] = None
    #: 父级节点是否可选:true-可选,false-不可选
    parentClick: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: 不确定作用
    period: Optional[str] = None
    #: resultString
    resultString: Optional[str] = None
    #: 角色方案角色
    role: Optional[str] = None
    #: 角色方案文件夹id
    roleFolderId: Optional[str] = None
    #: 角色方案路径
    rolePath: Optional[str] = None
    #: 角色方案角色组
    rolegroup: Optional[str] = None
    #: 不确定作用
    rsDimension: Optional[str] = None
    #: 不确定作用
    rsList: Optional[str] = None
    #: 角色方案行号
    rsMapping: Optional[int] = None
    #: 角色方案名
    rsName: Optional[str] = None
    #: searchValue
    searchValue: Optional[str] = None
    #: 不确定作用
    type: Optional[str] = None
    #: 不确定作用
    year: Optional[str] = None


class MembersAndExpressDto(BaseModel):
    """Members And Express Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/check/expresses/contains/member``
    """
    #: 维度名
    dimensionName: Optional[str] = None
    #: 需过滤的维度表达式列表
    expresses: Optional[List[str]] = None
    #: folderId
    folderId: Optional[str] = None
    #: 维度成员列表
    members: Optional[List[str]] = None
    #: path
    path: Optional[str] = None


class MoreLevelMemberDto(BaseModel):
    """More Level Member Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/custom/get-more-level-member``
    """
    #: 当前层级
    currentLevel: Optional[str] = None
    #: 默认维度成员名
    defaultValue: Optional[str] = None
    #: 维度表达式
    dimensionMemberNames: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: length
    length: Optional[int] = None
    #: path
    path: Optional[str] = None
    #: resultString
    resultString: Optional[str] = None
    #: 查询方向  1向上  2本层级  3向下
    searchDirection: Optional[str] = None
    #: 查询层级
    showLevel: Optional[str] = None
    #: start
    start: Optional[int] = None


class NewDimensionMemberSaveDto(BaseModel):
    """New Dimension Member Save Dto

    .. admonition:: 引用接口

        - **POST** ``/refactor/dimension/member/save``
    """
    #: 成员列表
    dimensionMemberList: Optional[List[DimensionMemberNewDto]] = None
    #: 维度名
    dimensionName: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 保存类型:0-全量,1-增量
    increment: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 是否进行ud校验
    udCheck: Optional[bool] = None


class NewViewDto(BaseModel):
    #: isActive
    isActive: Optional[bool] = None
    #: multilingual
    multilingual: Optional[Any] = None
    #: name
    name: Optional[str] = None
    #: value
    value: Optional[str] = None


class OpenErrorDto(BaseModel):
    #: 报错信息
    errorMessage: Optional[str] = None
    #: 报错字段
    field: Optional[str] = None
    #: 字段细分属性
    field2: Optional[str] = None
    #: 页面区域
    region: Optional[str] = None


class PeriodConfig(BaseModel):
    #: isActive
    isActive: Optional[int] = None
    #: periodLevel
    periodLevel: Optional[str] = None


class PeriodConfigDto(BaseModel):
    """Period Config Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/info/build-period-config-and-member``
    """
    #: dimensionName
    dimensionName: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: levelManage
    levelManage: Optional[List[Any]] = None
    #: path
    path: Optional[str] = None


class PeriodParameter(BaseModel):
    #: periodConfig
    periodConfig: Optional[List[PeriodConfig]] = None
    #: tablePeriodViewElement
    tablePeriodViewElement: Optional[ElementDetailVo] = None
    #: viewDtos
    viewDtos: Optional[List[NewViewDto]] = None


class PeriodParameterReq(BaseModel):
    #: periodConfig
    periodConfig: Optional[List[PeriodConfig]] = None
    #: tablePeriodViewElement
    tablePeriodViewElement: Optional[ElementDetailVoReq] = None
    #: viewDtos
    viewDtos: Optional[List[NewViewDto]] = None


class RelationDimension(BaseModel):
    #: absoluteTag
    absoluteTag: Optional[bool] = None
    #: dimensionType
    dimensionType: Optional[int] = None
    #: elementName
    elementName: Optional[str] = None
    #: filed
    filed: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: serverName
    serverName: Optional[str] = None


class RelationVoReq(BaseModel):
    #: elementDetail
    elementDetail: Optional[ElementDetailVoReq] = None
    #: relationField
    relationField: Optional[str] = None
    #: relationPosition
    relationPosition: Optional[str] = None


class RelationVo(BaseModel):
    #: elementDetail
    elementDetail: Optional[ElementDetailVo] = None
    #: relationField
    relationField: Optional[str] = None
    #: relationPosition
    relationPosition: Optional[str] = None


class ResponseResult(BaseModel):
    """Response Result«object»

    .. admonition:: 引用接口

        - **POST** ``/dimension/custom/get-around-dimension`` (Response: 200)
        - **POST** ``/dimension/custom/get-dimension-member-by-level`` (Response: 200)
        - **POST** ``/dimension/custom/get-ud-value-by-express`` (Response: 200)
        - **POST** ``/dimension/query/get-access-dimension-member-list`` (Response: 200)
        - **POST** ``/dimension/query/get-all-year-period-of-sceanrio`` (Response: 200)
        - **POST** ``/dimension/query/select-dimension-member-by-name-function`` (Response: 200)
        - **POST** ``/dimension/query/select-dimension-member-by-name-function-batch`` (Response: 200)
    """
    #: code
    code: Optional[int] = None
    #: data
    data: Optional[Any] = None
    #: message
    message: Optional[str] = None
    #: status
    status: Optional[bool] = None


class ResultObj(BaseModel):
    #: errorCode
    errorCode: Optional[str] = None
    #: errorList
    errorList: Optional[List[Any]] = None
    #: resultCode
    resultCode: Optional[int] = None
    #: resultList
    resultList: Optional[List[Any]] = None
    #: resultObj
    resultObj: Optional[Any] = None
    #: resultString
    resultString: Optional[str] = None
    #: success
    success: Optional[bool] = None
    #: tipMsg
    tipMsg: Optional[str] = None


class RsInfoDto(BaseModel):
    #: 角色方案文件夹id
    folderId: Optional[str] = None
    #: 角色方案路径
    path: Optional[str] = None
    #: 角色方案角色
    role: Optional[str] = None
    #: 角色方案角色组
    roleGroup: Optional[str] = None
    #: 角色方案行号
    rsMapping: Optional[int] = None
    #: 角色方案名
    rsName: Optional[str] = None


class UdValueByExpressDto(BaseModel):
    """Ud Value By Express Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/custom/get-ud-value-by-express``
    """
    #: 维度表达式
    dimensionMemberNames: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 返回数据格式:0-list,1-map
    outFormat: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: resultString
    resultString: Optional[str] = None
    #: 排序:0-正序,1-倒叙
    reverse_order: Optional[str] = None
    #: 自定义字段表达式
    ud_express: Optional[str] = None


class UpdateViewMemberDto(BaseModel):
    """Update View Member Dto

    .. admonition:: 引用接口

        - **POST** ``/refactor/dimension/info/update-view-member``
    """
    #: 维度名
    dimensionName: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None
    #: view数据
    viewDtos: Optional[List[NewViewDto]] = None


class ViewDto(BaseModel):
    #: is_access
    is_access: Optional[bool] = None
    #: is_active
    is_active: Optional[bool] = None
    #: multilingual
    multilingual: Optional[Any] = None
    #: name
    name: Optional[str] = None
    #: value
    value: Optional[str] = None


class ViewExpressDto(BaseModel):
    """View Express Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/query/get-view-by-express``
        - **POST** ``/dimension/query/get-view-by-express-batch``
    """
    #: elementName
    elementName: Optional[str] = None
    #: express
    express: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: showAll
    showAll: Optional[bool] = None


class ViewExpressResultDto(BaseModel):
    #: elementName
    elementName: Optional[str] = None
    #: express
    express: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: showAll
    showAll: Optional[bool] = None
    #: viewMembers
    viewMembers: Optional[List[ViewDto]] = None


class YearPeriodDto(BaseModel):
    #: end_period
    end_period: Optional[str] = None
    #: end_year
    end_year: Optional[str] = None
    #: start_period
    start_period: Optional[str] = None
    #: start_year
    start_year: Optional[str] = None


class AllYearPeriodOfSceanrioDto(BaseModel):
    """All Year Period Of Sceanrio Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/query/get-all-year-period-of-sceanrio``
    """
    #: 是否查询period所有层级 1是
    allParam: Optional[str] = None
    #: 场景维度名
    dimensionName: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 年份期间组合
    paramList: Optional[List[YearPeriodDto]] = None
    #: 路径
    path: Optional[str] = None


class Dimension(BaseModel):
    """dimension

    .. admonition:: 引用接口

        - **POST** ``/dimension-save/dimension-member-change-save``
        - **POST** ``/refactor/dimension/info/save``
    """
    #: accessTable_dim_col_table
    accessTable_dim_col_table: Optional[str] = None
    #: accessTable_dim_col_table_column
    accessTable_dim_col_table_column: Optional[str] = None
    #: addFieldValAsDimMember
    addFieldValAsDimMember: Optional[bool] = None
    #: application_name
    application_name: Optional[str] = None
    #: auto_sub_name
    auto_sub_name: Optional[int] = None
    #: create_time
    create_time: Optional[str] = None
    #: creator
    creator: Optional[str] = None
    #: creator_email
    creator_email: Optional[str] = None
    #: databaseServerName
    databaseServerName: Optional[str] = None
    #: description
    description: Optional[str] = None
    #: description1
    description1: Optional[str] = None
    #: description2
    description2: Optional[str] = None
    #: description3
    description3: Optional[str] = None
    #: description4
    description4: Optional[str] = None
    #: description5
    description5: Optional[str] = None
    #: description6
    description6: Optional[str] = None
    #: description7
    description7: Optional[str] = None
    #: description8
    description8: Optional[str] = None
    #: dimMemberParentName
    dimMemberParentName: Optional[str] = None
    #: dimensionType
    dimensionType: Optional[int] = None
    #: dimensionUd
    dimensionUd: Optional[List[Any]] = None
    #: dimension_info
    dimension_info: Optional[str] = None
    #: end_year
    end_year: Optional[str] = None
    #: errors
    errors: Optional[List[OpenErrorDto]] = None
    #: file_name
    file_name: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: id
    id: Optional[str] = None
    #: isSelected
    isSelected: Optional[str] = None
    #: is_sub_default
    is_sub_default: Optional[int] = None
    #: is_sub_dimension
    is_sub_dimension: Optional[int] = None
    #: language
    language: Optional[str] = None
    #: languageKey
    languageKey: Optional[str] = None
    #: last_modify_time
    last_modify_time: Optional[str] = None
    #: last_modify_user
    last_modify_user: Optional[str] = None
    #: last_modify_user_email
    last_modify_user_email: Optional[str] = None
    #: levelManage
    levelManage: Optional[List[Any]] = None
    #: moduleId
    moduleId: Optional[str] = None
    #: multilingual
    multilingual: Optional[Any] = None
    #: name
    name: Optional[str] = None
    #: no_create_table
    no_create_table: Optional[int] = None
    #: owner
    owner: Optional[str] = None
    #: parentId
    parentId: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: periodConfig
    periodConfig: Optional[List[PeriodConfig]] = None
    #: period_dimension
    period_dimension: Optional[str] = None
    #: period_level
    period_level: Optional[int] = None
    #: relationDimensions
    relationDimensions: Optional[List[RelationDimension]] = None
    #: scenario_sub
    scenario_sub: Optional[int] = None
    #: security_level
    security_level: Optional[str] = None
    #: start_year
    start_year: Optional[str] = None
    #: status
    status: Optional[str] = None
    #: system
    system: Optional[str] = None
    #: system_security_level
    system_security_level: Optional[str] = None
    #: tableClosure
    tableClosure: Optional[ElementDetailVo] = None
    #: tableDimension
    tableDimension: Optional[ElementDetailVo] = None
    #: tablePeriodView
    tablePeriodView: Optional[str] = None
    #: tablePeriodViewElement
    tablePeriodViewElement: Optional[ElementDetailVo] = None
    #: table_calendar_full
    table_calendar_full: Optional[str] = None
    #: table_calendar_info
    table_calendar_info: Optional[str] = None
    #: table_closure
    table_closure: Optional[str] = None
    #: table_dimension
    table_dimension: Optional[str] = None
    #: table_member_access
    table_member_access: Optional[str] = None
    #: table_ud_byperiod
    table_ud_byperiod: Optional[str] = None
    #: table_ud_duration
    table_ud_duration: Optional[str] = None
    #: tcFolderId
    tcFolderId: Optional[str] = None
    #: tcServerName
    tcServerName: Optional[str] = None
    #: tdFolderId
    tdFolderId: Optional[str] = None
    #: tdServerName
    tdServerName: Optional[str] = None
    #: ud1_alias
    ud1_alias: Optional[str] = None
    #: ud2_alias
    ud2_alias: Optional[str] = None
    #: ud3_alias
    ud3_alias: Optional[str] = None
    #: useLevelManage
    useLevelManage: Optional[bool] = None
    #: use_active_duration
    use_active_duration: Optional[int] = None
    #: version_sub
    version_sub: Optional[int] = None
    #: viewDtos
    viewDtos: Optional[List[ViewDto]] = None


class DimensionAccessVo(BaseModel):
    """Dimension Access Vo

    .. admonition:: 引用接口

        - **POST** ``/basic/dimension/refactor/get-dimension-member-list-access``
    """
    #: 维度表达式 
    dimensionExpression: Optional[str] = None
    #: 维度名
    dimensionName: Optional[str] = None
    #: 是否去重-true去重 false不去重
    duplicate: Optional[bool] = None
    #: 是否为精确查询
    exactQuery: Optional[bool] = None
    #: 返回列
    fieldList: Optional[List[str]] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 是否返回维度成员路径 - true返回 false不返回 
    memberPath: Optional[bool] = None
    #: 元素路径
    path: Optional[str] = None
    #: 角色方案信息
    rsInfo: Optional[RsInfoDto] = None
    #: 模糊搜索类型 0-名称 1-描述 2-名称+描述
    searchType: Optional[int] = None
    #: 搜索值
    searchValue: Optional[str] = None
    #: 是否共享节点去重- true去重 false不去重
    sharedMemDuplicate: Optional[bool] = None


class DimensionChangeSaveResult(BaseModel):
    #: code
    code: Any = None
    #: dimensionName
    dimensionName: Optional[str] = None
    #: errors
    errors: Optional[List[Error]] = None


class DimensionExpressionVo(BaseModel):
    """Dimension Expression Vo

    .. admonition:: 引用接口

        - **POST** ``/basic/dimension/refactor/select-dimension-expression``
        - **POST** ``/basic/dimension/refactor/select-dimension-expression-grouping-by-function``
    """
    #: 维度表达式
    dimensionExpression: Optional[str] = None
    #: 是否去重- true去重 false不去重
    duplicate: Optional[bool] = None
    #: 返回字段
    fieldList: Optional[List[str]] = None
    #: 元素folderId
    folderId: Optional[str] = None
    #: 是否忽略不存在的维度成员
    ignoreIllegalMember: Optional[bool] = None
    #: 元素path
    path: Optional[str] = None
    #: 排序:0-原本顺序,1-自下而上
    reverseOrder: Optional[int] = None
    #: 角色方案信息
    rsInfo: Optional[RsInfoDto] = None
    #: 是否共享节点去重- true去重 false不去重
    sharedMemDuplicate: Optional[bool] = None


class DimensionMemberChangeSaveSw(BaseModel):
    #: dimensionInfo
    dimensionInfo: Optional[DimensionInfoSw] = None
    #: dimensionMemberList
    dimensionMemberList: Optional[List[DimensionMemberOperationSw]] = None


class DimensionRelationVo(BaseModel):
    """Dimension Relation Vo

    .. admonition:: 引用接口

        - **POST** ``/dimension/info/relation``
    """
    #: elementInfoRelationList
    elementInfoRelationList: Optional[List[RelationVoReq]] = None
    #: 文件夹id
    templateFolderId: Optional[str] = None
    #: 元素名称
    templateName: Optional[str] = None


class DimensionTreeVo(BaseModel):
    """Dimension Tree Vo

    .. admonition:: 引用接口

        - **POST** ``/basic/dimension/refactor/get-dimension-tree``
    """
    #: 维度表达式
    dimensionExpression: Optional[str] = None
    #: 维度名
    dimensionName: Optional[str] = None
    #: 返回列
    fieldList: Optional[List[str]] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 当前选中节点id
    parentNodeId: Optional[int] = None
    #: 元素路径
    path: Optional[str] = None
    #: 角色方案信息
    rsInfo: Optional[RsInfoDto] = None


class DimensionUdDto(BaseModel):
    #: ud别名
    alias: str
    #: 小数精度，数字类型专用
    digitLen: Optional[str] = None
    #: 维度显示类型
    dimensionDisplay: Optional[int] = None
    #: 关联元素信息，值列表或维度类型有用
    elementDetail: Optional[ElementDetailVo] = None
    #: 内部标志位
    filed: Optional[str] = None
    #: 日期格式，日期类型专用
    instruction: Optional[str] = None
    #: 是否必填
    isMandatory: Optional[bool] = None
    #: 多语言key，内部使用
    language: Optional[str] = None
    #: 文本长度，文本类型专用
    length: Optional[int] = None
    #: 是否可以等于最大值，数字类型专用
    maxEqual: Optional[bool] = None
    #: 整数部分长度，数字类型专用
    maxLen: Optional[str] = None
    #: 最大值，数字类型专用
    maximun: Optional[str] = None
    #: 是否可以等于最小值，数字类型专用
    minEqual: Optional[bool] = None
    #: 最小值，数字类型专用
    minimun: Optional[str] = None
    #: 多语言描述
    multilingual: Optional[Any] = None
    #: 是否百分比展示，数字类型专用
    percentage: Optional[bool] = None
    #: script
    script: Optional[str] = None
    #: 值列表显示类型
    smartListDisplay: Optional[int] = None
    #: ud编码
    udName: str
    #: ud关键字，当ud是值列表或维度时为表达式
    valueKey: Optional[str] = None
    #: ud类型：1.文本; 3.值列表; 8.维度表达式; 11.时间/日期; 12.用户; 15.数字
    valueType: int


class DimensionUdDtoReq(BaseModel):
    #: ud别名
    alias: str
    #: 小数精度，数字类型专用
    digitLen: Optional[str] = None
    #: 维度显示类型
    dimensionDisplay: Optional[int] = None
    #: 关联元素信息，值列表或维度类型有用
    elementDetail: Optional[ElementDetailVoReq] = None
    #: 内部标志位
    filed: Optional[str] = None
    #: 日期格式，日期类型专用
    instruction: Optional[str] = None
    #: 是否必填
    isMandatory: Optional[bool] = None
    #: 多语言key，内部使用
    language: Optional[str] = None
    #: 文本长度，文本类型专用
    length: Optional[int] = None
    #: 是否可以等于最大值，数字类型专用
    maxEqual: Optional[bool] = None
    #: 整数部分长度，数字类型专用
    maxLen: Optional[str] = None
    #: 最大值，数字类型专用
    maximun: Optional[str] = None
    #: 是否可以等于最小值，数字类型专用
    minEqual: Optional[bool] = None
    #: 最小值，数字类型专用
    minimun: Optional[str] = None
    #: 多语言描述
    multilingual: Optional[Any] = None
    #: 是否百分比展示，数字类型专用
    percentage: Optional[bool] = None
    #: script
    script: Optional[str] = None
    #: 值列表显示类型
    smartListDisplay: Optional[int] = None
    #: ud编码
    udName: str
    #: ud关键字，当ud是值列表或维度时为表达式
    valueKey: Optional[str] = None
    #: ud类型：1.文本; 3.值列表; 8.维度表达式; 11.时间/日期; 12.用户; 15.数字
    valueType: int


class DimensionUdObj(BaseModel):
    #: alias
    alias: Optional[str] = None
    #: digitLen
    digitLen: Optional[str] = None
    #: dimensionDisplay
    dimensionDisplay: Optional[int] = None
    #: elementDetail
    elementDetail: Optional[ElementDetailVo] = None
    #: folderId
    folderId: Optional[str] = None
    #: instruction
    instruction: Optional[str] = None
    #: length
    length: Optional[int] = None
    #: mandatory
    mandatory: Optional[bool] = None
    #: maxEqual
    maxEqual: Optional[bool] = None
    #: maxLen
    maxLen: Optional[int] = None
    #: maximun
    maximun: Optional[str] = None
    #: minEqual
    minEqual: Optional[bool] = None
    #: minimun
    minimun: Optional[str] = None
    #: moduleId
    moduleId: Optional[str] = None
    #: multilingual
    multilingual: Optional[Any] = None
    #: percentage
    percentage: Optional[bool] = None
    #: smartListDisplay
    smartListDisplay: Optional[int] = None
    #: udName
    udName: Optional[str] = None
    #: valueKey
    valueKey: Optional[str] = None
    #: valueType
    valueType: Optional[int] = None


class NewDimension(BaseModel):
    #: 数据版本
    dataVersion: Optional[int] = None
    #: dimensionCacheKey
    dimensionCacheKey: Optional[str] = None
    #: 维度类型，0:Normal; 1: Scenario; 2: Version; 3: Entity; 4: Account; 5: Year; 6:Period;
    dimensionType: int
    #: 维度ud信息
    dimensionUd: Optional[List[DimensionUdDto]] = None
    #: 报错信息
    errors: Optional[List[OpenErrorDto]] = None
    #: 文件夹id,与路径任填其一或都填
    folderId: Optional[str] = None
    #: 维度id，新建时传0
    id: Optional[str] = None
    #: 主体信息多语言key
    language: Optional[str] = None
    #: 层级管理信息
    levelManage: Optional[List[LevelManageDto]] = None
    #: 组件id
    moduleId: str
    #: 多语言描述
    multilingual: Optional[Any] = None
    #: 维度编码
    name: str
    #: 路径，与文件夹id任填其一或都填
    path: Optional[str] = None
    #: 期间类特有参数
    periodParameter: Optional[PeriodParameter] = None
    #: 关联维度，比如场景类管理年份期间，实体类管理本位币
    relationDimensions: Optional[List[RelationDimension]] = None
    #: 维度成员关系表元素
    tableClosure: Optional[ElementDetailVo] = None
    #: 维度成员表元素
    tableDimension: Optional[ElementDetailVo] = None
    #: 是否启用层级管理
    useLevelManage: Optional[bool] = None


class NewDimensionReq(BaseModel):
    #: 数据版本
    dataVersion: Optional[int] = None
    #: 维度类型，0:Normal; 1: Scenario; 2: Version; 3: Entity; 4: Account; 5: Year; 6:Period;
    dimensionType: int
    #: 维度ud信息
    dimensionUd: Optional[List[DimensionUdDtoReq]] = None
    #: 报错信息
    errors: Optional[List[OpenErrorDto]] = None
    #: 文件夹id,与路径任填其一或都填
    folderId: Optional[str] = None
    #: 维度id，新建时传0
    id: Optional[str] = None
    #: 主体信息多语言key
    language: Optional[str] = None
    #: 层级管理信息
    levelManage: Optional[List[LevelManageDto]] = None
    #: 组件id
    moduleId: str
    #: 多语言描述
    multilingual: Optional[Any] = None
    #: 维度编码
    name: str
    #: 路径，与文件夹id任填其一或都填
    path: Optional[str] = None
    #: 期间类特有参数
    periodParameter: Optional[PeriodParameterReq] = None
    #: 关联维度，比如场景类管理年份期间，实体类管理本位币
    relationDimensions: Optional[List[RelationDimension]] = None
    #: 维度成员关系表元素
    tableClosure: Optional[ElementDetailVoReq] = None
    #: 维度成员表元素
    tableDimension: Optional[ElementDetailVoReq] = None
    #: tablePeriodViewElement
    tablePeriodViewElement: Optional[ElementDetailVoReq] = None
    #: 是否启用层级管理
    useLevelManage: Optional[bool] = None


class DimensionForTableCleanDto(BaseModel):
    #: dimension
    dimension: Optional[NewDimension] = None
    #: dimensionUdList
    dimensionUdList: Optional[List[DimensionUdDto]] = None
    #: isActive
    isActive: Optional[bool] = None
    #: memberList
    memberList: Optional[List[Any]] = None


class DimensionInfoObj(BaseModel):
    #: dimensionType
    dimensionType: Optional[int] = None
    #: dimensionUd
    dimensionUd: Optional[List[DimensionUdObj]] = None
    #: folderId
    folderId: Optional[str] = None
    #: id
    id: Optional[str] = None
    #: levelManage
    levelManage: Optional[List[DimensionLevelManageObj]] = None
    #: moduleId
    moduleId: Optional[str] = None
    #: multilingual
    multilingual: Optional[Any] = None
    #: name
    name: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: periodConfig
    periodConfig: Optional[List[DimensionPeriodLevelObj]] = None
    #: relationDimensions
    relationDimensions: Optional[List[RelationDimension]] = None
    #: useLevelManage
    useLevelManage: Optional[bool] = None
    #: viewDtos
    viewDtos: Optional[List[DimensionViewObj]] = None


class DimensionInfoAndMemberObj(BaseModel):
    """Dimension Info And Member Obj

    .. admonition:: 引用接口

        - **POST** ``/finance/dimension/save-dimension-and-member``
    """
    #: dimensionInfo
    dimensionInfo: Optional[DimensionInfoObj] = None
    #: dimensionMemberList
    dimensionMemberList: Optional[List[DimensionMemberChangeObj]] = None


class DimensionMemberSaveDto(BaseModel):
    """Dimension Member Save Dto

    .. admonition:: 引用接口

        - **POST** ``/dimension/member/save-dimension-member``
    """
    #: dimensionMemberList
    dimensionMemberList: Optional[List['DimensionMembersDto']] = None
    #: dimensionName
    dimensionName: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: 保存类型:0-全量,1-增量
    increment: Optional[str] = None
    #: path
    path: Optional[str] = None


class DimensionMembersDto(BaseModel):
    #: accounttype
    accounttype: Optional[str] = None
    #: actualDate
    actualDate: Optional[str] = None
    #: actualYear
    actualYear: Optional[str] = None
    #: aggweight
    aggweight: Optional[float] = None
    #: curr_level_sort
    curr_level_sort: Optional[int] = None
    #: dataLength
    dataLength: Optional[int] = None
    #: dataPrecision
    dataPrecision: Optional[int] = None
    #: datatype
    datatype: Optional[str] = None
    #: description_ar
    description_ar: Optional[str] = None
    #: description_de
    description_de: Optional[str] = None
    #: description_en
    description_en: Optional[str] = None
    #: description_es
    description_es: Optional[str] = None
    #: description_fr
    description_fr: Optional[str] = None
    #: description_ru
    description_ru: Optional[str] = None
    #: description_zh_cn
    description_zh_cn: Optional[str] = None
    #: description_zh_tw
    description_zh_tw: Optional[str] = None
    #: dmChildren
    dmChildren: Optional[List['DimensionMembersDto']] = None
    #: end_period
    end_period: Optional[str] = None
    #: end_year
    end_year: Optional[str] = None
    #: flowtype
    flowtype: Optional[str] = None
    #: formula
    formula: Optional[str] = None
    #: halfyear
    halfyear: Optional[str] = None
    #: id
    id: Optional[int] = None
    #: inputOnParentNode
    inputOnParentNode: Optional[bool] = None
    #: isTopDown
    isTopDown: Optional[bool] = None
    #: is_active
    is_active: Optional[bool] = None
    #: is_base
    is_base: Optional[bool] = None
    #: is_calculated
    is_calculated: Optional[bool] = None
    #: is_modula
    is_modula: Optional[bool] = None
    #: level
    level: Optional[int] = None
    #: local_currency
    local_currency: Optional[str] = None
    #: month
    month: Optional[str] = None
    #: multilingual
    multilingual: Optional[Any] = None
    #: name
    name: Optional[str] = None
    #: p0
    p0: Optional[int] = None
    #: p1
    p1: Optional[int] = None
    #: p10
    p10: Optional[int] = None
    #: p11
    p11: Optional[int] = None
    #: p12
    p12: Optional[int] = None
    #: p13
    p13: Optional[int] = None
    #: p14
    p14: Optional[int] = None
    #: p15
    p15: Optional[int] = None
    #: p16
    p16: Optional[int] = None
    #: p17
    p17: Optional[int] = None
    #: p18
    p18: Optional[int] = None
    #: p19
    p19: Optional[int] = None
    #: p2
    p2: Optional[int] = None
    #: p3
    p3: Optional[int] = None
    #: p4
    p4: Optional[int] = None
    #: p5
    p5: Optional[int] = None
    #: p6
    p6: Optional[int] = None
    #: p7
    p7: Optional[int] = None
    #: p8
    p8: Optional[int] = None
    #: p9
    p9: Optional[int] = None
    #: parent_id
    parent_id: Optional[str] = None
    #: parent_name
    parent_name: Optional[str] = None
    #: period_level
    period_level: Optional[int] = None
    #: quarter
    quarter: Optional[str] = None
    #: selfChange
    selfChange: Optional[bool] = None
    #: sharedmember
    sharedmember: Optional[bool] = None
    #: sort_col
    sort_col: Optional[str] = None
    #: start_period
    start_period: Optional[str] = None
    #: start_year
    start_year: Optional[str] = None
    #: 自定义ud属性
    #: ud1
    ud1: Optional[str] = None
    #: ud2
    ud2: Optional[str] = None
    #: ud3
    ud3: Optional[str] = None
    #: ud4
    ud4: Optional[str] = None
    #: ud5
    ud5: Optional[str] = None
    #: ud6
    ud6: Optional[str] = None
    #: ud7
    ud7: Optional[str] = None
    #: ud8
    ud8: Optional[str] = None
    #: ud9
    ud9: Optional[str] = None
    #: ud10
    ud10: Optional[str] = None
    #: ud11
    ud11: Optional[str] = None
    #: ud12
    ud12: Optional[str] = None
    #: ud13
    ud13: Optional[str] = None
    #: ud14
    ud14: Optional[str] = None
    #: ud15
    ud15: Optional[str] = None
    #: ud16
    ud16: Optional[str] = None
    #: ud17
    ud17: Optional[str] = None
    #: ud18
    ud18: Optional[str] = None
    #: ud19
    ud19: Optional[str] = None
    #: ud20
    ud20: Optional[str] = None
    #: ud21
    ud21: Optional[str] = None
    #: ud22
    ud22: Optional[str] = None
    #: ud23
    ud23: Optional[str] = None
    #: ud24
    ud24: Optional[str] = None
    #: ud25
    ud25: Optional[str] = None
    #: ud26
    ud26: Optional[str] = None
    #: ud27
    ud27: Optional[str] = None
    #: ud28
    ud28: Optional[str] = None
    #: ud29
    ud29: Optional[str] = None
    #: ud30
    ud30: Optional[str] = None
    #: ud31
    ud31: Optional[str] = None
    #: ud32
    ud32: Optional[str] = None
    #: ud33
    ud33: Optional[str] = None
    #: ud34
    ud34: Optional[str] = None
    #: ud35
    ud35: Optional[str] = None
    #: ud36
    ud36: Optional[str] = None
    #: ud37
    ud37: Optional[str] = None
    #: ud38
    ud38: Optional[str] = None
    #: ud39
    ud39: Optional[str] = None
    #: ud40
    ud40: Optional[str] = None
    #: ud41
    ud41: Optional[str] = None
    #: ud42
    ud42: Optional[str] = None
    #: ud43
    ud43: Optional[str] = None
    #: ud44
    ud44: Optional[str] = None
    #: ud45
    ud45: Optional[str] = None
    #: ud46
    ud46: Optional[str] = None
    #: ud47
    ud47: Optional[str] = None
    #: ud48
    ud48: Optional[str] = None
    #: ud49
    ud49: Optional[str] = None
    #: ud50
    ud50: Optional[str] = None
    #: ud51
    ud51: Optional[str] = None
    #: ud52
    ud52: Optional[str] = None
    #: ud53
    ud53: Optional[str] = None
    #: ud54
    ud54: Optional[str] = None
    #: ud55
    ud55: Optional[str] = None
    #: ud56
    ud56: Optional[str] = None
    #: ud57
    ud57: Optional[str] = None
    #: ud58
    ud58: Optional[str] = None
    #: ud59
    ud59: Optional[str] = None
    #: ud60
    ud60: Optional[str] = None
    #: week
    week: Optional[str] = None


DimensionMemberSaveDto.update_forward_refs()
DimensionMembersDto.update_forward_refs()
