"""
APIs provided by dimension-server1-2

generated by api_code_gen.py
  - **filename** : ``dimension.py``
  - **json timestamp** : ``2023-05-26 15:05:44``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.dimension import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable

import deepfos.api.V1_1.dimension as last_ver

__all__ = ['DimensionAPI']


class DimMemberAPI(ChildAPI):
    endpoint = '/'
    
    @post('basic/dimension/refactor/get-dimension-member')
    def basic_dimension_refactor_get_dimension_member(self, vo: DimensionByIdOrNameVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-维度成员单个查询
    
        维度成员批量查询，通用接口 by 维度成员id或name根据id或
        name或id+name查询维度成员
        """
        return {'body': vo}
    
    @post('basic/dimension/refactor/get-dimension-member-by-ids')
    def basic_dimension_refactor_get_dimension_member_by_ids(self, vo: DimensionByIdsVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-维度成员批量查询
    
        维度成员批量查询，通用接口 by 维度成员id
        """
        return {'body': vo}
    
    @post('basic/dimension/refactor/get-dimension-member-for-table')
    def basic_dimension_refactor_get_dimension_member_for_table(self, vo: DimensionForTableVo) -> Union[DimensionForTableCleanDto, Awaitable[DimensionForTableCleanDto]]:
        """
        【★】维度-数据-维度成员表格清单查询
    
        维度成员批量查询，通用接口 （维度表格编辑视图 - 全量/增量编辑处使
        用）剔除了被动共享的维度成员
        """
        return {'body': vo}
    
    @post('basic/dimension/refactor/get-dimension-member-list-access')
    def basic_dimension_refactor_get_dimension_member_list_access(self, vo: DimensionAccessVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-维度成员平铺查询 - 不分页
    
        维度成员不分层级搜索，通用不分页查询- 1.查询维度
        (dimensionName)下维度成员 如传了维度表达式
        (dimensionExpression) 则根据表达式限制查询范围
        - 2.模糊搜索：根据关键字(searchValue)&搜索类型
        (searchType)模糊搜索- 3.是否返回维度成员路径
        (member)是处理成员在树形结构中的路径 反参中以path返回具体
        路径  PS.若未传fieldList则默认查询所有字段，若想查询当前
        语言 可传description若未传fieldList则默认查询所有
        字段，若想查询当前语言 可传description
        """
        return {'body': vo}
    
    @post('basic/dimension/refactor/get-dimension-tree')
    def basic_dimension_refactor_get_dimension_tree(self, vo: DimensionTreeVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-维度树查询 - 不分页
    
        树形不分页查询，通用查询 - 1.查询维度
        (dimensionName)下维度成员 如传了维度表达式
        (dimensionExpression) 则根据表达式限制查询范围 
        - 2.查询逻辑:根据当前选中节点(parentNodeId)查询下一
        层信息    PS.若未传当前选中节点(parentNodeId) 默
        认从根节点开始查询       若未传fieldList则默认查询所有
        字段，若想查询当前语言 可传description
        """
        return {'body': vo}
    
    @post('basic/dimension/refactor/select-dimension-expression')
    def basic_dimension_refactor_select_dimension_expression(self, vo: DimensionExpressionVo) -> Union[List, Awaitable[List]]:
        """
        【★】维度-数据-表达式查询维度成员
    
        通过表达式查询维度成员 所有方法的成员统一返回- 1.当方法中的成员不
        存在时 通过参数是否忽略不存在成员
        (ignoreIllegalMember)决定是报错提示 还是忽略这个
        方法  PS.若未传fieldList则默认查询所有字段，若想查询当前
        语言 可传description
        """
        return {'body': vo}
    
    @post('basic/dimension/refactor/select-dimension-expression-bath')
    def basic_dimension_refactor_select_dimension_expression_bath(self, dimensionExpressionTransDtoList: List[DimensionExpressionTransDto]) -> Union[List[List], Awaitable[List[List]]]:
        """
        selectDimensionExpressionBath
    
        """
        return {'body': dimensionExpressionTransDtoList}
    
    @post('basic/dimension/refactor/select-dimension-expression-grouping-by-function')
    def basic_dimension_refactor_select_dimension_expression_grouping_by_function(self, vo: DimensionExpressionVo) -> Union[Dict, Awaitable[Dict]]:
        """
        【★】维度-数据-表达式查询维度成员 - 根据方法分组
    
        通过表达式查询维度成员 - 根据方法分组- 1.当方法中的成员不存在时
         通过参数是否忽略不存在成员
        (ignoreIllegalMember)决定是报错提示 还是忽略这个
        方法  PS.若未传fieldList则默认查询所有字段，若想查询当前
        语言 可传description
        """
        return {'body': vo}
    
    @get('dimension-member/export-dimension-member')
    def dimension_member_export_dimension_member(self, dimensionName: str = None, folderId: str = None, path: str = None) -> Union[Any, Awaitable[Any]]:
        """
        【★】维度-数据-导出
    
        导出Excel维度成员
        """
        return {'param': {'dimensionName': dimensionName, 'folderId': folderId, 'path': path}}
    
    @post('dimension-member/import-dimension-member')
    def dimension_member_import_dimension_member(self, uploadFile: str, dimensionName: str = None, folderId: str = None, increment: str = None, path: str = None) -> Union[ResultObj, Awaitable[ResultObj]]:
        """
        【★】维度-数据-导入
    
        Excel导入维度成员
        """
        return {
          'body': uploadFile,
          'param': {
              'dimensionName': dimensionName,
              'folderId': folderId,
              'increment': increment,
              'path': path,
          },
        }
    
    @post('refactor/dimension/member/save')
    def refactor_dimension_member_save(self, dto: NewDimensionMemberSaveDto) -> Union[ResultObj, Awaitable[ResultObj]]:
        """
        【★】维度-数据-保存维度成员信息
    
        表格全量及增量编辑维度成员
        """
        return {'body': dto}
    
    @post('refactor/dimension/member/tree/save')
    def refactor_dimension_member_tree_save(self, dto: DimensionMemberTreeSaveDto) -> Union[DimensionTreeSaveResultDto, Awaitable[DimensionTreeSaveResultDto]]:
        """
        【★】维度-数据-树形增量编辑维度接口
    
        给页面提供可拖拉拽的增加编辑删除的增量编辑接口
        """
        return {'body': dto}


class DimCompatAPI(last_ver.DimCompatAPI):
    endpoint = '/'



class DimCheckAPI(last_ver.DimCheckAPI):
    endpoint = '/dimension/check'



class Extra(last_ver.Extra):
    endpoint = '/'

    @post('refactor/dimension/info/query')
    def refactor_dimension_info_query(self, param: ElementBaseInfoParam) -> Union[NewDimension, Awaitable[NewDimension]]:
        """
        维度-编辑-获取主体信息
    
        获取维度主体信息
        """
        return {'body': param}
    
    @post('refactor/dimension/info/save')
    def refactor_dimension_info_save(self, dimension: NewDimensionReq) -> Union[str, Awaitable[str]]:
        """
        维度-编辑-主体新建及编辑保存
    
        维度新建及编辑：-保存维度主体信息，包括层级管理信息，ud信息，以及其
        他类型维度特有配置信息，自动生成对应数据表
        """
        return {'body': dimension}

    @post('dimension/query/select-dimension-member-by-name-function')
    def dimension_query_select_dimension_member_by_name_function(self, dto: DimensionMemberByNameFunctionDto) -> Union[
        List[DimensionMemberBean], Awaitable[List[DimensionMemberBean]]]:
        """
        【旧改新】通过表达式查询维度成员

        通过表达式查询维度成员
        """
        return {'body': dto}


class DimObjectAPI(ChildAPI):
    endpoint = '/refactor/dimension/object'

    @get('sync-data')
    def sync_data(self, folderId: str = None, name: str = None, path: str = None) -> Union[Any, Awaitable[Any]]:
        """
        导出多维实体维度配置表

        """
        return {'param': {'folderId': folderId, 'name': name, 'path': path}}


class DimensionConfig(ChildAPI):
    endpoint = '/dimension/config'

    @get('entity')
    def entity(self, dimensionName: str = None, folderId: str = None, path: str = None) -> Union[List[MultidimensionalEntityConfigMemberVO], Awaitable[List[MultidimensionalEntityConfigMemberVO]]]:
        """
        多维实体维度配置表查询全部数据

        """
        return {'param': {'dimensionName': dimensionName, 'folderId': folderId, 'path': path}}

    @post('entity/increment')
    def entity_increment(self, multidimensionalEntityConfigIncrementDTO: MultidimensionalEntityConfigIncrementDTO) -> Union[None, Awaitable[None]]:
        """
        多维实体维度配置表增量保存数据

        """
        return {'body': multidimensionalEntityConfigIncrementDTO}


class DimensionAPI(DynamicRootAPI, builtin=True):
    """维度组件接口"""
    module_type = 'DIM'
    default_version = (1, 0)
    multi_version = True
    cls_name = 'DimensionAPI'
    module_name = 'deepfos.api.V1_2.dimension'
    api_version = (1, 2)

    @cached_property
    def member(self) -> DimMemberAPI:
        """
        维度数据相关接口
        """
        return DimMemberAPI(self)

    @cached_property
    def compat(self) -> DimCompatAPI:
        """
        维度旧改新接口
        """
        return DimCompatAPI(self)

    @cached_property
    def check(self) -> DimCheckAPI:
        """
        维度校验相关
        """
        return DimCheckAPI(self)

    @cached_property
    def extra(self) -> Extra:
        """
        维度其他接口
        """
        return Extra(self)

    @cached_property
    def object(self) -> DimObjectAPI:
        """
        维度与模型对象相关接口
        """
        return DimObjectAPI(self)

    @cached_property
    def config(self) -> DimensionConfig:
        """
        维度配置相关接口
        """
        return DimensionConfig(self)
