"""
APIs provided by accounting-engines-server1-0

generated by api_code_gen.py
  - **filename** : ``accounting_engines.py``
  - **json timestamp** : ``2023-01-05 14:22:11``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.accounting_engines import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['AccountingEnginesAPI', 'BillEnginesAPI','AccountingEventTypeAPI']


class EnginesAPI(ChildAPI):
    endpoint = '/accounting/engines'
    
    @post('exec/by/id')
    def exec_by_id(self, requestDTO: AccountingEnginesRequestDTO) -> Union[DataDTO, Awaitable[DataDTO]]:
        """
        会计引擎-根据元素id（支持参数）-执行
    
        """
        return {'body': requestDTO}
    
    @post('exec/by/name/type')
    def exec_by_name_type(self, requestDTO: AccountingEnginesRequestDTO) -> Union[Any, Awaitable[Any]]:
        """
        会计引擎-根据元素名称和类型-执行
    
        """
        return {'body': requestDTO}
    
    @get('get-accounting-info-by-name-type')
    def get_accounting_info_by_name_type(self, elementType: str, elementName: str, folderId: str = None, path: str = None) -> Union[AccountingEnginesDTO, Awaitable[AccountingEnginesDTO]]:
        """
        会计引擎-查询-根据name,type获取详情
    
        """
        return {
          'param': {
              'elementName': elementName,
              'elementType': elementType,
              'folderId': folderId,
              'path': path,
          },
        }
    
    @post('sync/exec/by/id')
    def sync_exec_by_id(self, requestDTO: AccountingEnginesRequestDTO) -> Union[Any, Awaitable[Any]]:
        """
        会计引擎-根据元素id（支持参数）-异步执行
    
        """
        return {'body': requestDTO}
    
    @post('update/control/status')
    def update_control_status(self, requestDTO: AccountingControlRequestDTO) -> Union[Any, Awaitable[Any]]:
        """
        会计引擎-修改执行状态
    
        """
        return {'body': requestDTO}

class EventTypeEnginesAPI(ChildAPI):
    endpoint = '/accounting/event/type'

    @get('get-info-by-id')
    def get_info_by_id(self, elementId: str) -> Union[AccEventTypeElementDTO, Awaitable[AccEventTypeElementDTO]]:
        """
        会计事件类型根据元素ID，查询详情

        """
        return {'param': {'elementId': elementId}}

    @get('get-info-by-name')
    def get_info_by_name(self, elementType: str, elementName: str, folderId: str = None, path: str = None) -> Union[AccEventTypeElementDTO, Awaitable[AccEventTypeElementDTO]]:
        """
        会计事件类型根据元素名称和类型，查询详情

        """
        return {
          'param': {
              'elementName': elementName,
              'elementType': elementType,
              'folderId': folderId,
              'path': path,
          },
        }

    @post('insert/to/event/table')
    def insert_to_event_table(self, request: AccEventTypeTableDTO) -> Union[Any, Awaitable[Any]]:
        """
        业务主健插入会计事件表

        """
        return {'body': request}

class AccountingEnginesAPI(DynamicRootAPI, builtin=True):
    """会计引擎组件接口"""
    module_type = 'ACCOUNTING'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'AccountingEnginesAPI'
    module_name = 'deepfos.api.accounting_engines'
    api_version = (1, 0)

    @cached_property
    def engines(self) -> EnginesAPI:
        """
        会计引擎接口列表
        """
        return EnginesAPI(self)

class BillEnginesAPI(DynamicRootAPI, builtin=True):
    """单据引擎组件接口"""
    module_type = 'BILL'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'BillEnginesAPI'
    module_name = 'deepfos.api.accounting_engines'
    api_version = (1, 0)

    @cached_property
    def engines(self) -> EnginesAPI:
        """
        单据引擎接口列表
        """
        return EnginesAPI(self)

class AccountingEventTypeAPI(DynamicRootAPI, builtin=True):
    """单据引擎组件接口"""
    module_type = 'ACCOUNTING_EVENT_TYPE'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'AccountingEventTypeAPI'
    module_name = 'deepfos.api.accounting_engines'
    api_version = (1, 0)

    @cached_property
    def engines(self) -> EventTypeEnginesAPI:
        """
        会计事件类型接口列表
        """
        return EventTypeEnginesAPI(self)
