"""
APIs provided by app-server

generated by model_code_gen.py
  - **filename** : ``app.py``
  - **json timestamp** : ``2022-08-16 10:07:18``
"""
from .base import RootAPI, ChildAPI, get, post
from .models.app import *
from deepfos.options import OPTION
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable
from pydantic import BaseModel as PydanticBaseModel

__all__ = ['AppAPI']


class AppElementInfoAPI(ChildAPI):
    endpoint = '/element-info'
    
    @post('copy-element')
    def copy_element(self, copyElementDto: CopyElementDto, copyBusinessDataTag: bool = None) -> Union[int, Awaitable[int]]:
        """
        复制文件夹或元素
    
        对目标文件夹无写入权限，无法复制；复制操作默认跳过无权限元素(含同名合
        并)；合并文件夹下存在同名元素，根据用户选择的替换列表更新元素，不替换
        _copy新增平台复制完成后根据组件登记时的后置通知配置信息，通知组件
        处理后续业务；注：带业务数据标识的元素直接调用对应组件服务依赖组件复制
        """
        return {'body': copyElementDto, 'param': {'copyBusinessDataTag': copyBusinessDataTag}}
    
    @post('copy-folders-elements')
    def copy_folders_elements(self, copyElementDtoList: List[CopyElementDto], copyBusinessDataTag: bool = None) -> Union[int, Awaitable[int]]:
        """
        批量复制文件夹和元素
    
        对目标文件夹无写入权限，无法复制；复制操作默认跳过无权限元素(含同名合
        并)；合并文件夹下存在同名元素，根据用户选择的替换列表更新元素，不替换
        _copy新增平台复制完成后根据组件登记时的后置通知配置信息，通知组件
        处理后续业务；批量复制发生异常时复制操作将停止，该异常前已复制成功的文
        件夹/元素不受影响注：带业务数据标识的元素直接调用对应组件服务依赖组件
        复制
        """
        return {
          'body': copyElementDtoList,
          'param': {'copyBusinessDataTag': copyBusinessDataTag},
        }
    
    @get('get-all-element')
    def get_all_element(self, elementType: str = None) -> Union[List[ElementInfoPO], Awaitable[List[ElementInfoPO]]]:
        """
        查询所有元素基础信息
    
        """
        return {'param': {'elementType': elementType}}
    
    @post('get-element-folder/by-folder-list')
    def get_element_folder_by_folder_list(self, folderList: List[FolderInfo]) -> Union[List[ElementFolderTree], Awaitable[List[ElementFolderTree]]]:
        """
        根据文件夹id查询所有子集数据接口
    
        查询某文件夹下所有文件夹及元素信息，返回树形结构
        """
        return {'body': folderList}
    
    @post('get-element-folder/by-folder-list-relation')
    def get_element_folder_by_folder_list_relation(self, folderInfoAddRelation: FolderInfoAddRelation) -> Union[List[ElementFolderTree], Awaitable[List[ElementFolderTree]]]:
        """
        根据文件夹id，元素id查询所有子集数据及关联元素接口
    
        查询某文件夹下所有文件夹及元素信息以及关联元素，返回树形结构
        """
        return {'body': folderInfoAddRelation}
    
    @post('get-server-names')
    def get_server_names(self, queryElementInfoByTypeDtoList: List[QueryElementInfoByTypeDto]) -> Union[List[ModuleServerNameVO], Awaitable[List[ModuleServerNameVO]]]:
        """
        批量获取组件服务名
    
        根据元素名称，类型，路径/文件夹等条件查询元素对应组件id，再调用
        space服务根据组件id查询组件详细信息（批量）接口(含服务名)
        """
        return {'body': queryElementInfoByTypeDtoList}
    
    @post('get-server-names/v2')
    def get_server_names_v2(self, queryModuleServerNameDtoList: List[QueryModuleServerNameDto]) -> Union[List[ModuleServerNamesVO], Awaitable[List[ModuleServerNamesVO]]]:
        """
        批量获取组件服务名带错误信息
    
        根据元素名称，类型，路径/文件夹等条件查询元素对应组件id，再调用
        space服务根据组件id查询组件详细信息（批量）接口(含服务名)
        """
        return {'body': queryModuleServerNameDtoList}
    
    @get('list')
    def list(self, folderId: str = None, moduleIdList: List[str] = None, path: str = None) -> Union[List[FolderListVO], Awaitable[List[FolderListVO]]]:
        """
        查询指定目录下元素列表接口
    
        查询某文件夹下所有文件夹及元素，其中元素描述多语言信息
        elementNameDes通过元素id和language从
        app_element_name_des表取
        """
        return {'param': {'folderId': folderId, 'moduleIdList': moduleIdList, 'path': path}}
    
    @get('list-all')
    def list_all(self, ) -> Union[List[FolderListVO], Awaitable[List[FolderListVO]]]:
        """
        查询所有元素列表信息
    
        查询当前app下所有文件夹及元素列表，其中元素描述多语言信息
        elementNameDes通过元素id和language从
        app_element_name_des表取
        """
        return {}
    
    @post('modify-element-name')
    def modify_element_name(self, modifyElementNameDto: ModifyElementNameDto) -> Union[int, Awaitable[int]]:
        """
        修改元素名称
    
        修改元素名称,存在关联元素时也需修改关联元素名称
        """
        return {'body': modifyElementNameDto}
    
    @post('move-element')
    def move_element(self, moveElementDto: MoveElementDto) -> Union[int, Awaitable[int]]:
        """
        移动文件夹或元素
    
        对目标文件夹无写入权限，无法移动；移动操作默认跳过无权限元素(含同名合
        并)；合并文件夹下存在同名元素，根据用户选择的替换列表更新元素
        """
        return {'body': moveElementDto}
    
    @post('move-folders-elements')
    def move_folders_elements(self, moveElementDtoList: List[MoveElementDto]) -> Union[int, Awaitable[int]]:
        """
        批量移动文件夹和元素
    
        对目标文件夹无写入权限，无法移动；移动操作默认跳过无权限元素(含同名合
        并)；合并文件夹下存在同名元素，根据用户选择的替换列表更新元素
        """
        return {'body': moveElementDtoList}
    
    @post('register/usable')
    def register_usable(self, elementRegisterUsableQueryDtoList: List[ElementRegisterUsableQueryDto]) -> Union[List[ElementRegisterStatusInfoVo], Awaitable[List[ElementRegisterStatusInfoVo]]]:
        """
        查询元素是否可用
    
        根据元素名称、类型、文件夹id拿到元素对应组件id，再根据组件id分别
        调用space获取其可用状态、system服务获取服务基本信息
        """
        return {'body': elementRegisterUsableQueryDtoList}


class AppElementRelatioinAPI(ChildAPI):
    endpoint = '/element-relations'
    
    @get('by-cite')
    def by_cite(self, elementType: str, elementName: str, folderId: str = None, path: str = None, relationType: List[str] = None) -> Union[List[ElementRelationInfo], Awaitable[List[ElementRelationInfo]]]:
        """
        获取某元素关联引用的元素列表接口
    
        """
        return {
          'param': {
              'elementName': elementName,
              'elementType': elementType,
              'folderId': folderId,
              'path': path,
              'relationType': relationType,
          },
        }
    
    @get('by-cited')
    def by_cited(self, elementType: str, elementName: str, folderId: str = None, path: str = None, relationType: List[str] = None) -> Union[List[ElementRelationInfo], Awaitable[List[ElementRelationInfo]]]:
        """
        获取某元素关联被引用的元素列表接口
    
        """
        return {
          'param': {
              'elementName': elementName,
              'elementType': elementType,
              'folderId': folderId,
              'path': path,
              'relationType': relationType,
          },
        }
    
    @post('referenced-element')
    def referenced_element(self, elementInfoBaseDtoList: List[ElementInfoBaseDto]) -> Union[List[ReferencedElementVO], Awaitable[List[ReferencedElementVO]]]:
        """
        获取某元素关联被引用的元素列表接口-批量
    
        获取某元素关联被引用的元素列表-批量
        """
        return {'body': elementInfoBaseDtoList}


class AppElementAPI(ChildAPI):
    endpoint = '/element'
    
    @post('element-upgrade')
    def element_upgrade(self, elementUpgradeInfoDtoList: List[ElementUpgradeInfoDto]) -> Union[ElementUpgradeInfo, Awaitable[ElementUpgradeInfo]]:
        """
        元素升级接口
    
        """
        return {'body': elementUpgradeInfoDtoList}
    
    @get('upgrade-info')
    def upgrade_info(self, type: str, name: str, folderId: str) -> Union[List[ElementUpgradeInfoVO], Awaitable[List[ElementUpgradeInfoVO]]]:
        """
        元素升级信息查询接口
    
        """
        return {'param': {'folderId': folderId, 'name': name, 'type': type}}
    
    @post('upgrade-info-batch')
    def upgrade_info_batch(self, list: List[UpgradeInfoQuerryDto]) -> Union[List[ElementUpgradeInfoVO], Awaitable[List[ElementUpgradeInfoVO]]]:
        """
        元素升级信息批量查询接口
    
        """
        return {'body': list}
    
    @get('upgrade-log/by-id')
    def upgrade_log_by_id(self, id: int) -> Union[ElementUpgradeInfo, Awaitable[ElementUpgradeInfo]]:
        """
        根据升级记录主表id查询元素升级记录接口
    
        """
        return {'param': {'id': id}}


class AppElementsAPI(ChildAPI):
    endpoint = '/elements'

    def _get_description(self, desc: Union[PydanticBaseModel, dict]):
        if desc is None:
            return None
        if isinstance(desc, PydanticBaseModel):
            desc = desc.dict(by_alias=True)
    
        new_desc = {
            k: v
            for k, v in desc.items() if v
        }
    
        if not new_desc:
            return None
        return new_desc
    
    @get('check-element-exist')
    def check_element_exist(self, elementType: str, elementName: str, folderId: str = None, path: str = None) -> Union[bool, Awaitable[bool]]:
        """
        根据元素名称/类型/路径（或文件夹id）校验该元素是否已经存在
    
        若path绝对路径有传参数，则以路径为准，通过路径去
        folder_info表拿folderId，再通过元素名称/类型/文件
        夹id查询元素是否存在
        """
        return {
          'param': {
              'elementName': elementName,
              'elementType': elementType,
              'folderId': folderId,
              'path': path,
          },
        }
    
    @post('check-element-exist-by-list')
    def check_element_exist_by_list(self, checkElementExistDtoList: List[ElementExistsDto]) -> Union[List[ElementExistsVo], Awaitable[List[ElementExistsVo]]]:
        """
        根据元素名称/类型/路径（或文件夹id）批量校验该元素是否已经存在
    
        若path绝对路径有传参数，则以路径为准，通过路径去
        folder_info表拿folderId，再通过元素名称/类型
        /folderId查询element_info元素是否存在
        """
        return {'body': checkElementExistDtoList}
    
    @get('check-element-exist/v2')
    def check_element_exist_v2(self, elementType: str, elementName: str, folderId: str = None, path: str = None, toFolderId: str = None, toPath: str = None) -> Union[ElementBaseInfoVO, Awaitable[ElementBaseInfoVO]]:
        """
        根据元素名称/类型/路径（或文件夹id）/相对路径(或相对文件夹id)校验该元素是否已经存在
    
        若path绝对/相对路径有传参数，则以路径为准，根据路径去
        folder_info表拿文件夹id，再通过元素名称/类型/文件夹
        id查询元素是否存在
        """
        return {
          'param': {
              'elementName': elementName,
              'elementType': elementType,
              'folderId': folderId,
              'path': path,
              'toFolderId': toFolderId,
              'toPath': toPath,
          },
        }
    
    @post('confirm-element')
    def confirm_element(self, confirmElementInfoDto: ConfirmElementInfoDto) -> Union[int, Awaitable[int]]:
        """
        元素实例创建确认
    
        元素表保存了元素创建完成标识confirm，未创建完成的数据不显示，元
        素实例创建完成可通过该接口更改为已确认
        """
        return {'body': confirmElementInfoDto}
    
    @post('create-element')
    def create_element(self, createElementInfoDto: CreateElementInfoDto) -> Union[ElementVO, Awaitable[ElementVO]]:
        """
        元素实例创建
    
        """
        createElementInfoDto.elementNameDesAll = self._get_description(createElementInfoDto.elementNameDesAll)
        return {'body': createElementInfoDto}
    
    @post('del-element')
    def del_element(self, removeElementInfoDtoList: List[RemoveElementInfoDto], confirm: bool = None) -> Union[int, Awaitable[int]]:
        """
        元素实例删除
    
        """
        return {'body': removeElementInfoDtoList, 'param': {'confirm': confirm}}
    
    @get('element-infos')
    def list_element_infos(self, elementType: str) -> Union[List[ElementInfoVO], Awaitable[List[ElementInfoVO]]]:
        """
        根据元素类型查询元素信息
    
        """
        return {'param': {'elementType': elementType}}
    
    @post('get-element-info-base-by-id')
    def get_element_info_base_by_id(self, elementInfoIdList: List[str]) -> Union[List[ElementInfoBaseVO], Awaitable[List[ElementInfoBaseVO]]]:
        """
        根据元素id批量查询元素基本信息（入参最大100，超过100返回空）
    
        """
        return {'body': elementInfoIdList}
    
    @post('get-element-info-by-id')
    def get_element_info_by_id(self, elementInfoIdList: List[str]) -> Union[List[ElementInfoVO], Awaitable[List[ElementInfoVO]]]:
        """
        根据元素id批量查询元素信息（入参最大100，超过100返回空）
    
        """
        return {'body': elementInfoIdList}
    
    @get('get-element-info-by-name/base-info')
    def get_element_info_by_name(self, elementName: str, elementType: str = None) -> Union[List[ElementRelationInfo], Awaitable[List[ElementRelationInfo]]]:
        """
        根据元素名称查询元素信息
    
        """
        return {'param': {'elementName': elementName, 'elementType': elementType}}
    
    @post('get-element-info-by-type')
    def get_element_info_by_type(self, queryElementInfoByTypeDtoList: List[QueryElementInfoByTypeDto]) -> Union[List[ElementInfoVO], Awaitable[List[ElementInfoVO]]]:
        """
        元素信息查询
    
        """
        return {'body': queryElementInfoByTypeDtoList}
    
    @post('get-element-permission-by-type')
    def get_element_permission_by_type(self, queryElementPermissionByTypeDtoList: List[QueryElementPermissionByTypeDto]) -> Union[List[ElementPermissionVO], Awaitable[List[ElementPermissionVO]]]:
        """
        元素权限查询
    
        根据元素类型，名称，路径/文件夹id查询元素的权限
        """
        return {'body': queryElementPermissionByTypeDtoList}
    
    @post('get-elements-by-protocol')
    def get_elements_by_protocol(self, queryElementInfoByProtocolDto: QueryElementInfoByProtocolDto, eqElementTypeChild: List[str] = None, includeElementType: str = None) -> Union[List[ElementInfoForProtocolVO], Awaitable[List[ElementInfoForProtocolVO]]]:
        """
        根据组件使用的协议查询支持的元素实例接口
    
        调用space服务获取使用该协议和版本的所有组件，再通过组件id获取元
        素信息
        """
        return {
          'body': queryElementInfoByProtocolDto,
          'param': {
              'eqElementTypeChild': eqElementTypeChild,
              'includeElementType': includeElementType,
          },
        }
    
    @post('get-elements-by-protocol-list')
    def get_elements_by_protocol_list(self, queryElementInfoByProtocolDtoList: List[QueryElementInfoByProtocolDto], elementType: List[str] = None, eqElementTypeChild: List[str] = None) -> Union[List[ElementInfoForProtocolVO], Awaitable[List[ElementInfoForProtocolVO]]]:
        """
        根据组件使用的协议查询支持的元素实例(批量)接口
    
        调用space服务获取使用该协议和版本的所有组件，再通过组件id获取元
        素信息(批量)
        """
        return {
          'body': queryElementInfoByProtocolDtoList,
          'param': {
              'elementType': elementType,
              'eqElementTypeChild': eqElementTypeChild,
          },
        }
    
    @get('get-menu-list')
    def get_menu_list(self, ) -> Union[List[ElementVO], Awaitable[List[ElementVO]]]:
        """
        获取菜单列表接口
    
        查询element-type为MEN的元素信息
        """
        return {}
    
    @post('save-element')
    def save_element(self, createElementInfoDto: CreateElementInfoDto) -> Union[int, Awaitable[int]]:
        """
        元素实例保存
    
        元素不存在创建元素，该元素所在文件夹不存在先创建文件夹再创建元素；否则
        修改元素信息
        """
        return {'body': createElementInfoDto}
    
    @post('update-element')
    def update_element(self, modifyElementInfoDto: ModifyElementInfoDto) -> Union[int, Awaitable[int]]:
        """
        元素实例更新
    
        """
        modifyElementInfoDto.elementNameDesAll = self._get_description(modifyElementInfoDto.elementNameDesAll)
        return {'body': modifyElementInfoDto}
    
    @post('update-element-warning')
    def update_element_warning(self, elementWarningDefend: ElementWarningDefend) -> Union[Any, Awaitable[Any]]:
        """
        维护元素信息警告标识接口
    
        根据path和folderId获取最终有效的folderId,根据
        elementName、elementType、folderId更新
        element_info表对应元素el_warning字段值
        """
        return {'body': elementWarningDefend}


class AppFolderAPI(ChildAPI):
    endpoint = '/folders'
    
    @post('create-folder')
    def create_folder(self, createFolderInfoDto: CreateFolderInfoDto) -> Union[int, Awaitable[int]]:
        """
        创建文件夹
    
        所在路径下不存在同名文件夹时创建
        """
        return {'body': createFolderInfoDto}
    
    @post('del-folder')
    def del_folder(self, confirm: bool = None, ids: List[str] = None) -> Union[int, Awaitable[int]]:
        """
        删除文件夹
    
        默认跳过无权限元素；根据文件夹id删除该文件夹下所有文件夹及元素，从最
        里层开始，删除发生异常时删除操作将停止，该异常前已删除成功的文件夹/元
        素不受影响
        """
        return {'body': ids, 'param': {'confirm': confirm}}
    
    @post('del-folder-element')
    def del_folder_element(self, delFolderElementDtoList: List[DelFolderElementDto], confirm: bool = None) -> Union[int, Awaitable[int]]:
        """
        批量删除文件夹和元素
    
        默认跳过无权限元素；根据元素名称、类型、组件id或者文件夹id删除对应
        元素或文件夹，批量删除发生异常时删除操作将停止，该异常前已删除成功的文
        件夹/元素不受影响
        """
        return {'body': delFolderElementDtoList, 'param': {'confirm': confirm}}
    
    @post('edit-folder')
    def edit_folder(self, modifyFolderInfoDto: ModifyFolderInfoDto) -> Union[int, Awaitable[int]]:
        """
        编辑文件夹
    
        修改文件夹信息
        """
        return {'body': modifyFolderInfoDto}
    
    @get('get-folder-full')
    def get_folder_full(self, folderId: str) -> Union[Any, Awaitable[Any]]:
        """
        查询文件夹全路径
    
        根据文件夹id查询文件夹全路径
        """
        return {'param': {'folderId': folderId}}
    
    @get('get-folder-id/by-full-path')
    def get_folder_id_by_full_path(self, fullPath: str) -> Union[Any, Awaitable[Any]]:
        """
        根据全路径查询文件夹id
    
        """
        return {'param': {'fullPath': fullPath}}
    
    @get('get-folder-info')
    def get_folder_info(self, folderId: str) -> Union[FolderInfoVO, Awaitable[FolderInfoVO]]:
        """
        查询文件夹明细
    
        """
        return {'param': {'folderId': folderId}}
    
    @get('get-folders')
    def get_folders(self, folderId: str = None) -> Union[List[FolderInfoVO], Awaitable[List[FolderInfoVO]]]:
        """
        查询文件夹列表
    
        根据文件夹id查询文件夹下所有文件
        """
        return {'param': {'folderId': folderId}}
    
    @post('update-open-extend')
    def update_open_extend(self, folderInfoUpdateOpenExtendDto: FolderInfoUpdateOpenExtendDto) -> Union[int, Awaitable[int]]:
        """
        文件夹启用/禁用继承开关接口
    
        用于用户选择是否继承于父级文件夹的权限还是自定义配置权限
        """
        return {'body': folderInfoUpdateOpenExtendDto}


class PermissionAPI(ChildAPI):
    endpoint = '/permission'
    
    @get('add-group')
    def add_group(self, groupId: str = None, pGroupId: str = None) -> Union[int, Awaitable[int]]:
        """
        新增用户组关联的权限数据
    
        """
        return {'param': {'groupId': groupId, 'pGroupId': pGroupId}}
    
    @get('delete-group')
    def delete_group(self, groupId: str = None) -> Union[int, Awaitable[int]]:
        """
        删除用户组关联的权限数据
    
        删除用户组及各子用户组关联的权限数据
        """
        return {'param': {'groupId': groupId}}
    
    @post('edit')
    def edit(self, requsetDto: RightDistributionReqBody = None) -> Union[RightDistributionRespBody, Awaitable[RightDistributionRespBody]]:
        """
        权限编辑
    
        元素及文件夹权限新增及删除
        """
        return {'body': requsetDto}
    
    @get('get-enterprise-group')
    def get_enterprise_group(self, ) -> Union[List[str], Awaitable[List[str]]]:
        """
        查询元素或文件夹中有配置 所有用户/企业所有用户组权限对应的组id
    
        2.8.0版本
        """
        return {}


class AppAPI(RootAPI):
    """应用服务接口"""
    prefix = lambda: OPTION.server.app

    @cached_property
    def element_info(self) -> AppElementInfoAPI:
        """
        元素信息
        """
        return AppElementInfoAPI(self)

    @cached_property
    def element_relation(self) -> AppElementRelatioinAPI:
        """
        元素引用关系
        """
        return AppElementRelatioinAPI(self)

    @cached_property
    def element(self) -> AppElementAPI:
        """
        元素升级信息操作接口
        """
        return AppElementAPI(self)

    @cached_property
    def elements(self) -> AppElementsAPI:
        """
        元素相关接口
        """
        return AppElementsAPI(self)

    @cached_property
    def folder(self) -> AppFolderAPI:
        """
        文件夹操作接口
        """
        return AppFolderAPI(self)

    @cached_property
    def permission(self) -> PermissionAPI:
        """
        权限接口
        """
        return PermissionAPI(self)


