"""
APIs provided by business-model-server1-0

generated by api_code_gen.py
  - **filename** : ``business_model.py``
  - **json timestamp** : ``2022-07-26 13:51:23``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.business_model import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['BusinessModelAPI']


class ModelAPI(ChildAPI):
    endpoint = '/business'

    @get('model')
    def query(self, elementName: str, folderId: str = None, path: str = None) -> Union[BusinessModelResultVO, Awaitable[BusinessModelResultVO]]:
        """
        业务模型基础配置查询

        业务模型配置数据(不含权限)的查询，使用场景：1、通过页面配置业务模型
        保存时使用
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}

    @post('model')
    def save(self, logicTableInfo: BusinessModelDTO) -> Union[BusinessModelResultVO, Awaitable[BusinessModelResultVO]]:
        """
        业务模型基础配置保存

        业务模型配置(不含权限)保存，使用场景：1、通过页面配置业务模型保存时
        使用
        """
        return {'body': logicTableInfo}


class ApprovalAPI(ChildAPI):
    endpoint = '/business/model'

    @post('approval-operation')
    def operation(self, approveDTO: BusinessModelApproveDTO) -> Union[OperateRecordResponseVO, Awaitable[OperateRecordResponseVO]]:
        """
        业务模型审批操作

        针对每个子模型配置的审批流进行审批操作自测场景：1、传入参数不合法：如
        操作id不存在，操作和状态对应不上等2、业务模型未配置角色方案，提示未
        配置角色方案3、用户无角色，无法执行4、有角色状态正常，会生成一条审批
        记录，并更改业务数据的审批状态
        """
        return {'body': approveDTO}

    @post('approval-records')
    def records(self, approveListDTO: BusinessModelApproveListDTO) -> Union[List[ApprovalRecordVo], Awaitable[List[ApprovalRecordVo]]]:
        """
        业务模型审批记录查询

        获取指定模型的业务审批记录，自测场景：1、业务模型未启用角色方案，可获
        取全部的审批记录，无操作按钮2、业务模型启用角色方案，用户有对应角色，
        可获取全部审批记录，并在最近一条审批记录上展示对应操作按钮3、业务模型
        启用角色方案，用户无对应角色，可获取全部审批记录，无操作按钮
        """
        return {'body': approveListDTO}


class ConfigureAPI(ChildAPI):
    endpoint = '/business/model/form'

    @get('partitions')
    def partitions(self, elementName: str, folderId: str = None, path: str = None) -> Union[List[PartitionDTO], Awaitable[List[PartitionDTO]]]:
        """
        业务模型模型列表查询-模型元素

        list 根据模型名称、目录获取业务模型主/子模型信息列表
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}

    @get('structure/top')
    def structure_top(self, elementName: str, folderId: str = None, path: str = None) -> Union[StructureDTO, Awaitable[StructureDTO]]:
        """
        业务模型主表配置查询接口-模型元素

        object 含数据表信息、字段信息、业务主键、冗余字段等
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}

    @get('structures')
    def structures(self, elementName: str, folderId: str = None, path: str = None) -> Union[List[StructureDTO], Awaitable[List[StructureDTO]]]:
        """
        业务模型表配置查询接口-模型元素

        list 含数据表信息、字段信息、业务主键、冗余字段等
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}


class PermissionAPI(ChildAPI):
    endpoint = '/business/model'

    @get('permission')
    def query(self, elementName: str = None, folderId: str = None, path: str = None) -> Union[AuthorityDTO, Awaitable[AuthorityDTO]]:
        """
        业务模型角色、状态配置查询

        object 业务模型权限配置查询,使用场景:业务模型权限配置页面打开
        查询数据
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}

    @post('permission')
    def permission(self, permissionInfo: PermissionDTO) -> Union[Any, Awaitable[Any]]:
        """
        业务模型权限配置保存

        void 业务模型权限配置的保存,使用场景:业务模型权限配置页面
        """
        return {'body': permissionInfo}


class BusinessModelAPI(DynamicRootAPI, builtin=True):
    """业务模型组件接口"""
    module_type = 'BCUB'
    default_version = (1, 0)
    multi_version = True
    cls_name = 'BusinessModelAPI'
    module_name = 'deepfos.api.business_model'
    api_version = (1, 0)

    @cached_property
    def model(self) -> ModelAPI:
        """
        model-controller
        """
        return ModelAPI(self)

    @cached_property
    def approval(self) -> ApprovalAPI:
        """
        business-model-approve-controller
        """
        return ApprovalAPI(self)

    @cached_property
    def configure(self) -> ConfigureAPI:
        """
        model-form-controller
        """
        return ConfigureAPI(self)

    @cached_property
    def permission(self) -> PermissionAPI:
        """
        access-control-controller
        """
        return PermissionAPI(self)


