"""
APIs provided by deepfos-task-server

generated by api_code_gen.py
  - **filename** : ``deepfos_task.py``
  - **json timestamp** : ``2023-02-22 14:40:20``
"""
from deepfos.api.base import RootAPI, ChildAPI, get, post
from .models.deepfos_task import *
from deepfos.options import OPTION
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable, Optional


__all__ = ['TaskAPI']


class TaskInstance(ChildAPI):
    endpoint = '/api/deepfos/task'

    @post('instance/period/create')
    def instance_period_create(self, periodTaskCreateDTO: PeriodicTaskCreateInfo) -> Union[PeriodicTaskViewInfo, Awaitable[PeriodicTaskViewInfo]]:
        """
        创建一个周期任务实例

        """
        return {'body': periodTaskCreateDTO}

    @post('instance/scheduled/create')
    def instance_scheduled_create(self, scheduledTaskCreateDTO: ScheduledTaskCreateInfo) -> Union[ScheduledTaskViewInfo, Awaitable[ScheduledTaskViewInfo]]:
        """
        创建一个定时任务实例

        """
        return {'body': scheduledTaskCreateDTO}

    @post('search')
    def search(self, taskSearchDTO: TaskSearchDTO) -> Union[List[Optional[TTaskInfo]], Awaitable[List[Optional[TTaskInfo]]]]:
        """
        根据筛选条件查询任务配置

        """
        return {'body': taskSearchDTO}


class Job(ChildAPI):
    endpoint = '/job'

    @post('batch-add')
    def batch_add(self, jobCreateDtoList: List[JobCreateDto]) -> Union[int, Awaitable[int]]:
        """
        作业批量创建接口

        """
        return {'body': jobCreateDtoList}

    @get('current-content')
    def query_current_content(self, batchId: str = None, jobId: str = None) -> Union[List[JobCurrentContentDTO], Awaitable[List[JobCurrentContentDTO]]]:
        """
        根据jobId获取等待中与运行中作业与作业明细信息

        """
        return {'param': {'batchId': batchId, 'jobId': jobId}}

    @post('current-content')
    def current_content(self, jobSearchDTO: JobSearchDTO) -> Union[JobCurrentContentDTOResp, Awaitable[JobCurrentContentDTOResp]]:
        """
        根据筛选条件获取等待中与运行中作业与作业明细信息

        """
        return {'body': jobSearchDTO}


class TaskAPI(RootAPI):
    """任务管理接口"""
    prefix = lambda: OPTION.server.deepfos_task

    @cached_property
    def task_instance(self) -> TaskInstance:
        """
        任务相关接口
        """
        return TaskInstance(self)

    @cached_property
    def job(self) -> Job:
        """
        作业相关接口
        """
        return Job(self)


