"""
APIs provided by journal-template-server1-0

generated by api_code_gen.py
  - **filename** : ``journal_template.py``
  - **json timestamp** : ``2022-09-23 15:10:19``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.journal_template import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['JournalTemplateAPI']


class JournalTemplate(ChildAPI):
    endpoint = '/journal-template'
    
    @post('query-detail')
    def query_detail(self, elementBasicInfoVO: JournalTemplateQuery) -> Union[JournalTemplateDetail, Awaitable[JournalTemplateDetail]]:
        """
        单据模板定义全量信息查询
    
        查询信息包括头体尾及审批流,按钮,过账等信息
        """
        return {'body': elementBasicInfoVO}


class Journal(ChildAPI):
    endpoint = '/journal'
    
    @post('batch-save')
    def batch_save(self, dto: JournalBatchDataDTO) -> Union[Any, Awaitable[Any]]:
        """
        批量保存单据信息(后台调用)
    
        """
        return {'body': dto}
    
    @post('delete-by-filter')
    def delete_by_filter(self, delete: JournalDataBatchDel) -> Union[DataTableCustomSqlResultDTO, Awaitable[DataTableCustomSqlResultDTO]]:
        """
        根据条件删除单据
    
        """
        return {'body': delete}
    
    @post('get-aggregate-data')
    def get_aggregate_data(self, batchQuery: JournalOrderDataBatchQuery) -> Union[List[JournalAggregateResultDTO], Awaitable[List[JournalAggregateResultDTO]]]:
        """
        聚合数据获取
    
        """
        return {'body': batchQuery}
    
    @post('get-batch-data')
    def get_batch_data(self, query: JournalOrderDataBatchQuery) -> Union[DataTableCustomSqlResultDTO, Awaitable[DataTableCustomSqlResultDTO]]:
        """
        批量查询单据数据
    
        """
        return {'body': query}
    
    @post('get-total-data')
    def get_total_data(self, batchQuery: JournalOrderDataBatchQuery) -> Union[DataTableCustomSqlResultDTO, Awaitable[DataTableCustomSqlResultDTO]]:
        """
        查询统计数据
    
        """
        return {'body': batchQuery}


class Posting(ChildAPI):
    endpoint = '/posting'
    
    @post('cancel-posting')
    def cancel_posting(self, requestPostingParamDTO: PostingRequestDto) -> Union[Any, Awaitable[Any]]:
        """
        取消过账请求
    
        """
        return {'body': requestPostingParamDTO}
    
    @post('get-posting')
    def get_posting(self, requestPostingParamDTO: PostingRequestDto) -> Union[Any, Awaitable[Any]]:
        """
        过账请求
    
        """
        return {'body': requestPostingParamDTO}
    
    @post('query-posting-param')
    def query_posting_param(self, postingInfoParamQuery: PostingParamQueryDto) -> Union[PostingParam, Awaitable[PostingParam]]:
        """
        过账参数查询
    
        """
        return {'body': postingInfoParamQuery}


class JournalTemplateAPI(DynamicRootAPI, builtin=True):
    """日记账模板组件接口"""
    module_type = 'JT'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'JournalTemplateAPI'
    module_name = 'deepfos.api.journal_template'
    api_version = (1, 0)

    @cached_property
    def journaltemplate(self) -> JournalTemplate:
        """
        单据模板定义信息接口
        """
        return JournalTemplate(self)

    @cached_property
    def journal(self) -> Journal:
        """
        单据数据操作接口
        """
        return Journal(self)

    @cached_property
    def posting(self) -> Posting:
        """
        过账接口
        """
        return Posting(self)


