"""
Models used by /accounting-engines-server1-0

generated by model_code_gen.py
  - **filename** : ``accounting_engines.py``
  - **json timestamp** : ``2023-01-05 14:22:11``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'AccEventTypeLineInfo',
    'AccEventTypeTableDTO',
    'AccountElementDetailDTO',
    'AccountingControlRequestDTO',
    'AccountingEnginesExecCallbackPythonDTO',
    'AccountingEnginesRequestDTO',
    'AggrConfigDTO',
    'DataDTO',
    'DataTableColumnDTO',
    'ElementDetailDTO',
    'FilterScopeDTO',
    'FormulaConditionsDTO',
    'GlobalConfigDTO',
    'GroupConfigDTO',
    'JoinOnDTO',
    'JoinWhereDTO',
    'LookupConditionsDTO',
    'LookupReturnColumnDTO',
    'ParamConfigDTO',
    'RegularConditionsDTO',
    'SequenceColumnDTO',
    'SequenceManageDTO',
    'TipModel',
    'AccEventTypeHeadDTO',
    'JoinConfigDTO',
    'AccEventTypeBasicDTO',
    'AccEventTypeElementDTO',
    'AccountDataTableInfoDTO',
    'ConfigRuleDTO',
    'NodeConfigDTO',
    'AccEventTypeDTO',
    'AccountBusinessModelDTO',
    'CustomContentsDTO',
    'AccountingEnginesDTO'
]


class AccEventTypeLineInfo(BaseModel):
    #: 科目类型编码
    accountType: str
    #: 科目类型描述
    accountTypeDesc: str
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人ID
    createUser: Optional[str] = None
    #: 借贷方向编码
    dc: str
    #: 借贷方向描述
    dcDesc: str
    #: 事件类型头编码
    eventTypeCode: str
    #: id
    id: Optional[str] = None
    #: 序号
    lineNo: Optional[int] = None
    #: 创建时间
    modifyTime: Optional[str] = None
    #: 修改人
    modifyUser: Optional[str] = None


class AccEventTypeTableDTO(BaseModel):
    """Acc Event Type Table DTO

    .. admonition:: 引用接口

        - **POST** ``/accounting/event/type/insert/to/event/table``
    """
    #: 事件类型元素ID（如果有值，则优先根据元素ID执行)
    elementId: Optional[str] = None
    #: 事件类型元素编码(与elementId 两个二选一必)
    elementName: Optional[str] = None
    #: 文件夹ID (path 两个二选一必填)
    folderId: Optional[str] = None
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str] = None
    #: 业务主键ID集合
    objectIdList: List[str]


class AccountElementDetailDTO(BaseModel):
    #: 是否绝对路径
    absoluteTag: Optional[bool] = None
    #: 真实表名
    actualTableName: Optional[str] = None
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 目录id
    folderId: Optional[str] = None
    #: 元素ID
    id: Optional[str] = None
    #: 元素绝对路径
    path: Optional[str] = None
    #: 相对路径
    relativePath: Optional[str] = None
    #: 描述备注信息
    remark: Optional[str] = None
    #: 组件id
    serverName: Optional[str] = None


class AccountingControlRequestDTO(BaseModel):
    """Accounting Control Request DTO

    .. admonition:: 引用接口

        - **POST** ``/accounting/engines/update/control/status``
    """
    #: 会计元素-ID
    elementId: Optional[str] = None
    #: 会计元素-执行批次号
    batchNumber: Optional[str] = None
    #: 会计元素-执行状态：字符类型 ，0 失败，1 成功，2 删除
    status: Optional[str] = None
    #: 会计元素-元素名称
    elementName: Optional[str] = None
    #: 元素类型 BILL：单据，ACCOUNTING：会计引擎
    elementType: Optional[str] = None
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str] = None
    #: 文件夹ID (与path 两个二选一必填)
    folderId: Optional[str] = None
    #: 目标数据ID集合
    targetElementDataIdList: Optional[List[str]] = None


class AccountingEnginesExecCallbackPythonDTO(BaseModel):
    #: PY所在路径，与folderId二选一
    path: Optional[str] = None
    #: PY所在文件夹ID，与path二选一
    folderId: Optional[str] = None
    #: PY的元素名称
    elementName: str
    #: 类型 默认值 PY
    elementType: Optional[str] = None
    #: Python服务名，如：python-server2-0
    serverName: Optional[str] = None
    #: 传给回调的参数，{key1:value1,key2:value2}
    callbackParams: Optional[Dict] = None


class AccountingEnginesRequestDTO(BaseModel):
    """Accounting Engines Request DTO

    .. admonition:: 引用接口

        - **POST** ``/accounting/engines/exec/by/id``
        - **POST** ``/accounting/engines/exec/by/name/type``
        - **POST** ``/accounting/engines/sync/exec/by/id``
    """
    #: 元素ID（如果有值，则优先根据元素ID执行）
    elementId: Optional[str] = None
    #: 元素编码
    elementName: Optional[str] = None
    #: 元素类型 ACCOUNTING:会计引擎，BILL:单据引擎
    elementType: Optional[str] = None
    #: 文件夹ID (path 两个二选一必填)
    folderId: Optional[str] = None
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str] = None
    #: 执行参数值列表{key1:value1,key2:value2}
    paramValueMap: Optional[Any] = None
    #: 回调信息
    callbackInfo: Optional[AccountingEnginesExecCallbackPythonDTO] = None


class AggrConfigDTO(BaseModel):
    #: 全局唯一uuid
    uuid: Optional[str] = None
    #: 数据表uuid
    dataTableUuid: Optional[str] = None
    #: 字段uuid
    columnUuid: Optional[str] = None
    #: 聚合方式
    method: Optional[str] = None
    #: 新增列名
    newColumnName: Optional[str] = None
    #: 新增字段描述
    newColumnDesc: Optional[str] = None
    #: 新增字段类型
    newColumnType: Optional[str] = None
    #: 新增字段长度
    newColumnLength: Optional[str] = None


class DataDTO(BaseModel):
    #: 批次号
    batchNumber: Optional[str] = None
    #: 状态控制表信息
    controlTableInfo: Optional[AccountElementDetailDTO] = None


class DataTableColumnDTO(BaseModel):
    #: 会计事件类型配置,key为事件类型行uuid
    accEventRuleConfig: Optional[Any] = None
    #: 字段别名 默认为列名
    alias: Optional[str] = None
    #: 字段默认值
    defaultValue: Optional[str] = None
    #: 字段描述信息
    description: Optional[str] = None
    #: 字段格式
    format: Optional[str] = None
    #: 头分组字段标识
    headGroupFlag: Optional[bool] = None
    #: 字段长度
    length: Optional[str] = None
    #: 行分组字段标识
    lineGroupFlag: Optional[bool] = None
    #: 字段名称
    name: Optional[str] = None
    #: newDescription
    newDescription: Optional[str] = None
    #: newFlag
    newFlag: Optional[bool] = None
    #: 字段类型-原始类型
    originType: Optional[str] = None
    #: 排序
    sort: Optional[int] = None
    #: 字段类型-转换后
    type: Optional[str] = None
    #: uniqueKey
    uniqueKey: Optional[bool] = None
    #: 字段UUID
    uuid: Optional[str] = None
    #: 可否为空
    whetherEmpty: Optional[bool] = None
    #: 是否自增
    whetherIncrement: Optional[bool] = None
    #: 是否业务主键
    whetherLogicKey: Optional[bool] = None
    #: 是否唯一
    whetherOnly: Optional[bool] = None
    #: 是否系统主键
    whetherPrimary: Optional[bool] = None
    #: 是否系统字段
    whetherSystemColumn: Optional[bool] = None


class ElementDetailDTO(BaseModel):
    #: 是否绝对路径
    absoluteTag: Optional[bool] = None
    #: description
    description: Optional[Any] = None
    #: 元素ID,同ID
    elementId: Optional[str] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 目录id
    folderId: Optional[str] = None
    #: 元素ID
    id: Optional[str] = None
    #: 元素绝对路径
    path: Optional[str] = None
    #: 元素相对路径
    relativePath: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class FilterScopeDTO(BaseModel):
    #: 字段uuid
    columnUuid: Optional[str] = None
    #: 属性值
    columnValue: Optional[str] = None
    #: 数据表uuid
    dataTableUuid: Optional[str] = None
    #: 操作符
    operationCode: Optional[str] = None
    #: 全局参数uuid
    paramUuid: Optional[str] = None


class FormulaConditionsDTO(BaseModel):
    #: 全局唯一uuid
    uuid: Optional[str] = None
    #: 计算公式
    calcFormula: Optional[str] = None
    #: 新增字段名
    newColumnName: Optional[str] = None
    #: 新增字段描述
    newColumnDesc: Optional[str] = None
    #: 新增字段类型
    newColumnType: Optional[str] = None
    #: 新增字段长度
    newColumnLength: Optional[str] = None


class GlobalConfigDTO(BaseModel):
    #: 生成规则 0：不允许重复生成，1：允许多次且提示，2：允许多次且不提示
    rule: int
    #: 筛选范围
    filterScope: Optional[List[FilterScopeDTO]] = None


class GroupConfigDTO(BaseModel):
    #: 字段uuid
    columnUuid: Optional[str] = None
    #: 数据表uuid
    dataTableUuid: Optional[str] = None
    #: 是否父级
    isParent: Optional[bool] = None
    #: 全局唯一uuid
    uuid: Optional[str] = None


class JoinOnDTO(BaseModel):
    #: 关联符号，一般是=
    operationCode: str
    #: 源对象uuid｜目标模型父级
    sourceColumnUuid: str
    #: 目标对象uuid｜目标模型当前
    targetColumnUuid: str
    #: type
    type: Optional[str] = None
    #: uuid
    uuid: str


class JoinWhereDTO(BaseModel):
    #: 字段uuid
    columnUuid: Optional[str] = None
    #: 字段值
    columnValue: Optional[str] = None
    #: 操作符
    operationCode: Optional[str] = None
    #: 全局参数uuid
    paramUuid: Optional[str] = None
    #: uuid
    uuid: Optional[str] = None


class LookupConditionsDTO(BaseModel):
    #: 会计事件字段规则来源【源:TABLE;参数：PARAMETER;科目：ACCOUNT】
    sourceType: Optional[str] = None
    #: 全局唯一uuid
    uuid: Optional[str] = None
    #: 数据表uuid
    dataTableUuid: Optional[str] = None
    #: 字段Uuid
    columnUuid: Optional[str] = None
    #: 操作符
    operationCode: Optional[str] = None
    #: 被查询字段uuid
    lookupColumnUuid: Optional[str] = None


class LookupReturnColumnDTO(BaseModel):
    #: 全局唯一uuid
    uuid: Optional[str] = None
    #: 返回字段UUID
    lookupColumnUuid: Optional[str] = None
    #: 新增字段名
    newColumnName: Optional[str] = None
    #: 新增字段描述
    newColumnDesc: Optional[str] = None
    #: 新增字段类型
    newColumnType: Optional[str] = None
    #: 新增字段长度
    newColumnLength: Optional[str] = None


class ParamConfigDTO(BaseModel):
    #: 参数编码
    paramCode: Optional[str] = None
    #: 参数描述
    paramDesc: Optional[str] = None
    #: 参数类型
    paramType: Optional[str] = None
    #: 参数长度
    paramLength: Optional[str] = None
    #: 默认值
    defaultValue: Optional[str] = None


class RegularConditionsDTO(BaseModel):
    #: 全局唯一uuid
    uuid: Optional[str] = None
    #: 数据表uuid
    dataTableUuid: Optional[str] = None
    #: 字段uuid
    columnUuid: Optional[str] = None
    #: 正则公式
    regular: Optional[str] = None
    #: 新增字段名
    newColumnName: Optional[str] = None
    #: 新增字段描述
    newColumnDesc: Optional[str] = None
    #: 新增字段类型
    newColumnType: Optional[str] = None
    #: 新增字段长度
    newColumnLength: Optional[str] = None


class SequenceColumnDTO(BaseModel):
    #: 字段uuid
    columnUuid: Optional[str] = None
    #: 数据表uuid
    dataTableUuid: Optional[str] = None
    #: uuid
    uuid: Optional[str] = None


class SequenceManageDTO(BaseModel):
    #: uuid
    uuid: Optional[str] = None
    #: 序列名称
    seqName: Optional[str] = None
    #: 序列编码
    seqCode: Optional[str] = None
    #: 序列长度
    length: Optional[int] = None
    #: 起始值
    start: Optional[int] = None
    #: 目标模型元素
    targetDataTableUuid: Optional[str] = None
    #: 步长
    stepBy: Optional[int] = None
    #: 分组依据字段
    groupColumns: Optional[List[SequenceColumnDTO]] = None
    #: 流水段分割符
    separator: Optional[str] = None


class TipModel(BaseModel):
    #: code
    code: Optional[str] = None
    #: id
    id: Optional[int] = None
    #: logical
    logical: Optional[str] = None
    #: message
    message: Optional[str] = None
    #: module
    module: Optional[str] = None
    #: object
    object: Optional[str] = None
    #: remark
    remark: Optional[str] = None
    #: type
    type: Optional[int] = None
    #: uuid
    uuid: Optional[str] = None


class AccEventTypeHeadDTO(BaseModel):
    #: 关联业务单据-元素编码
    bcubCode: str
    #: 关联业务单据-元素ID
    bcubId: str
    #: 关联业务单据-元素名称
    bcubName: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人ID
    createUser: Optional[str] = None
    #: 事件类型编码
    eventTypeCode: str
    #: 事件类型名称,存多语言JSON
    eventTypeName: Optional[str] = None
    #: 创建时间
    modifyTime: Optional[str] = None
    #: 修改人
    modifyUser: Optional[str] = None
    #: 关联业务单据元素信息
    relationBMInfo: ElementDetailDTO
    #: 事件类型描述
    remark: str


class JoinConfigDTO(BaseModel):
    #: 连接方式，left join,right join,inner join,outer join
    joinHow: str
    #: 关联关系
    joinOn: Optional[List[JoinOnDTO]] = None
    #: 关联条件
    joinWhere: Optional[List[JoinWhereDTO]] = None


class AccEventTypeBasicDTO(BaseModel):
    """Acc Event Type Basic DTO

    .. admonition:: 引用接口

        - **POST** ``/accounting/event/type/save``
        - **POST** ``/accounting/event/type/update``
    """
    #: accEventTypeHeadDTO
    accEventTypeHeadDTO: Optional[AccEventTypeHeadDTO] = None
    #: accEventTypeLineInfoList
    accEventTypeLineInfoList: Optional[List[AccEventTypeLineInfo]] = None
    #: elementId
    elementId: Optional[str] = None
    #: elementName
    elementName: Optional[str] = None
    #: elementType
    elementType: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: 元素来源类型 handleCreate：手动新建，copyCreate：复制过来的，importCreate：导入进来的
    sourceType: Optional[str] = None


class AccEventTypeElementDTO(BaseModel):
    """Acc Event Type Element DTO

    .. admonition:: 引用接口

        - **GET** ``/accounting/event/type/get-info-by-id`` (Response: 200)
        - **GET** ``/accounting/event/type/get-info-by-name`` (Response: 200)
    """
    #: 元素ID
    elementId: Optional[str] = None
    #: 会计引擎唯一编码
    elementName: str
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str] = None
    #: 文件夹ID (与path 两个二选一必填)
    folderId: Optional[str] = None
    #: 元素状态 0：未保存，1：已保存，2：已发布
    elementStatus: Optional[int] = None
    #: 元素类型 ACCOUNTING_EVENT_TYPE：会计事件类型
    elementType: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 名称（多语言）
    description: Optional[Any] = None
    #: 自动确认，默认值：true
    autoConfirm: Optional[bool] = None
    #: 描述信息
    remark: Optional[str] = None
    #: 会计事件类型-未发布json内容
    customContents: Optional[AccEventTypeBasicDTO] = None
    #: 会计事件-发布后json内容
    customContentBlobs: Optional[AccEventTypeBasicDTO] = None
    #: 检查错误信息
    errorMsg: Optional[str] = None


class AccountDataTableInfoDTO(BaseModel):
    #: 是否是最顶层表
    firstLevelFlag: Optional[bool] = None
    #: 是否是最底层表
    lastLevelFlag: Optional[bool] = None
    #: 数据表ID
    uuid: Optional[str] = None
    #: 父级数据表ID
    parentUuid: Optional[str] = None
    #: 名称（多语言）
    description: Optional[Any] = None
    #: 真实表名
    actualTableName: Optional[str] = None
    #: 数据表别名
    dataTableAlias: Optional[str] = None
    #: 列集合
    columns: Optional[List[DataTableColumnDTO]] = None
    #: 数据表元素信息
    elementDetail: Optional[AccountElementDetailDTO] = None
    #: 关联关系配置
    joinConfig: Optional[JoinConfigDTO] = None
    #: 备注说明
    remark: Optional[str] = None
    #: 表类型：源业务单据：SOURCE_BCUB；关联维度：RELATION_DIMENSION；会计事件类型表：ACC_EVENT_TYPE
    accEventTableType: Optional[str] = None


class ConfigRuleDTO(BaseModel):
    #: uuid
    uuid: Optional[str] = None
    #: 序号
    lineNo: Optional[int] = None
    #: 规则名称
    ruleName: Optional[str] = None
    #: 规则类型：regularConditions:正则，formulaConditions:公式，lookupConditions:lookup查找groupConfig：分组，aggrConfig：聚合
    ruleType: Optional[str] = None
    #: 目标模型元素
    targetDataTableUuid: Optional[str] = None
    #: 目标模型元素父级uuid
    parentTargetDataTableUuid: Optional[str] = None
    #: 描述备注
    remark: Optional[str] = None
    #: 被查询的元素信息
    lookupDataTable: Optional[AccountDataTableInfoDTO] = None
    #: 匹配多条时 ERROR：报错，ANY：返回任意一条
    lookupMulti: Optional[str] = None
    #: Lookup匹配规则时，新增的返回字段集合
    lookupReturnColumns: Optional[List[LookupReturnColumnDTO]] = None
    #: lookup条件信息
    lookupConditions: Optional[List[LookupConditionsDTO]] = None
    #: 计算公式条件
    formulaConditions: Optional[List[FormulaConditionsDTO]] = None
    #: 正则表达式条件
    regularConditions: Optional[List[RegularConditionsDTO]] = None
    #: 分组配置信息
    groupConfig: Optional[List[GroupConfigDTO]] = None
    #: 聚合信息
    aggrConfig: Optional[List[AggrConfigDTO]] = None


class NodeConfigDTO(BaseModel):
    #: 序号
    lineNo: int
    #: 节点名称
    nodeName: str
    #: 节点的配置规则
    ruleConfigList: Optional[List[ConfigRuleDTO]] = None
    #: 序列管理
    sequenceManageList: Optional[List[SequenceManageDTO]] = None
    #: 源对象数据表集合
    sourceDataTableList: Optional[List[AccountDataTableInfoDTO]] = None
    #: 目标模型数据表集合
    targetDataTableList: Optional[List[AccountDataTableInfoDTO]] = None


class AccEventTypeDTO(BaseModel):
    #: accEventTypeDetail
    accEventTypeDetail: Optional[AccEventTypeElementDTO] = None
    #: elementId
    elementId: Optional[str] = None
    #: elementName
    elementName: Optional[str] = None
    #: elementType
    elementType: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None


class AccountBusinessModelDTO(BaseModel):
    #: 模型ID
    id: Optional[str] = None
    #: 模型名称
    name: str
    #: 名称 多语言信息
    description: Any
    #: 路径
    path: Optional[str] = None
    #: 文件夹ID
    folderId: Optional[str] = None
    #: 模型ID
    moduleId: Optional[str] = None
    #: 逻辑表信息
    dataTableList: Optional[List[AccountDataTableInfoDTO]] = None
    #: 服务名
    serverName: Optional[str] = None
    #: 类型
    type: Optional[str] = None
    #: 元素ID
    elementId: Optional[str] = None


class CustomContentsDTO(BaseModel):
    #: accountingType
    accountingType: Optional[str] = None
    #: description
    description: Optional[Any] = None
    #: 元素执行状态 0：未执行成功过，1：执行成功过
    elementExecStatus: Optional[int] = None
    #: 元素来源类型 handleCreate：手动新建，copyCreate：复制过来的，importCreate：导入进来的
    sourceType: Optional[str] = None
    #: 会计事件类型-会计事件使用
    accEventType: Optional[AccEventTypeDTO] = None
    #: 源对象数据表集合-会计事件使用
    sourceDataTableList: Optional[List[AccountDataTableInfoDTO]] = None
    #: 目标模型数据表集合-会计事件使用
    targetDataTableList: Optional[List[AccountDataTableInfoDTO]] = None
    #: 源对象信息
    sourceElement: AccountBusinessModelDTO
    #: 目标模型信息
    targetElement: AccountBusinessModelDTO
    #: 参数管理
    paramConfig: Optional[List[ParamConfigDTO]] = None
    #: 元素状态 0：未保存，1：已保存，2：已发布
    elementStatus: Optional[int] = None
    #: 全局配置
    globalConfig: Optional[GlobalConfigDTO] = None
    #: 节点配置，默认有6个节点
    nodeConfig: Optional[List[NodeConfigDTO]] = None


class AccountingEnginesDTO(BaseModel):
    """Accounting Engines DTO

    .. admonition:: 引用接口

        - **GET** ``/accounting/engines/get-accounting-info-by-id`` (Response: 200)
        - **GET** ``/accounting/engines/get-accounting-info-by-name-type`` (Response: 200)
        - **POST** ``/accounting/engines/publish/{elementId}`` (Response: 200)
        - **POST** ``/accounting/engines/relation/update`` (Response: 200)
        - **POST** ``/accounting/engines/save``
        - **POST** ``/accounting/engines/update``
    """
    #: accountingType
    accountingType: Optional[str] = None
    #: 错误标识
    errorTag: Optional[bool] = None
    #: 错误集合
    errorList: Optional[List[TipModel]] = None
    #: 预警标识
    warningTag: Optional[bool] = None
    #: 预警集合
    warningList: Optional[List[TipModel]] = None
    #: 元素ID
    elementId: Optional[str] = None
    #: 会计引擎唯一编码
    elementName: str
    #: 元素路径 (与folderId 两个二选一必填)
    path: Optional[str] = None
    #: 文件夹ID (与path 两个二选一必填)
    folderId: Optional[str] = None
    #: 元素状态 0：未保存，1：已保存，2：已发布
    elementStatus: Optional[int] = None
    #: 元素类型 BILL：单据，ACCOUNTING：会计引擎，EVENT：会计事件
    elementType: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 名称（多语言）
    description: Optional[Any] = None
    #: 自动确认，默认值：true
    autoConfirm: Optional[bool] = None
    #: 描述信息
    remark: Optional[str] = None
    #: 会计元素-未发布json内容
    customContents: Optional[CustomContentsDTO] = None
    #: 会计元素-发布后json内容
    customContentBlobs: Optional[CustomContentsDTO] = None
    #: 会计元素-转换后的结构（单据到凭证，发布时进行转换）
    transformBlobs: Optional[CustomContentsDTO] = None
    #: 检查错误信息
    errorMsg: Optional[str] = None



