"""
Models used by /approval-process-server1-0

generated by model_code_gen.py
  - **filename** : ``approval_process.py``
  - **json timestamp** : ``2022-06-27 17:44:05``
"""


from .base import BaseModel
from typing import List, Optional, Union
from pydantic import Field


__all__ = [
    'ApprovalButton',
    'DataTableColumnDTO',
    'DataTableInfoDTO',
    'DimensionMemberForOperatorDto',
    'DimensionMemberVo',
    'ElementFixInfoDTO',
    'ErrorTips',
    'InitOperationDto',
    'OperationDto',
    'OperationRecordDto',
    'OperationRecordVo',
    'PrimaryKeyByDimensionMemberDto',
    'ProcessControlInfoDto',
    'ProcessControlInfoVo',
    'ProcessRoleDto',
    'ProcessTargetStatusVo',
    'QueryOperationAuthorityDto',
    'QueryOperationOperatorDto',
    'QueryRecordDto',
    'RecordDeleteDto',
    'RecordDeleteVo',
    'RoleMessageDto',
    'SmartList',
    'SmartListInfo',
    'SmartListUd',
    'SmartListVo',
    'SmartlistValueDto',
    'UserDto',
    'ApprovalRecordVo',
    'CustomOperation',
    'CustomOperationVo',
    'DataTableBasicDTO',
    'NextOperationOperatorVo',
    'PrimaryKeyByDimensionDto',
    'ProcessSmartlistDto',
    'QueryOperationOperatorByDimensionDto',
    'RoleDto',
    'SmartListSaveForm',
    'SmartListSaveFormVo',
    'ApprovalRecordTableVo',
    'ProcessOperationDto',
    'ProcessOperationVo',
    'ProcessRoleVo',
    'NextOperationBacthVo',
    'NextOperationVo',
    'ProcessConfigBasicsVo',
    'ProcessInfoDto',
    'ProcessInfoVo',
    'ProcessTargetStatusAndOperatorBatchVo',
    'ProcessTargetStatusAndOperatorVo',
    'ProcessConfigureDto',
    'ProcessConfigureVo'
]


class ApprovalButton(BaseModel):
    #: 操作描述
    description: str
    #: 操作id
    id: str
    #: 操作是否为提交
    isSubmit: Optional[bool] = None
    #: 操作名称
    name: str


class DataTableColumnDTO(BaseModel):
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建者
    creator: Optional[str] = None
    #: 数据表基本信息的id值
    datatableId: str
    #: 数据表名称(简名)
    datatableName: str
    #: 字段的默认值
    defaultValue: Optional[str] = None
    #: 字段的描述信息
    description: Optional[str] = None
    #: 最后一次更新的时间
    lastModifyTime: Optional[str] = None
    #: 最后一次编辑的用户
    lastModifyUser: Optional[str] = None
    #: 字段长度(datatime类型不用传值)
    length: str
    #: 字段名称
    name: str
    #: 字段对应的排序信息
    sort: int
    #: 字段类型
    type: str
    #: 唯一key
    uniqueKey: Optional[str] = None
    #: 是否可以为空
    whetherEmpty: Optional[bool] = None
    #: 是否自增
    whetherIncrement: Optional[bool] = None
    #: 是否唯一
    whetherOnly: Optional[bool] = None
    #: 是否为主键
    whetherPrimary: Optional[bool] = None
    #: 是否为系统字段
    whetherSystemColumn: Optional[bool] = None


class DataTableInfoDTO(BaseModel):
    #: 实际表名
    actualTableName: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建者
    creator: Optional[str] = None
    #: deleteFlag
    deleteFlag: Optional[bool] = None
    #: 多语言描述信息
    description: Optional[dict] = None
    #: 数据表id
    id: str
    #: 最后一次编辑的时间
    lastModifyTime: Optional[str] = None
    #: 最后一次编辑的用户
    lastModifyUser: Optional[str] = None
    #: 数据表名称(简名)
    name: str
    #: parentId
    parentId: Optional[str] = None


class DimensionMemberForOperatorDto(BaseModel):
    #: 维度名
    dimensionName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 权限方案配置中的维度序号，1-5
    line: Optional[int] = None
    #: 路径
    path: Optional[str] = None


class DimensionMemberVo(BaseModel):
    #: 维度成员
    dimensionMember: Optional[str] = None
    #: 权限方案配置中的维度序号，1-5
    line: Optional[int] = None


class ElementFixInfoDTO(BaseModel):
    #: absoluteTag
    absoluteTag: Optional[bool] = None
    #: elementName
    elementName: Optional[str] = None
    #: elementType
    elementType: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: relativePath
    relativePath: Optional[str] = None
    #: serverName
    serverName: Optional[str] = None


class ErrorTips(BaseModel):
    #: 错误字段
    tipKey: Optional[str] = None
    #: 错误描述
    tipValue: Optional[str] = None


class InitOperationDto(BaseModel):
    #: 文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 审批流名称
    pcName: str


class OperationDto(BaseModel):
    """Operation Dto

    .. admonition:: 引用接口

        - **POST** ``/process/interface/operation``
        - **POST** ``/process/interface/operation/init``
    """
    #: 文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 操作
    name: str
    #: 路径
    path: Optional[str] = None
    #: 审批流名称
    pcName: str


class OperationRecordDto(BaseModel):
    """Operation Record Dto

    .. admonition:: 引用接口

        - **POST** ``/process/operation/record``
    """
    #: 父文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 源状态
    originStatus: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 审批流名称
    pcName: str
    #: 业务主键字段(key为业务主键的key,value为业务主键对应的值)
    primaryKeyValue: dict
    #: 操作id
    processOperationId: str
    #: 审批备注
    remark: Optional[str] = None
    #: 角色(全部角色传-1)
    roles: List[Union[str, int]]
    #: 是否跳过后置操作
    skipPost: Optional[bool] = None
    #: 是否跳过前置操作
    skipPre: Optional[bool] = None


class OperationRecordVo(BaseModel):
    """Operation Record Vo

    .. admonition:: 引用接口

        - **POST** ``/process/operation/record`` (Response: 200)
    """
    #: 错误信息
    errors: Optional[List[dict]] = None
    #: 操作结果
    success: bool
    #: 警告信息
    warnings: Optional[List[dict]] = None


class PrimaryKeyByDimensionMemberDto(BaseModel):
    #: 权限方案配置中的维度序号，1-5
    line: int
    #: 维度成员
    member: str


class ProcessControlInfoDto(BaseModel):
    #: 审批记录表表元素类型
    approvalRecordTableElementType: Optional[str] = None
    #: 审批记录表表父文件夹id
    approvalRecordTableFolderId: Optional[str] = None
    #: 审批记录表表名
    approvalRecordTableName: Optional[str] = None
    #: 审批记录表表路径
    approvalRecordTablePath: Optional[str] = None
    #: 描述
    descriptionMap: Optional[dict] = None
    #: 元素名称
    elementName: str
    #: 父文件夹id
    folderId: str
    #: 组件id
    moduleId: str
    #: 元素路径
    path: Optional[str] = None
    #: 权限方案元素类型
    rsElementType: str
    #: 权限方案父文件夹id
    rsFolderId: str
    #: 权限方案名称
    rsName: str
    #: 权限方案路径
    rsPath: str
    #: 审批流状态对应的smartlist的name
    statusSmartlist: str
    #: 前端样式参数
    style: Optional[str] = None


class ProcessControlInfoVo(BaseModel):
    #: 审批记录表表元素类型
    approvalRecordTableElementType: Optional[str] = None
    #: 审批记录表表父文件夹id
    approvalRecordTableFolderId: Optional[str] = None
    #: 审批记录表表名
    approvalRecordTableName: Optional[str] = None
    #: 审批记录表表路径
    approvalRecordTablePath: Optional[str] = None
    #: 描述
    descriptionMap: Optional[dict] = None
    #: 元素名称
    elementName: str
    #: 校验错误标记
    errorList: Optional[List[ErrorTips]] = None
    #: 父文件夹id
    folderId: str
    #: 组件id
    moduleId: str
    #: 元素路径
    path: Optional[str] = None
    #: 权限方案元素类型
    rsElementType: str
    #: 权限方案父文件夹id
    rsFolderId: str
    #: 权限方案名称
    rsName: str
    #: 权限方案路径
    rsPath: str
    #: 审批流状态对应的smartlist的name
    statusSmartlist: str
    #: 前端样式参数
    style: Optional[str] = None


class ProcessRoleDto(BaseModel):
    """Process Role Dto

    .. admonition:: 引用接口

        - **POST** ``/process/interface/get-action``
    """
    #: 文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 审批流名称
    pcName: str
    #: 角色
    role: List[str]


class ProcessTargetStatusVo(BaseModel):
    """Process Target Status Vo

    .. admonition:: 引用接口

        - **GET** ``/process/interface/operation/target-status`` (Response: 200)
    """
    #: 元素名称
    elementName: str
    #: 父文件夹id
    folderId: str
    #: 目标状态
    targetStatus: Optional[str] = None


class QueryOperationAuthorityDto(BaseModel):
    """Query Operation Authority Dto

    .. admonition:: 引用接口

        - **POST** ``/process/interface/operation/roles-status``
    """
    #: 审批流父文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 审批流名称
    name: str
    #: 源状态
    originStatus: str
    #: 审批流父路径
    path: Optional[str] = None
    #: 角色
    roles: List[str]


class QueryOperationOperatorDto(BaseModel):
    """Query Operation Operator Dto

    .. admonition:: 引用接口

        - **POST** ``/process/interface/operation/operator``
    """
    #: 父文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 状态
    originStatus: str
    #: 路径
    path: Optional[str] = None
    #: 审批流名称
    pcName: str
    #: 主键字段
    primaryKeyValue: dict


class QueryRecordDto(BaseModel):
    """Query Record Dto

    .. admonition:: 引用接口

        - **POST** ``/process/operation/get-record``
    """
    #: 父文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 审批流名称
    pcName: str
    #: 主键字段
    primaryKeyValue: dict
    #: 角色(全部角色传-1)
    roles: Optional[List[Union[str, int]]] = None


class RecordDeleteDto(BaseModel):
    """Record Delete Dto

    .. admonition:: 引用接口

        - **POST** ``/process/operation/delete/record``
        - **POST** ``/process/operation/delete/record/batch``
    """
    #: 父文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 审批流名称
    pcName: str
    #: 主键字段
    primaryKeyValue: dict


class RecordDeleteVo(BaseModel):
    """Record Delete Vo

    .. admonition:: 引用接口

        - **POST** ``/process/operation/delete/record/batch`` (Response: 200)
    """
    #: 错误信息
    error: Optional[str] = None
    #: 父文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 审批流名称
    pcName: str
    #: 主键字段
    primaryKeyValue: dict
    #: 删除结果
    success: bool


class RoleMessageDto(BaseModel):
    #: 描述
    description: Optional[dict] = None
    #: 说明
    instruction: Optional[dict] = None
    #: 名称
    name: str


class SmartList(BaseModel):
    #: 描述
    desc: Optional[dict] = None
    #: 值列表成员唯一标识
    key: Optional[str] = None
    #: 排序字段
    sortId: Optional[int] = None
    #: 状态
    status: Optional[bool] = None
    #: 成员值
    subjectValue: str
    #: 自定义属性值1
    ud1: Optional[str] = None
    #: ud10
    ud10: Optional[str] = None
    #: ud11
    ud11: Optional[str] = None
    #: ud12
    ud12: Optional[str] = None
    #: ud13
    ud13: Optional[str] = None
    #: ud14
    ud14: Optional[str] = None
    #: ud15
    ud15: Optional[str] = None
    #: ud16
    ud16: Optional[str] = None
    #: ud17
    ud17: Optional[str] = None
    #: ud18
    ud18: Optional[str] = None
    #: ud19
    ud19: Optional[str] = None
    #: ud2
    ud2: Optional[str] = None
    #: ud20
    ud20: Optional[str] = None
    #: ud21
    ud21: Optional[str] = None
    #: ud22
    ud22: Optional[str] = None
    #: ud23
    ud23: Optional[str] = None
    #: ud24
    ud24: Optional[str] = None
    #: ud25
    ud25: Optional[str] = None
    #: ud26
    ud26: Optional[str] = None
    #: ud27
    ud27: Optional[str] = None
    #: ud28
    ud28: Optional[str] = None
    #: ud29
    ud29: Optional[str] = None
    #: ud3
    ud3: Optional[str] = None
    #: ud30
    ud30: Optional[str] = None
    #: ud4
    ud4: Optional[str] = None
    #: ud5
    ud5: Optional[str] = None
    #: ud6
    ud6: Optional[str] = None
    #: ud7
    ud7: Optional[str] = None
    #: ud8
    ud8: Optional[str] = None
    #: ud9
    ud9: Optional[str] = None


class SmartListInfo(BaseModel):
    #: 描述
    desc: Optional[dict] = None
    #: 值列表id
    id: Optional[str] = None
    #: 值列表名称
    name: str


class SmartListUd(BaseModel):
    #: 状态
    active: Optional[bool] = None
    #: 描述
    decs: Optional[dict] = None
    #: 自定义属性名称
    udName: Optional[str] = None


class SmartListVo(BaseModel):
    #: 描述
    desc: Optional[dict] = None
    #: 校验错误标记
    errorList: Optional[List[ErrorTips]] = None
    #: 值列表成员唯一标识
    key: Optional[str] = None
    #: 排序字段
    sortId: Optional[int] = None
    #: 状态
    status: Optional[bool] = None
    #: 成员值
    subjectValue: str
    #: 自定义属性值1
    ud1: Optional[str] = None
    #: ud10
    ud10: Optional[str] = None
    #: ud11
    ud11: Optional[str] = None
    #: ud12
    ud12: Optional[str] = None
    #: ud13
    ud13: Optional[str] = None
    #: ud14
    ud14: Optional[str] = None
    #: ud15
    ud15: Optional[str] = None
    #: ud16
    ud16: Optional[str] = None
    #: ud17
    ud17: Optional[str] = None
    #: ud18
    ud18: Optional[str] = None
    #: ud19
    ud19: Optional[str] = None
    #: ud2
    ud2: Optional[str] = None
    #: ud20
    ud20: Optional[str] = None
    #: ud21
    ud21: Optional[str] = None
    #: ud22
    ud22: Optional[str] = None
    #: ud23
    ud23: Optional[str] = None
    #: ud24
    ud24: Optional[str] = None
    #: ud25
    ud25: Optional[str] = None
    #: ud26
    ud26: Optional[str] = None
    #: ud27
    ud27: Optional[str] = None
    #: ud28
    ud28: Optional[str] = None
    #: ud29
    ud29: Optional[str] = None
    #: ud3
    ud3: Optional[str] = None
    #: ud30
    ud30: Optional[str] = None
    #: ud4
    ud4: Optional[str] = None
    #: ud5
    ud5: Optional[str] = None
    #: ud6
    ud6: Optional[str] = None
    #: ud7
    ud7: Optional[str] = None
    #: ud8
    ud8: Optional[str] = None
    #: ud9
    ud9: Optional[str] = None


class SmartlistValueDto(BaseModel):
    #: 多语言描述
    desc: Optional[dict] = None
    #: 成员值
    value: Optional[str] = None


class UserDto(BaseModel):
    #: 是否管理员标识
    adminTag: Optional[str] = None
    #: 头像
    avatar: Optional[str] = None
    #: 邮箱
    email: Optional[str] = None
    #: 手机号
    mobilePhone: Optional[str] = None
    #: 昵称
    nickName: Optional[str] = None
    #: 状态
    status: Optional[str] = None
    #: 用户id
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None


class ApprovalRecordVo(BaseModel):
    """Approval Record Vo

    .. admonition:: 引用接口

        - **POST** ``/process/operation/get-record`` (Response: 200)
    """
    #: 按钮
    buttons: List[ApprovalButton]
    #: 操作是否为提交
    isSubmit: Optional[bool] = None
    #: 行号
    line_no: int
    #: 操作时间
    operate_time: str
    #: 操作人
    operate_user: str
    #: 审批备注
    pc_remark: Optional[str] = None
    #: 业务主键字段(key为业务主键的key,value为业务主键对应的值)
    primaryKeyValue: dict
    #: 审批操作描述
    process_operation_des: str
    #: 审批操作id
    process_operation_id: str
    #: 审批后的状态
    result_status: str
    #: 审批后的状态描述
    result_status_des: str
    #: 用户信息,用户不存在为null
    user_detail: Optional[UserDto] = None


class CustomOperation(BaseModel):
    #: 同步异步 1异步,0同步
    async_: int = Field(..., alias='async')
    #: elementDetail
    elementDetail: Optional[ElementFixInfoDTO] = None
    #: 父文件夹id
    elementFolderId: Optional[str] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 路径
    elementPath: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 前后置操作id
    id: str
    #: 操作排序
    sort: int
    #: url路径
    url: Optional[str] = None


class CustomOperationVo(BaseModel):
    #: 同步异步 1异步,0同步
    async_: int = Field(..., alias='async')
    #: 父文件夹id
    elementFolderId: Optional[str] = None
    #: elementName
    elementName: Optional[Union[ElementFixInfoDTO, str]] = None
    #: 路径
    elementPath: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 校验错误标记
    errorFlag: Optional[bool] = None
    #: 校验错误描述
    errorMsg: Optional[str] = None
    #: 前后置操作id
    id: str
    #: 操作排序
    sort: int
    #: url路径
    url: Optional[str] = None


class DataTableBasicDTO(BaseModel):
    #: 当前数据表的所有列
    datatableColumn: List[DataTableColumnDTO]
    #: 数据表相关信息
    datatableInfo: DataTableInfoDTO


class NextOperationOperatorVo(BaseModel):
    #: 是否所有用户
    allUsers: Optional[bool] = None
    #: 可执行的操作人
    operators: Optional[List[UserDto]] = None
    #: 维度字段
    primaryKeyValue: Optional[List[DimensionMemberVo]] = None


class PrimaryKeyByDimensionDto(BaseModel):
    #: 权限方案配置中的维度
    members: List[PrimaryKeyByDimensionMemberDto]


class ProcessSmartlistDto(BaseModel):
    """Process Smartlist Dto

    .. admonition:: 引用接口

        - **GET** ``/process/interface/pc-smartlist`` (Response: 200)
    """
    #: 父文件夹id
    folderId: Optional[str] = None
    #: 审批流name
    pcName: Optional[str] = None
    #: 对应值列表成员+描述
    smart: Optional[List[SmartlistValueDto]] = None


class QueryOperationOperatorByDimensionDto(BaseModel):
    """Query Operation Operator By Dimension Dto

    .. admonition:: 引用接口

        - **POST** ``/process/interface/operation/get-operator-by-dimensions``
    """
    #: 维度
    dimensions: List[DimensionMemberForOperatorDto]
    #: 父文件夹id，folderId与path，必须传一个
    folderId: Optional[str] = None
    #: 状态
    originStatus: str
    #: 路径
    path: Optional[str] = None
    #: 审批流名称
    pcName: str
    #: 维度字段
    primaryKeyValues: List[PrimaryKeyByDimensionDto]


class RoleDto(BaseModel):
    #: 是否全部角色
    allRoles: Optional[bool] = None
    #: 角色组
    groupInfo: Optional[List[RoleMessageDto]] = None
    #: 角色
    roleInfo: Optional[List[RoleMessageDto]] = None


class SmartListSaveForm(BaseModel):
    #: 元素类型(新建时可以为空)
    elementType: Optional[str] = None
    #: 父文件夹id
    folderId: str
    #: 组件id
    moduleId: Optional[str] = None
    #: 元素路径
    path: str
    #: 值列表成员值(多个)
    smartList: Optional[List[SmartList]] = None
    #: 值列表基本信息
    smartListInfo: SmartListInfo
    #: 值列表ud信息(多个)
    smartListUd: Optional[List[SmartListUd]] = None
    #: ADD-新建,EDIT-编辑
    type: Optional[str] = None


class SmartListSaveFormVo(BaseModel):
    #: 元素类型(新建时可以为空)
    elementType: Optional[str] = None
    #: 校验错误标记
    errorList: Optional[List[ErrorTips]] = None
    #: 父文件夹id
    folderId: str
    #: 组件id
    moduleId: Optional[str] = None
    #: 元素路径
    path: str
    #: 值列表成员值(多个)
    smartList: Optional[List[SmartListVo]] = None
    #: 值列表基本信息
    smartListInfo: SmartListInfo
    #: 值列表ud信息(多个)
    smartListUd: Optional[List[SmartListUd]] = None
    #: ADD-新建,EDIT-编辑
    type: Optional[str] = None


class ApprovalRecordTableVo(BaseModel):
    """Approval Record Table Vo

    .. admonition:: 引用接口

        - **GET** ``/process/operation/record-table`` (Response: 200)
    """
    #: 审批记录表信息
    dataTableBasic: Optional[DataTableBasicDTO] = None
    #: 审批记录表父文件夹id
    folderId: Optional[str] = None
    #: 审批记录表名称
    name: Optional[str] = None
    #: 审批记录表路径
    path: Optional[str] = None


class ProcessOperationDto(BaseModel):
    """Process Operation Dto

    .. admonition:: 引用接口

        - **POST** ``/process/interface/operation`` (Response: 200)
        - **POST** ``/process/interface/operation/init`` (Response: 200)
        - **POST** ``/process/interface/operation/roles-status`` (Response: 200)
    """
    #: 描述
    descriptionMap: Optional[dict] = None
    #: 操作id,0为初始操作
    id: str
    #: 操作是否为提交
    isSubmit: Optional[bool] = None
    #: 操作名称
    name: str
    #: 源状态值 逗号分隔
    originStatusList: Optional[str] = None
    #: 后置操作
    postOpe: Optional[List[CustomOperation]] = None
    #: 前置操作
    preOpe: Optional[List[CustomOperation]] = None
    #: 角色
    role: RoleDto
    #: 目标状态值
    targetStatus: str


class ProcessOperationVo(BaseModel):
    #: 描述
    descriptionMap: Optional[dict] = None
    #: 校验错误标记
    errorList: Optional[List[ErrorTips]] = None
    #: 操作id,0为初始操作
    id: str
    #: 操作是否为提交
    isSubmit: Optional[bool] = None
    #: 操作名称
    name: str
    #: 源状态值 逗号分隔
    originStatusList: Optional[str] = None
    #: 后置操作
    postOpe: Optional[List[CustomOperationVo]] = None
    #: 前置操作
    preOpe: Optional[List[CustomOperationVo]] = None
    #: 角色
    role: RoleDto
    #: 目标状态值
    targetStatus: str


class ProcessRoleVo(BaseModel):
    """Process Role Vo

    .. admonition:: 引用接口

        - **POST** ``/process/interface/get-action`` (Response: 200)
    """
    #: 文件夹id
    folderId: str
    #: 操作信息
    operation: List[ProcessOperationDto]
    #: 审批流名称
    pcName: str
    #: 角色
    roleName: List[str]


class NextOperationBacthVo(BaseModel):
    #: 下一步的可行操作
    operation: Optional[ProcessOperationDto] = None
    #: 对应的可执行操作人
    operators: Optional[List[NextOperationOperatorVo]] = None


class NextOperationVo(BaseModel):
    #: 是否所有用户
    allUsers: Optional[bool] = None
    #: 下一步的可行操作
    operation: Optional[ProcessOperationDto] = None
    #: 可执行的操作人
    operators: Optional[List[UserDto]] = None


class ProcessConfigBasicsVo(BaseModel):
    """Process Config Basics Vo

    .. admonition:: 引用接口

        - **GET** ``/process/configure/basics`` (Response: 200)
    """
    #: 审批流信息
    controlInfo: ProcessControlInfoDto
    #: 审批流操作信息
    operationInfo: List[ProcessOperationDto]


class ProcessInfoDto(BaseModel):
    #: 审批流信息
    controlInfo: ProcessControlInfoDto
    #: 审批流操作信息
    operationInfo: List[ProcessOperationDto]
    #: ADD-新建,EDIT-编辑
    type: Optional[str] = None


class ProcessInfoVo(BaseModel):
    #: 审批流信息
    controlInfo: ProcessControlInfoVo
    #: 审批流操作信息
    operationInfo: List[ProcessOperationVo]
    #: ADD-新建,EDIT-编辑
    type: Optional[str] = None


class ProcessTargetStatusAndOperatorBatchVo(BaseModel):
    """Process Target Status And Operator Batch Vo

    .. admonition:: 引用接口

        - **POST** ``/process/interface/operation/get-operator-by-dimensions`` (Response: 200)
    """
    #: 元素名称
    elementName: str
    #: 父文件夹id
    folderId: str
    #: 下一步的可行操作
    nextOperations: Optional[List[NextOperationBacthVo]] = None
    #: 路径
    path: str


class ProcessTargetStatusAndOperatorVo(BaseModel):
    """Process Target Status And Operator Vo

    .. admonition:: 引用接口

        - **POST** ``/process/interface/operation/operator`` (Response: 200)
    """
    #: 元素名称
    elementName: str
    #: 父文件夹id
    folderId: str
    #: 下一步的可行操作
    nextOperations: Optional[List[NextOperationVo]] = None
    #: 路径
    path: str


class ProcessConfigureDto(BaseModel):
    """Process Configure Dto

    .. admonition:: 引用接口

        - **POST** ``/process/configure/pt``
    """
    #: 审批流内容
    processInfo: ProcessInfoDto
    #: 1为保存,0为保存前置获取影响关系,暂时写死为1
    saveType: Optional[int] = None
    #: 值列表内容
    smartListInfo: SmartListSaveForm


class ProcessConfigureVo(BaseModel):
    """Process Configure Vo

    .. admonition:: 引用接口

        - **GET** ``/process/configure`` (Response: 200)
    """
    #: 审批流内容
    processInfo: ProcessInfoVo
    #: 1为保存,0为保存前置获取影响关系,暂时写死为1
    saveType: Optional[int] = None
    #: 值列表内容
    smartListInfo: Optional[SmartListSaveFormVo] = None



