"""
Models used by /gateway-server,/consolidation-server1-0

generated by model_code_gen.py
  - **filename** : ``consolidation.py``
  - **json timestamp** : ``2022-01-07 10:49:10``
"""


from .base import BaseModel
from typing import List, Optional, Union
from pydantic import Field


__all__ = [
    'CubeAccessControlStatusDTO',
    'CustomAccount',
    'ErrorDTO',
    'GroupRoleBaseInfoDTO',
    'RoleBaseInfoDTO',
    'ElementBaseInfo',
    'MatchAccountJournalTemplateType',
    'ConsolidationMemModel',
    'ScriptConfigure',
    'JournalTemplateConfigure',
    'RateConfigure',
    'AccountProcessing',
    'AccountTradeType',
    'DimensionMatchAccountInfo',
    'EquityInvestRelation',
    'ConConditionDimDTO',
    'ConLogParamsDTO',
    'CubeAccessControlDTO',
    'CubeDimensionDTO',
    'ElementInfoByProcotolDTO',
    'EntityRelationParamsDTO',
    'TradeTypeJTInfo',
    'MemFinModelDto',
    'MatchAccountInfo',
    'MatchAccountProcessType',
    'ConsolidationRelDim',
    'ConsolidationReqParam',
    'ExchangeConfigure',
    'EquityRelation',
    'ConsolidationStructure',
    'EquityLawParam'
]


class CubeAccessControlStatusDTO(BaseModel):
    #: 状态描述
    desc: Optional[dict] = None
    #: 状态
    value: Optional[str] = None


class CustomAccount(BaseModel):
    #: name
    name: Optional[str] = None
    #: udValue
    udValue: Optional[str] = None


class ErrorDTO(BaseModel):
    #: 异常key
    tipKey: Optional[str] = None
    #: 异常信息
    tipValue: Optional[str] = None


class GroupRoleBaseInfoDTO(BaseModel):
    #: 角色组描述
    description: Optional[dict] = None
    #: description1
    description1: Optional[str] = None
    #: description2
    description2: Optional[str] = None
    #: 是否为空
    empty: Optional[bool] = None
    #: 角色组说明
    instruction: Optional[dict] = None
    #: instruction1
    instruction1: Optional[str] = None
    #: instruction2
    instruction2: Optional[str] = None
    #: 角色组名称
    name: Optional[str] = None


class RoleBaseInfoDTO(BaseModel):
    #: 默认角色组名称
    defaultRolegroupName: Optional[str] = None
    #: 角色描述
    description: Optional[dict] = None
    #: description1
    description1: Optional[str] = None
    #: description2
    description2: Optional[str] = None
    #: 是否为空
    empty: Optional[bool] = None
    #: 角色说明
    instruction: Optional[dict] = None
    #: instruction1
    instruction1: Optional[str] = None
    #: instruction2
    instruction2: Optional[str] = None
    #: 角色名称
    name: Optional[str] = None


class ElementBaseInfo(BaseModel):
    """元素基础参数信息

    .. admonition:: 引用接口

        - **POST** ``/check-relation-element``
        - **POST** ``/consolidation/exchange-rate-account-code``
        - **POST** ``/consolidation/journal-model-column-name``
        - **POST** ``/consolidation/query-match-account``
        - **POST** ``/consolidation/view/query-con-dim-params``
    """
    #: 多语言描述
    description: Optional[dict] = None
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: str
    #: 组件id
    moduleId: Optional[str] = None
    #: 绝对路径
    path: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class MatchAccountJournalTemplateType(BaseModel):
    #: 匹配科目对应的日记账模板基础参数
    matchJournalBaseMap: Optional[dict] = None
    #: 匹配科目对应的日记账模板
    matchJournalTemplate: Optional[dict] = None


class ConsolidationMemModel(BaseModel):
    """合并内存财务模型

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/generate-merge-node-value``
        - **POST** ``/consolidation/view/generate-total-value``
    """
    #: 合并内存财务模型编码
    cubeCode: Optional[str] = None
    #: 合并内存财务模型文件夹ID
    cubeFolderId: Optional[str] = None
    #: 参数
    params: Optional[dict] = None
    #: 合并内存财务模型服务名
    serverName: Optional[str] = None


class ScriptConfigure(BaseModel):
    #: 执行模式，0：增强，1：替换
    executionMode: Optional[int] = None
    #: 后置脚本
    postscript: Optional[ElementBaseInfo] = None
    #: 后置脚本key
    postscriptKey: Optional[str] = None
    #: 前置脚本
    prescript: Optional[ElementBaseInfo] = None
    #: 前置脚本key
    prescriptKey: Optional[str] = None
    #: 替换脚本
    replaceScript: Optional[ElementBaseInfo] = None
    #: 后置脚本key
    replaceScriptKey: Optional[str] = None


class JournalTemplateConfigure(BaseModel):
    """日记账列参数信息

    .. admonition:: 引用接口

        - **POST** ``/consolidation/journal-model-column-name`` (Response: 200)
    """
    #: 列名
    columnName: str
    #: 列描述
    desc: Optional[dict] = None


class RateConfigure(BaseModel):
    #: 汇率科目
    accountCode: Optional[str] = None
    #: 科目类型
    accountType: Optional[str] = None
    #: 汇率科目多语言
    multilingual: Optional[dict] = None
    #: 自定义编码
    udKey: Optional[str] = None


class AccountProcessing(BaseModel):
    #: 加工类型多语言
    description: Optional[dict] = None
    #: 成员编码
    memberCode: Optional[str] = None
    #: 科目成员多语言
    multilingual: Optional[dict] = None
    #: 加工类型编码
    tradeCode: Optional[str] = None


class AccountTradeType(BaseModel):
    #: 匹配科目科目类型
    accountType: Optional[str] = None
    #: 交易属性编码
    eliCode: str
    #: 交易属性多语言描述
    eliDesc: Optional[dict] = None
    #: 交易属性自定义编码
    eliKey: Optional[str] = None
    #: 匹配科目自定义编码
    matKey: Optional[str] = None
    #: 匹配科目编码
    matchCode: str
    #: 匹配科目多语言描述
    matchDesc: Optional[dict] = None
    #: 成员编码
    memberCode: str
    #: 成员多语言描述
    memberDesc: Optional[dict] = None
    #: 科目成员本身类型
    memberType: Optional[str] = None


class DimensionMatchAccountInfo(BaseModel):
    #: 成员编码
    code: str
    #: 多语言描述
    description: Optional[dict] = None
    #: 自定义编码
    udKey: Optional[str] = None


class EquityInvestRelation(BaseModel):
    #: account
    account: Optional[str] = None
    #: increaseRatio
    increaseRatio: Optional[float] = None
    #: 真实投资期间-购买期间
    investPeriod: Optional[str] = None
    #: 真实投资年-购买年
    investYear: Optional[str] = None
    #: 被投资公司
    investee: Optional[str] = None
    #: 投资公司(末级公司)
    investor: Optional[str] = None
    #: 期间
    period: Optional[str] = None
    #: 场景
    scenario: Optional[str] = None
    #: 年度
    year: Optional[str] = None


class ConConditionDimDTO(BaseModel):
    """Con Condition Dim DTO

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/entity-offset-range-params``
    """
    #: 维度成员编码
    code: Optional[str] = None
    #: 维度信息
    dimElement: Optional[ElementBaseInfo] = None
    #: 维度作用
    dimensionUsage: Optional[int] = None
    #: 维度成员值
    value: Optional[dict] = None


class ConLogParamsDTO(BaseModel):
    """Con Log Params DTO

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/con-log-info``
        - **POST** ``/consolidation/view/equity-investment-offset``
        - **POST** ``/consolidation/view/fixed-asset-purchase-offset``
        - **POST** ``/consolidation/view/internal-inventory-offset``
        - **POST** ``/consolidation/view/reduction-offset``
        - **POST** ``/consolidation/view/universal-offset``
    """
    #: 合并算法基础参数
    element: Optional[ElementBaseInfo] = None
    #: 是否是合并实体
    mergeEntity: Optional[bool] = None
    #: 条件参数
    params: Optional[List[ConConditionDimDTO]] = None


class CubeAccessControlDTO(BaseModel):
    #: 访问权
    accessRight: Optional[int] = None
    #: 角色组
    groupRoleList: Optional[List[GroupRoleBaseInfoDTO]] = None
    #: id
    id: Optional[int] = None
    #: 角色
    roleList: Optional[List[RoleBaseInfoDTO]] = None
    #: cube读写控制状态
    statusList: Optional[List[CubeAccessControlStatusDTO]] = None


class CubeDimensionDTO(BaseModel):
    #: 科目成员脚本
    accountMemberScript: Optional[str] = None
    #: 列类型,0:什么也没有，1：维度，2：度量
    columnType: int
    #: 审批单元标记
    datablockSeg: Optional[bool] = None
    #: 审批单元编号
    datablockSegNo: Optional[int] = None
    #: 字段名
    datatableColumn: str
    #: 维度描述
    dimensionDescription: Optional[str] = None
    #: 字段关联的维度所在文件夹Id
    dimensionFolderId: str
    #: 字段关联的维度的moudelId
    dimensionMoudelId: Optional[str] = None
    #: 字段关联维度名称
    dimensionName: str
    #: 字段关联的维度的路径
    dimensionPath: Optional[str] = None
    #: 维度服务名称
    dimensionServerName: Optional[str] = None
    #: 字段关联维度类型
    dimensionType: str
    #: 列作用
    dimensionUsage: int
    #: 异常信息
    errorList: Optional[List[ErrorDTO]] = None
    #: 是否关联时间维度字段
    isDate: Optional[bool] = None
    #: 关联的维度是否为新维度
    isNewDimension: bool
    #: 关联数据表字段是否丢失
    lossCol: Optional[bool] = None
    #: 度量类型,1data2text
    measureType: Optional[int] = None
    #: 多语言
    multilingual: Optional[dict] = None
    #: 流程控制字段成员
    processMember: Optional[str] = None
    #: 流程控制字段标记
    processSeg: Optional[bool] = None
    #: 流程控制字段编号
    processSegNo: Optional[int] = None
    #: 是否用做权限字段(仅维度类型的允许用做权限字段)
    roleSeg: Optional[bool] = None
    #: 角色映射
    rsMapping: Optional[int] = None


class ElementInfoByProcotolDTO(BaseModel):
    """Element Info By Procotol DTO

    .. admonition:: 引用接口

        - **GET** ``/consolidation/query-active-entity-datatable`` (Response: 200)
        - **GET** ``/consolidation/query-cube-params`` (Response: 200)
    """
    #: 关联维度信息
    dimElementInfo: Optional[ElementBaseInfo] = None
    #: 当前语种元素描述
    elementNameDes: Optional[str] = None
    #: 所有语种元素描述
    elementNameDesAll: Optional[str] = None
    #: 状态
    elementTypeChild: Optional[str] = None
    #: 文件夹id/组件id
    id: Optional[str] = None
    #: 服务版本
    moduleVersion: Optional[str] = None
    #: 多语言
    multilingual: Optional[dict] = None
    #: 名称
    name: Optional[str] = None
    #: 父级id
    parentId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None
    #: 类型
    type: Optional[str] = None


class EntityRelationParamsDTO(BaseModel):
    """Entity Relation Params DTO

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/entity-offset-range-params`` (Response: 200)
    """
    #: 实体基础信息
    element: Optional[ElementBaseInfo] = None
    #: 激活实体
    entityCode: Optional[List[str]] = None
    #: 实体关联
    entityRelation: Optional[List[List]] = None
    #: 实体末级公司内部关联
    lastStageEntityRelation: Optional[List[str]] = None
    #: 非激活实体
    noActiveEntityCode: Optional[List[str]] = None
    #: 合并节点末级不关联
    noEntityRelation: Optional[List[str]] = None
    #: 合并实体父节点与子节点
    parentParamMap: Optional[dict] = None
    #: 合并实体父节点与子节点-共享节点
    sharedParamMap: Optional[dict] = None


class TradeTypeJTInfo(BaseModel):
    #: 列名集合
    columnList: Optional[List[JournalTemplateConfigure]] = None
    #: 分组列名
    columnName: str
    #: 日记账模板
    journalModel: ElementBaseInfo
    #: 值列名
    valueColumnName: str


class MemFinModelDto(BaseModel):
    #: 自动进行档期数和累计数的汇总计算，false：关；true：开；
    autoCalculation: Optional[bool] = None
    #: 资产负债类科目保存,1：当期数,2：累计数,autoCalculation为1时值必填
    balanceAccountSave: Optional[int] = None
    #: 内存财务数据模型编码
    code: str
    #: 读写权限
    cubeAccessControlReactList: Optional[List[CubeAccessControlDTO]] = None
    #: 内存财务数据模型关联列信息
    cubeDimensionList: Optional[List[CubeDimensionDTO]] = None
    #: cube类型,4：期间作为度量；5：不作为度量
    cubeType: int
    #: 数据表类型，0:mysql，1:clickhouse
    dataSync: Optional[int] = None
    #: 数据表元素类型
    datatableElementType: Optional[str] = None
    #: 关联的数据表所在文件夹Id
    datatableFolderId: Optional[str] = None
    #: 关联的数据表的ModuleId
    datatableModuleId: Optional[str] = None
    #: 内存财务数据模型关联数据表名称
    datatableName: Optional[str] = None
    #: 关联数据表的路径
    datatablePath: Optional[str] = None
    #: 多语言信息
    description: Optional[dict] = None
    #: 关联维度的所在的文件夹Id
    dimensionFolderId: Optional[str] = None
    #: 关联期间维度的moduleId
    dimensionModuleId: Optional[str] = None
    #: 关联期间维度的编码
    dimensionName: Optional[str] = None
    #: 关联维度的路径
    dimensionPath: Optional[str] = None
    #: dimensionRelKey
    dimensionRelKey: Optional[str] = None
    #: 关联维度的服务名
    dimensionServerName: Optional[str] = None
    #: 关联期间维度的Type
    dimensionType: Optional[str] = None
    #: 内存财务数据模型类型
    elementType: Optional[str] = None
    #: 是否启用流程控制
    enableProcessControl: Optional[bool] = None
    #: 损益类科目保存,1：当期数,2：累计数,autoCalculation为1时值必填
    flowAccountSave: Optional[int] = None
    #: 内存财务数据模型所在文件夹Id
    folderId: str
    #: 内存财务数据模型id
    id: Optional[str] = None
    #: 多语言信息关联主键
    languageKey: Optional[str] = None
    #: 期间作为度量,最小期间层级,cubeType为4时,使用该属性
    minPeriodLevel: Optional[str] = None
    #: 内存财务数据模型moduleId
    moduleId: Optional[str] = None
    #: 内存财务数据模型路径
    path: Optional[str] = None
    #: 权限字段
    permission: Optional[int] = None
    #: 内存财务模型关联流程控制信息
    processControlInfo: Optional[ElementBaseInfo] = None
    #: 审批流关联角色方案信息
    processRelRoleInfo: Optional[ElementBaseInfo] = None
    #: 内存财务模型关联角色方案信息
    roleSchemeInfo: Optional[ElementBaseInfo] = None
    #: 流程控制字段信息
    rsPcsColumnInfo: Optional[List[CubeDimensionDTO]] = None
    #: 内存财务数据模型服务名
    serverName: Optional[str] = None


class MatchAccountInfo(BaseModel):
    """匹配科目信息

    .. admonition:: 引用接口

        - **POST** ``/consolidation/query-match-account`` (Response: 200)
    """
    #: 匹配科目成员信息
    dimensionSearchMember: List[DimensionMatchAccountInfo]
    #: 关联维度信息
    relationDimensionInfo: Optional[ElementBaseInfo] = None
    #: 字段类型
    valueType: Optional[int] = None


class MatchAccountProcessType(BaseModel):
    """匹配科目关联的科目成员，加工类型

    .. admonition:: 引用接口

        - **POST** ``/consolidation/query-account-member-trade-type``
        - **POST** ``/consolidation/query-account-member-trade-type`` (Response: 200)
    """
    #: 匹配科目信息
    matchAccountParam: Optional[DimensionMatchAccountInfo] = None
    #: 匹配科目关联的科目成员，加工类型
    matchAccountRelationParamList: Optional[List[AccountProcessing]] = None
    #: 关联维度信息
    relationDimensionInfo: Optional[ElementBaseInfo] = None
    #: 字段类型
    valueType: int


class ConsolidationRelDim(BaseModel):
    """合并算法关联维度成员相关参数

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/query-con-dim-params`` (Response: 200)
    """
    #: 科目维度信息
    element: Optional[ElementBaseInfo] = None
    #: 关联的成员，匹配科目，交易属性信息
    params: Optional[List[AccountTradeType]] = None


class ConsolidationReqParam(BaseModel):
    """合并请求参数

    .. admonition:: 引用接口

        - **POST** ``/consolidation/view/consolidation``
    """
    #: 合并算法组件编码
    conCode: str
    #: 合并算法组件文件夹ID
    conFolderId: str
    #: 是否强制合并
    isForceConsolidation: bool
    #: 合并参数
    params: Optional[List[ConConditionDimDTO]] = None
    #: 合并算法组件路径
    path: Optional[str] = None
    #: 合并算法组件服务名
    serverName: Optional[str] = None


class ExchangeConfigure(BaseModel):
    #: 外币折算方式，0：乘法；1：除法
    convertedType: int
    #: 科目类型，汇率科目信息
    exchangeRateList: Optional[List[RateConfigure]] = None


class EquityRelation(BaseModel):
    #: 投资公司在合并公司下的股权投资关系(已过滤非激活实体）
    equityInvestmentRelations: Optional[List[EquityInvestRelation]] = None
    #: 投资公司(末级公司)
    investor: Optional[ConConditionDimDTO] = None


class ConsolidationStructure(BaseModel):
    """合并算法结构信息

    .. admonition:: 引用接口

        - **GET** ``/consolidation/query-consolidation-info`` (Response: 200)
        - **POST** ``/consolidation/save-or-edit-consolidation``
        - **POST** ``/consolidation/save-or-edit-consolidation`` (Response: 200)
    """
    #: 调整日记账模板
    adjustJournalModel: Optional[TradeTypeJTInfo] = None
    #: 计算脚本
    calculateScript: Optional[ScriptConfigure] = None
    #: 编码
    code: str
    #: 日志实际表名
    conLogActualTableName: Optional[str] = None
    #: 日志表信息
    conLogTable: Optional[ElementBaseInfo] = None
    #: 状态实际表名
    conStatusActualTableName: Optional[str] = None
    #: 状态表信息
    conStatusTable: Optional[ElementBaseInfo] = None
    #: 汇率配置信息
    convertedConfigInfo: Optional[ExchangeConfigure] = None
    #: 类型
    elementType: str
    #: 股权信息内存财务模型
    equityInfoCube: ElementBaseInfo
    #: 股权信息内存财务模型科目维度信息
    equityInfoCubeAccountDim: ElementBaseInfo
    #: 汇率内存财务模型
    exchangeRateCube: ElementBaseInfo
    #: 汇率内存财务模型科目维度信息
    exchangeRateCubeAccountDim: ElementBaseInfo
    #: 文件夹id
    folderId: str
    #: id
    id: Optional[str] = None
    #: 匹配科目
    matchAccountParam: MatchAccountInfo
    #: 合并内存财务模型
    mergerCube: ElementBaseInfo
    #: 合并内存财务模型科目维度信息
    mergerCubeAccountDim: ElementBaseInfo
    #: 组件id
    moduleId: Optional[str] = None
    #: 多语言
    multilingual: Optional[dict] = None
    #: 抵消日记账模板
    offsetJournalModel: Optional[TradeTypeJTInfo] = None
    #: 抵消脚本
    offsetScript: Optional[ScriptConfigure] = None
    #: 路径
    path: Optional[str] = None
    #: 关联交易内存财务模型
    relationTradeCube: ElementBaseInfo
    #: 关联交易内存财务模型科目维度信息
    relationTradeCubeAccountDim: ElementBaseInfo
    #: 服务名
    serverName: Optional[str] = None
    #: 激活实体表
    stateEntityTableInfo: Optional[ElementBaseInfo] = None


class EquityLawParam(BaseModel):
    """权益法调整参数

    .. admonition:: 引用接口

        - **POST** ``/consolidation/equity-adjust``
    """
    #: 激活实体表元素信息
    activeEntityTable: Optional[ElementBaseInfo] = None
    #: 分组列名
    adjustColumnName: str
    #: 权益法，匹配科目对应日记账信息
    adjustTemplateParam: Optional[MatchAccountJournalTemplateType] = None
    #: 校验科目
    checkAccountList: Optional[List[CustomAccount]] = None
    #: 交易类型、匹配科目、科目成员的对应关系
    conRelationDimParam: Optional[ConsolidationRelDim] = None
    #: 合并内存财务模型结构信息
    consolidationCube: Optional[MemFinModelDto] = None
    #: 选择的合并实体
    consolidationEntity: Optional[dict] = None
    #: 实体成员信息
    dimMemberMap: Optional[dict] = None
    #: 实体
    entity: Optional[ConConditionDimDTO] = None
    #: 股权信息内存模型
    equityInformationCube: Optional[MemFinModelDto] = None
    #: 投资公司(末级公司)的股权关系
    equityInvestments: Optional[List[EquityRelation]] = None
    #: 汇率信息内存模型
    exchangeRateCube: Optional[MemFinModelDto] = None
    #: 未激活实体
    noActiveEntityMap: Optional[dict] = None
    #: 分组列名
    offsetColumnName: str
    #: 抵消算法，匹配科目对应日记账信息
    offsetTemplateParam: Optional[MatchAccountJournalTemplateType] = None
    #: 期间
    period: Optional[ConConditionDimDTO] = None
    #: 关联交易内存财务模型结构信息
    relatedTransactionCube: Optional[MemFinModelDto] = None
    #: 场景
    scenario: Optional[ConConditionDimDTO] = None
    #: 值维度
    value: Optional[ConConditionDimDTO] = None
    #: 值维度字段
    valueColumnName: str
    #: 版本
    version: Optional[ConConditionDimDTO] = None
    #: 年度
    year: Optional[ConConditionDimDTO] = None



