"""
Models used by /data-table-mysql-server1-0

generated by model_code_gen.py
  - **filename** : ``data_table_mysql.py``
  - **json timestamp** : ``2021-06-29 10:49:22``
"""


from .base import BaseModel
from typing import List, Optional
from pydantic import Field


__all__ = [
    'CustomSqlReqDTO',
    'CustomSqlRespDTO',
    'DatatableDataDeleteDTO',
    'DatatableDataUpdateDTO',
    'DatatableIndexDTO',
    'DatatableInsertDTO',
    'DatatableSelectDTO',
    'GenerateActualTableNameDTO',
    'ResponseResult',
    'BaseElementInfo',
    'DatatableColumnInfoDTO',
    'DatatableInfoCheckDTO',
    'DatatableInfoMemberDTO',
    'PhysicalTableExistDTO',
    'DatatableColumnAddDTO',
    'DatatableInfoDTO',
    'DatatableInfoBasicInfoDTO',
    'DatatableInfoSaveParam',
    'MiscModel',
    'AccountInfo',
]


class CustomSqlReqDTO(BaseModel):
    """Custom Sql Req DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/custom-sql``
    """
    #: 自定义SQL
    sql: str


class CustomSqlRespDTO(BaseModel):
    #: 增删改影响的行数
    modifyCounts: Optional[int] = None
    #: SQL类型：insert、update、delete、select
    operation: Optional[str] = None
    #: 查询操作返回的结果集，返回类型为 List Map<String,Object>
    selectResult: Optional[List[Optional[dict]]] = None


class DatatableDataDeleteDTO(BaseModel):
    """Datatable Data Delete DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/delete-data``
    """
    #: 删除数据条件列表
    columnList: dict
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId、path二选一）
    folderId: Optional[str] = None
    #: 路径（folderId、path二选一）
    path: Optional[str] = None


class DatatableDataUpdateDTO(BaseModel):
    """Datatable Data Update DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/update-data``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId、path二选一）
    folderId: Optional[str] = None
    #: 路径（folderId、path二选一）
    path: Optional[str] = None
    #: 更新条件
    setList: dict
    #: 过滤条件
    whereList: Optional[dict] = None


class DatatableIndexDTO(BaseModel):
    #: 列名
    columnName: Optional[str] = None
    #: commit
    commit: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建者
    creator: Optional[str] = None
    #: 数据表基本信息的id
    datatableId: Optional[str] = None
    #: id
    id: Optional[str] = None
    #: 索引列信息
    indexColumns: Optional[List[str]] = None
    #: 索引名称
    indexName: Optional[str] = None
    #: indexSchema
    indexSchema: Optional[str] = None
    #: 索引类型
    indexType: Optional[str] = None
    #: indexTypeMethod
    indexTypeMethod: Optional[str] = None
    #: 最后一次修改的时间
    lastModifyTime: Optional[str] = None
    #: 最后一次修改的用户
    lastModifyUser: Optional[str] = None
    #: nonUnique
    nonUnique: Optional[str] = None
    #: 唯一key
    uniqueKey: Optional[str] = None


class DatatableInsertDTO(BaseModel):
    """Datatable Insert DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/insert``
    """
    #: 数据字段列表
    columnList: List[str]
    #: 数据值列表
    columnValueList: List[List]
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId、path二选一）
    folderId: Optional[str] = None
    #: 路径（folderId、path二选一）
    path: Optional[str] = None


class DatatableSelectDTO(BaseModel):
    """Datatable Select DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/execute-sql``
        - **POST** ``/datatable/executeBatchSql``
    """
    #: 批量操作的sql,update insert into select delete 等,实际表名用${xxx}代替
    batchSql: List[str]
    #: 元素列表信息,key为占位的关键字,value为元素信息
    elementBaseInfoParamMap: dict
    #: select语句,传sql语句,实际表名用${xxx}代替
    sql: str
    #: 是否返回数据总数;0:不返回,1:返回
    total: Optional[int] = None


class GenerateActualTableNameDTO(BaseModel):
    """Generate Actual Table Name DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable-edit-view/generateActualTableName``
    """
    #: tableName
    tableName: Optional[str] = None


class ResponseResult(BaseModel):
    """Response Result

    .. admonition:: 引用接口

        - **POST** ``/datatable-edit-view/column-add`` (Response: 200)
        - **POST** ``/datatable-edit-view/generateActualTableName`` (Response: 200)
        - **POST** ``/datatable-using-view/customizesql`` (Response: 200)
        - **POST** ``/datatable/execute-sql`` (Response: 200)
        - **POST** ``/element-info/copy`` (Response: 200)
        - **POST** ``/element-info/delete`` (Response: 200)
        - **POST** ``/element-info/import`` (Response: 200)
    """
    #: code
    code: Optional[int] = None
    #: data
    data: Optional[dict] = None
    #: message
    message: Optional[str] = None
    #: status
    status: Optional[bool] = None


class BaseElementInfo(BaseModel):
    """元素基本信息

    .. admonition:: 引用接口

        - **POST** ``/datatable/actual-tablename``
        - **POST** ``/datatable/batch-actual-tablename``
        - **POST** ``/datatable/datatable-info-batch``
        - **POST** ``/datatable/table-info-field``
        - **POST** ``/datatable/table-info-field-physical``
        - **POST** ``/element-info/delete``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId、path二选一）
    folderId: Optional[str] = None
    #: 路径（folderId、path二选一）
    path: Optional[str] = None


class DatatableColumnInfoDTO(BaseModel):
    """Datatable Column Info DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/column/column-name``
    """
    #: 列名信息
    columnName: str
    #: 元素基本信息
    elementBaseInfoParam: BaseElementInfo


class DatatableInfoCheckDTO(BaseModel):
    """Datatable Info Check DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/table-ifexists``
        - **POST** ``/datatable/table-ifexists-physical``
    """
    #: 元素的基本信息
    elementBaseInfoParam: BaseElementInfo
    #: 数据表的实际表名
    tableName: Optional[str] = None


class DatatableInfoMemberDTO(BaseModel):
    """Datatable Info Member DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/distinct-column-members``
    """
    #: 元素请求基本信息
    elementBaseInfoParam: BaseElementInfo
    #: 列名集合
    fieldList: List[str]


class PhysicalTableExistDTO(BaseModel):
    """Physical Table Exist DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/physical-table-exist``
    """
    #: 实际表名（二选一，当元素信息为空时，使用实际表名）
    actualTableName: Optional[str] = None
    #: 元素信息（二选一，元素信息不为空，则优先使用元素信息来处理，不使用传过来的实际表名）
    elementBaseInfo: Optional[BaseElementInfo] = None


class DatatableColumnAddDTO(BaseModel):
    """Datatable Column Add DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable-edit-view/column-add``
    """
    #: 要新增的列信息集合
    columnToAddList: Optional[List['MiscModel']] = None
    #: 元素基本信息
    elementBaseInfoParam: Optional[BaseElementInfo] = None


class DatatableInfoDTO(BaseModel):
    #: 实际的物理表名（前端必传，如果不传则接口内会自动生成）
    actualTableName: Optional[str] = None
    #: 是否记录操作时间
    createLogColumn: Optional[bool] = None
    #: 是否创建排序
    createSort: Optional[bool] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建者
    creator: Optional[str] = None
    #: 多语言描述信息
    description: Optional[dict] = None
    #: 新建不需要传值，编辑时需要传值
    id: Optional[str] = None
    #: 最后一次编辑的时间
    lastModifyTime: Optional[str] = None
    #: 最后一次编辑的用户
    lastModifyUser: Optional[str] = None
    #: 是否记录操作人
    modifyLogColumn: Optional[bool] = None
    #: 数据表名称(简名)
    name: Optional[str] = None
    #: 之前的信息，新建则不用传值
    oldInfo: Optional['DatatableInfoDTO'] = None
    #: 数据表存放的父层级文件夹id(folderId、parentId、path三选一)
    parentId: Optional[str] = None


class DatatableInfoBasicInfoDTO(BaseModel):
    """Datatable Info Basic Info DTO

    .. admonition:: 引用接口

        - **POST** ``/datatable/data-diff``
        - **POST** ``/datatable/table-info-field`` (Response: 200)
        - **POST** ``/datatable/table-info-field-physical`` (Response: 200)
    """
    #: 当前数据表的所有列
    datatableColumn: List['MiscModel']
    #: 索引列表
    datatableIndexInfo: Optional[List[DatatableIndexDTO]] = None
    #: 数据表相关信息
    datatableInfo: Optional[DatatableInfoDTO] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 新建元素时，支持手动指定path，当文件路径不存在时，则平台自动创建
    path: Optional[str] = None


class DatatableInfoSaveParam(BaseModel):
    """Datatable Info Save Param

    .. admonition:: 引用接口

        - **POST** ``/datatable-edit-view/datatable-save``
        - **POST** ``/datatable-edit-view/datatable-save`` (Response: 200)
        - **POST** ``/datatable-edit-view/datatable-save-edit``
        - **POST** ``/datatable-edit-view/datatable-save-edit`` (Response: 200)
        - **POST** ``/datatable-edit-view/only-check``
        - **POST** ``/datatable-edit-view/only-check`` (Response: 200)
        - **POST** ``/datatable-edit-view/only-save``
        - **POST** ``/datatable-edit-view/only-save`` (Response: 200)
        - **POST** ``/datatable-edit-view/only-save-edit``
        - **POST** ``/datatable-edit-view/only-save-edit`` (Response: 200)
    """
    #: 当前数据表的所有列
    datatableColumn: List['MiscModel']
    #: 索引列表
    datatableIndexInfo: List[DatatableIndexDTO]
    #: 数据表相关信息
    datatableInfo: DatatableInfoDTO
    #: 元素子类型
    elementTypeChild: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 是否增量编辑列信息(后端参数)
    incrementalEditing: Optional[bool] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 是否只创建物理表（不通知平台）
    onlyCreatePhysicalTable: Optional[bool] = None
    #: 元素实例打开路径
    openPath: Optional[str] = None
    #: 新建元素时，支持手动指定path，当文件路径不存在时，则平台自动创建
    path: str


class MiscModel(BaseModel):
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建者
    creator: Optional[str] = None
    #: 字段的默认值
    defaultValue: Optional[str] = None
    #: 字段的描述信息
    description: Optional[str] = None
    #: 最后一次更新的时间
    lastModifyTime: Optional[str] = None
    #: 最后一次编辑的用户
    lastModifyUser: Optional[str] = None
    #: 字段长度(datatime类型不用传值)
    length: Optional[str] = None
    #: 字段名称
    name: str
    #: 更新、删除操作变更前的数据信息
    oldInfo: Optional['MiscModel'] = None
    #: 操作类型--add/update/delete
    operation: Optional[str] = None
    #: 字段对应的排序信息
    sort: Optional[int] = None
    #: 字段类型
    type: str
    #: 唯一key
    uniqueKey: Optional[str] = None
    #: 是否可以为空
    whetherEmpty: Optional[bool] = None
    #: 是否自增
    whetherIncrement: Optional[bool] = None
    #: 是否唯一
    whetherOnly: Optional[bool] = None
    #: 是否为主键
    whetherPrimary: Optional[bool] = None
    #: 是否为系统字段
    whetherSystemColumn: Optional[bool] = None


class AccountInfo(BaseModel):
    name: str
    password: str
    accountStatus: bool
    dbName: str
    host: str
    port: int


DatatableColumnAddDTO.update_forward_refs()
DatatableInfoDTO.update_forward_refs()
DatatableInfoBasicInfoDTO.update_forward_refs()
DatatableInfoSaveParam.update_forward_refs()
MiscModel.update_forward_refs()
