"""
Models used by /financial-model-server1-0

generated by model_code_gen.py
  - **filename** : ``financial_model.py``
  - **json timestamp** : ``2022-11-28 17:27:51``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'ClearDataDTO',
    'CopyCalculateDTO',
    'CubeDataLogForm',
    'CubeRightElementDTO',
    'ElementDeleteFrontRearDTO',
    'ElementDetailDTO',
    'ElementDetailDto',
    'ElementRelationDTO',
    'ErrorDTO',
    'GroupRoleDataBlockUserGroup',
    'ListTableQueryParamDTO',
    'ListTableVerifyErrorInfoDTO',
    'PageVo',
    'QueryOptimizeConfigVO',
    'ReactFormAuthData',
    'ReactFormErrorMessage',
    'ResponseResult',
    'ResultObj',
    'SheetDimensionLevelDto',
    'SheetPovInfoDto',
    'SheetPovTreeParam',
    'SheetUdMemberDto',
    'SplitSqlWhiteDimensionConfig',
    'SpreadsheetError',
    'SpreadsheetRowData',
    'UdInfoDto',
    'ValueTypeMapDTO',
    'CubeAccessStatus',
    'DataBlockDimension',
    'DataBlockDimDto',
    'RoleDto',
    'RoleDataBlock',
    'CellDataDTO',
    'CubeDimensionDto',
    'CubeRelationResponseDTO',
    'CustomizeSplitSqlForPeriod',
    'PageParamsVo',
    'ReactFormListDTO',
    'SheetDimensionAttributeDto',
    'SheetDimensionDto',
    'SheetMemberDto',
    'SheetPovMulitLevelDto',
    'SheetRowDto',
    'SplitSqlFixedConfigItem',
    'SpreadsheetSingleData',
    'WookbookParamDto',
    'DataBlockInfo',
    'DataBlockInfoDto',
    'AccountCalendarDto',
    'CubeQueryForOutVo',
    'PcParams',
    'ReactSpreadsheetSaveForm',
    'SheetColumnDto',
    'SheetPageDto',
    'CubeAccessControlViewReact',
    'DatatableColumnDto',
    'DatatableInfoDto',
    'FinancialModelDto',
    'GroupRoleDatablockReactView',
    'SheetDto',
    'WorkbookInfoDto',
    'SheetPovChildrenDto',
    'SheetPovTreeDto',
    'CubeAccessCtrlDto',
    'HeaderObject',
    'RoleSetDataBlock',
    'FinancialDataDto',
    'TaskExecutionParam',
    'TaskExecutionResult'
]


class ClearDataDTO(BaseModel):
    """Clear Data DTO

    .. admonition:: 引用接口

        - **POST** ``/cubeCalculate/clearData``
    """
    #: clear_script
    clear_script: Optional[str] = None
    #: cube_name
    cube_name: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: path
    path: Optional[str] = None


class CopyCalculateDTO(BaseModel):
    """Copy Calculate DTO

    .. admonition:: 引用接口

        - **POST** ``/copyCalculate``
    """
    #: 财务模型名称cubeFolderId
    cubeFolderId: Optional[str] = None
    #: 财务模型名称cubename
    cubeName: Optional[str] = None
    #: 财务模型名称cubePath
    cubePath: Optional[str] = None
    #: entryObject
    entryObject: Optional[str] = None
    #: fixMembers表达式
    fixMembers: Optional[str] = None
    #: formula表达式
    formula: Optional[str] = None


class CubeDataLogForm(BaseModel):
    """Cube Data Log Form

    .. admonition:: 引用接口

        - **POST** ``/cube/data/log/list``
    """
    #: 财务模型路径id
    cubeFolderId: Optional[str] = None
    #: 财务模型名称
    cubeName: Optional[str] = None
    #: 财务模型路径
    cubePath: Optional[str] = None
    #: 维度组合
    dimensionData: Optional[Any] = None


class MdxParam(BaseModel):
    key: Optional[str] = None
    type: Optional[int] = None
    value: Optional[str] = None


class ParameterDefineDto(BaseModel):
    #: key
    key: Optional[str] = None
    #: type
    type: Optional[int] = None
    #: value
    value: Optional[str] = None


class TaskExecutionParam(BaseModel):
    """Task Execution Param

    .. admonition:: 引用接口

        - **POST** ``/mdx/task/execution``
    """
    #: businessId
    businessId: Optional[str] = None
    #: callBackUrl
    callBackUrl: Optional[str] = None
    #: decimalDigitsType
    decimalDigitsType: Optional[int] = None
    #: entryMode
    entryMode: Optional[int] = None
    #: parameters
    parameters: Optional[List[ParameterDefineDto]] = None
    #: precision
    precision: Optional[int] = None
    #: script
    script: Optional[str] = None
    scriptCode: Optional[str] = None
    #: timeout
    timeout: Optional[int] = None
    cubeName: Optional[str] = None
    cubeFolderId: Optional[str] = None
    cubePath: Optional[str] = None


class TaskExecutionResult(BaseModel):
    """Task Execution Result

    .. admonition:: 引用接口

        - **POST** ``/mdx/task/execution`` (Response: 200)
    """
    #: 业务id
    businessId: Optional[str] = None
    #: 失败原因
    failReason: Optional[str] = None
    #: 处理是否正常，true 正常， false 异常
    result: Optional[bool] = None
    #: 状态，默认为0(正常返回)，超时为1(超时返回)，判断超时逻辑：result = true & status = 1
    status: Optional[int] = None
    #: 计算脚本影响单元格数，模型编辑器入口时返回具体值，其他时候返回null
    cell: Optional[int] = None


class CubeRightElementDTO(BaseModel):
    #: 被引用元素绝对/相对标识
    absoluteTag: Optional[bool] = None
    #: 元素列表的警告标记：0-正常；1-警告
    elWarning: Optional[int] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 组件名称
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 被引用元素相对路径
    relativePath: Optional[str] = None
    #: 组件服务名称
    serverName: Optional[str] = None


class ElementDeleteFrontRearDTO(BaseModel):
    """Element Delete Front Rear DTO

    .. admonition:: 引用接口

        - **POST** ``/cube/delete-other``
    """
    #: app
    app: Optional[str] = None
    #: elementName
    elementName: Optional[str] = None
    #: elementType
    elementType: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: isDeleteData
    isDeleteData: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: space
    space: Optional[str] = None


class ElementDetailDTO(BaseModel):
    #: 是否是绝对路径
    absoluteTag: Optional[bool] = None
    #: 多语言
    description: Optional[Any] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 多语言使用的key
    languageKey: Optional[str] = None
    #: 元素对应组件版本
    moduleVersion: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None
    #: 相对路径
    relativePath: Optional[str] = None
    #: 元素对应组件服务名
    serverName: Optional[str] = None


class ElementDetailDto(BaseModel):
    #: description
    description: Optional[str] = None
    #: elementName
    elementName: Optional[str] = None
    #: elementType
    elementType: Optional[str] = None
    #: folderId
    folderId: Optional[str] = None
    #: languageKey
    languageKey: Optional[str] = None
    #: moduleVersion
    moduleVersion: Optional[str] = None
    #: path
    path: Optional[str] = None
    #: serverName
    serverName: Optional[str] = None


class ElementRelationDTO(BaseModel):
    #: 被引用元素绝对/相对标识
    absoluteTag: Optional[bool] = None
    #: 被引用元素名称
    elementName: Optional[str] = None
    #: 被引用元素类型
    elementType: Optional[str] = None
    #: 被引用元素文件夹id
    folderId: Optional[str] = None
    #: 被引用元素绝对路径
    path: Optional[str] = None
    #: 引用者元素名称
    quoter: Optional[str] = None
    #: 被引用元素相对路径
    relativePath: Optional[str] = None
    #: 被引用元素服务名
    serverName: Optional[str] = None


class ErrorDTO(BaseModel):
    #: 异常key
    tipKey: Optional[str] = None
    #: 异常信息
    tipValue: Optional[str] = None


class GroupRoleDataBlockUserGroup(BaseModel):
    #: groupId
    groupId: Optional[str] = None
    #: groupName
    groupName: Optional[str] = None


class ListTableQueryParamDTO(BaseModel):
    #: 元素名称
    elementName: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 页数
    page: Optional[int] = None
    #: 每页条数
    pageSize: Optional[int] = None
    #: pov条件
    pov: Optional[Any] = None
    #: screen
    screen: Optional[List[Any]] = None
    #: 搜索条件
    search: Optional[str] = None
    #: sheet01  第几个sheet页
    sheetMark: Optional[str] = None
    #: sort
    sort: Optional[List[Any]] = None


class ListTableVerifyErrorInfoDTO(BaseModel):
    #: 错误key
    tipKey: Optional[str] = None
    #: 错误提示描述
    tipValue: Optional[str] = None


class PageVo(BaseModel):
    #: 属性维别名
    adn: Optional[str] = None
    #: 多选时，维度成员
    curname: Optional[str] = None
    #: 字段名
    dc: Optional[str] = None
    #: 维度成员
    name: Optional[str] = None


class QueryOptimizeConfigVO(BaseModel):
    #: distinguishZero
    distinguishZero: Optional[bool] = None
    #: dynamicPriorityDimensionNames
    dynamicPriorityDimensionNames: Optional[List[str]] = None
    #: fewBaseMemberDimensionNames
    fewBaseMemberDimensionNames: Optional[List[str]] = None
    #: fixedJoinPriorityDimensionNames
    fixedJoinPriorityDimensionNames: Optional[List[str]] = None
    #: viewEnd
    viewEnd: Optional[bool] = None


class ReactFormAuthData(BaseModel):
    #: 别名与权限控制单元的关系
    accessControlUnitMap: Optional[Any] = None
    #: 清单表是否允许编辑
    allowEdit: Optional[int] = None
    #: 行数据，由别名和值构成
    businessData: Optional[Any] = None
    #: 字段初步权限判断
    colAlias2Auth: Optional[Any] = None
    #: 字段别名与角色方案间的关系
    colAliasRoleDim: Optional[Any] = None
    #: 是否启用权限控制单元
    enableAccessUnit: Optional[int] = None
    #: 清单表id
    listTableId: Optional[str] = None
    #: 清单表类型
    listType: Optional[int] = None
    #: 角色方案元素明细信息
    rsElementDetail: Optional[ElementDetailDTO] = None
    #: 角色方案名称
    rsName: Optional[str] = None
    #: 状态字段别名顺序集合
    statusAliasArr: Optional[List[str]] = None


class ReactFormErrorMessage(BaseModel):
    #: alias
    alias: Optional[str] = None
    #: colNum
    colNum: Optional[str] = None
    #: columnName
    columnName: Optional[str] = None
    #: dataTableName
    dataTableName: Optional[str] = None
    #: errMsg
    errMsg: Optional[str] = None
    #: errorCode
    errorCode: Optional[int] = None
    #: lineMapping
    lineMapping: Optional[str] = None
    #: rowNum
    rowNum: Optional[str] = None
    #: value
    value: Optional[Any] = None


class ResponseResult(BaseModel):
    """Response Result

    .. admonition:: 引用接口

        - **POST** ``/block/pc-init`` (Response: 200)
        - **GET** ``/block/pc-init-status`` (Response: 200)
        - **POST** ``/block/pc-status`` (Response: 200)
        - **POST** ``/copyCalculate`` (Response: 200)
        - **GET** ``/dependencies`` (Response: 200)
        - **GET** ``/dynamic/config/get/{key}`` (Response: 200)
        - **GET** ``/dynamic/config/getAll`` (Response: 200)
        - **GET** ``/dynamic/config/remove/{key}`` (Response: 200)
        - **POST** ``/dynamic/config/update`` (Response: 200)
        - **POST** ``/spreadsheets/writeCacheToFile``
    """
    #: code
    code: Optional[int] = None
    #: data
    data: Optional[Any] = None
    #: message
    message: Optional[str] = None
    #: status
    status: Optional[bool] = None


class ResultObj(BaseModel):
    """Result Obj

    .. admonition:: 引用接口

        - **POST** ``/cubeCalculate/clearData`` (Response: 200)
    """
    #: map
    map: Optional[Any] = None
    #: resultCode
    resultCode: Optional[int] = None
    #: resultList
    resultList: Optional[List[Any]] = None
    #: resultObj
    resultObj: Optional[Any] = None
    #: resultString
    resultString: Optional[str] = None
    #: set
    set: Optional[List[Any]] = None
    #: tipMsg
    tipMsg: Optional[str] = None


class SheetDimensionLevelDto(BaseModel):
    #: 层级标题描述
    lns: Optional[List[Dict]] = None
    #: 层级成员集合
    lrs: Optional[List[Dict]] = None


class SheetPovInfoDto(BaseModel):
    """Sheet Pov Info Dto

    .. admonition:: 引用接口

        - **GET** ``/spreadsheets/query-pov-member`` (Response: 200)
    """
    #: pov信息
    scriptMember: Optional[List[Dict]] = None
    #: sheet 名称
    sheetName: Optional[str] = None


class SheetPovTreeParam(BaseModel):
    """Sheet Pov Tree Param

    .. admonition:: 引用接口

        - **GET** ``/spreadsheets/query-pov-dimension-tree``
    """
    #: defaultSelected
    defaultSelected: Optional[str] = None
    #: dimensionExpression
    dimensionExpression: Optional[str] = None
    #: dimensionFolderId
    dimensionFolderId: Optional[str] = None
    #: dimensionName
    dimensionName: Optional[str] = None
    #: dimensionType
    dimensionType: Optional[str] = None
    #: dimensionUsage
    dimensionUsage: Optional[str] = None
    #: name
    name: Optional[str] = None
    #: rsList
    rsList: Optional[str] = None
    #: rsMapping
    rsMapping: Optional[str] = None
    #: rsName
    rsName: Optional[str] = None
    #: searchValue
    searchValue: Optional[str] = None


class SheetUdMemberDto(BaseModel):
    #: 描述
    d: Optional[str] = None
    #: n
    n: Optional[str] = None


class SplitSqlWhiteDimensionConfig(BaseModel):
    #: dimensionName
    dimensionName: Optional[str] = None
    #: groupedDimensionMemberNames
    groupedDimensionMemberNames: Optional[List[List]] = None
    #: normalGranularity
    normalGranularity: Optional[int] = None
    #: normalMax
    normalMax: Optional[int] = None
    #: periodGranularityForMergeBase
    periodGranularityForMergeBase: Optional[int] = None
    #: periodGranularityForMergeNotNormal
    periodGranularityForMergeNotNormal: Optional[int] = None
    #: periodGranularityForMergeParent
    periodGranularityForMergeParent: Optional[int] = None
    #: type
    type: Optional[int] = None


class SpreadsheetError(BaseModel):
    #: 错误编码
    errorCode: Optional[int] = None
    #: 错误描述
    errorMsg: Optional[str] = None


class SpreadsheetRowData(BaseModel):
    #: 科目类型
    accountType: Optional[str] = None
    #: assistWritingAuditLogs
    assistWritingAuditLogs: Optional[Any] = None
    #: 列名和维度成员名对应关系
    columnDimensionMemberMap: Optional[Any] = None
    #: 错误提示
    errorMsgList: Optional[List[SpreadsheetError]] = None
    #: 单元格的位置，用于前台提示信息友好
    location: Optional[str] = None
    #: 更新的列名
    updateColumn: Optional[str] = None


class UdInfoDto(BaseModel):
    #: 别名
    alias: Optional[str] = None
    #: 多语种
    multilingual: Optional[Any] = None
    #: ud名称
    udName: Optional[str] = None


class ValueTypeMapDTO(BaseModel):
    #: 小数部分展示长度
    decimalDisplayLength: Optional[int] = None
    #: 默认值
    defaultValue: Optional[str] = None
    #: 默认值显示
    defaultValueShow: Optional[str] = None
    #: 整数部分长度
    digitLen: Optional[int] = None
    #: 维度展示类型
    dimensionDisplay: Optional[int] = None
    #: 维度名称
    dimensionName: Optional[str] = None
    #: 展示的整数长度
    displayDigitLen: Optional[int] = None
    #: 元素信息
    elementDetail: Optional[ElementDetailDTO] = None
    #: 是否启用维度表达式
    enableDimensionExpression: Optional[bool] = None
    #: 报错信息
    errorList: Optional[List[ListTableVerifyErrorInfoDTO]] = None
    #: 是否报错
    errorTag: Optional[bool] = None
    #: functionCode
    functionCode: Optional[str] = None
    #: 介绍
    instruction: Optional[str] = None
    #: 长度
    length: Optional[int] = None
    #: list
    list: Optional[str] = None
    #: 是否大于等于
    maxEqual: Optional[bool] = None
    #: 最大长度
    maxLen: Optional[int] = None
    #: 最大值
    maximun: Optional[str] = None
    #: 是否小于等于
    minEqual: Optional[bool] = None
    #: 最小值
    minimun: Optional[float] = None
    #: 多层级
    multiLevel: Optional[str] = None
    #: 最大选择的限制
    multipleChoiceLimit: Optional[int] = None
    #: 多层级信息
    multipleLevelInfo: Optional[List[Any]] = None
    #: 是否百分比显示
    percentage: Optional[bool] = None
    #: 选择多层级
    selectMulti: Optional[str] = None
    #: 是否允许多选
    selectedMulti: Optional[bool] = None
    #: 值列表展示类型
    smartListDisplay: Optional[int] = None
    #: 是否千分位显示
    thousandthSymbol: Optional[bool] = None
    #: 是否树形展示
    treeView: Optional[bool] = None
    #: 多个值字段
    valueField: Optional[List[str]] = None
    #: valueKey
    valueKey: Optional[str] = None
    #: 字段类型
    valueType: Optional[int] = None


class CubeAccessStatus(BaseModel):
    #: 状态
    status: Optional[str] = None
    #: 状态描述
    statusDescription: Optional[str] = None


class DataBlockDimension(BaseModel):
    #: 数据块的id
    blockId: Optional[str] = None
    #: 数据块行号
    blockLine: Optional[str] = None
    #: cube的id
    cubeId: Optional[str] = None
    #: dimensionFolderId
    dimensionFolderId: Optional[str] = None
    #: 维度名称
    dimensionName: Optional[str] = None
    #: 维度脚本
    dimensionScript: Optional[str] = None
    #: 行号
    line: Optional[int] = None
    #: seg段名称
    segName: Optional[str] = None


class DataBlockDimDto(BaseModel):
    #: 块的id
    blockId: Optional[str] = None
    #: cube的id
    cubeId: Optional[str] = None
    #: 维度脚本
    dimensionScript: Optional[str] = None
    #: 行号
    line: Optional[int] = None
    #: 成员数组集合
    menmbers: Optional[List[str]] = None
    #: seg段的名称
    segName: Optional[str] = None


class RoleDto(BaseModel):
    #: 昵称
    nickName: Optional[str] = None
    #: 用户id
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None


class RoleDataBlock(BaseModel):
    #: 默认角色组名称
    defaultRolegroupName: Optional[str] = None
    #: 描述信息
    description: Optional[Any] = None
    #: 唯一标识
    key: Optional[str] = None
    #: 编码
    name: Optional[str] = None
    #: 角色id
    roleId: Optional[str] = None
    #: 角色名称
    roleName: Optional[str] = None


class CellDataDTO(BaseModel):
    #: 实际表名
    actualTableName: Optional[str] = None
    #: 字段别名
    alias: Optional[str] = None
    #: 权限
    auth: Optional[str] = None
    #: code值
    codeValue: Optional[str] = None
    #: 列号和别名
    colObj: Optional[Any] = None
    #: 数据表名
    dataTableName: Optional[str] = None
    #: 数据表别名
    datatableAlias: Optional[str] = None
    #: 字段名
    datatableColumn: Optional[str] = None
    #: 单元格数据是否需要编辑标识
    editFlag: Optional[bool] = None
    #: 允许为空
    isAllowEmpty: Optional[int] = None
    #: 字段描述
    label: Optional[str] = None
    #: 数据表行id名称
    lineIdName: Optional[str] = None
    #: 数据表行Id值
    lineIdValue: Optional[str] = None
    #: 行号
    rowNum: Optional[str] = None
    #: 字段值
    value: Optional[str] = None
    #: 字段性质对象
    valueTypeMap: Optional[ValueTypeMapDTO] = None


class CubeDimensionDto(BaseModel):
    #: 字段列是否为主键（true表示作为主键）
    columnPrimary: Optional[bool] = None
    #: 列类型
    columnType: Optional[int] = None
    #: 字段列名
    datatableColumn: Optional[str] = None
    #: 字段关联的维度的路径标识
    dimAbsoluteTag: Optional[bool] = None
    #: 字段关联的维度相对路径
    dimRelationPath: Optional[str] = None
    #: 字段关联的维度所在文件夹Id
    dimensionFolderId: Optional[str] = None
    #: 字段关联的维度的moudelId
    dimensionMoudelId: Optional[str] = None
    #: 字段关联维度名称
    dimensionName: Optional[str] = None
    #: 字段关联的维度的路径
    dimensionPath: Optional[str] = None
    #: dimensionServerName
    dimensionServerName: Optional[str] = None
    #: 列作用
    dimensionUsage: Optional[int] = None
    #: 异常信息
    errorList: Optional[List[ErrorDTO]] = None
    #: 是否关联时间维度字段
    isDate: Optional[bool] = None
    #: isNewDimension
    isNewDimension: Optional[bool] = None
    #: 关联数据表字段是否丢失
    lossCol: Optional[bool] = None
    #: 度量类型,1data2text
    measureType: Optional[int] = None
    #: multilingual
    multilingual: Optional[Any] = None
    #: 是否用做权限字段(仅维度类型的允许用做权限字段)
    roleSeg: Optional[bool] = None
    #: 该维度关联的ud信息
    udInfoDtos: Optional[List[UdInfoDto]] = None


class CubeRelationResponseDTO(BaseModel):
    """Cube Relation Response DTO

    .. admonition:: 引用接口

        - **GET** ``/cube/relation-query`` (Response: 200)
    """
    #: 关联关系结果
    elementDetail: Optional[ElementRelationDTO] = None
    #: 当前cube的路径
    formPath: Optional[str] = None
    #: 当前元素引用者
    related: Optional[str] = None
    #: 当前被关联元素标识
    relationField: Optional[str] = None
    #: 当前引用元素类型
    typeFlag: Optional[str] = None


class CustomizeSplitSqlForPeriod(BaseModel):
    #: forBase
    forBase: Optional[List[SplitSqlWhiteDimensionConfig]] = None
    #: forParent
    forParent: Optional[List[SplitSqlWhiteDimensionConfig]] = None


class PageParamsVo(BaseModel):
    #: ac
    ac: Optional[Any] = None
    #: 清单表pov对象
    listTableQueryParamDTO: Optional[ListTableQueryParamDTO] = None
    #: pov对象
    page: Optional[List[PageVo]] = None
    #: sheet名称
    sheetName: Optional[str] = None


class ReactFormListDTO(BaseModel):
    #: 删除的数据
    delete: Optional[List[List]] = None
    #: 使用视图保存时产生的错误信息
    errorMessage: Optional[List[ReactFormErrorMessage]] = None
    #: 清单表id
    formListId: Optional[str] = None
    #: 插入的数据
    insert: Optional[List[List]] = None
    #: pov
    pov: Optional[Any] = None
    #: 权限数据参数
    reactFormAuthData: Optional[ReactFormAuthData] = None
    #: 展示列信息
    showColumns: Optional[List[Dict]] = None
    #: 更新的数据
    update: Optional[List[CellDataDTO]] = None


class SheetDimensionAttributeDto(BaseModel):
    #: sd-展示维度描述，sb-展示描述名称和描述，sn-展示维度名称，h-隐藏
    sab: Optional[str] = None
    #: 维度属性与维度间隔数
    sp: Optional[int] = None
    #: ud成员描述集合
    uds: Optional[List[SheetUdMemberDto]] = None
    #: ud属性标题描述集合
    uns: Optional[List[SheetUdMemberDto]] = None


class SheetDimensionDto(BaseModel):
    #: autoWrap
    autoWrap: Optional[int] = None
    #: 描述
    d: Optional[str] = None
    #: 字段名
    dc: Optional[str] = None
    #: dimensionKey
    dimensionKey: Optional[str] = None
    #: 单元格缩进格数
    et: Optional[int] = None
    #: 是否是父类 0-是 1-否
    ib: Optional[int] = None
    #: 收缩单元格数，逻辑见详情
    le: Optional[int] = None
    #: 限制收缩宽度
    lee: Optional[int] = None
    #: 合并单元格数
    mc: Optional[int] = None
    #: 倒序合并单元格的数量 ,仅在倒序时使用
    mcr: Optional[int] = None
    #: mergeCell
    mergeCell: Optional[str] = None
    #: 维度名称
    n: Optional[str] = None
    #: sd-展示维度描述，sb-展示描述名称和描述，sn-展示维度名称，h-隐藏
    sab: Optional[str] = None
    #: st
    st: Optional[int] = None
    #: 维度属性展示
    uaList: Optional[List[SheetDimensionAttributeDto]] = None
    #: 维度层级对象
    ul: Optional[SheetDimensionLevelDto] = None
    #: v
    v: Optional[int] = None
    #: virtualMeasure
    virtualMeasure: Optional[bool] = None


class SheetMemberDto(BaseModel):
    #: 行或列上的数据类型
    cellType: Optional[str] = None
    #: dc
    dc: Optional[str] = None
    #: 维度成员信息
    sdd: Optional[List[SheetDimensionDto]] = None
    #: sortKey
    sortKey: Optional[str] = None
    #: 标识是否存在属性维 1-只存在属性维，这个时候前端不能保存
    v: Optional[int] = None


class SheetPovMulitLevelDto(BaseModel):
    #: 层级描述
    des: Optional[str] = None
    #: level
    level: Optional[str] = None
    #: pls
    pls: Optional[List[SheetDimensionDto]] = None


class SheetRowDto(BaseModel):
    #: ab
    ab: Optional[str] = None
    #: autoWrap
    autoWrap: Optional[int] = None
    #: autoWraps
    autoWraps: Optional[List[int]] = None
    #: 列是否置空（指的是列组合，并不是单列）0-否  1-是
    blankCell: Optional[int] = None
    #: 每列或每行维度描述
    ds: Optional[List[Dict]] = None
    #: 该列的第几行是否收缩  0-收缩  1-展开
    f: Optional[List[int]] = None
    #: 该列是否隐藏 （指的是列组合，并非单列）0-否 1-是
    h: Optional[int] = None
    #: hideBlank
    hideBlank: Optional[str] = None
    #: hidenoaccess
    hidenoaccess: Optional[int] = None
    #: hidezero
    hidezero: Optional[int] = None
    #: 该列的成员组合，有多少个就有多少列
    m: Optional[List[SheetMemberDto]] = None
    #: 行/列中最长的字符串(带缩进)
    maxContent: Optional[List[str]] = None
    #: rateLength
    rateLength: Optional[int] = None
    #: ul合并单元格数
    ulMc: Optional[List[List]] = None
    #: virtualMeasure
    virtualMeasure: Optional[bool] = None
    #: width
    width: Optional[str] = None
    #: 列宽度
    widths: Optional[List[str]] = None


class SplitSqlFixedConfigItem(BaseModel):
    #: black
    black: Optional[List[str]] = None
    #: customizePeriodSplitNotUseWhiteOrBlack
    customizePeriodSplitNotUseWhiteOrBlack: Optional[CustomizeSplitSqlForPeriod] = None
    #: white
    white: Optional[List[SplitSqlWhiteDimensionConfig]] = None


class SpreadsheetSingleData(BaseModel):
    """Spreadsheet Single Data

    .. admonition:: 引用接口

        - **POST** ``/react/spreadsheet/save`` (Response: 200)
        - **POST** ``/react/spreadsheet/saveFromZip`` (Response: 200)
    """
    #: 公共成员错误提示
    commonErrorMsgList: Optional[List[SpreadsheetError]] = None
    #: pov公共参数
    commonMember: Optional[Any] = None
    #: 财务folderId
    cubeFolderId: Optional[str] = None
    #: cubeId
    cubeId: Optional[str] = None
    #: 财务模型名称
    cubeName: Optional[str] = None
    #: 财务path
    cubePath: Optional[str] = None
    #: 浮动行参数
    formListDTO: Optional[ReactFormListDTO] = None
    #: 指定当前sheet页批量保存大小，默认100W
    insertBatch: Optional[float] = None
    #: 表格数据
    rowDatas: Optional[List] = None
    #: sheet页id
    sheetId: Optional[str] = None
    #: sheet页类型
    sheetType: Optional[str] = None


class WookbookParamDto(BaseModel):
    """Wookbook Param Dto

    .. admonition:: 引用接口

        - **POST** ``/spreadsheets/query-workbook-data``
    """
    #: language
    language: Optional[str] = None
    #: pov参数
    pageList: Optional[List[PageParamsVo]] = None
    #: sheet页name
    sheetName: Optional[str] = None
    #: showSheet
    showSheet: Optional[str] = None
    #: 电子表格路径id
    wbFolderId: Optional[str] = None
    #: 电子表格名称
    wbName: str
    #: 电子表格路径
    wbPath: Optional[str] = None


class DataBlockInfo(BaseModel):
    #: 访问控制单元
    accessControlUnit: Optional[str] = None
    #: blockDimensionList
    blockDimensionList: Optional[List[DataBlockDimension]] = None
    #: 数据块类型
    blockType: Optional[int] = None
    #: cube的id
    cubeId: Optional[str] = None
    #: errorList
    errorList: Optional[List[ErrorDTO]] = None
    #: id
    id: Optional[str] = None
    #: 介绍
    instruction: Optional[str] = None
    #: 数据块的名称
    name: Optional[str] = None
    #: 使用Period维度
    usePeriod: Optional[int] = None
    #: 使用Scenario维度
    useScenario: Optional[int] = None
    #: 使用Version维度
    useVersion: Optional[int] = None
    #: 使用Year维度
    useYear: Optional[int] = None


class DataBlockInfoDto(BaseModel):
    #: 块的id
    blockId: Optional[str] = None
    #: 块的类型
    blockType: Optional[int] = None
    #: cube的id
    cubeId: Optional[str] = None
    #: 功能编码
    functionCode: Optional[List[str]] = None
    #: 介绍
    instruction: Optional[str] = None
    #: list
    list: Optional[List[DataBlockDimDto]] = None
    #: 名称
    name: Optional[str] = None


class AccountCalendarDto(BaseModel):
    #: defaultPeriod
    defaultPeriod: Optional[str] = None
    #: defaultYear
    defaultYear: Optional[str] = None
    #: name
    name: Optional[str] = None
    #: period
    period: Optional[List[SheetDimensionDto]] = None
    #: year
    year: Optional[List[SheetDimensionDto]] = None


class CubeQueryForOutVo(BaseModel):
    """Cube Query For Out Vo

    .. admonition:: 引用接口

        - **POST** ``/cube-data/query``
    """
    #: 扩展需要汇总的列作用
    aggregationDimEnum: Optional[List[str]] = None
    #: 公共维度表达式
    commonScript: Optional[str] = None
    #: 财务模型名称
    cubeName: str
    #: 财务模型路径id
    folderId: Optional[str] = None
    #: 是否需要返回权限信息
    needAccess: Optional[bool] = None
    #: 无数据依然返回权限
    needAccessWithNoData: Optional[bool] = None
    #: 页号
    pageNo: Optional[int] = None
    #: 每页条数
    pageSize: Optional[int] = None
    #: 财务模型路径
    path: Optional[str] = None
    #: 查询优化器配置
    queryOptimizeConfig: Optional[QueryOptimizeConfigVO] = None
    #: 维度表达式
    script: str
    #: 并行优化器配置
    splitSqlConfig: Optional[SplitSqlFixedConfigItem] = None


class PcParams(BaseModel):
    """Pc Params

    .. admonition:: 引用接口

        - **POST** ``/block/pc-init``
        - **POST** ``/block/pc-status``
    """
    #: 审批单元集合
    blockInfoList: Optional[List[DataBlockInfo]] = None
    #: 审批单元编码集合
    blockList: Optional[List[str]] = None
    #: 审批单元名称
    blockName: Optional[str] = None
    #: 财务模型folderId
    cubeFolderId: Optional[str] = None
    #: 财务模型开关
    cubeName: Optional[str] = None
    #: 财务模型Path
    cubePath: Optional[str] = None
    #: 审批控制字段(key:字段名，value:维度表达式)
    datablockMap: Optional[Any] = None
    #: 数据表类型
    datatableElementType: Optional[str] = None
    #: extParam
    extParam: Optional[str] = None
    #: insertBatch
    insertBatch: Optional[float] = None
    #: 审批动作
    operationName: Optional[str] = None
    #: 流程控制字段(key:字段名，value:维度表达式)
    processMap: Optional[Any] = None
    #: 审批状态
    status: Optional[str] = None


class ReactSpreadsheetSaveForm(BaseModel):
    """React Spreadsheet Save Form

    .. admonition:: 引用接口

        - **POST** ``/react/spreadsheet/save``
    """
    #: 日志开关
    dataAuditSwitch: Optional[bool] = None
    #: 数据来源icon
    entryMode: int
    #: 数据来源
    entryObject: str
    #: needCheck
    needCheck: Optional[bool] = None
    #: 多sheet
    sheetDatas: Optional[List[SpreadsheetSingleData]] = None
    #: 校验维度成员大小写
    validateDimensionMember: Optional[bool] = None
    #: 电子表格folderid
    wbFolderId: Optional[str] = None
    #: 电子表格名称
    wbName: Optional[str] = None
    #: 电子表格path
    wbPath: Optional[str] = None
    #: 是否回调
    callback: Optional[bool] = None
    #: 数据保存权鉴模式
    saveDataAuthMode: Optional[int] = None


class SheetColumnDto(BaseModel):
    #: ab
    ab: Optional[str] = None
    #: autoWrap
    autoWrap: Optional[int] = None
    #: 列是否置空（指的是列组合，并不是单列）0-否  1-是
    blankCell: Optional[int] = None
    #: 该列的第几行是否收缩  0-收缩  1-展开
    f: Optional[List[int]] = None
    #: 该列是否隐藏 （指的是列组合，并非单列）0-否 1-是
    h: Optional[int] = None
    #: hideBlank
    hideBlank: Optional[str] = None
    #: hidenoaccess
    hidenoaccess: Optional[int] = None
    #: hidezero
    hidezero: Optional[int] = None
    #: 该列的成员组合，有多少个就有多少列
    m: Optional[List[SheetMemberDto]] = None
    #: 行/列中最长的字符串(带缩进)
    maxContent: Optional[List[str]] = None
    #: rateLength
    rateLength: Optional[int] = None
    #: ul合并单元格数
    ulMc: Optional[List[List]] = None
    #: virtualMeasure
    virtualMeasure: Optional[bool] = None
    #: width
    width: Optional[str] = None


class SheetPageDto(BaseModel):
    #: 是否为会计日历，1-是会计日历
    acFlag: Optional[int] = None
    #: 属性维-存放后面维度字段
    adn: Optional[str] = None
    #: dc
    dc: Optional[str] = None
    #: 默认维度成员  名称
    dfd: Optional[str] = None
    #: dg
    dg: Optional[int] = None
    #: 维度表达式
    dimensionExpress: Optional[str] = None
    #: 维度路径Id
    dimensionFolderId: Optional[str] = None
    #: dimension name
    dn: Optional[str] = None
    #: dimension type
    dt: Optional[str] = None
    #: elementDetail
    elementDetailDto: Optional[ElementDetailDto] = None
    #: 结束会计日历
    endAc: Optional[AccountCalendarDto] = None
    #: g
    g: Optional[int] = None
    #: 1-前端允许多选  0-不允许
    hc: Optional[int] = None
    #: 限制多选个数
    hcN: Optional[int] = None
    #: 保存数据时，是否需要page  1-不需要
    is_: int = Field(None, alias='is')
    #: 多层级控制，表达式涵盖的可选范围
    leCon: Optional[str] = None
    #: 多层级时，前端用该对象渲染维度信息
    levels: Optional[List[SheetPovMulitLevelDto]] = None
    #: page部分维度成员集合
    pls: Optional[List[SheetDimensionDto]] = None
    #: rateLength
    rateLength: Optional[int] = None
    #: role_seg
    role_seg: Optional[bool] = None
    #: rsDimension
    rsDimension: Optional[str] = None
    #: rsFolderId
    rsFolderId: Optional[str] = None
    #: rsList
    rsList: Optional[List[Dict]] = None
    #: rsMapping
    rsMapping: Optional[str] = None
    #: rsName
    rsName: Optional[str] = None
    #: 展示属性
    sb: Optional[str] = None
    #: pov 存在树形结构时，维度表达式
    sc: Optional[str] = None
    #: 属性name
    sn: Optional[str] = None
    #: 起始会计日历
    startAc: Optional[AccountCalendarDto] = None
    #: text描述
    text: Optional[str] = None
    #: text多语言
    textLanguage: Optional[str] = None
    #: 树形结构  0-否  1-是
    tr: Optional[int] = None
    #: 判断字段是否汇总
    ug: Optional[int] = None
    #: v
    v: Optional[int] = None
    #: virtualMeasure
    virtualMeasure: Optional[bool] = None


class CubeAccessControlViewReact(BaseModel):
    #: add
    add: Optional[List['CubeAccessCtrlDto']] = None
    #: delete
    delete: Optional[List[str]] = None
    #: edit
    edit: Optional[List['CubeAccessCtrlDto']] = None


class DatatableColumnDto(BaseModel):
    #: 字段默认值
    defaultValue: Optional[str] = None
    #: 列描述
    description: Optional[str] = None
    #: 字段长度
    length: Optional[str] = None
    #: 列名
    name: Optional[str] = None
    #: 列旧数据
    oldInfo: Optional['DatatableColumnDto'] = None
    #: 操作类型
    operation: Optional[str] = None
    #: 排序字段
    sort: Optional[int] = None
    #: 列类型
    type: Optional[str] = None
    #: 是否为空
    whetherEmpty: Optional[bool] = None
    #: 是否为自增
    whetherIncrement: Optional[bool] = None
    #: 是否为唯一键
    whetherOnly: Optional[bool] = None
    #: 是否为主键
    whetherPrimary: Optional[bool] = None
    #: 是否为系统字段
    whetherSystemColumn: Optional[bool] = None


class DatatableInfoDto(BaseModel):
    #: 实际表名
    actualTableName: Optional[str] = None
    #: 数据表名称的多语言
    description: Optional[Any] = None
    #: 数据表元素类型
    elementType: Optional[str] = None
    #: engineType
    engineType: Optional[int] = None
    #: 所在文件夹id
    folderId: Optional[str] = None
    #: 数据表Id
    id: Optional[str] = None
    #: moduleId
    moduleId: Optional[str] = None
    #: 数据表名称
    name: Optional[str] = None
    #: 数据表旧数据
    oldInfo: Optional['DatatableInfoDto'] = None
    #: 数据表路径
    path: Optional[str] = None


class FinancialModelDto(BaseModel):
    """Financial Model Dto

    .. admonition:: 引用接口

        - **GET** ``/cube/data`` (Response: 200)
        - **GET** ``/cube/right/query`` (Response: 200)
        - **POST** ``/cube/save``
        - **POST** ``/cube/save`` (Response: 200)
    """
    #: 财务数据模型主数据
    cube: 'FinancialDataDto'
    #: 财务数据模型列数据
    cubeDimensionList: List[CubeDimensionDto]
    #: 关联数据表主数据
    datatable: DatatableInfoDto
    #: 关联数据表列数据
    datatableCols: List[DatatableColumnDto]
    #: 关联维度数据
    dimensions: List[Any]
    #: 校验结果，如果为true则出现异常
    errorFlag: Optional[bool] = None
    #: 元素权限
    permission: Optional[int] = None
    #: 保存类型0为只校验,1为保存
    saveType: Optional[int] = None


class GroupRoleDatablockReactView(BaseModel):
    #: add
    add: Optional[List['RoleSetDataBlock']] = None
    #: delete
    delete: Optional[List[str]] = None
    #: edit
    edit: Optional[List['RoleSetDataBlock']] = None


class SheetDto(BaseModel):
    """Sheet Dto

    .. admonition:: 引用接口

        - **POST** ``/dynamic-report/query`` (Response: 200)
    """
    #: adaptive
    adaptive: Optional[List[str]] = None
    #: 列头显示控制对象
    colHeaderList: Optional[List['HeaderObject']] = None
    #: 列维度0正序1倒序
    colShowOrder: Optional[int] = None
    #: 电子表格的列部分
    columnList: Optional[List[SheetColumnDto]] = None
    #: 财务模型路径Id
    cubeFolderId: Optional[str] = None
    #: 财务模型ID
    cubeId: Optional[str] = None
    #: 财务模型名称
    cubeName: Optional[str] = None
    #: cubeType
    cubeType: Optional[int] = None
    #: 数据
    dataList: Optional[List[List]] = None
    #: 区分0查询开关
    distinguishZeroSwitch: Optional[bool] = None
    #: 数据表的key
    dtn: Optional[str] = None
    #: 冻结起始列
    fc: Optional[int] = None
    #: 固定顺序join优先级维度名称
    fixedJoinPriorityDimensionNames: Optional[List[str]] = None
    #: 固定join优先级开关
    fixedJoinPrioritySwitch: Optional[bool] = None
    #: 浮动行列表返回类型
    formListDatas: Optional[Any] = None
    #: 冻结起始行
    fr: Optional[int] = None
    #: 开表查询-join中in对应base增加到事实表where后面，配置的维度名称
    joinInBaseToFactDimensionNames: Optional[List[str]] = None
    #: 开表查询-join中in对应base增加到事实表where后面，配置开关
    joinInBaseToFactSwitch: Optional[bool] = None
    #: js文件路径
    jsfile: Optional[str] = None
    #: json文件路径
    jsonfile: Optional[str] = None
    #: 开表无数据的原因
    noDataReason: Optional[str] = None
    #: 精度1，0.1，0.01，0.001，0.0001，0.00001，0.000001
    p: Optional[str] = None
    #: 0-禁止调整小数位，1允许
    pa: Optional[int] = None
    #: pov部分
    pageList: Optional[List[SheetPageDto]] = None
    #: 刷新后触发自定义js方法
    rar: Optional[str] = None
    #: 保存前触发自定义js方法
    rbs: Optional[str] = None
    #: 初次加载触发自定义js方法
    rol: Optional[str] = None
    #: 行头显示控制对象
    rowHeaderList: Optional[List['HeaderObject']] = None
    #: 电子表格行部分
    rowList: Optional[List[SheetRowDto]] = None
    #: 行维度0正序1倒序
    rowShowOrder: Optional[int] = None
    #: 起始列
    sc: Optional[int] = None
    #: sheet描述
    sd: Optional[str] = None
    #: sheet name language
    sheetNameLanguage: Optional[str] = None
    #: sheet id
    si: Optional[str] = None
    #: sheet name 开表取值规则：优先取sheetNameLanguage，为空则取sheetName的值
    sn: Optional[str] = None
    #: sheet name 多语言辅助字段，备份原sn(辅助前端用)
    snl: Optional[str] = None
    #: 起始行
    sr: Optional[int] = None
    #: 静态表返回
    staticCells: Optional[List[Dict]] = None
    #: sheet页类型 1-动态  2-静态  3-浮动行表
    t: Optional[int] = None
    #: 0-禁止显示千分位分隔符 1-允许
    ts: Optional[int] = None
    #: 0-禁止调整千分位分隔符，1-允许
    tsa: Optional[int] = None
    #: 0-禁止调整单位 1-允许
    ua: Optional[int] = None
    #: 单位 1，1000，10000，1000000，1000000000
    unit: Optional[str] = None
    #: view设置到尾部开关
    viewEndSwitch: Optional[bool] = None
    #: workType
    workType: Optional[str] = None


class WorkbookInfoDto(BaseModel):
    """Workboot Dto

    .. admonition:: 引用接口

        - **POST** ``/spreadsheets/query-workbook-data`` (Response: 200)
    """
    #: cubeInfoDataCache
    cubeInfoDataCache: Optional[Any] = None
    #: 电子表格描述
    description: Optional[Any] = None
    #: 文件缓存时间
    fileCacheTime: Optional[int] = None
    #: 电子表格说明
    instruction: Optional[Any] = None
    #: 电子表格名称
    name: Optional[str] = None
    #: 电子表格元素权限
    permission: Optional[int] = None
    #: sheet页
    sheetList: Optional[List[SheetDto]] = None
    #: 默认展示sheet页id
    showSheet: Optional[str] = None


class SheetPovChildrenDto(BaseModel):
    #: children
    children: Optional[List['SheetPovChildrenDto']] = None
    #: d
    d: Optional[str] = None
    #: default_selected
    default_selected: Optional[bool] = None
    #: ia
    ia: Optional[int] = None
    #: ib
    ib: Optional[bool] = None
    #: n
    n: Optional[str] = None
    #: open
    open: Optional[bool] = None
    #: selected
    selected: Optional[bool] = None
    #: st
    st: Optional[int] = None


class SheetPovTreeDto(BaseModel):
    """Sheet Pov Tree Dto

    .. admonition:: 引用接口

        - **GET** ``/spreadsheets/query-pov-dimension-tree`` (Response: 200)
    """
    #: tree
    tree: Optional[List[SheetPovChildrenDto]] = None


class CubeAccessCtrlDto(BaseModel):
    #: 访问权限
    accessRight: Optional[int] = None
    #: 角色是否全选的标识位
    allRoles: Optional[bool] = None
    #: cube的id
    cubeId: Optional[str] = None
    #: 临时赋值用的多语言描述信息
    des: Optional[str] = None
    #: id
    id: Optional[str] = None
    #: 行号
    line: Optional[int] = None
    #: 角色，多个用逗号隔开
    role: Optional[str] = None
    #: 角色组，多个用逗号隔开
    roleGroup: Optional[str] = None
    #: roleGroupList
    roleGroupList: Optional[List['RoleSetDataBlock']] = None
    #: roleList
    roleList: Optional[List[RoleDataBlock]] = None
    #: 状态
    status: Optional[str] = None
    #: statusList
    statusList: Optional[List[CubeAccessStatus]] = None


class HeaderObject(BaseModel):
    #: 描述
    d: Optional[str] = None
    #: 显示方式
    hide: Optional[str] = None
    #: 名称
    n: Optional[str] = None
    #: 标题
    title: Optional[str] = None
    #: ua属性显示方式
    uaHeaderList: Optional[List['HeaderObject']] = None
    #: 是否虚拟度量
    virtualMeasure: Optional[bool] = None


class RoleSetDataBlock(BaseModel):
    #: 角色是否全选的标识位
    allRoles: Optional[bool] = None
    #: block的Id
    blockId: Optional[str] = None
    #: block的名称
    blockName: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建者
    creater: Optional[str] = None
    #: cube的Id
    cubeId: Optional[str] = None
    #: id
    id: Optional[str] = None
    #: 修改者
    modifier: Optional[str] = None
    #: 修改时间
    modifyTime: Optional[str] = None
    #: 审批操作
    operationList: Optional[List[str]] = None
    #: 角色，多个用逗号隔开
    role: Optional[str] = None
    #: 角色组，多个用逗号隔开
    roleGroup: Optional[str] = None
    #: 角色组角色组数据块
    roleGroupList: Optional[List['RoleSetDataBlock']] = None
    #: 角色组角色数据块
    roleList: Optional[List[RoleDataBlock]] = None
    #: 排序信息
    sort: Optional[int] = None
    #: 用户组id集合
    userGroupIdIntList: Optional[List[str]] = None
    #: 用户组id
    userGroupInfoId: Optional[str] = None
    #: 用户组列表
    userGroupList: Optional[List[GroupRoleDataBlockUserGroup]] = None
    #: 用户组id集合
    userIdIntList: Optional[List[str]] = None
    #: 用户id
    userInfoId: Optional[str] = None
    #: 用户列表
    userList: Optional[List[RoleDto]] = None


class FinancialDataDto(BaseModel):
    """财务数据模型实体类

    .. admonition:: 引用接口

        - **GET** ``/cube/find-cube-data`` (Response: 200)
        - **POST** ``/cube/right`` (Response: 200)
    """
    #: 科目表达式,cube类型为3时,使用该属性
    accountMemberScript: Optional[str] = None
    #: 关联流程表路径标识
    airAbsoluteTag: Optional[bool] = None
    #: 关联流程表的相对路径
    airRelativePath: Optional[str] = None
    #: 自动汇总开关
    autoCalculation: Optional[bool] = None
    #: 资产负债类科目保存
    balanceAccountSave: Optional[int] = None
    #: 财务模型角色--审批单元
    blockInfoList: Optional[List[DataBlockInfo]] = None
    #: 关联cube权限表路径标识
    cacAbsoluteTag: Optional[bool] = None
    #: 关联cube权限表的相对路径
    cacRelativePath: Optional[str] = None
    #: checkCol
    checkCol: Optional[bool] = None
    #: 清空null数据开关
    clearNullSwitch: Optional[bool] = None
    #: 清空0数据开关
    clearZeroSwitch: Optional[bool] = None
    #: 关联备注表的路径标识
    comAbsoluteTag: Optional[bool] = None
    #: 关联备注表的相对路径
    comRelativePath: Optional[str] = None
    #: 备注表的实际表名
    commentActualTableName: Optional[str] = None
    #: 读写权限--权限保存前端传参
    cubeAccessControl: Optional[CubeAccessControlViewReact] = None
    #: 读写权限--权限查询返回给前端用
    cubeAccessControlList: Optional[List[CubeAccessCtrlDto]] = None
    #: 财务模型角色--读写权限 总条数
    cubeAccessControlTotal: Optional[int] = None
    #: 汇总模式,1属性汇总模式2全汇总模式
    cubeMode: Optional[int] = None
    #: cube的日志/备注/附件表引用关系
    cubeRelationInfo: Optional[List[CubeRelationResponseDTO]] = None
    #: cube类型,3科目作为度量4期间作为度量5不作为度量
    cubeType: Optional[int] = None
    #: 数据表类型（0-MySQL，1-CK）
    dataSync: Optional[int] = None
    #: datablockInfo
    datablockInfo: Optional[List[DataBlockInfoDto]] = None
    #: 关联数据表的相对路径
    datatableAbsoluteTag: Optional[bool] = None
    #: 数据表元素类型
    datatableElementType: Optional[str] = None
    #: 关联的数据表所在文件夹Id
    datatableFolderId: Optional[str] = None
    #: 关联的数据表的ModuleId
    datatableModuleId: Optional[str] = None
    #: 财务数据模型关联数据表名称
    datatableName: Optional[str] = None
    #: 关联数据表的路径
    datatablePath: Optional[str] = None
    #: 关联数据表的相对路径
    datatableRelativePath: Optional[str] = None
    #: cube选用的数据表组件的服务名
    datatableServerName: Optional[str] = None
    #: 关联流程表路径标识
    dbcAbsoluteTag: Optional[bool] = None
    #: 关联流程表的相对路径
    dbcRelativePath: Optional[str] = None
    #: 名称的多语言描述对象
    description: Optional[Any] = None
    #: 关联维度路径标识
    dimAbsoluteTag: Optional[bool] = None
    #: 关联维度的相对路径
    dimRelativePath: Optional[str] = None
    #: 关联维度的所在的文件夹Id.cubeType为3时Account维度所在文件夹Id;4时Period维度所在文件夹Id
    dimensionFolderId: Optional[str] = None
    #: 关联维度的module
    dimensionModuleId: Optional[str] = None
    #: 关联维度的路径
    dimensionPath: Optional[str] = None
    #: 维度组件的服务名
    dimensionServerName: Optional[str] = None
    #: 区分0查询开关
    distinguishZeroSwitch: Optional[bool] = None
    #: 关联角色方案路径标识
    drsAbsoluteTag: Optional[bool] = None
    #: 元素错误标识
    elWarning: Optional[int] = None
    #: 异常信息
    errorList: Optional[List[ErrorDTO]] = None
    #: 异常标记
    errorTag: Optional[bool] = None
    #: 关联附件表的路径标识
    fileAbsoluteTag: Optional[bool] = None
    #: 附件表的实际表名
    fileActualTableName: Optional[str] = None
    #: 关联附件表的相对路径
    fileRelativePath: Optional[str] = None
    #: 固定顺序join优先级维度名称(外部取数专用，开表用sheet配置)
    fixedJoinPriorityDimensionNames: Optional[List[str]] = None
    #: 固定join优先级开关(外部取数专用，开表用sheet配置)
    fixedJoinPrioritySwitch: Optional[bool] = None
    #: 损益类科目保存
    flowAccountSave: Optional[int] = None
    #: 财务数据模型所在文件夹Id
    folderId: Optional[str] = None
    #: 审批单元角色--权限查询前端传参
    groupRoleDatablock: Optional[GroupRoleDatablockReactView] = None
    #: 审批单元角色--权限查询返回给前端
    groupRoleDatablockList: Optional[List[RoleSetDataBlock]] = None
    #: groupRoleDatablockReactView
    groupRoleDatablockReactView: Optional[GroupRoleDatablockReactView] = None
    #: 财务模型角色--审批单元角色 总条数
    groupRoleDatablockTotal: Optional[int] = None
    #: 财务数据模型id
    id: Optional[str] = None
    #: 开表查询-join中in对应base增加到事实表where后面，配置的维度名称(外部取数专用，开表用sheet配置)
    joinInBaseToFactDimensionNames: Optional[List[str]] = None
    #: 开表查询-join中in对应base增加到事实表where后面，配置开关(外部取数专用，开表用sheet配置)
    joinInBaseToFactSwitch: Optional[bool] = None
    #: join优先级维度名称集合
    joinPriorityDimensionNames: Optional[List[str]] = None
    #: join优先级开关
    joinPrioritySwitch: Optional[bool] = None
    #: 关联日志表的路径标识
    logAbsoluteTag: Optional[bool] = None
    #: 日志表的实际表名
    logActualTableName: Optional[str] = None
    #: 关联日志表的相对路径
    logRelativePath: Optional[str] = None
    #: 最小期间层级,cube类型为4时,使用该属性
    minPeriodLevel: Optional[str] = None
    #: 财务数据模型moduleId
    moduleId: Optional[str] = None
    #: 财务数据模型名称
    name: Optional[str] = None
    #: 当前cube存在通用period父成员时是否拆父
    notSplitCommonPeriodParentForThisCube: Optional[bool] = None
    #: 是否不对当前cube拆分sql
    notSplitSqlForThisCube: Optional[bool] = None
    #: 财务数据模型路径
    path: Optional[str] = None
    #: 关联审批流路径标识
    pcAbsoluteTag: Optional[bool] = None
    #: 流程控制元素信息--前端传参
    pcElementDetail: Optional[CubeRightElementDTO] = None
    #: 关联审批流的相对路径
    pcRelativePath: Optional[str] = None
    #: 元素权限
    permission: Optional[int] = None
    #: 关联审批表路径标识
    processControlAbsoluteTag: Optional[bool] = None
    #: 关联审批表的相对路径
    processControlRelativePath: Optional[str] = None
    #: 角色方案元素信息--前端传参
    rsElementDetail: Optional[CubeRightElementDTO] = None
    #: 关联角色方案的相对路径
    rsRelativePath: Optional[str] = None
    #: 财务数据模型包名
    serverName: Optional[str] = None
    #: view设置到尾部开关
    viewEndSwitch: Optional[bool] = None
    #: 财务数据模型关联数据表真实表名
    actualTableName: Optional[str] = None
    #: 财务数据模型列数据
    cubeDimensionList: Optional[List[CubeDimensionDto]] = None
    #: 关联数据表主数据
    datatable: Optional[DatatableInfoDto] = None


CubeAccessControlViewReact.update_forward_refs()
DatatableColumnDto.update_forward_refs()
DatatableInfoDto.update_forward_refs()
FinancialModelDto.update_forward_refs()
GroupRoleDatablockReactView.update_forward_refs()
SheetDto.update_forward_refs()
SheetPovChildrenDto.update_forward_refs()
CubeAccessCtrlDto.update_forward_refs()
HeaderObject.update_forward_refs()
RoleSetDataBlock.update_forward_refs()
