"""
Models used by /journal-template-server1-0

generated by model_code_gen.py
  - **filename** : ``journal_template.py``
  - **json timestamp** : ``2022-09-23 15:10:19``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'BatchColumn',
    'BatchDefineDTO',
    'DataTableCustomSqlResultDTO',
    'DimensionRoleInfo',
    'ErrorInfo',
    'ExpressionParserDTO',
    'GroupColumnInfo',
    'JournalAggregateResultDTO',
    'JournalBodyData',
    'JournalColumnAuthorityInfo',
    'JournalDataBatchDel',
    'JournalDataFilterParam',
    'JournalMainData',
    'JournalTemplateQuery',
    'NumberPostingInfo',
    'OrderColumnInfo',
    'ProcessInfo',
    'ElementInfo',
    'MemCubeModelDto',
    'JTRelationColumn',
    'JournalTemplateFieldViewFeature',
    'PostingParam',
    'AdvancedSettingsDTO',
    'ApprovalProcessColumn',
    'ApprovalProcessInfo',
    'CollectColumnInfo',
    'JournalColumnLogicInfo',
    'JournalData',
    'JournalListColumnInfo',
    'JournalOrderDataBatchQuery',
    'ElementRelationInfo',
    'JTPostingRelColumn',
    'PostingInfoDto',
    'PostingParamQueryDto',
    'PostingRequestDto',
    'JournalBatchDataDTO',
    'ButtonInfoDealParamDTO',
    'JournalButtonInfoDTO',
    'JournalColumnDataTableInfo',
    'JournalColumnInfo',
    'JournalDataTableBaseInfo',
    'JournalTemplateAreaInfo',
    'JournalTemplateBaseInfo',
    'JournalTemplateDTO',
    'JournalTemplateDetail'
]


class BatchColumn(BaseModel):
    #: 字段编码
    code: Optional[str] = None
    #: 字段名
    name: Optional[str] = None
    #: 显示方式(0成员名称,1描述,2成员加描述默认为2)
    dimensionDisplay: Optional[int] = None


class BatchDefineDTO(BaseModel):
    #: 批量字段列
    columns: Optional[List[str]] = None
    #: 批量单据名称
    name: Optional[str] = None


class DataTableCustomSqlResultDTO(BaseModel):
    """Data Table Custom Sql Result DTO

    .. admonition:: 引用接口

        - **POST** ``/journal/delete-by-filter`` (Response: 200)
        - **POST** ``/journal/get-batch-data`` (Response: 200)
        - **POST** ``/journal/get-total-data`` (Response: 200)
        - **POST** ``/query_sum_data`` (Response: 200)
    """
    #: 查询结果计数
    modifyCounts: Optional[int] = None
    #: sql类型:insert,update,delete,select
    operation: Optional[str] = None
    #: 查询结果集
    selectResult: Optional[List[Dict]] = None


class DimensionRoleInfo(BaseModel):
    #: 权限方案名称
    rsName: str
    #: 权限方案文件夹id
    roleFolderId: str
    #: 权限方案文件夹id
    rolePath: str
    #: 角色
    role: List[str]
    #: 角色组
    rolegroup: List[str]
    #: 权限方案中所选维度的行号
    rsMapping: int


class ErrorInfo(BaseModel):
    #: 提示key
    tipKey: str
    #: 提示value
    tipValue: str


class ExpressionParserDTO(BaseModel):
    """Expression Parser DTO

    .. admonition:: 引用接口

        - **POST** ``/check-formula-definition``
        - **POST** ``/check-formula-definition`` (Response: 200)
    """
    #: 错误标志
    errorFlag: Optional[bool] = None
    #: 公式
    formula: str
    #: 校验成功后的公式
    formulaCheck: Optional[str] = None
    #: 公式名称
    formulaName: str
    #: 公式成员
    members: Optional[List[str]] = None
    #: 错误信息
    message: Optional[str] = None
    #: 替换符
    replaceStr: Optional[List[str]] = None


class GroupColumnInfo(BaseModel):
    #: 字段编码
    columnCode: Optional[str] = None
    #: 是否有小计行
    isHaveSubTotal: Optional[bool] = None
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]] = None
    #: 错误标识
    errorTag: Optional[bool] = None


class JournalAggregateResultDTO(BaseModel):
    """Journal Aggregate Result DTO

    .. admonition:: 引用接口

        - **POST** ``/journal/get-aggregate-data`` (Response: 200)
    """
    #: 分组字段
    groupColumn: Optional[List[str]] = None
    #: 查询结果
    result: Optional[List[Dict]] = None


class JournalBodyData(BaseModel):
    #: 子表真实表名
    bodyActualTableName: str
    #: 增量数据
    data: List[Dict]
    #: 删除数据
    delEntryCode: List[str]


class JournalColumnAuthorityInfo(BaseModel):
    #: 是否必填
    required: Optional[bool] = None
    #: 展示类型(0:不显示,1显示到列表,2显示到页面,3显示到列表及页面)
    showInList: Optional[int] = None


class JournalDataBatchDel(BaseModel):
    """Journal Data Batch Del

    .. admonition:: 引用接口

        - **POST** ``/journal/delete-by-filter``
    """
    #: 文件夹ID
    folderId: Optional[str] = None
    #: 模板编码
    templateCode: str
    #: 路径
    path: Optional[str] = None
    #: 成员编码及名称
    memberInfo: Optional[Any] = None


class JournalDataFilterParam(BaseModel):
    #: 字段编码
    columnCode: str
    #: 筛选方式(like)
    filterType: Optional[str] = None
    #: 筛选值
    filterValue: Optional[str] = None
    #: 字段类型(维度为8,值列表为3)
    fieldType: Optional[int] = None
    #: 主子表类型(主表字段为1,子表字段为2)
    tableType: int


class JournalMainData(BaseModel):
    #: 日记账编码
    journalCode: str
    #: 字段编码(日记账头主键字段编码)
    columnCode: str
    #: 主表真实表名
    mainActualTableName: str
    #: 数据
    data: Any


class JournalTemplateQuery(BaseModel):
    """Journal Template Query

    .. admonition:: 引用接口

        - **POST** ``/journal-list/defaultQuery``
        - **POST** ``/journal-template/advanced-setting-query``
        - **POST** ``/journal-template/baseInfo/batchQuery``
        - **POST** ``/journal-template/query``
        - **POST** ``/journal-template/query-detail``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id(文件夹id/path必传一个)
    folderId: Optional[str] = None
    #: 元素路径(文件夹id/path必传一个)
    path: Optional[str] = None


class NumberPostingInfo(BaseModel):
    #: 数值类过账字段编码
    code: Optional[str] = None
    #: 映射配置信息表达式
    mappingExpression: Optional[str] = None
    #: 映射配置信息
    mappingInfo: Optional[Any] = None
    #: 数值类过账字段名称
    name: Optional[str] = None


class OrderColumnInfo(BaseModel):
    #: 字段编码
    columnCode: Optional[str] = None
    #: 顺序
    orderType: Optional[str] = None
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]] = None
    #: 错误标识
    errorTag: Optional[bool] = None


class ProcessInfo(BaseModel):
    #: 公式
    formula: Optional[ExpressionParserDTO] = None
    #: 汇总方式 1:计数 2:计算值
    summaryWay: Optional[str] = None
    #: 小计行
    group: Optional[bool] = None


class ElementInfo(BaseModel):
    """元素信息

    .. admonition:: 引用接口

        - **POST** ``/callback/delete-front``
    """
    #: 名称
    elementName: Optional[str] = None
    #: 类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class MemCubeModelDto(BaseModel):
    #: 自动进行档期数和累计数的汇总计算，false：关；true：开；
    autoCalculation: Optional[bool] = None
    #: 内存财务数据模型编码
    code: str
    #: 多语言信息
    description: Optional[Any] = None
    #: 类型
    elementType: Optional[str] = None
    #: 异常信息
    errorList: Optional[List[ErrorInfo]] = None
    #: 异常标记
    errorTag: Optional[bool] = None
    #: 内存财务数据模型所在文件夹Id
    folderId: str
    #: 内存财务数据模型路径
    path: Optional[str] = None
    #: 元素引用关系唯一key
    relationKey: Optional[str] = None
    #: 权限方案文件夹ID
    rsFolderId: Optional[str] = None
    #: 权限方案名
    rsName: Optional[str] = None
    #: 权限方案类型
    rsType: Optional[str] = None
    #: 内存财务数据模型服务名
    serverName: Optional[str] = None


class JTRelationColumn(BaseModel):
    #: 字段编码
    code: Optional[str] = None
    #: 字段表类型
    type: Optional[str] = None
    #: 多语言描述
    description: Any
    #: 不做后端业务逻辑，仅前端展示逻辑
    showName: Optional[str] = None


class JournalTemplateFieldViewFeature(BaseModel):
    #: 显示树形结构(默认true)
    treeView: Optional[bool] = None
    #: 是否隐藏
    whetherHide: Optional[bool] = None
    #: 列宽(为空为自适应)
    columnWidth: Optional[int] = None
    #: 维度显示方式(0成员名称,1描述,2成员加描述默认为2)
    dimensionDisplay: Optional[int] = None
    #: 用户显示方式(email,nickName,userName)
    valueKey: Optional[str] = None
    #: 值列表显示方式(0成员名称,1描述,2成员加描述,默认为2)
    smartListDisplay: Optional[int] = None


class PostingParam(BaseModel):
    #: 参数集
    params: Optional[Any] = None


class AdvancedSettingsDTO(BaseModel):
    """Advanced Settings DTO

    .. admonition:: 引用接口

        - **POST** ``/journal-template/advanced-setting-query`` (Response: 200)
        - **POST** ``/journal-template/advanced-setting-save``
    """
    #: 批量定义可选字段
    allBatchColumns: Optional[List[BatchColumn]] = None
    #: 批量定义
    batchDefine: Optional[List[BatchDefineDTO]] = None
    #: 是否开启批量
    turnOnBatch: bool
    #: 元素名称
    elementName: str
    #: 文件夹id(文件夹id/path必传一个)
    folderId: Optional[str] = None
    #: 元素路径(文件夹id/path必传一个)
    path: Optional[str] = None


class ApprovalProcessColumn(BaseModel):
    #: 字段编码
    columnCode: str
    #: 多语言描述
    description: Any
    #: 多语言唯一Key
    uniqueKey: str
    #: 数据表名
    dbName: str
    #: 是否用于审批记录的分组显示
    groupColumn: Optional[bool] = None
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]] = None
    #: 错误标签
    errorTag: Optional[bool] = None


class ApprovalProcessInfo(BaseModel):
    #: 编码
    code: str
    #: 多语言描述
    description: Any
    #: 数据表名
    dbName: str
    #: 多语言唯一Key
    uniqueKey: str
    #: 数据表实际名称(审批记录表)
    actualTableName: str
    #: 数据表路径
    dbPath: str
    #: 审批流对应的明细信息
    elementDetail: Optional[ElementInfo] = None
    #: 状态字段编码
    statusColumnCode: str
    #: 字段信息
    columns: List[ApprovalProcessColumn]
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]] = None
    #: 错误标签
    errorTag: Optional[bool] = None


class CollectColumnInfo(BaseModel):
    #: 字段编码
    columnCode: Optional[str] = None
    #: 汇总类型
    collectType: Optional[str] = None
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]] = None
    #: 错误标识
    errorTag: Optional[bool] = None


class JournalColumnLogicInfo(BaseModel):
    #: 是否是分组字段
    groupColumn: Optional[bool] = None
    #: 字段类型
    valueType: int
    #: 字段长度
    length: Optional[str] = None
    #: 字段默认值
    defaultValue: Optional[str] = None
    #: 是否为业务主键
    logicKey: Optional[bool] = None
    #: 维度表达式|值列表成员|日期时间内容|自定义列表
    valueKey: Optional[str] = None
    #: 值列表信息|维度详细信息(字段类型为值列表或维度时传)
    elementDetail: Optional[ElementInfo] = None
    #: 小数部分长度(字段类型为数字时传)
    digitLen: Optional[str] = None
    #: 大于等于(字段类型为数字时传)
    maxEqual: Optional[bool] = None
    #: 整数部分长度(字段类型为数字时传)
    maxLen: Optional[str] = None
    #: 数值范围(大于)(字段类型为数字时传)
    maximun: Optional[str] = None
    #: (字段类型为数字时传)
    minEqual: Optional[bool] = None
    #: 数值范围(小于)(字段类型为数字时传)
    minimun: Optional[str] = None
    #: 用户类型展示值(保存时不传)
    valueDesc: Optional[str] = None
    #: 值列表成员
    valueField: Optional[List[str]] = None


class JournalData(BaseModel):
    #: 主表数据
    mainData: Optional[JournalMainData] = None
    #: 子表数据
    bodyData: JournalBodyData


class JournalListColumnInfo(BaseModel):
    #: 有权限成员
    authorityMember: Optional[List[str]] = None
    #: 字段编码
    columnCode: str
    #: 值列表信息|维度详细信息(字段类型为值列表或维度时传)
    elementDetail: Optional[ElementInfo] = None
    #: 展示类型(0:不显示,1显示到列表,2显示到页面,3显示到列表及页面)
    showInList: Optional[int] = None
    #: 多语言描述
    description: Any
    #: 字段类型
    valueType: int
    #: 维度表达式|日期时间内容|自定义列表
    valueKey: Optional[str] = None
    #: 值列表成员
    valueField: Optional[List[str]] = None
    #: 字段默认值
    defaultValue: Optional[str] = None
    #: 字段默认值描述
    defaultValueDesc: Optional[str] = None
    #: 值描述
    valueDesc: Optional[str] = None
    #: 字段关联维度权限信息
    dimensionRoleInfo: Optional[DimensionRoleInfo] = None
    #: 字段显示属性
    show: Optional[JournalTemplateFieldViewFeature] = None


class JournalOrderDataBatchQuery(BaseModel):
    """Journal Order Data Batch Query

    .. admonition:: 引用接口

        - **POST** ``/journal/get-aggregate-data``
        - **POST** ``/journal/get-batch-data``
        - **POST** ``/journal/get-total-data``
    """
    #: 模板编码
    templateCode: str
    #: 文件夹ID
    folderId: Optional[str] = None
    #: 模板路径
    path: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None
    #: 是否需要维度当前语言描述信息
    needDesc: Optional[bool] = None
    #: 页面字段参数集
    headerParams: Optional[List[JournalDataFilterParam]] = None
    #: 展示列字段参数集
    columnParams: Optional[List[JournalDataFilterParam]] = None
    #: 排序语句集合
    orderColumns: Optional[List[OrderColumnInfo]] = None
    #: 统计字段
    collectColumns: Optional[List[CollectColumnInfo]] = None
    #: 统计字段
    groupColumns: Optional[List[GroupColumnInfo]] = None
    #: 是否保留同凭证号分录明细（22年3月迭代新增）
    showDetail: Optional[bool] = None


class ElementRelationInfo(BaseModel):
    #: 列作用(通用类:0   场景类:1  版本类:2  实体类:3  科目类:4  年份类:5  期间类:6 值类型:99 交易伙伴:98)
    dimensionUsage: int
    #: 维度元素信息
    dimensionInfo: ElementInfo
    #: 字段编码(数据库名称)
    dimensionCode: Optional[str] = None
    #: 默认值
    defaultValue: str
    #: 对应字段
    relationColumn: Optional[JTRelationColumn] = None
    #: 对应字段集合
    relationColumnList: Optional[List[JTRelationColumn]] = None


class JTPostingRelColumn(BaseModel):
    """单据模板过账映射配置信息

    .. admonition:: 引用接口

        - **POST** ``/posting/memory-financial-model-mapping/query`` (Response: 200)
    """
    #: 所有数值类过账字段和对应维度默认值
    allNumberMapping: Optional[List[NumberPostingInfo]] = None
    #: 保存后数值类过账字段和对应维度默认值
    numberMapping: Optional[List[NumberPostingInfo]] = None
    #: 内存财务模型信息
    modelInfo: MemCubeModelDto
    #: 映射配置信息
    mappingInfo: List[ElementRelationInfo]


class PostingInfoDto(BaseModel):
    """过账信息dto

    .. admonition:: 引用接口

        - **POST** ``/posting/query`` (Response: 200)
    """
    #: 清数类型 1: 全量清数;2: 增量清数
    clearType: Optional[int] = None
    #: 凭证类别 1: 会计凭证;2: 报表凭证
    type: int
    #: 映射配置信息
    dimensionModel: List[JTPostingRelColumn]


class PostingParamQueryDto(BaseModel):
    """过账参数查询类

    .. admonition:: 引用接口

        - **POST** ``/posting/query-posting-param``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id(与元素路径二选一)
    folderId: Optional[str] = None
    #: 元素类型
    elementType: str
    #: 元素路径(与文件夹id二选一)
    path: Optional[str] = None
    #: 页面查询参数
    pageColumns: Optional[List[JournalListColumnInfo]] = None


class PostingRequestDto(BaseModel):
    """过账请求参数

    .. admonition:: 引用接口

        - **POST** ``/posting/cancel-posting``
        - **POST** ``/posting/get-posting``
    """
    #: 模板查询参数
    templateQuery: JournalTemplateQuery
    #: 过账参数
    postingInfoParam: PostingParam
    #: 过账是否变更状态
    modifyMergeStatus: Optional[bool] = None


class JournalBatchDataDTO(BaseModel):
    """Journal Batch Data DTO

    .. admonition:: 引用接口

        - **POST** ``/journal/batch-save``
    """
    #: 修改数据主表主键编码(修改时传)
    codeList: Optional[List[str]] = None
    #: 修改数据子表主键编码(修改时传)
    entryCodeList: Optional[List[str]] = None
    #: 文件夹ID
    folderId: Optional[str] = None
    #: 模板编码
    templateCode: str
    #: 路径
    path: Optional[str] = None
    #: 数据
    batchData: Optional[List[JournalData]] = None
    #: 是否新增
    isNew: Optional[bool] = None


class ButtonInfoDealParamDTO(BaseModel):
    """Button Info Deal Param DTO

    .. admonition:: 引用接口

        - **GET** ``/button/query`` (Response: 200)
    """
    #: 按钮信息（全局按钮&行按钮）
    journalButtonInfoList: Optional[List['JournalButtonInfoDTO']] = None


class JournalButtonInfoDTO(BaseModel):
    #: 排序
    sort: Optional[int] = None
    #: 按钮id
    id: Optional[str] = None
    #: 编码
    name: str
    #: 按钮父级id
    parentId: Optional[str] = None
    #: 按钮名称多语言描述
    description: Any
    #: 多语言唯一Key
    uniqueKey: Optional[str] = None
    #: 提示
    title: Optional[Any] = None
    #: 按钮类型(type)
    type: Optional[str] = None
    #: 是否隐藏
    hidden: Optional[bool] = None
    #: 子级按钮
    child: Optional[List['JournalButtonInfoDTO']] = None
    #: 按钮类型(position)
    position: Optional[str] = None
    #: 类型
    executeType: Optional[str] = None
    #: url
    executeUrl: Optional[str] = None
    #: 参数key&value 默认预留5个长度
    executeParam: Optional[List[Dict]] = None
    #: 只读权限 关联权限方案中的角色/角色组 此处存储elementName
    readPermission: Optional[Any] = None
    #: 运行权限 关联权限方案中的角色/角色组 此处存储elementName
    writePermission: Optional[Any] = None
    #: 样式属性
    styles: Optional[Any] = None
    #: 权限
    accessRight: Optional[str] = None
    #: 是否启用权限控制
    enableAccessControl: bool


class JournalColumnDataTableInfo(BaseModel):
    #: 字段编码
    columnCode: str
    #: 多语言描述
    description: Any
    #: 多语言唯一Key(新建时为空)
    uniqueKey: Optional[str] = None
    #: 数据表名
    dbName: str
    #: 数据类型
    type: str
    #: 数据长度
    length: Optional[str] = None
    #: 数据默认值
    defaultValue: Optional[str] = None
    #: 是否为主键
    whetherPrimary: Optional[bool] = None
    #: 操作类型
    operation: str
    #: 是否自增
    whetherIncrement: Optional[bool] = None
    #: 唯一索引
    whetherOnly: Optional[bool] = None
    #: 原字段数据库信息(新建时为null)
    oldInfo: Optional['JournalColumnDataTableInfo'] = None


class JournalColumnInfo(BaseModel):
    #: 复合表头
    displayName: Optional[str] = None
    #: 数据库属性
    dataTableInfo: JournalColumnDataTableInfo
    #: 逻辑属性
    logicInfo: JournalColumnLogicInfo
    #: 编辑及权限属性
    authorityInfo: JournalColumnAuthorityInfo
    #: 显示属性
    show: Optional[JournalTemplateFieldViewFeature] = None
    #: 是否为系统字段
    systemColumn: bool
    #: 样式属性
    styles: Optional[Any] = None
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]] = None
    #: 错误标识
    errorTag: Optional[bool] = None
    #: 加工属性
    processInfo: Optional[ProcessInfo] = None


class JournalDataTableBaseInfo(BaseModel):
    #: 数据表Id(空时表示新建,不为空时表示更新)
    id: str
    #: 数据表名
    dbName: str
    #: 数据表文件夹ID
    folderId: str
    #: 数据表路径
    dbPath: str
    #: 数据表实际名称
    actualTableName: str
    #: 数据表服务名
    serverName: str
    #: 数据表多语言描述
    description: Optional[Any] = None
    #: 原数据表信息(新建时为空,更新时必须)
    oldInfo: Optional['JournalDataTableBaseInfo'] = None


class JournalTemplateAreaInfo(BaseModel):
    #: 编码(名称)
    code: str
    #: 多语言描述
    description: Any
    #: 多语言唯一Key
    uniqueKey: Optional[str] = None
    #: 数据表基本信息
    dataTableBaseInfo: JournalDataTableBaseInfo
    #: 字段
    columns: List[JournalColumnInfo]
    #: 样式属性
    styles: Optional[Any] = None
    #: 允许添加行(日记账体)
    allowAddRow: Optional[bool] = None
    #: 允许复制行(日记账体)
    allowCopyRow: Optional[bool] = None
    #: 允许删除行(日记账体)
    allowDeleteRow: Optional[bool] = None
    #: 错误信息
    errorInfoList: Optional[List[ErrorInfo]] = None
    #: 错误标签
    errorTag: Optional[bool] = None


class JournalTemplateBaseInfo(BaseModel):
    #: 审批记录表
    approveRecord: Optional[JournalDataTableBaseInfo] = None
    #: 关账流程表信息
    closeAccountDB: Optional[JournalDataTableBaseInfo] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 模板id
    templateId: Optional[str] = None
    #: 编码(名称)
    code: str
    #: 名称(多语言)
    description: Optional[Any] = None
    #: 角色方案对应的明细信息
    rsElementDetail: Optional[ElementInfo] = None
    #: 样式属性
    styles: Optional[Any] = None
    #: 默认展示条数
    defaultItem: Optional[int] = None


class JournalTemplateDTO(BaseModel):
    """Journal Template DTO

    .. admonition:: 引用接口

        - **POST** ``/journal-template/baseInfo/batchQuery`` (Response: 200)
        - **POST** ``/journal-template/query`` (Response: 200)
        - **POST** ``/journal-template/save``
    """
    #: python脚本信息
    pythonScriptInfo: Optional[ElementInfo] = None
    #: 日记账模板基础信息
    baseInfo: JournalTemplateBaseInfo
    #: 日记账模板头区域信息
    headerInfo: JournalTemplateAreaInfo
    #: 日记账体区域信息
    bodyInfo: JournalTemplateAreaInfo
    #: 日记账尾区域信息
    footInfo: JournalTemplateAreaInfo
    #: 审批流信息
    approvalProcessInfo: Optional[ApprovalProcessInfo] = None
    #: 错误标识
    errorTag: Optional[bool] = None
    #: 模板类型
    templateType: Optional[str] = None


class JournalTemplateDetail(BaseModel):
    """模板整体详细信息

    .. admonition:: 引用接口

        - **POST** ``/journal-template/query-detail`` (Response: 200)
    """
    #: 高级设置
    advancedSetting: Optional[AdvancedSettingsDTO] = None
    #: 单据模板信息
    journalTemplateInfo: JournalTemplateDTO
    #: saveTime
    saveTime: Optional[str] = None
    #: 过账配置信息
    postingInfo: PostingInfoDto
    #: 按钮信息
    buttonInfo: ButtonInfoDealParamDTO


ButtonInfoDealParamDTO.update_forward_refs()
JournalButtonInfoDTO.update_forward_refs()
JournalColumnDataTableInfo.update_forward_refs()
JournalDataTableBaseInfo.update_forward_refs()
