"""
Models used by /gateway-server,/memory-financial-model-server1-0

generated by model_code_gen.py
  - **filename** : ``memory_financial_model.py``
  - **json timestamp** : ``2022-08-16 18:00:32``
"""


from .base import BaseModel
from typing import List, Optional, Union, Any
from pydantic import Field


__all__ = [
    'ErrorDTO',
    'ExpressionParserDTO',
    'GroupRoleBaseInfoDTO',
    'PythonQueryCubeDTO',
    'PythonResultDTO',
    'RoleBaseInfoDTO',
    'ElementBaseInfo',
    'ServerNodeInfo',
    'ModelQueryStructure',
    'RegisterConfigure',
    'CubeAccessControlDTO',
    'CubeDimensionDTO',
    'CubeGeneralQuery',
    'SheetDataResultVo',
    'MemFinancialModelVo',
    'QueryParamInfoVo'
]


class ErrorDTO(BaseModel):
    #: 异常key
    tipKey: Optional[str] = None
    #: 异常信息
    tipValue: Optional[str] = None


class ExpressionParserDTO(BaseModel):
    """Expression Parser DTO

    .. admonition:: 引用接口

        - **POST** ``/multi-report/check-formula-definition``
        - **POST** ``/multi-report/check-formula-definition`` (Response: 200)
    """
    #: 错误标志
    errorFlag: Optional[bool] = None
    #: 公式
    formula: str
    #: 校验成功后的公式
    formulaCheck: Optional[str] = None
    #: 公式名称
    formulaName: str
    #: 公式成员
    members: Optional[List[str]] = None
    #: 错误信息
    message: Optional[str] = None
    #: 替换符
    replaceStr: Optional[List[str]] = None


class GroupRoleBaseInfoDTO(BaseModel):
    #: 角色组描述
    description: Optional[Any] = None
    #: description1
    description1: Optional[str] = None
    #: description2
    description2: Optional[str] = None
    #: 是否为空
    empty: Optional[bool] = None
    #: 角色组说明
    instruction: Optional[Any] = None
    #: instruction1
    instruction1: Optional[str] = None
    #: instruction2
    instruction2: Optional[str] = None
    #: 角色组名称
    name: Optional[str] = None


class PythonQueryCubeDTO(BaseModel):
    """Python Query Cube DTO

    .. admonition:: 引用接口

        - **POST** ``/cube-data/cell-data``
        - **POST** ``/cube-data/clear-cube-data``
        - **POST** ``/cube-data/python-exp``
    """
    #: 内存财务模型编码
    cubeCode: Optional[str] = None
    #: 小数进位的方式, 默认ROUND_DOWN（截断），ROUND_HELF_UP（四舍五入），ROUND_CEILING（进位），ROUND_FLOOR（降位）
    decimalFormatType: Optional[str] = None
    #: 表达式信息集合
    expressionList: Optional[List[str]] = None
    #: 内存财务模型文件夹id
    folderId: Optional[str] = None
    #: 公共数据条件
    params: Optional[Any] = None
    #: 公式写入时小数保存位数,默认不限制
    saveDecimalNum: Optional[int] = None


class PythonResultDTO(BaseModel):
    """Python Result DTO

    .. admonition:: 引用接口

        - **POST** ``/cube-data/python-exp`` (Response: 200)
    """
    #: 计算标记
    calculateFalg: Optional[bool] = None
    #: 计算数据
    data: Optional[float] = None
    #: 计算公式
    exp: Optional[str] = None
    #: 响应信息
    message: Optional[str] = None


class RoleBaseInfoDTO(BaseModel):
    #: 默认角色组名称
    defaultRolegroupName: Optional[str] = None
    #: 角色描述
    description: Optional[Any] = None
    #: description1
    description1: Optional[str] = None
    #: description2
    description2: Optional[str] = None
    #: 是否为空
    empty: Optional[bool] = None
    #: 角色说明
    instruction: Optional[Any] = None
    #: instruction1
    instruction1: Optional[str] = None
    #: instruction2
    instruction2: Optional[str] = None
    #: 角色名称
    name: Optional[str] = None


class ElementBaseInfo(BaseModel):
    """元素基础参数信息

    .. admonition:: 引用接口

        - **POST** ``/check-relation-element``
        - **POST** ``/cube-data/query-dimension-ud-batch``
        - **POST** ``/cube/delete-other``
        - **POST** ``/dimension/update-single-dimension-cache``
    """
    #: 绝对路径标识
    absoluteTag: Optional[bool] = None
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: str
    #: 组件id
    moduleId: Optional[str] = None
    #: 绝对路径
    path: Optional[str] = None
    #: 相对路径
    relativePath: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class ServerNodeInfo(BaseModel):
    """服务节点信息类

    .. admonition:: 引用接口

        - **GET** ``/cube/eureka-nodes`` (Response: 200)
    """
    #: ip
    host: str
    #: 实例id
    instanceId: str
    #: 端口
    port: int
    #: 服务id
    serviceId: str


class ModelQueryStructure(BaseModel):
    #: 绝对路径标识
    absoluteTag: Optional[bool] = None
    #: 解析方式,0：成员；1：成员list；2：公式
    analysisType: Optional[int] = None
    #: cartesianProductList
    cartesianProductList: Optional[Any] = None
    #: 列名
    columnName: str
    #: 维度成员
    dimMember: Optional[str] = None
    #: 列作用
    dimensionUsage: int
    #: 自定义属性钻取真实维度标志
    drill: Optional[bool] = None
    #: 动态公式列表
    dynamicFormulas: Optional[List[ExpressionParserDTO]] = None
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 额外的附加信息
    extraInfo: Optional[List[dict]] = None
    #: 文件夹id
    folderId: str
    #: 成员公式
    formula: Optional[str] = None
    #: 是否动态公式列
    formulaCol: Optional[bool] = None
    #: 是否动态公式行
    formulaRow: Optional[bool] = None
    #: 合并单元格数量，Merge Cells
    mc: Optional[int] = None
    #: 维度成员
    members: Optional[List[str]] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 绝对路径
    path: Optional[str] = None
    #: 是否已经穿透
    penetrated: Optional[bool] = None
    #: 维度成员是否有权限
    permission: Optional[bool] = None
    #: 相对路径
    relativePath: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None
    #: 是否是属性维
    udFlag: Optional[bool] = None
    #: 自定义属性名称
    udName: Optional[str] = None


class RegisterConfigure(BaseModel):
    #: 注册维度信息
    dimensions: List[ModelQueryStructure]
    #: registerNodes
    registerNodes: Optional[List[ServerNodeInfo]] = None


class CubeAccessControlDTO(BaseModel):
    #: 访问权，4：只读；5：可写
    accessRight: Optional[int] = None
    #: 是否全部角色
    allRoles: Optional[bool] = None
    #: 角色组
    groupRoleList: Optional[List[GroupRoleBaseInfoDTO]] = None
    #: id
    id: Optional[int] = None
    #: 角色
    roleList: Optional[List[RoleBaseInfoDTO]] = None


class CubeDimensionDTO(BaseModel):
    #: 科目成员脚本
    accountMemberScript: Optional[str] = None
    #: 列类型,0:什么也没有，1：维度，2：度量
    columnType: int
    #: 审批单元标记
    datablockSeg: Optional[bool] = None
    #: 审批单元编号
    datablockSegNo: Optional[int] = None
    #: 字段名
    datatableColumn: str
    #: 维度描述
    dimensionDescription: Optional[str] = None
    #: 字段关联的维度所在文件夹Id
    dimensionFolderId: Optional[str] = None
    #: 字段关联的维度的moudelId
    dimensionMoudelId: Optional[str] = None
    #: 字段关联维度名称
    dimensionName: Optional[str] = None
    #: 字段关联的维度的路径
    dimensionPath: Optional[str] = None
    #: 维度服务名称
    dimensionServerName: Optional[str] = None
    #: 字段关联维度类型
    dimensionType: Optional[str] = None
    #: 列作用
    dimensionUsage: Optional[int] = None
    #: 异常信息
    errorList: Optional[List[ErrorDTO]] = None
    #: 是否关联时间维度字段
    isDate: Optional[bool] = None
    #: 关联的维度是否为新维度
    isNewDimension: bool
    #: 关联数据表字段是否丢失
    lossCol: Optional[bool] = None
    #: 度量类型,1data2text
    measureType: Optional[int] = None
    #: 多语言
    multilingual: Optional[Any] = None
    #: 流程控制字段成员
    processMember: Optional[str] = None
    #: 流程控制字段标记
    processSeg: Optional[bool] = None
    #: 流程控制字段编号
    processSegNo: Optional[int] = None
    #: 是否用做权限字段(仅维度类型的允许用做权限字段)
    roleSeg: Optional[bool] = None


class CubeGeneralQuery(BaseModel):
    """Cube General Query

    .. admonition:: 引用接口

        - **POST** ``/cube-data/general-query``
    """
    #: 内存财务模型编码
    cubeCode: str
    #: dimensions
    dimensions: Optional[List[ModelQueryStructure]] = None
    #: 是否过滤ICP
    filterICP: Optional[bool] = None
    #: 文件夹id
    folderId: str
    #: 期间列字段名称
    periodColumnName: str
    #: 是否汇总实体
    sumEntity: Optional[bool] = None
    #: 是否计算view,默认为0：计算；1：不计算
    viewFlag: int


class SheetDataResultVo(BaseModel):
    """sheet数据结果集类

    .. admonition:: 引用接口

        - **POST** ``/cube-data/query`` (Response: 200)
    """
    #: 列维度
    colDims: List[List]
    #: 页维度
    pageDims: List[ModelQueryStructure]
    #: 行维度
    rowDims: List[List]
    #: 数据集合
    values: List[List]


class MemFinancialModelVo(BaseModel):
    """内存财务数据模型实体类

    .. admonition:: 引用接口

        - **POST** ``/consolidation/query/initCache``
        - **GET** ``/cube/find-cube-data`` (Response: 200)
        - **POST** ``/cube/right``
        - **POST** ``/cube/right`` (Response: 200)
    """
    #: 自动进行档期数和累计数的汇总计算，false：关；true：开；
    autoCalculation: Optional[bool] = None
    #: 资产负债类科目保存,1：当期数,2：累计数,autoCalculation为1时值必填
    balanceAccountSave: Optional[int] = None
    #: 内存财务数据模型编码
    code: str
    #: 读写权限
    cubeAccessControlReactList: Optional[List[CubeAccessControlDTO]] = None
    #: 内存财务数据模型关联列信息
    cubeDimensionList: Optional[List[CubeDimensionDTO]] = None
    #: cube类型,4：期间作为度量；5：不作为度量
    cubeType: int
    #: 数据表类型，0:mysql，1:clickhouse
    dataSync: Optional[int] = None
    #: 数据表元素类型
    datatableElementType: Optional[str] = None
    #: 关联的数据表所在文件夹Id
    datatableFolderId: Optional[str] = None
    #: 关联的数据表的ModuleId
    datatableModuleId: Optional[str] = None
    #: 内存财务数据模型关联数据表名称
    datatableName: Optional[str] = None
    #: 关联数据表的路径
    datatablePath: Optional[str] = None
    #: 多语言信息
    description: Optional[Any] = None
    #: 关联维度的所在的文件夹Id
    dimensionFolderId: Optional[str] = None
    #: 关联期间维度的moduleId
    dimensionModuleId: Optional[str] = None
    #: 关联期间维度的编码
    dimensionName: Optional[str] = None
    #: 关联维度的路径
    dimensionPath: Optional[str] = None
    #: 关联维度的服务名
    dimensionServerName: Optional[str] = None
    #: 关联期间维度的Type
    dimensionType: Optional[str] = None
    #: 内存财务数据模型类型
    elementType: Optional[str] = None
    #: 是否启用流程控制
    enableProcessControl: Optional[bool] = None
    #: 异常信息
    errorList: Optional[List[ErrorDTO]] = None
    #: 异常标记
    errorTag: Optional[bool] = None
    #: 损益类科目保存,1：当期数,2：累计数,autoCalculation为1时值必填
    flowAccountSave: Optional[int] = None
    #: 内存财务数据模型所在文件夹Id
    folderId: str
    #: 内存财务数据模型id
    id: Optional[str] = None
    #: 索引维
    indexDims: Optional[List[ModelQueryStructure]] = None
    #: 多语言信息关联主键
    languageKey: Optional[str] = None
    #: 期间作为度量,最小期间层级,cubeType为4时,使用该属性
    minPeriodLevel: Optional[str] = None
    #: 内存财务数据模型moduleId
    moduleId: Optional[str] = None
    #: 内存财务数据模型路径
    path: Optional[str] = None
    #: periodMeasure
    periodMeasure: Optional[bool] = None
    #: 权限字段
    permission: Optional[int] = None
    #: 内存财务模型关联流程控制信息
    processControlInfo: Optional[ElementBaseInfo] = None
    #: 审批流关联角色方案信息
    processRelRoleInfo: Optional[ElementBaseInfo] = None
    #: 注册维
    registerDims: Optional[List[ModelQueryStructure]] = None
    #: 节点注册相关配置信息
    registrationInfos: Optional[List[RegisterConfigure]] = None
    #: 内存财务模型关联角色方案信息
    roleSchemeInfo: Optional[ElementBaseInfo] = None
    #: 流程控制字段信息
    rsPcsColumnInfo: Optional[List[CubeDimensionDTO]] = None
    #: 内存财务数据模型服务名
    serverName: Optional[str] = None


class QueryParamInfoVo(BaseModel):
    """内存财务模型查询条件类

    .. admonition:: 引用接口

        - **POST** ``/cube-data/query``
    """
    #: 激活实体
    activeEntity: Optional[ElementBaseInfo] = None
    #: 先行后列：0；先列后行：1
    calculOrder: Optional[int] = None
    #: 列维度参数
    colDims: List[List]
    #: 内存财务模型编码
    cubeCode: str
    #: 钻取类型，行列：0；行：1；列：2
    drillType: Optional[int] = None
    #: 是否过滤没有权限的成员，过滤：0；不过滤：1，默认0
    filterNoAuth: Optional[int] = None
    #: 文件夹id
    folderId: str
    #: 页维度参数
    pageDims: List[ModelQueryStructure]
    #: 期间列字段名称
    periodColumnName: str
    #: 关联交易模型元素基础信息
    relatedModel: Optional[ElementBaseInfo] = None
    #: 行维度参数
    rowDims: List[List]
    #: 是否计算view,默认为0：计算；1：不计算
    viewFlag: Optional[int] = None



