"""
Models used by /reconciliation-engine-server1-0

generated by model_code_gen.py
  - **filename** : ``reconciliation_engine.py``
  - **json timestamp** : ``2022-12-26 11:11:22``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'AccountInfoParam',
    'CanDoParam',
    'ElementBaseInfoParam',
    'OffTaskItem',
    'OnTaskItem',
    'OrderType',
    'QueryColumnDataItem',
    'QueryTaskListItem',
    'RctDO',
    'ReconSignByHand',
    'ReconciliationExecDto',
    'ReconciliationExecCreate',
    'CancelItem',
    'CancelReconMatch',
    'CancelSignByHand',
    'ConfirmItem',
    'DeleteDsItem',
    'DeleteTaskItem',
    'PageInfoRctDO'
]


class AccountInfoParam(BaseModel):
    #: 参数编码
    code: Optional[str] = None
    #: 默认值
    defaultValue: Optional[str] = None
    #: 参数描述
    description: Optional[str] = None
    #: 长度
    length: Optional[str] = None
    #: realValue
    realValue: Optional[Any] = None
    #: 类型 1.文本; 2.整数 3.小数 4.日期 5.日期时间;
    valueType: Optional[int] = None


class CanDoParam(BaseModel):
    #: 是否清理数据
    isClean: Optional[bool] = None
    #: 是否确认
    isConfirm: Optional[bool] = None


class ElementBaseInfoParam(BaseModel):
    """Element Base Info Param

    .. admonition:: 引用接口

        - **POST** ``/data_get/element_column``
    """
    #: 是否绝对路径
    absoluteTag: Optional[bool] = None
    #: 路径
    elementId: Optional[str] = None
    #: 元素名
    elementName: str
    #: 元素中英文
    elementNameDesAll: Optional[Any] = None
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: str
    #: 组件id
    moduleId: str
    #: 路径
    path: Optional[str] = None
    #: 相对路径
    relativePath: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class OffTaskItem(BaseModel):
    """Off Task Item

    .. admonition:: 引用接口

        - **POST** ``/reconciliation/off_task``
    """
    #: 批次id
    dsBatchId: Optional[str] = None
    #: 批次id集合
    dsBatchIds: Optional[List[str]] = None
    #: 任务id集合
    rcTaskIds: Optional[List[str]] = None
    #: 对账元素
    reconElement: Optional[ElementBaseInfoParam] = None


class OnTaskItem(BaseModel):
    """On Task Item

    .. admonition:: 引用接口

        - **POST** ``/reconciliation/on_task``
    """
    #: 批次id
    dsBatchId: Optional[str] = None
    #: 任务id
    rcTaskId: Optional[str] = None
    #: 任务id集合
    rcTaskIds: Optional[List[str]] = None
    #: 对账元素
    reconElement: Optional[ElementBaseInfoParam] = None


class OrderType(BaseModel):
    #: columnName
    columnName: Optional[str] = None
    #: orderType
    orderType: Optional[str] = None


class QueryColumnDataItem(BaseModel):
    """Query Column Data Item

    .. admonition:: 引用接口

        - **POST** ``/data_get/get_column_data``
    """
    #: 自动执行条件
    canDoParam: CanDoParam
    #: 清单表元素
    dsBatchId: Optional[str] = None
    #: 清单表元素
    dsBatchName: Optional[str] = None
    #: 清单表元素
    elementBaseInfoParamTable: Optional[ElementBaseInfoParam] = None
    #: 手动参数
    params: Optional[List[AccountInfoParam]] = None


class QueryTaskListItem(BaseModel):
    """Query Task List Item

    .. admonition:: 引用接口

        - **POST** ``/reconciliation/get_task_list``
    """
    #: pov条件
    fields: Optional[Any] = None
    #: 排序
    orderType: Optional[OrderType] = None
    #: 页码
    pageNum: Optional[int] = None
    #: 每页个数
    pageSize: Optional[int] = None
    #: 对账元素
    reconElement: Optional[ElementBaseInfoParam] = None
    #: 匹配编码
    taskStatus: Optional[str] = None


class RctDO(BaseModel):
    #: baseAuto
    baseAuto: Optional[int] = None
    #: baseMnl
    baseMnl: Optional[int] = None
    #: baseNot
    baseNot: Optional[int] = None
    #: baseProportion
    baseProportion: Optional[str] = None
    #: baseTotal
    baseTotal: Optional[int] = None
    #: baseUn
    baseUn: Optional[int] = None
    #: cprAuto
    cprAuto: Optional[int] = None
    #: cprMnl
    cprMnl: Optional[int] = None
    #: cprNot
    cprNot: Optional[int] = None
    #: cprProportion
    cprProportion: Optional[str] = None
    #: cprTotal
    cprTotal: Optional[int] = None
    #: cprUn
    cprUn: Optional[int] = None
    #: dsBatchId
    dsBatchId: Optional[str] = None
    #: lastExecStatus
    lastExecStatus: Optional[str] = None
    #: lastRunTime
    lastRunTime: Optional[str] = None
    #: rcTaskId
    rcTaskId: Optional[str] = None
    #: rcTaskName
    rcTaskName: Optional[str] = None
    #: rcTaskStatus
    rcTaskStatus: Optional[str] = None
    #: ruleInfo
    ruleInfo: Optional[str] = None


class ReconSignByHand(BaseModel):
    """Recon Sign By Hand

    .. admonition:: 引用接口

        - **POST** ``/recon-cfg/mark-by-hand``
    """
    #: 选择的基础数据ids
    baseDataIds: Optional[List[str]] = None
    #: 选择的对比数据ids
    cprDataIds: Optional[List[str]] = None
    #: 说明
    description: Optional[str] = None
    #: 附件对应的id,多个英文逗号分割
    enclosures: Optional[str] = None
    #: 匹配批次ID
    rcTaskId: Optional[str] = None
    #: 匹配原因
    reason: Optional[str] = None
    #: 对账元素
    reconElement: Optional[ElementBaseInfoParam] = None
    #: 操作类型: 4 手工匹配  6 暂挂 5 不参与匹配
    type: Optional[str] = None


class ReconciliationExecDto(BaseModel):
    """Reconciliation Exec Dto

    .. admonition:: 引用接口

        - **POST** ``/reconciliationExecution/reconciliation``
    """
    #: 对账元素
    elementBaseInfoParam: ElementBaseInfoParam
    #: 前端传入的参数
    params: List[AccountInfoParam]
    #: pov信息
    povParams: Any
    #: 对账任务id，不为空表示执行旧的对账
    rcTaskId: Optional[str] = None
    #: 对账任务名称，对账id为空，用来新建对账任务
    rcTaskName: Optional[str] = None

class ReconciliationExecCreate(BaseModel):
    """Reconciliation Exec Create

    .. admonition:: 引用接口

        - **POST** ``/reconciliationExecution/create``
    """
    #: 创建成功后是否自动执行
    autoRunning: bool
    #: 对账元素
    elementBaseInfoParam: ElementBaseInfoParam
    #: 前端传入的参数
    params: List[AccountInfoParam]
    #: pov信息
    povParams: Any
    #: 对账任务id，不为空表示执行旧的对账
    rcTaskId: Optional[str] = None
    #: 对账任务名称，对账id为空，用来新建对账任务
    rcTaskName: Optional[str] = None

class CancelItem(BaseModel):
    """Cancel Item

    .. admonition:: 引用接口

        - **POST** ``/data_get/cancel_ds``
    """
    #: 批次号
    dsId: Optional[str] = None
    #: 批次号
    dsIds: Optional[str] = None
    #: 基础元素
    elementBaseInfoParamData: Optional[ElementBaseInfoParam] = None


class CancelReconMatch(BaseModel):
    """Cancel Recon Match

    .. admonition:: 引用接口

        - **POST** ``/recon-cfg/cancel_recon_match``
    """
    #: 匹配编码列表
    matchIds: Optional[List[str]] = None
    #: 对账任务ID
    rcTaskId: Optional[str] = None
    #: 对账元素
    reconElement: Optional[ElementBaseInfoParam] = None


class CancelSignByHand(BaseModel):
    """Cancel Sign By Hand

    .. admonition:: 引用接口

        - **POST** ``/recon-cfg/cancel-by-hand``
    """
    #: 选择的基础数据ids
    baseDataIds: Optional[List[str]] = None
    #: 选择的对比数据ids
    cprDataIds: Optional[List[str]] = None
    #: 对账任务ID
    rcTaskId: Optional[str] = None
    #: 对账元素
    reconElement: Optional[ElementBaseInfoParam] = None
    #: 操作类型: 0 取消挂起  1 取消不参与匹配
    type: Optional[int] = None


class ConfirmItem(BaseModel):
    """Confirm Item

    .. admonition:: 引用接口

        - **POST** ``/data_get/confirm_ds``
        - **POST** ``/data_get/confirm_ds_batch``
    """
    #: 批次号
    dsId: Optional[str] = None
    #: 批次号
    dsIds: Optional[str] = None
    #: 基础元素
    elementBaseInfoParamData: Optional[ElementBaseInfoParam] = None


class DeleteDsItem(BaseModel):
    """Delete Ds Item

    .. admonition:: 引用接口

        - **POST** ``/data_get/delete_ds``
        - **POST** ``/data_get/delete_ds_batch``
    """
    #: 批次号
    dsId: Optional[str] = None
    #: 批次号
    dsIds: Optional[str] = None
    #: 基础元素
    elementBaseInfoParamData: Optional[ElementBaseInfoParam] = None


class DeleteTaskItem(BaseModel):
    """Delete Task Item

    .. admonition:: 引用接口

        - **POST** ``/reconciliation/delete_task``
    """
    #: 批次id
    dsBatchId: Optional[str] = None
    #: 批次id集合
    dsBatchIds: Optional[List[str]] = None
    #: 任务id集合
    rcTaskIds: Optional[List[str]] = None
    #: 对账元素
    reconElement: Optional[ElementBaseInfoParam] = None


class PageInfoRctDO(BaseModel):
    #: endRow
    endRow: Optional[int] = None
    #: hasNextPage
    hasNextPage: Optional[bool] = None
    #: hasPreviousPage
    hasPreviousPage: Optional[bool] = None
    #: isFirstPage
    isFirstPage: Optional[bool] = None
    #: isLastPage
    isLastPage: Optional[bool] = None
    #: list
    list: Optional[List[RctDO]] = None
    #: navigateFirstPage
    navigateFirstPage: Optional[int] = None
    #: navigateLastPage
    navigateLastPage: Optional[int] = None
    #: navigatePages
    navigatePages: Optional[int] = None
    #: navigatepageNums
    navigatepageNums: Optional[List[int]] = None
    #: nextPage
    nextPage: Optional[int] = None
    #: pageNum
    pageNum: Optional[int] = None
    #: pageSize
    pageSize: Optional[int] = None
    #: pages
    pages: Optional[int] = None
    #: prePage
    prePage: Optional[int] = None
    #: size
    size: Optional[int] = None
    #: startRow
    startRow: Optional[int] = None
    #: total
    total: Optional[int] = None



