"""
Models used by /role-strategy-server1-0

generated by model_code_gen.py
  - **filename** : ``role_strategy.py``
  - **json timestamp** : ``2022-08-08 13:39:19``
"""


from .base import BaseModel
from typing import List, Optional, Union, Any
from pydantic import Field


__all__ = [
    'BaseTip',
    'DataTableInfoVO',
    'DimensionLineForRolesVO',
    'DimensionMemberByRoleDto',
    'DimensionMemberByUserDto',
    'DimensionMemberByUserVO',
    'DimensionMemberDto',
    'DimensionMemberGroupDto',
    'DimensionMemberInfoVO',
    'DimensionMemberRoleStrategyBatchDto',
    'DimensionMemberRoleStrategyDto',
    'DimensionMemberSegDto',
    'DimensionMemberUserByRolesDto',
    'DimensionMembersByUserAndSegMembersVO',
    'DimensionMembersCheckDto',
    'DimensionMessageBatchVO',
    'DimensionMessageVO',
    'DimensionScriptMessageVO',
    'DimensionScriptsCheckDto',
    'ElementDetailVO',
    'ImportRoleSchemeDetailDto',
    'ImportRoleSchemeDto',
    'QueryRoleSchemeDTO',
    'ResultStringDto',
    'RoleByRoleSchemeVO',
    'RoleSchemeSegmentVO',
    'RolegroupByRoleSchemeVO',
    'RolegroupsByRoleSchemeDto',
    'RolesByUserAndSegMembersVO',
    'RolesByUserVO',
    'UserGroupListDTO',
    'UsersByRolesDto',
    'BatchQueryRolesByUserAndSegMembersVO',
    'DimMemberCheckDimensionDto',
    'DimensionMemberBySchemeLineVO',
    'DimensionMemberBySchemeVO',
    'DimensionMemberByUserAndRoleVO',
    'DimensionMemberByUserRoleDimVO',
    'RoleSchemeInfoVO',
    'UserByRolesBatchDto',
    'UserDTO',
    'UsersByRoleGroupsVO',
    'UsersByRolesVO',
    'DimensionAndUserForRolesVO',
    'UserByRolesAndRoleGroupsVO',
    'RoleDetailVO',
    'RoleGroupDetailVO',
    'RoleGroupVO',
    'RoleInfoVO'
]


class BaseTip(BaseModel):
    #: tipKey
    tipKey: Optional[str] = None
    #: tipValue
    tipValue: Optional[str] = None


class DataTableInfoVO(BaseModel):
    #: 绝对路径标识
    absoluteTag: Optional[bool] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 相对路径
    relativePath: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class DimensionLineForRolesVO(BaseModel):
    #: 维度成员
    dimensionMember: Optional[str] = None
    #: 权限方案配置中的维度序号，1-5
    line: Optional[int] = None


class DimensionMemberByRoleDto(BaseModel):
    """Dimension Member By Role Dto

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-member-by-user-role``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId与path必传一个）
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 角色组名称
    roleGroups: Optional[List[str]] = None
    #: 角色名称
    roles: Optional[List[str]] = None


class DimensionMemberByUserDto(BaseModel):
    #: 维度名
    dimensionName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: Optional[str] = None
    #: segment的行号
    line: int
    #: 路径
    path: Optional[str] = None


class DimensionMemberByUserVO(BaseModel):
    #: 维度名
    dimensionName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: Optional[str] = None
    #: segment的行号
    line: int
    #: 路径
    path: Optional[str] = None


class DimensionMemberDto(BaseModel):
    #: 需要校验的维度成员
    dimensionMembers: List[str]
    #: 维度名
    dimensionName: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: str
    #: segment的行号
    line: int
    #: 路径
    path: Optional[str] = None


class DimensionMemberGroupDto(BaseModel):
    #: 唯一标识，别名
    alias: Optional[str] = None
    #: 校验维度，line1-5，且不能重复
    dimensions: List[DimensionMemberDto]


class DimensionMemberInfoVO(BaseModel):
    #: 描述
    multilingual: Optional[Any] = None
    #: 维度成员名称
    name: Optional[str] = None


class DimensionMemberRoleStrategyBatchDto(BaseModel):
    """Dimension Member Role Strategy Batch Dto

    .. admonition:: 引用接口

        - **POST** ``/batch-query-roles-by-user-seg-members``
    """
    #: 校验维度分组
    dimensionGroups: List[DimensionMemberGroupDto]
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId与path必传一个）
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None


class DimensionMemberRoleStrategyDto(BaseModel):
    """Dimension Member Role Strategy Dto

    .. admonition:: 引用接口

        - **POST** ``/get-roles-by-user-seg-members``
    """
    #: 校验维度
    dimension: List[DimensionMemberDto]
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: str
    #: 文件夹路径
    path: str


class DimensionMemberSegDto(BaseModel):
    #: 维度名
    dimensionName: str
    #: 需要校验的维度成员
    dimensionScripts: str
    #: 元素类型
    elementType: str
    #: 文件夹id
    folderId: Optional[str] = None
    #: segment的行号
    line: int
    #: 路径
    path: Optional[str] = None


class DimensionMemberUserByRolesDto(BaseModel):
    #: 需要校验的维度成员
    dimensionMembers: Optional[List[str]] = None
    #: 维度名
    dimensionName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 权限方案配置中的维度序号，1-5
    line: Optional[int] = None
    #: 路径
    path: Optional[str] = None


class DimensionMembersByUserAndSegMembersVO(BaseModel):
    """Dimension Members By User And Seg Members VO

    .. admonition:: 引用接口

        - **POST** ``/get-dim-members-by-user-seg-members`` (Response: 200)
    """
    #: 维度成员
    dimensionMembers: Optional[List[DimensionMemberInfoVO]] = None
    #: 维度名
    dimensionName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: dimension在权限方案中的行号
    line: Optional[int] = None


class DimensionMembersCheckDto(BaseModel):
    """Dimension Members Check Dto

    .. admonition:: 引用接口

        - **POST** ``/get-dim-members-by-user-seg-members``
    """
    #: 校验维度
    dimensions: List[DimensionMemberDto]
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: str
    #: 角色组名称
    roleGroups: Optional[List[str]] = None
    #: 角色名称
    roles: Optional[List[str]] = None


class DimensionMessageBatchVO(BaseModel):
    """Dimension Message Batch VO

    .. admonition:: 引用接口

        - **POST** ``/get-Dimension-Member-by-role-scheme-batch`` (Response: 200)
    """
    #: 校验维度
    dimension: Optional[DimensionMemberByUserVO] = None
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: Optional[str] = None
    #: 维度成员是否受控
    enableAll: Optional[bool] = None
    #: 错误描述
    errorMsg: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 维度成员
    member: Optional[List[str]] = None
    #: 权限方案路径
    path: Optional[str] = None
    #: 角色组名称
    roleGroups: Optional[List[str]] = None
    #: 角色名称
    roles: Optional[List[str]] = None


class DimensionMessageVO(BaseModel):
    """Dimension Message VO

    .. admonition:: 引用接口

        - **POST** ``/get-Dimension-Member-by-role-scheme`` (Response: 200)
    """
    #: 维度成员是否受控
    enableAll: Optional[bool] = None
    #: 维度成员
    member: Optional[List[str]] = None


class DimensionScriptMessageVO(BaseModel):
    """Dimension Script Message VO

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-script-by-role-scheme`` (Response: 200)
    """
    #: 维度成员是否受控
    enableAll: Optional[bool] = None
    #: 维度表达式
    script: Optional[List[str]] = None


class DimensionScriptsCheckDto(BaseModel):
    """Dimension Scripts Check Dto

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-member-by-user-role-scripts``
    """
    #: 校验维度
    dimensions: List[DimensionMemberSegDto]
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 角色组名称
    roleGroups: Optional[List[str]] = None
    #: 角色名称
    roles: Optional[List[str]] = None


class ElementDetailVO(BaseModel):
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class ImportRoleSchemeDetailDto(BaseModel):
    #: 角色名
    roleNames: Optional[List[str]] = None
    #: 角色组名
    rolegroupName: Optional[List[str]] = None
    #: segment1
    segment1: Optional[str] = None
    #: segment2
    segment2: Optional[str] = None
    #: segment3
    segment3: Optional[str] = None
    #: segment4
    segment4: Optional[str] = None
    #: segment5
    segment5: Optional[str] = None
    #: 用户id
    userIds: Optional[List[str]] = None
    #: 用户信息参数
    userMessageList: Optional[List[str]] = None
    #: 用户组id
    usergroupId: Optional[List[str]] = None
    #: 用户组信息参数
    usergroupMessageList: Optional[List[str]] = None


class ImportRoleSchemeDto(BaseModel):
    """Import Role Scheme Dto

    .. admonition:: 引用接口

        - **POST** ``/role-scheme-data-import``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 权限方案导入配置
    importDataList: Optional[List[ImportRoleSchemeDetailDto]] = None
    #: 元素path路径
    path: Optional[str] = None
    #: 全量增量导入标识
    tag: str


class QueryRoleSchemeDTO(BaseModel):
    """Query Role Scheme DTO

    .. admonition:: 引用接口

        - **POST** ``/role-strategy/info-list``
    """
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 页码
    pageNo: Optional[int] = None
    #: 每页大小
    pageSize: Optional[int] = None
    #: 元素path路径
    path: Optional[str] = None
    #: 要搜索的角色组编码
    roleGroupNames: Optional[List[str]] = None
    #: 要搜索的角色编码
    roleNames: Optional[List[str]] = None
    #: 要搜索的用户组ID
    userGroupIds: Optional[List[str]] = None
    #: 要搜索的用户ID
    userIds: Optional[List[str]] = None


class ResultStringDto(BaseModel):
    """Result String Dto

    .. admonition:: 引用接口

        - **POST** ``/role-strategy/rolescheme/import`` (Response: 200)
        - **POST** ``/role-strategy/save-role-scheme`` (Response: 200)
        - **POST** ``/rolegroup/role-rolegroup/import`` (Response: 200)
    """
    #: code
    code: Optional[int] = None
    #: result
    result: Optional[str] = None


class RoleByRoleSchemeVO(BaseModel):
    """Role By Role Scheme VO

    .. admonition:: 引用接口

        - **POST** ``/get-roles-by-role-scheme-rolegroups`` (Response: 200)
    """
    #: 默认角色组名称
    defaultRolegroupName: Optional[str] = None
    #: 描述
    description: Optional[Any] = None
    #: 说明
    instruction: Optional[Any] = None
    #: 角色名称
    name: Optional[str] = None


class RoleSchemeSegmentVO(BaseModel):
    #: elementDetail
    elementDetail: Optional[ElementDetailVO] = None
    #: 错误提示
    errorList: Optional[List[BaseTip]] = None
    #: rsMapping
    line: Optional[int] = None


class RolegroupByRoleSchemeVO(BaseModel):
    """Rolegroup By Role Scheme VO

    .. admonition:: 引用接口

        - **POST** ``/get-rolegroups-by-role-scheme-roles`` (Response: 200)
    """
    #: 描述
    description: Optional[Any] = None
    #: 说明
    instruction: Optional[Any] = None
    #: 名称
    name: Optional[str] = None


class RolegroupsByRoleSchemeDto(BaseModel):
    """Rolegroups By Role Scheme Dto

    .. admonition:: 引用接口

        - **POST** ``/get-rolegroups-by-role-scheme-roles``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: str
    #: 角色编码
    roleNames: List[str]


class RolesByUserAndSegMembersVO(BaseModel):
    """Roles By User And Seg Members VO

    .. admonition:: 引用接口

        - **POST** ``/get-roles-by-user-seg-members`` (Response: 200)
    """
    #: 是否全部角色，若为true，roles和roleGroups值返回空
    allRoles: Optional[bool] = None
    #: 角色组
    roleGroups: Optional[List[RolegroupByRoleSchemeVO]] = None
    #: 角色
    roles: Optional[List[RoleByRoleSchemeVO]] = None


class RolesByUserVO(BaseModel):
    """Roles By User VO

    .. admonition:: 引用接口

        - **GET** ``/get-roles-by-user`` (Response: 200)
    """
    #: 是否全部角色，若为true，roles和roleGroups值返回空
    allRoles: Optional[bool] = None
    #: 角色组
    roleGroups: Optional[List[RolegroupByRoleSchemeVO]] = None
    #: 角色
    roles: Optional[List[RoleByRoleSchemeVO]] = None


class UserGroupListDTO(BaseModel):
    #: 用户组描述
    groupDesc: Optional[str] = None
    #: 用户组名称
    groupName: Optional[str] = None
    #: 用户组id
    id: Optional[str] = None
    #: 状态
    status: Optional[str] = None
    #: 类型
    type: Optional[str] = None


class UsersByRolesDto(BaseModel):
    #: 唯一标识，别名
    alias: Optional[str] = None
    #: 校验维度
    dimensions: Optional[List[DimensionMemberUserByRolesDto]] = None
    #: 角色组名称
    roleGroups: List[str]
    #: 角色名称，全部角色为["-1"]
    roles: List[str]


class BatchQueryRolesByUserAndSegMembersVO(BaseModel):
    """Batch Query Roles By User And Seg Members VO

    .. admonition:: 引用接口

        - **POST** ``/batch-query-roles-by-user-seg-members`` (Response: 200)
    """
    #: 唯一标识，别名
    alias: Optional[str] = None
    #: 是否全部角色，若为true，roles和roleGroups值返回空
    allRoles: Optional[bool] = None
    #: 角色组
    roleGroups: Optional[List[RolegroupByRoleSchemeVO]] = None
    #: 角色
    roles: Optional[List[RoleByRoleSchemeVO]] = None


class DimMemberCheckDimensionDto(BaseModel):
    """Dim Member Check Dimension Dto

    .. admonition:: 引用接口

        - **POST** ``/get-Dimension-Member-by-role-scheme``
        - **POST** ``/get-Dimension-Member-by-role-scheme-batch``
        - **POST** ``/get-dimension-script-by-role-scheme``
    """
    #: 校验维度
    dimension: DimensionMemberByUserDto
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId与path必传一个）
    folderId: Optional[str] = None
    #: 维度路径
    path: Optional[str] = None
    #: 角色组名称
    roleGroups: Optional[List[str]] = None
    #: 角色名称
    roles: Optional[List[str]] = None


class DimensionMemberBySchemeLineVO(BaseModel):
    #: 权限方案维度组合
    roleSchemeLineList: Optional[List[DimensionMembersByUserAndSegMembersVO]] = None


class DimensionMemberBySchemeVO(BaseModel):
    #: 权限方案维度组合
    dimensionList: Optional[List[DimensionMembersByUserAndSegMembersVO]] = None


class DimensionMemberByUserAndRoleVO(BaseModel):
    """Dimension Member By User And Role VO

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-member-by-user-role`` (Response: 200)
    """
    #: 用户是否管理员
    adminTag: Optional[bool] = None
    #: 权限方案维度组合，管理员时，组合为空
    schemeLineVOList: Optional[List[DimensionMemberBySchemeLineVO]] = None


class DimensionMemberByUserRoleDimVO(BaseModel):
    """Dimension Member By User Role Dim VO

    .. admonition:: 引用接口

        - **POST** ``/get-dimension-member-by-user-role-scripts`` (Response: 200)
    """
    #: 用户是否管理员
    adminTag: Optional[bool] = None
    #: 权限方案维度组合，管理员时，组合为空
    schemeLineVOList: Optional[List[DimensionMemberBySchemeVO]] = None


class RoleSchemeInfoVO(BaseModel):
    """Role Scheme Info VO

    .. admonition:: 引用接口

        - **GET** ``/role-strategy/info`` (Response: 200)
        - **POST** ``/role-strategy/info-list`` (Response: 200)
    """
    #: 权限方案数据表信息
    dataTableInfo: Optional[DataTableInfoVO] = None
    #: 多语言信息
    description: Optional[Any] = None
    #: 描述1
    description1: Optional[str] = None
    #: 描述2
    description2: Optional[str] = None
    #: dimensionErrorList
    dimensionErrorList: Optional[List[BaseTip]] = None
    #: dimensionErrorTag
    dimensionErrorTag: Optional[bool] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 错误提示
    errorList: Optional[List[BaseTip]] = None
    #: 是否存在错误提示
    errorTag: Optional[bool] = None
    #: 文件夹ID
    folderId: Optional[str] = None
    #: 组件ID
    moduleId: Optional[str] = None
    #: 元素路径path
    path: Optional[str] = None
    #: 元素权限
    permission: Optional[int] = None
    #: 权限方案
    roleScheme: Optional[Any] = None
    #: rsId
    rsId: Optional[str] = None
    #: 关联维度
    segments: Optional[List[RoleSchemeSegmentVO]] = None
    #: 警告提示
    warningList: Optional[List[BaseTip]] = None
    #: 是否存在警告提示
    warningTag: Optional[bool] = None


class UserByRolesBatchDto(BaseModel):
    """User By Roles Batch Dto

    .. admonition:: 引用接口

        - **POST** ``/get-users-by-roles``
    """
    #: 元素名称
    elementName: str
    #: 文件夹id（folderId与path必传一个）
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: roleAndGroups
    roleAndGroups: List[UsersByRolesDto]


class UserDTO(BaseModel):
    #: 是否管理员
    adminTag: Optional[str] = None
    #: 头像
    avatar: Optional[str] = None
    #: 邮箱
    email: Optional[str] = None
    #: 用户组
    groupList: Optional[List[UserGroupListDTO]] = None
    #: 手机号
    mobilePhone: Optional[str] = None
    #: 别名
    nickName: Optional[str] = None
    #: 状态
    status: Optional[str] = None
    #: 用户Id
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None


class UsersByRoleGroupsVO(BaseModel):
    #: 是否所有用户
    enableAll: Optional[bool] = None
    #: 是否企业用户
    enableEnterpriseAll: Optional[bool] = None
    #: 角色组名
    roleGroupName: Optional[str] = None
    #: 用户
    users: Optional[List[UserDTO]] = None


class UsersByRolesVO(BaseModel):
    #: 是否所有用户
    enableAll: Optional[bool] = None
    #: 是否企业用户
    enableEnterpriseAll: Optional[bool] = None
    #: 角色名，全部角色为-1
    roleName: Optional[str] = None
    #: 用户
    users: Optional[List[UserDTO]] = None


class DimensionAndUserForRolesVO(BaseModel):
    #: 维度组合
    dimensionLines: Optional[List[DimensionLineForRolesVO]] = None
    #: 角色组
    roleGroups: Optional[List[UsersByRoleGroupsVO]] = None
    #: 角色
    roles: Optional[List[UsersByRolesVO]] = None


class UserByRolesAndRoleGroupsVO(BaseModel):
    """User By Roles And Role Groups VO

    .. admonition:: 引用接口

        - **POST** ``/get-users-by-roles`` (Response: 200)
    """
    #: 唯一标识，别名
    alias: Optional[str] = None
    #: 满足维度的角色/角色组
    dimensions: Optional[List[DimensionAndUserForRolesVO]] = None
    #: 角色组，dimensions为空时，此参数有效
    roleGroups: Optional[List[UsersByRoleGroupsVO]] = None
    #: 角色，dimensions为空时，此参数有效
    roles: Optional[List[UsersByRolesVO]] = None


class RoleDetailVO(BaseModel):
    #: 多语言描述
    description: Optional[Any] = None
    #: 描述1
    description1: Optional[str] = None
    #: 描述2
    description2: Optional[str] = None
    #: 多语言说明
    instruction: Optional[Any] = None
    #: 说明1
    instruction1: Optional[str] = None
    #: 说明2
    instruction2: Optional[str] = None
    #: 角色名称
    name: Optional[str] = None
    #: 关联的角色组
    relation: Optional[List['RoleGroupDetailVO']] = None


class RoleGroupDetailVO(BaseModel):
    #: 多语言描述
    description: Optional[Any] = None
    #: 描述1
    description1: Optional[str] = None
    #: 描述2
    description2: Optional[str] = None
    #: 多语言说明
    instruction: Optional[Any] = None
    #: 说明1
    instruction1: Optional[str] = None
    #: 说明2
    instruction2: Optional[str] = None
    #: 名称
    name: Optional[str] = None
    #: 关联的角色
    relation: Optional[List[RoleDetailVO]] = None
    #: 状态 0禁用/1启用
    status: Optional[int] = None
    #: 类型 ROLE/GROUP
    type: Optional[str] = None


class RoleGroupVO(BaseModel):
    """Role Group VO

    .. admonition:: 引用接口

        - **GET** ``/rolegroup/data`` (Response: 200)
    """
    #: 权限方案数据表信息
    dataTableInfo: Optional[DataTableInfoVO] = None
    #: 多语言描述
    description: Optional[Any] = None
    #: 描述1
    description1: Optional[str] = None
    #: 描述2
    description2: Optional[str] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 错误提示
    errorList: Optional[List[BaseTip]] = None
    #: 文件夹ID
    folderId: Optional[str] = None
    #: 多语言说明
    instruction: Optional[Any] = None
    #: 组件ID
    moduleId: Optional[str] = None
    #: 元素路径path
    path: Optional[str] = None
    #: 角色组
    rolegroup: Optional[List[RoleGroupDetailVO]] = None
    #: rsId
    rsId: Optional[str] = None


class RoleInfoVO(BaseModel):
    """Role Info VO

    .. admonition:: 引用接口

        - **GET** ``/role/data`` (Response: 200)
    """
    #: 权限方案数据表信息
    dataTableInfo: Optional[DataTableInfoVO] = None
    #: 多语言信息
    description: Optional[Any] = None
    #: 描述1
    description1: Optional[str] = None
    #: 描述2
    description2: Optional[str] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 错误提示
    errorList: Optional[List[BaseTip]] = None
    #: 文件夹ID
    folderId: Optional[str] = None
    #: 组件ID
    moduleId: Optional[str] = None
    #: 元素路径path
    path: Optional[str] = None
    #: 角色
    role: Optional[List[RoleDetailVO]] = None
    #: rsId
    rsId: Optional[str] = None


RoleDetailVO.update_forward_refs()
