"""
Models used by /space-server

generated by model_code_gen.py
  - **filename** : ``space.py``
  - **json timestamp** : ``2023-03-02 14:49:01``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'AppInfo',
    'DataSourceInfo',
    'ElementInfoDto',
    'FileInfoVo',
    'GroupInfoDto',
    'GroupUserVo',
    'ModuleElementInfoForm',
    'ModuleQuoteAddDto',
    'ModuleRegisterStatusAndRegisterTimeVo',
    'ModuleStatusDto',
    'ModuleTypeVersionInfoDto',
    'Owner',
    'QueryAppRequestDTO',
    'QueryAppResponseDTO',
    'QuoteForceRelationVo',
    'SingleGroupVo',
    'SpAppInfo',
    'SpAppInfoAddDto',
    'SpAppInfoUpdateDto',
    'SpAppInfoVo',
    'SpAppJdbcInfoVo',
    'SpFileBusinessRecordSaveDto',
    'SpModlueRegisterStausUsableVo',
    'SpModuleAutoCreateRelationVo',
    'SpModuleInfoPageVo',
    'SpModuleRegisterDetailVo',
    'SpModuleRegisterInfoDto',
    'SpModuleRegisterInfoUpdateDto',
    'SpModuleRegisterRelationVo',
    'SpModuleRegisterResultVo',
    'SpaceAppDto',
    'UserExistVo',
    'UserGroupAssociation',
    'UserInfoVo',
    'UserSearchDto',
    'UserUpdateDto',
    'UserVo',
    'AppDto',
    'GroupUserDto',
    'ModuleRegisterAndQuoteDto',
    'SpaceDto',
    'GroupInfoVo',
    'SingleUserVo',
    'GroupVo',
    'UserAndGroupDto',
    'UserGroupInfoVo'
]


class AppInfo(BaseModel):
    """App Info

    .. admonition:: 引用接口

        - **GET** ``/api/space/app/query-app-info-list/by-space-id`` (Response: 200)
    """
    #: app名称
    appName: Optional[str] = None
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str] = None
    #: appId
    id: Optional[str] = None


class DataSourceInfo(BaseModel):
    """Data Source Info

    .. admonition:: 引用接口

        - **GET** ``/get-app-datasource`` (Response: 200)
    """
    #: 驱动类
    driverClassName: Optional[str] = None
    #: database的连接地址
    jdbcUrl: Optional[str] = None
    #: 最大连接池
    maximumPoolSize: Optional[int] = None
    #: 密码
    password: Optional[str] = None
    #: 用户名
    username: Optional[str] = None


class ElementInfoDto(BaseModel):
    #: 是否分配过权限
    allocationPermission: Optional[bool] = None
    #: 业务数据标记，true: 带业务数据，false: 不带业务数据
    businessDataFlag: Optional[bool] = None
    #: 确认标记
    confirm: Optional[bool] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建者
    createUser: Optional[str] = None
    #: 错误标记
    elError: Optional[bool] = None
    #: 平台元素错误标记
    elOsError: Optional[bool] = None
    #: 警告标记
    elWarning: Optional[int] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 元素子类型
    elementTypeChild: Optional[str] = None
    #: 文件夹id
    folderId: Optional[str] = None
    #: 文件夹名称
    folderName: Optional[str] = None
    #: 元素路径
    fullPath: Optional[str] = None
    #: 元素id
    id: Optional[str] = None
    #: 修改时间
    modifyTime: Optional[str] = None
    #: 修改者
    modifyUser: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 启用继承权限标识
    openExtend: Optional[bool] = None
    #: 元素实例打开路径
    openPath: Optional[str] = None
    #: 启用公开权限标识
    openPermission: Optional[bool] = None
    #: 权限值
    permission: Optional[int] = None
    #: 组件服务名
    serverName: Optional[str] = None
    #: 状态
    status: Optional[bool] = None
    #: 系统标识
    systemTag: Optional[bool] = None


class FileInfoVo(BaseModel):
    """File Info Vo

    .. admonition:: 引用接口

        - **POST** ``/file-info/add``
        - **GET** ``/file-info/find-by-id`` (Response: 200)
    """
    #: 创建用户
    createUser: Optional[str] = None
    #: 文件描述
    fileDescription: str
    #: 文件名
    fileName: str
    #: 文件大小
    fileSize: int
    #: 类型
    fileType: str
    #: id
    id: str
    #: 路径
    url: str


class GroupInfoDto(BaseModel):
    """Group Info Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/group-info/add-group``
        - **POST** ``/api/space/group-info/update``
    """
    #: 用户组多语种描述
    groupDes: Optional[Any] = None
    #: 用户id,编辑时使用
    groupInfoId: Optional[str] = None
    #: 用户组名
    groupName: str
    #: 父级用户组id
    parentId: Optional[str] = None
    #: 用户组状态
    status: Optional[str] = None
    #: 包含的用户id
    userIds: Optional[List[str]] = None


class GroupUserVo(BaseModel):
    #: 是否管理员标识(SPACE_ADMIN为管理员,非管理员时该值为空)
    adminTag: Optional[str] = None
    #: 头像
    avatar: Optional[str] = None
    #: 邮箱
    email: Optional[str] = None
    #: 手机号
    mobilePhone: Optional[str] = None
    #: 昵称
    nickName: Optional[str] = None
    #: 状态
    status: Optional[str] = None
    #: 用户id
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None


class ModuleElementInfoForm(BaseModel):
    """Module Element Info Form

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/use/elements`` (Response: 200)
    """
    #: 元素类型
    elementType: Optional[str] = None
    #: 组件名称
    elementTypeName: Optional[str] = None
    #: 组件元素id生产规则:0.自定义拼接 1.组件注册登记
    idGenerateType: Optional[int] = None
    #: 组件元素id
    moduleElementId: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None


class ModuleQuoteAddDto(BaseModel):
    """Module Quote Add Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/quote-relation/add``
        - **POST** ``/api/space/module/quote-relation/batch-add``
    """
    #: 协议号
    protocolSplitJoint: str
    #: 组件需要引用对象
    quoteByModuleId: str
    #: 创建的默认引用元素对象
    quoteTargetElementId: str
    #: 创建的默认引用对象
    quoteTargetModuleId: str


class ModuleRegisterStatusAndRegisterTimeVo(BaseModel):
    """Module Register Status And Register Time Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/register/status`` (Response: 200)
    """
    #: 是否缺少强制依赖
    coercionLack: Optional[bool] = None
    #: 缺少强制依赖描述
    lackReason: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 系统组件/自定义组件
    moduleTag: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None
    #: 注册时间
    registerTime: Optional[str] = None
    #: 空间id
    spaceId: Optional[str] = None
    #: 状态1：启用;2：未启用
    status: Optional[int] = None


class ModuleStatusDto(BaseModel):
    """Module Status Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/status``
    """
    #: 注册的组件Id
    moduleId: str
    #: 状态 1：启用，2：不启用
    status: int


class ModuleTypeVersionInfoDto(BaseModel):
    """Module Type Version Info Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/register-assign-module``
    """
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None


class Owner(BaseModel):
    #: avatar
    avatar: Optional[str] = None
    #: email
    email: Optional[str] = None
    #: nickname
    nickname: Optional[str] = None
    #: userName
    userName: Optional[str] = None


class QueryAppRequestDTO(BaseModel):
    """Query App Request DTO

    .. admonition:: 引用接口

        - **POST** ``/app-list``
    """
    #: 应用id列表
    appIds: Optional[List[str]] = None
    #: 应用名称模糊查询条件
    dimName: Optional[str] = None


class QueryAppResponseDTO(BaseModel):
    """Query App Response DTO

    .. admonition:: 引用接口

        - **POST** ``/app-list`` (Response: 200)
    """
    #: 应用id
    appId: Optional[str] = None
    #: 应用名称
    appName: Optional[str] = None


class QuoteForceRelationVo(BaseModel):
    #: 是否自动创建协议
    autoCreateProtocols: Optional[List[str]] = None
    #: 创建组件列表
    createModuleElements: Optional[Any] = None
    #: 创建组件列表
    createModules: Optional[Any] = None
    #: 组件元素列表
    elements: Optional[Any] = None
    #: 组件列表
    modules: Optional[Any] = None


class SingleGroupVo(BaseModel):
    """Single Group Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/group-info/query`` (Response: 200)
    """
    #: 所有语种描述
    groupDes: Optional[Any] = None
    #: 当前语种描述
    groupDesc: Optional[str] = None
    #: 用户组名称
    groupName: Optional[str] = None
    #: 用户组id
    id: Optional[str] = None
    #: 用户组状态
    status: Optional[str] = None
    #: 用户组类型
    type: Optional[str] = None
    #: 包含的用户
    userList: Optional[List[GroupUserVo]] = None


class SpAppInfo(BaseModel):
    """Sp App Info

    .. admonition:: 引用接口

        - **POST** ``/app-info`` (Response: 200)
    """
    #: app名称
    appName: Optional[str] = None
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str] = None
    #: 创建人
    createUser: Optional[str] = None
    #: 是否默认数据源标识
    customDataSource: bool
    #: 是否默认logo标识
    customLogo: Optional[bool] = None
    #: 数据库名
    dbName: Optional[str] = None
    #: 描述
    description: Optional[str] = None
    #: icon图标地址
    icon: Optional[str] = None
    #: appId
    id: Optional[str] = None
    #: 数据库连接头信息
    jdbcHeader: Optional[str] = None
    #: 数据库连接密码
    jdbcPassword: Optional[str] = None
    #: database的连接类型
    jdbcType: Optional[str] = None
    #: jdbc连接地址其它信息如时区，编码等
    jdbcUrl: Optional[str] = None
    #: 默认启用，1：启用，2：不启用
    jdbcUrlOthers: Optional[str] = None
    #: 数据库连接账号
    jdbcUserName: Optional[str] = None
    #: 空间logo路径
    logoPath: Optional[str] = None
    #: 端口
    port: Optional[int] = None
    #: 是否删除：0:使用 1:回收站中 2:已删除
    recycleBin: Optional[bool] = None
    #: 空间id
    spaceId: Optional[str] = None
    #: 状态
    status: Optional[str] = None


class SpAppInfoAddDto(BaseModel):
    """Sp App Info Add Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/app/add``
    """
    #: app名称
    appName: str
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str] = None
    #: app地址
    appUrl: Optional[str] = None
    #: 是否默认数据源标识 是：true/否：false
    customDataSource: bool
    #: 是否自定义logo标识 是：true/否：false
    customLogo: bool
    #: 数据库名
    dbName: Optional[str] = None
    #: app描述
    description: Optional[str] = None
    #: jdbc密码
    jdbcPassword: Optional[str] = None
    #: 数据库类型，不填默认使用空间地址
    jdbcType: Optional[str] = None
    #: database的连接地址
    jdbcUrl: Optional[str] = None
    #: jdbc后缀参数地址
    jdbcUrlOthers: Optional[str] = None
    #: jdbc用户名
    jdbcUserName: Optional[str] = None
    #: 空间logo路径
    logoPath: Optional[str] = None
    #: 端口
    port: Optional[int] = None


class SpAppInfoUpdateDto(BaseModel):
    """Sp App Info Update Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/app/update``
    """
    #: app名称
    appName: str
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str] = None
    #: 外部应用app地址
    appUrl: Optional[str] = None
    #: app描述
    description: Optional[str] = None
    #: appId
    id: str
    #: 空间logo路径
    logoPath: Optional[str] = None


class SpAppInfoVo(BaseModel):
    """Sp App Info Vo

    .. admonition:: 引用接口

        - **POST** ``/api/space/app/all`` (Response: 200)
    """
    #: app名称
    appName: Optional[str] = None
    #: app类型 OUTSIDE/DEEPFOS
    appType: Optional[str] = None
    #: 外部应用app地址
    appUrl: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人id
    createUser: Optional[str] = None
    #: 是否默认数据源标识
    customDataSource: bool
    #: 数据库名
    dbName: Optional[str] = None
    #: 描述
    description: Optional[str] = None
    #: icon图标地址
    icon: Optional[str] = None
    #: id
    id: Optional[str] = None
    #: database的连接类型
    jdbcType: Optional[str] = None
    #: jdbc连接地址
    jdbcUrl: Optional[str] = None
    #: 其它信息如时区，编码等
    jdbcUrlOthers: Optional[str] = None
    #: 数据库连接账号
    jdbcUserName: Optional[str] = None
    #: 空间logo路径
    logoPath: Optional[str] = None
    #: 修改时间
    modifyTime: Optional[str] = None
    #: 修改人id
    modifyUser: Optional[str] = None
    #: 所有者
    owner: Optional[Owner] = None
    #: 用户app权限
    permissions: Optional[List[str]] = None
    #: 端口
    port: Optional[int] = None
    #: 状态,默认1
    status: Optional[str] = None
    #: 状态名
    statusName: Optional[str] = None


class SpAppJdbcInfoVo(BaseModel):
    """Sp App Jdbc Info Vo

    .. admonition:: 引用接口

        - **GET** ``/internal/space/app/jdbc`` (Response: 200)
    """
    #: 数据库密码
    jdbcPassword: Optional[str] = None
    #: 数据库端口
    jdbcPort: Optional[int] = None
    #: jdbc类型
    jdbcType: Optional[str] = None
    #: jdbcURL
    jdbcUrl: Optional[str] = None
    #: 数据库连接其他信息
    jdbcUrlOthers: Optional[str] = None
    #: 数据库名
    jdbcUserName: Optional[str] = None


class SpFileBusinessRecordSaveDto(BaseModel):
    """Sp File Business Record Save Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/file/business/record/save``
        - **POST** ``/api/space/file/business/record/update``
    """
    #: 应用id：空值时为-1
    app: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 失败日志文id
    failLogFileId: Optional[str] = None
    #: 文件描述(同文件名后缀格式)
    fileDescription: Optional[str] = None
    #: 文件id
    fileId: Optional[str] = None
    #: 文件名
    fileName: str
    #: 文件大小
    fileSize: float
    #: 记录主键id(仅在更新文件时需要)
    id: Optional[str] = None
    #: 最后一次下载时间
    lastDownloadTime: Optional[str] = None
    #: 操作类型
    opeType: Optional[str] = None
    #: 操作类型描述
    opeTypeDesc: Optional[str] = None
    #: 生成文件进度百分比
    percentage: Optional[int] = None
    #: 空间id：空值时为-1
    space: Optional[str] = None
    #: 状态
    status: Optional[str] = None
    #: 文件大小单位
    unit: str


class SpModlueRegisterStausUsableVo(BaseModel):
    """Sp Modlue Register Staus Usable Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/register/coercion-lack/check-usable-batch`` (Response: 200)
    """
    #: 是否缺少强制依赖
    coercionLack: Optional[bool] = None
    #: 组件Id
    moduleId: Optional[str] = None
    #: 状态
    status: Optional[bool] = None
    #: 是否可用
    usable: Optional[bool] = None


class SpModuleAutoCreateRelationVo(BaseModel):
    """Sp Module Auto Create Relation Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/quote-relation/server-name`` (Response: 200)
    """
    #: 元素Id
    moduleElementId: Optional[str] = None
    #: 元素名
    moduleElementName: Optional[str] = None
    #: 元素类型
    moduleElementType: Optional[str] = None
    #: 元素版本
    moduleElementVersion: Optional[str] = None
    #: 组件Id
    moduleId: Optional[str] = None
    #: 组件名
    moduleName: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class SpModuleInfoPageVo(BaseModel):
    """Sp Module Info Page Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/all/list`` (Response: 200)
    """
    #: 是否缺少强制依赖
    coercionLack: Optional[bool] = None
    #: 是否注册
    hasRegister: Optional[bool] = None
    #: 组件id
    id: Optional[int] = None
    #: 缺少强制依赖描述
    lackReason: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 系统组件/自定义组件
    moduleTag: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None
    #: 注册时间
    registerTime: Optional[str] = None
    #: 空间id
    space: Optional[str] = None
    #: 状态
    status: Optional[int] = None
    #: 状态名
    statusName: Optional[str] = None


class SpModuleRegisterDetailVo(BaseModel):
    """Sp Module Register Detail Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/detail`` (Response: 200)
        - **GET** ``/api/space/module/detail/list`` (Response: 200)
        - **GET** ``/api/space/module/register-list/usable`` (Response: 200)
        - **GET** ``/api/space/module/register-list/usable/coercion-lack`` (Response: 200)
    """
    #: 组件分类code
    categoryCode: Optional[str] = None
    #: 组件分类描述
    categoryName: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人
    createUser: Optional[str] = None
    #: 元素类型icon
    elementIcon: Optional[str] = None
    #: 元素登记注册状态
    elementStatus: Optional[int] = None
    #: 组件对应的元素类型
    elementType: Optional[str] = None
    #: 组件对应的元素类型名称
    elementTypeName: Optional[str] = None
    #: 主键
    id: Optional[int] = None
    #: 元素id生产类别
    idGenerateType: Optional[int] = None
    #: 修改时间
    modifyTime: Optional[str] = None
    #: 修改人
    modifyUser: Optional[int] = None
    #: 元素Id
    moduleElementId: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 组件标签
    moduleTag: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None
    #: 一级分类CODE
    parentCode: Optional[str] = None
    #: 注册时间
    registerTime: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None
    #: 空间id
    space: Optional[str] = None
    #: 状态
    status: Optional[int] = None
    #: 状态名
    statusName: Optional[str] = None


class SpModuleRegisterInfoDto(BaseModel):
    """Sp Module Register Info Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/register``
    """
    #: 注册的组件Id
    moduleId: str
    #: 状态 1：启用，2：不启用
    status: Optional[int] = None


class SpModuleRegisterInfoUpdateDto(BaseModel):
    """Sp Module Register Info Update Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/app/update-module-register-info/by-module-id``
    """
    #: 组件id
    moduleId: str
    #: 组件名称
    moduleName: str


class SpModuleRegisterRelationVo(BaseModel):
    """Sp Module Register Relation Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/module/relation-all`` (Response: 200)
        - **GET** ``/api/space/module/unregister/relation-all`` (Response: 200)
    """
    #: 强依赖
    quoteForce: Optional[QuoteForceRelationVo] = None
    #: 非强依赖
    quoteNotForce: Optional[Any] = None


class SpModuleRegisterResultVo(BaseModel):
    """Sp Module Register Result Vo

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/batch/module-element-register`` (Response: 200)
        - **POST** ``/api/space/module/batch/quote-relation-register`` (Response: 200)
        - **POST** ``/api/space/module/register`` (Response: 200)
    """
    #: 失败Element列表
    failedElementList: Optional[List[str]] = None
    #: 失败moduleId列表
    failedList: Optional[List[str]] = None
    #: 成功Element列表
    successElementList: Optional[List[str]] = None
    #: 成功moduleId列表
    successList: Optional[List[str]] = None


class SpaceAppDto(BaseModel):
    """Space App Dto

    .. admonition:: 引用接口

        - **GET** ``/api/space/app/all/list`` (Response: 200)
    """
    #: 应用ID
    appId: Optional[str] = None
    #: 创建人
    createUser: Optional[str] = None
    #: 数据库名
    dbName: Optional[str] = None
    #: 空间ID
    spaceId: Optional[str] = None


class UserExistVo(BaseModel):
    """User Exist Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/user-info/check-user-exist/batch`` (Response: 200)
    """
    #: 空间存在标识
    existTag: Optional[bool] = None
    #: 状态
    status: Optional[str] = None
    #: 用户id
    userId: Optional[str] = None


class UserGroupAssociation(BaseModel):
    #: groupInfoId
    groupInfoId: Optional[str] = None
    #: userId
    userId: Optional[str] = None


class UserInfoVo(BaseModel):
    """User Info Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/user-info/all_enable_user`` (Response: 200)
        - **POST** ``/api/space/user-info/batch/query/by-user-ids`` (Response: 200)
        - **GET** ``/api/space/user-info/query/batch`` (Response: 200)
        - **GET** ``/api/space/user-info/query/batch/by-name`` (Response: 200)
        - **POST** ``/api/space/user-info/query/batch/by-user-ids`` (Response: 200)
    """
    #: 是否管理员标识
    adminTag: Optional[str] = None
    #: 头像
    avatar: Optional[str] = None
    #: 颜色
    color: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人
    createUser: Optional[str] = None
    #: 邮箱
    email: Optional[str] = None
    #: 员工是否离开企业 0 离开 1  未离开
    leave: Optional[int] = None
    #: 员工是否离开空间 0 离开 1  未离开
    leaveSpace: Optional[int] = None
    #: 手机号
    mobilePhone: Optional[str] = None
    #: 更新时间
    modifyTime: Optional[str] = None
    #: 更新用户
    modifyUser: Optional[str] = None
    #: 昵称
    nickName: Optional[str] = None
    #: 是否为sso用户
    ssoUser: Optional[bool] = None
    #: 状态
    status: Optional[str] = None
    #: 用户id
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None
    #: 用户名修改次数
    usernameModifyTimes: Optional[int] = None


class UserSearchDto(BaseModel):
    """User Search Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/user-info/search``
    """
    #: keyword
    keyword: Optional[str] = None
    #: scope
    scope: Optional[List[str]] = None


class UserUpdateDto(BaseModel):
    """User Update Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/user-info/update``
    """
    #: 管理员标识
    adminTag: Optional[str] = None
    #: 分配的用户组Id
    groupIds: Optional[List[str]] = None
    #: 用户状态
    status: Optional[str] = None
    #: 用户Id
    userId: str


class UserVo(BaseModel):
    """User Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/user-info/get-all-children-user-list/by-group`` (Response: 200)
        - **POST** ``/api/space/user-info/search`` (Response: 200)
    """
    #: 头像
    avatar: Optional[str] = None
    #: 颜色
    color: Optional[str] = None
    #: 邮箱
    email: Optional[str] = None
    #: 手机号
    mobilePhone: Optional[str] = None
    #: 昵称
    nickName: Optional[str] = None
    #: 是否为sso用户
    ssoUser: Optional[bool] = None
    #: 状态
    status: Optional[str] = None
    #: 用户id
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None
    #: 用户名修改次数
    usernameModifyTimes: Optional[int] = None


class AppDto(BaseModel):
    #: 应用id
    app: Optional[str] = None
    #: 应用名称
    appName: Optional[str] = None
    #: 元素基础信息列表
    elementInfoDtoList: Optional[List[ElementInfoDto]] = None


class GroupUserDto(BaseModel):
    """Group User Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/user-info/get-all-children-user-list/by-group-batch`` (Response: 200)
    """
    #: 用户组id
    groupId: Optional[str] = None
    #: 子级用户对象
    userInfoVOS: Optional[List[UserVo]] = None


class ModuleRegisterAndQuoteDto(BaseModel):
    """Module Register And Quote Dto

    .. admonition:: 引用接口

        - **POST** ``/api/space/module/batch/module-element-register``
        - **POST** ``/api/space/module/batch/quote-relation-register``
    """
    #: 默认新建组件
    moduleQuoteAddDto: Optional[List[ModuleQuoteAddDto]] = None
    #: 父组件信息
    parentModule: Optional[SpModuleRegisterInfoDto] = None
    #: 组件关系
    relationModuleList: Optional[List[SpModuleRegisterInfoDto]] = None


class SpaceDto(BaseModel):
    """Space Dto

    .. admonition:: 引用接口

        - **GET** ``/get-all-element`` (Response: 200)
    """
    #: 应用列表
    appDtoList: Optional[List[AppDto]] = None
    #: 空间id
    space: Optional[str] = None
    #: 空间名称
    spaceName: Optional[str] = None


class GroupInfoVo(BaseModel):
    """Group Info Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/group-info/query/batch`` (Response: 200)
        - **POST** ``/api/space/group-info/query/batch/by-group-ids`` (Response: 200)
    """
    #: 子用户组
    childrenGroup: Optional[List['GroupInfoVo']] = None
    #: 用户组编码
    groupCode: Optional[str] = None
    #: 当前语种描述
    groupDesc: Optional[str] = None
    #: 用户组名称
    groupName: Optional[str] = None
    #: 用户组id
    id: Optional[str] = None
    #: 父级用户组id
    parentId: Optional[str] = None
    #: 用户组状态
    status: Optional[str] = None
    #: 用户组类型
    type: Optional[str] = None


class SingleUserVo(BaseModel):
    """Single User Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/user-info/query`` (Response: 200)
    """
    #: 是否管理员标识
    adminTag: Optional[str] = None
    #: 是否为应用管理员
    appAdmin: Optional[bool] = None
    #: 头像
    avatar: Optional[str] = None
    #: 颜色
    color: Optional[str] = None
    #: 是否为应用开发者角色
    developerRole: Optional[bool] = None
    #: 邮箱
    email: Optional[str] = None
    #: 所属用户组id
    groupList: Optional[List[GroupInfoVo]] = None
    #: 手机号
    mobilePhone: Optional[str] = None
    #: 昵称
    nickName: Optional[str] = None
    #: 是否为空间管理员
    spaceAdmin: Optional[bool] = None
    #: 是否为sso用户
    ssoUser: Optional[bool] = None
    #: 状态
    status: Optional[str] = None
    #: 是否为系统管理员
    systemAdmin: Optional[bool] = None
    #: 用户id
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None
    #: 用户名修改次数
    usernameModifyTimes: Optional[int] = None


class GroupVo(BaseModel):
    #: 子用户组
    childrenGroup: Optional[List['GroupVo']] = None
    #: 当前语种描述
    groupDesc: Optional[str] = None
    #: 用户组名称
    groupName: Optional[str] = None
    #: 用户组id
    id: Optional[str] = None
    #: 父级用户组id
    parentId: Optional[str] = None
    #: status
    status: Optional[str] = None
    #: top
    top: Optional[bool] = None
    #: type
    type: Optional[str] = None


class UserAndGroupDto(BaseModel):
    """User And Group Dto

    .. admonition:: 引用接口

        - **GET** ``/api/space/group-info/get-user-group-all`` (Response: 200)
    """
    #: group
    group: Optional[List[GroupVo]] = None
    #: user
    user: Optional[List[UserGroupAssociation]] = None


class UserGroupInfoVo(BaseModel):
    """User Group Info Vo

    .. admonition:: 引用接口

        - **GET** ``/api/space/group-info/all`` (Response: 200)
        - **GET** ``/api/space/group-info/all_enable_group`` (Response: 200)
        - **GET** ``/api/space/group-info/all_enable_group_no_tree`` (Response: 200)
        - **GET** ``/api/space/group-info/query/batch/by-name`` (Response: 200)
    """
    #: 子用户组
    childrenGroup: Optional[List['UserGroupInfoVo']] = None
    #: 描述
    description: Optional[str] = None
    #: 用户组代码
    groupCode: Optional[str] = None
    #: 用户组名称
    groupName: Optional[str] = None
    #: 用户组id
    id: Optional[str] = None
    #: 层级
    level: Optional[int] = None
    #: 父级用户组id
    parentId: Optional[str] = None
    #: 用户组状态
    status: Optional[str] = None


GroupInfoVo.update_forward_refs()
GroupVo.update_forward_refs()
UserGroupInfoVo.update_forward_refs()
