"""
Models used by /system-server

generated by model_code_gen.py
  - **filename** : ``system.py``
  - **json timestamp** : ``2024-04-11 14:48:33``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field


__all__ = [
    'HikariDataSourceInfo',
    'InstallSysModuleUpgradeInfoDto',
    'JobContentDto',
    'JobCurrentDto',
    'MessageCountDto',
    'MessageDelDto',
    'MessageFormResultDTO',
    'MessageReceiverVO',
    'MessageTemplate',
    'MessageTemplateListQueryDto',
    'MessageTemplateParam',
    'MessageTemplateParamListQueryDto',
    'MessageTemplateParamVO',
    'ModuleElementInfoVO',
    'ModuleElementaryInfoVO',
    'ModuleExistVO',
    'ModuleInfo',
    'ModuleInfoDTO',
    'ModuleProtocolDTO',
    'ModuleServerVO',
    'MsgAttachmentDTO',
    'MsgPushBaseRequestVO',
    'MsgPushRequestAttachmentVO',
    'MessageTemplateParamResp',
    'ProtocolVersionDTO',
    'SHasAttachmentEmailDTO',
    'SendEmailResultVO',
    'SendPlatMsgResultVO',
    'SmsPushRequestVO',
    'SmsSingleSendDTO',
    'SpModuleOperateNoticeConfigDTO',
    'SpaceJdcbInfoVo',
    'SysModuleLanguageInfoDTO',
    'UpdateJobCurrentDto',
    'UserInfoVo',
    'EmailPushRequestVO',
    'InstallModuleDTO',
    'MessageCenter',
    'MessageTemplateDTO',
    'MessageTemplateListVO',
    'MsgPushHasAttachmentRequestVO',
    'MessageTemplateListVOResp',
    'SmsSendResultVO',
    'RegisterModuleElementVO',
    'ModuleProtocolVO',
    'RegisterModuleVO'
]


class HikariDataSourceInfo(BaseModel):
    """Hikari Data Source Info

    .. admonition:: 引用接口

        - **GET** ``/get-space-datasource`` (Response: 200)
    """
    #: driverClassName
    driverClassName: Optional[str] = None
    #: jdbcUrl
    jdbcUrl: Optional[str] = None
    #: maximumPoolSize
    maximumPoolSize: Optional[int] = None
    #: password
    password: Optional[str] = None
    #: username
    username: Optional[str] = None


class InstallSysModuleUpgradeInfoDto(BaseModel):
    #: 升级接口url POST
    api: str
    #: 该组件可以升级操作的版本
    version: str


class JobContentDto(BaseModel):
    #: 结束时间
    endTime: Optional[str] = None
    #: 作业明细名称英文
    jobContentNameEn: Optional[str] = None
    #: 作业明细名称中文
    jobContentNameZhcn: Optional[str] = None
    #: 作业明细名称繁体
    jobContentNameZhtw: Optional[str] = None
    #: 单个作业明细区分标识
    key: str
    #: 日志文本内容,内容长度限制1200个字符
    log: Optional[str] = None
    #: 开始时间
    startTime: Optional[str] = None
    #: 状态 WAIT：等待/GO：运行中/SUCCESS：成功/FAIL：失败/PART_FAIL：部分失败/STOP：暂停
    status: Optional[str] = None


class JobCurrentDto(BaseModel):
    """Job Current Dto

    .. admonition:: 引用接口

        - **POST** ``/job-content-list``
        - **POST** ``/job-create``
        - **POST** ``/job-current-list``
        - **POST** ``/job-update``
    """
    #: 作业取消等操作回调接口请求body
    callbackPostBody: Optional[str] = None
    #: 作业取消等操作回调接口请求url-内部项目使用：服务名为前缀格式，外部项目使用：http为前缀格式, 回调接口请求格式：post
    callbackUrl: Optional[str] = None
    #: 结束时间
    endTime: Optional[str] = None
    #: 作业完成提示
    endedMsg: Optional[str] = None
    #: 作业id,不指定则默认使用uuid
    id: Optional[str] = None
    #: jobContents
    jobContents: Optional[List[JobContentDto]] = None
    #: 作业名称英文
    jobNameEn: Optional[str] = None
    #: 作业名称中文
    jobNameZhcn: Optional[str] = None
    #: 作业名称繁体
    jobNameZhtw: Optional[str] = None
    #: 操作对象英文
    jobObjEn: Optional[str] = None
    #: 操作对象中文
    jobObjZhcn: Optional[str] = None
    #: 操作对象繁体
    jobObjZhtw: Optional[str] = None
    #: 日志文本内容, 内容长度限制1200个字符，过长已附件形式记录
    log: Optional[str] = None
    #: 日志附件id
    logFile: Optional[str] = None
    #: 进入队列时间
    readTime: Optional[str] = None
    #: 开始时间
    startTime: Optional[str] = None
    #: 创建作业成功提示
    startedMsg: Optional[str] = None
    #: 状态 WAIT:等待 / GO:运行中 / SUCCESS:成功 / FAIL:失败 / PART_FAIL:部分失败 / STOP:暂停 / CANCEL:取消 / DELETE:删除
    status: Optional[str] = None
    #: 超时时间（上一次更新时间开始计算）单位：s（最小10秒，小于10秒重制为10秒，为空不做超时处理）（go状态开始计时）
    timeOut: Optional[int] = None


class MessageCountDto(BaseModel):
    """Message Count Dto

    .. admonition:: 引用接口

        - **GET** ``/message-center/count`` (Response: 200)
    """
    #: messageCount
    messageCount: Optional[int] = None


class MessageDelDto(BaseModel):
    """Message Del Dto

    .. admonition:: 引用接口

        - **POST** ``/message-center/delete``
    """
    #: ids
    ids: Optional[List[str]] = None


class MessageFormResultDTO(BaseModel):
    #: content
    content: Optional[str] = None
    #: id
    id: Optional[int] = None
    #: sysTime
    sysTime: Optional[str] = None
    #: title
    title: Optional[str] = None
    #: type
    type: Optional[int] = None
    #: userId
    userId: Optional[str] = None


class MessageReceiverVO(BaseModel):
    #: 用户ID 或 分组ID
    id: str
    #: 用户USER/用户组GROUP
    type: str


class MessageTemplate(BaseModel):
    """Message Template

    .. admonition:: 引用接口

        - **POST** ``/message-template/add``
        - **POST** ``/message-template/update``
    """
    #: 模板内容
    content: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人
    createUser: Optional[str] = None
    #: 附件信息（json数组形式）
    fileContent: Optional[str] = None
    #: 自增主键
    id: Optional[int] = None
    #: 语言类别：当前空间已启用的多语言
    language: Optional[str] = None
    #: 修改时间
    modifyTime: Optional[str] = None
    #: 修改人
    modifyUser: Optional[str] = None
    #: 来源：1：自定义；2：预定义
    source: Optional[int] = None
    #: 空间ID
    spaceId: Optional[str] = None
    #: 状态： 1：已启用；2：未启用
    status: Optional[int] = None
    #: 模板编码
    templateCode: Optional[str] = None
    #: 模板名称
    templateName: Optional[str] = None
    #: 模板标题
    title: Optional[str] = None
    #: 模板类别：1：平台公告；2：站内消息；3：短信；4：邮箱；
    type: Optional[int] = None
    #: 消息有效天数（0即永久有效）
    validDays: Optional[int] = None
    #: 是否开启有效天数（1 启用 2 不启用）
    validDaysEnable: Optional[int] = None


class MessageTemplateListQueryDto(BaseModel):
    """Message Template List Query Dto

    .. admonition:: 引用接口

        - **POST** ``/message-template/page``
    """
    #: 创建人
    createUsers: Optional[List[str]] = None
    #: 创建时间-结束时间
    endCreate: Optional[str] = None
    #: 搜索关键字
    keyword: Optional[str] = None
    #: 分页页数 默认第1页
    pageNum: Optional[int] = None
    #: 分页展示条数 默认10条
    pageSize: Optional[int] = None
    #: 创建时间-开始时间
    startCreate: Optional[str] = None
    #: 状态： 1：已启用；2：未启用
    status: Optional[int] = None
    #: 模板编码
    templateCode: Optional[str] = None
    #: 模板名称
    templateName: Optional[str] = None
    #: 模板类别：1：平台公告；2：站内消息；3：短信；4：邮箱；
    types: Optional[List[int]] = None


class MessageTemplateParam(BaseModel):
    #: 参数描述
    desc: Optional[str] = None
    #: 自增主键
    id: Optional[int] = None
    #: 消息模板ID
    messageTemplateId: int
    #: 参数名称
    paramName: str
    #: 所属范围（1：标题，2：内容）
    scope: int


class MessageTemplateParamListQueryDto(BaseModel):
    """Message Template Param List Query Dto

    .. admonition:: 引用接口

        - **POST** ``/message-template/get-template-param``
    """
    #: 分页页数 默认第1页
    pageNum: Optional[int] = None
    #: 分页展示条数 默认10条
    pageSize: Optional[int] = None
    templateId: int


class MessageTemplateParamVO(BaseModel):
    """Message Template Param VO

    .. admonition:: 引用接口

        - **GET** ``/message-service/message-template-param`` (Response: 200)
    """
    #: 参数描述
    desc: Optional[str] = None
    #: 参数名称
    paramName: str
    #: 参数值
    paramValue: str
    #: 所属范围（1：标题，2：内容）
    scope: int


class ModuleElementInfoVO(BaseModel):
    #: 是否应用初始化标识
    appInitTag: Optional[bool] = None
    #: 组件名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 元素版本
    elementVersion: Optional[str] = None
    #: 组件元素id生产规则:0.自定义拼接 1.组件注册登记
    idGenerateType: Optional[int] = None
    #: 组件元素id
    moduleElementId: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 组件标签，系统或者自定义
    moduleTag: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None


class ModuleElementaryInfoVO(BaseModel):
    """Module Elementary Info VO

    .. admonition:: 引用接口

        - **GET** ``/module/module-elementary-info`` (Response: 200)
    """
    #: 初始化应用标识
    appInitTag: Optional[bool] = None
    #: 存放前端组件路径，区分同一服务多个组件的场景
    childPath: Optional[str] = None
    #: 创建路径
    createPath: Optional[str] = None
    #: 编辑路径
    editPath: Optional[str] = None
    #: elementType
    elementType: Optional[str] = None
    #: iframe地址
    iframeUrl: Optional[str] = None
    #: 元素Id
    moduleElementId: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 组件标记
    moduleTag: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None
    #: 打开路径
    openPath: Optional[str] = None
    #: 组件服务名
    serverName: Optional[str] = None


class ModuleExistVO(BaseModel):
    """Module Exist VO

    .. admonition:: 引用接口

        - **POST** ``/module/judge-module-exist`` (Response: 200)
    """
    #: 是否应用初始化标识
    appInitTag: Optional[bool] = None
    #: exist
    exist: Optional[bool] = None
    #: 组件id生产规则:0,自动拼接 1.登记指定
    idGenerateType: Optional[int] = None
    #: 包含的元素类型
    moduleElementInfos: Optional[List[ModuleElementInfoVO]] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 组件标签，系统或者自定义
    moduleTag: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None


class ModuleInfo(BaseModel):
    """Module Info

    .. admonition:: 引用接口

        - **GET** ``/log/query-obj-name`` (Response: 200)
        - **POST** ``/module/query-module-name``
        - **POST** ``/module/query-module-name`` (Response: 200)
    """
    #: 组件名称
    moduleName: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None


class ModuleInfoDTO(BaseModel):
    """Module Info DTO

    .. admonition:: 引用接口

        - **GET** ``/module/module-info-list`` (Response: 200)
    """
    #: 创建路径
    createPath: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人
    createUser: Optional[str] = None
    #: 描述
    description1: Optional[str] = None
    #: 编辑路径
    editPath: Optional[str] = None
    #: 组件元素类型
    elementType: Optional[str] = None
    #: iframe地址
    iframeUrl: Optional[str] = None
    #: 菜单路径
    menuPath: Optional[str] = None
    #: 修改时间
    modifyTime: Optional[str] = None
    #: 修改人
    modifyUser: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 组件标记
    moduleTag: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None
    #: 打开路径
    openPath: Optional[str] = None


class ModuleProtocolDTO(BaseModel):
    #: 使用的协议是否为强制依赖
    mandatoryDependence: bool
    #: 协议号
    protocol: str
    #: 协议版本
    protocolVersion: str


class ModuleServerVO(BaseModel):
    """Module Server VO

    .. admonition:: 引用接口

        - **POST** ``/module/get-server-name`` (Response: 200)
        - **POST** ``/module/get-server-name-for-elements`` (Response: 200)
        - **POST** ``/module/get-server-name-target`` (Response: 200)
    """
    #: 元素类型
    elementType: Optional[str] = None
    #: id生产类型
    idGenerateType: Optional[int] = None
    #: moduleElementId
    moduleElementId: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class MsgAttachmentDTO(BaseModel):
    #: 文件名
    fileName: str
    #: 附件大小
    fileSize: Optional[str] = None
    #: 文件类型
    fileType: Optional[str] = None
    #: 文件下载id
    id: str
    #: 空间ID
    space: Optional[str] = None
    #: 文件url地址
    url: Optional[str] = None


class MsgPushBaseRequestVO(BaseModel):
    """Msg Push Base Request VO

    .. admonition:: 引用接口

        - **POST** ``/message-service/push-plat-notice``
        - **POST** ``/message-service/push-sms-message``
    """
    #: 模板参数
    params: Optional[List[MessageTemplateParamVO]] = None
    #: 接收对象（用户/用户组）
    receiver: List[MessageReceiverVO]
    #: 发送人
    sender: Optional[str] = None
    #: 模板编码
    templateCode: str


class MsgPushRequestAttachmentVO(BaseModel):
    #: 文件id
    id: str
    #: 空间ID
    space: str


class MessageTemplateParamResp(BaseModel):
    """Page Bean«Message Template Param»

    .. admonition:: 引用接口

        - **POST** ``/message-template/get-template-param`` (Response: 200)
    """
    #: list
    list: Optional[List[MessageTemplateParam]] = None
    #: 总页数
    pages: Optional[int] = None
    #: 总记录条数
    total: Optional[int] = None


class ProtocolVersionDTO(BaseModel):
    #: 协议号
    protocol: str
    #: 协议版本
    protocolVersion: str


class SHasAttachmentEmailDTO(BaseModel):
    #: attachments
    attachments: Optional[List[MsgAttachmentDTO]] = None
    #: ccEmail
    ccEmail: Optional[str] = None
    #: content
    content: Optional[str] = None
    #: subject
    subject: Optional[str] = None
    #: toEmail
    toEmail: Optional[str] = None


class SendEmailResultVO(BaseModel):
    """Send Email Result VO

    .. admonition:: 引用接口

        - **POST** ``/message-service/push-email-message`` (Response: 200)
        - **POST** ``/message-service/send-email`` (Response: 200)
    """
    #: failure
    failure: Optional[List[SHasAttachmentEmailDTO]] = None
    #: success
    success: Optional[List[SHasAttachmentEmailDTO]] = None


class SendPlatMsgResultVO(BaseModel):
    """Send Plat Msg Result VO

    .. admonition:: 引用接口

        - **POST** ``/message-service/push-plat-notice`` (Response: 200)
        - **POST** ``/message-service/push-station-message`` (Response: 200)
    """
    #: failure
    failure: Optional[List[MessageFormResultDTO]] = None
    #: success
    success: Optional[List[MessageFormResultDTO]] = None


class SmsPushRequestVO(BaseModel):
    """Sms Push Request VO

    .. admonition:: 引用接口

        - **POST** ``/message-service/send-sms``
    """
    #: 模板参数
    params: Optional[List[MessageTemplateParamVO]] = None
    #: 手机号
    receiver: List[str]
    #: 发送人
    sender: Optional[str] = None
    #: 模板编码
    templateCode: str


class SmsSingleSendDTO(BaseModel):
    #: content
    content: Optional[str] = None
    #: errorMsg
    errorMsg: Optional[str] = None
    #: phone
    phone: Optional[str] = None


class SpModuleOperateNoticeConfigDTO(BaseModel):
    """Sp Module Operate Notice Config DTO

    .. admonition:: 引用接口

        - **GET** ``/module/getOperateNoticeConfigByModuleIds`` (Response: 200)
        - **GET** ``/module/getOperateNoticeConfigByOperate`` (Response: 200)
        - **GET** ``/module/getOperateNoticeConfigByParam`` (Response: 200)
    """
    #: 操作类型，注册MODULE_REGISTER/应用创建APP_CREATE/元素删除ELEMENT_REMOVE/元素复制ELEMENT_COPY/元素导入ELEMENT_IMPORT/元素导出ELEMENT_EXPORT/元素移动ELEMENT_MOVE
    operate: Optional[str] = None
    #: 同步SYNC 异步ASYNC
    syncOrAsyn: Optional[str] = None
    #: 前置FRONT/后置REAR
    type: Optional[str] = None
    #: 接口url，固定post接口
    url: Optional[str] = None


class SpaceJdcbInfoVo(BaseModel):
    """Space Jdcb Info Vo

    .. admonition:: 引用接口

        - **GET** ``/space-datasource/detail`` (Response: 200)
    """
    #: 数据库连接url
    databaseUrl: Optional[str] = None
    #: 数据库名称
    dbName: Optional[str] = None
    #: 数据库连接头
    jdbcHeader: Optional[str] = None
    #: 数据库密码
    jdbcPassword: Optional[str] = None
    #: 数据库类型
    jdbcType: Optional[str] = None
    #: 数据库连接设置信息
    jdbcUrlOthers: Optional[str] = None
    #: 数据库账号
    jdbcUserName: Optional[str] = None
    #: 数据库端口号
    port: Optional[str] = None


class SysModuleLanguageInfoDTO(BaseModel):
    #: 组件默认语言
    moduleLanguageDefault: Optional[str] = None
    #: 组件支持的语言列表
    moduleLanguageList: Optional[List[str]] = None


class UpdateJobCurrentDto(BaseModel):
    #: 作业取消等操作回调接口请求body
    callbackPostBody: Optional[str] = None
    #: 作业取消等操作回调接口请求url-内部项目使用：服务名为前缀格式，外部项目使用：http为前缀格式, 回调接口请求格式：post
    callbackUrl: Optional[str] = None
    #: 结束时间
    endTime: Optional[str] = None
    #: 作业完成提示
    endedMsg: Optional[str] = None
    #: 作业id
    id: str
    #: jobContents
    jobContents: Optional[List[JobContentDto]] = None
    #: 作业名称英文
    jobNameEn: Optional[str] = None
    #: 作业名称中文
    jobNameZhcn: Optional[str] = None
    #: 作业名称繁体
    jobNameZhtw: Optional[str] = None
    #: 操作对象英文
    jobObjEn: Optional[str] = None
    #: 操作对象中文
    jobObjZhcn: Optional[str] = None
    #: 操作对象繁体
    jobObjZhtw: Optional[str] = None
    #: 日志文本内容
    log: Optional[str] = None
    #: 日志附件id
    logFile: Optional[str] = None
    #: 开始时间
    startTime: Optional[str] = None
    #: 状态 WAIT:等待 / GO:运行中 / SUCCESS:成功 / FAIL:失败 / PART_FAIL:部分失败 / STOP:暂停 / CANCEL:取消 / DELETE:删除
    status: Optional[str] = None
    #: 超时时间（上一次更新时间开始计算）单位：s（最小10秒，小于10秒重制为10秒，为空不做超时处理）（go状态开始计时）
    timeOut: Optional[int] = None


class UserInfoVo(BaseModel):
    """User Info Vo

    .. admonition:: 引用接口

        - **POST** ``/user/get-user-detail-list`` (Response: 200)
        - **GET** ``/user/get-userdetail`` (Response: 200)
        - **POST** ``/user/query/batch/by-user-ids-post`` (Response: 200)
    """
    #: 是否管理员标识
    adminTag: Optional[str] = None
    #: 头像
    avatar: Optional[str] = None
    #: 颜色
    color: Optional[str] = None
    #: 邮箱
    email: Optional[str] = None
    #: 员工是否离开企业 0 离开 1  未离开
    leave: Optional[int] = None
    #: 员工是否离开空间 0 离开 1  未离开
    leaveSpace: Optional[int] = None
    #: 手机号
    mobilePhone: Optional[str] = None
    #: 昵称
    nickName: Optional[str] = None
    #: 状态
    status: Optional[str] = None
    #: 用户id
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None


class EmailPushRequestVO(BaseModel):
    """Email Push Request VO

    .. admonition:: 引用接口

        - **POST** ``/message-service/send-email``
    """
    #: 附件
    attachment: Optional[List[MsgPushRequestAttachmentVO]] = None
    #: 抄送人邮箱
    ccEmail: Optional[List[str]] = None
    #: 模板参数
    params: Optional[List[MessageTemplateParamVO]] = None
    #: 收件人邮箱
    receiver: List[str]
    #: 发送人
    sender: Optional[str] = None
    #: 模板编码
    templateCode: str


class InstallModuleDTO(BaseModel):
    """Install Module DTO

    .. admonition:: 引用接口

        - **POST** ``/module/install-module``
        - **POST** ``/module/multi-install-module``
    """
    #: 应用初始化标识
    appInitTag: Optional[bool] = None
    #: 自动创建时使用协议集合
    autoUseProtocol: List[ProtocolVersionDTO]
    #: 存放前端组件路径，区分同一服务多个组件的场景
    childPath: Optional[str] = None
    #: 组件元素实例创建路径
    createPath: Optional[str] = None
    #: 组件依赖的数据源，多个逗号隔开
    dependencyDatasource: Optional[str] = None
    #: 组件说明
    description1: str
    #: 组件元素实例编辑路径
    editPath: Optional[str] = None
    #: iframe地址
    iframeUrl: Optional[str] = None
    #: 组件支持和默认语言信息
    moduleLanguageInfo: Optional[SysModuleLanguageInfoDTO] = None
    #: 组件名称（废弃）
    moduleName: str
    #: 平台国际化
    moduleNames: Any
    #: 组件标签：系统平台或空间所属 SYSTEM/CUSTOM
    moduleTag: str
    #: 组件类型
    moduleType: str
    #: 组件版本
    moduleVersion: str
    #: 组件元素实例打开路径
    openPath: Optional[str] = None
    #: 组件操作前置后置通知配置信息
    operateNoticeConfig: Optional[List[SpModuleOperateNoticeConfigDTO]] = None
    #: 支持的协议集合
    protocolList: List[ProtocolVersionDTO]
    #: 组件对应服务名称
    serverName: str
    #: 空间id
    spaceId: Optional[str] = None
    #: 组件升级信息
    upgradeInfo: Optional[List[InstallSysModuleUpgradeInfoDto]] = None
    #: 使用的协议集合
    useProtocolList: List[ModuleProtocolDTO]


class MessageCenter(BaseModel):
    """Message Center

    .. admonition:: 引用接口

        - **GET** ``/message-center/get-platform-message`` (Response: 200)
        - **GET** ``/message-center/message-info`` (Response: 200)
    """
    #: app
    app: Optional[str] = None
    #: attachment
    attachment: Optional[str] = None
    #: attachmentList
    attachmentList: Optional[List[MsgAttachmentDTO]] = None
    #: closedStatus
    closedStatus: Optional[int] = None
    #: content
    content: Optional[str] = None
    #: expiresTime
    expiresTime: Optional[str] = None
    #: id
    id: Optional[str] = None
    #: messageId
    messageId: Optional[str] = None
    #: 用户昵称
    nickName: Optional[str] = None
    #: sendTime
    sendTime: Optional[str] = None
    #: sendUser
    sendUser: Optional[str] = None
    #: space
    space: Optional[str] = None
    #: status
    status: Optional[int] = None
    #: textContent
    textContent: Optional[str] = None
    #: timeDif
    timeDif: Optional[int] = None
    #: title
    title: Optional[str] = None
    #: type
    type: Optional[int] = None
    #: userId
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None


class MessageTemplateDTO(BaseModel):
    #: 模板内容
    content: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人
    createUser: Optional[str] = None
    #: 附件信息（json数组形式）
    fileContent: Optional[str] = None
    #: 自增主键
    id: Optional[int] = None
    #: 语言类别：当前空间已启用的多语言
    language: Optional[str] = None
    #: 修改时间
    modifyTime: Optional[str] = None
    #: 修改人
    modifyUser: Optional[str] = None
    #: 模板参数
    params: Optional[List[MessageTemplateParam]] = None
    #: 来源：1：自定义；2：预定义
    source: Optional[int] = None
    #: 空间ID
    spaceId: Optional[str] = None
    #: 状态： 1：已启用；2：未启用
    status: Optional[int] = None
    #: 模板编码
    templateCode: Optional[str] = None
    #: 模板名称
    templateName: Optional[str] = None
    #: 模板标题
    title: Optional[str] = None
    #: 模板类别：1：平台公告；2：站内消息；3：短信；4：邮箱；
    type: Optional[int] = None


class MessageTemplateListVO(BaseModel):
    #: 模板内容
    content: Optional[str] = None
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人
    createUser: Optional[UserInfoVo] = None
    #: 附件信息（json数组形式）
    fileContent: Optional[str] = None
    #: 自增主键
    id: Optional[int] = None
    #: 语言类别：当前空间已启用的多语言
    language: Optional[str] = None
    #: 修改时间
    modifyTime: Optional[str] = None
    #: 修改人
    modifyUser: Optional[UserInfoVo] = None
    #: 来源：1：自定义；2：预定义
    source: Optional[int] = None
    #: 空间ID
    spaceId: Optional[str] = None
    #: 状态： 1：已启用；2：未启用
    status: Optional[int] = None
    #: 模板编码
    templateCode: Optional[str] = None
    #: 模板名称
    templateName: Optional[str] = None
    #: 模板标题
    title: Optional[str] = None
    #: 模板类别：1：平台公告；2：站内消息；3：短信；4：邮箱；
    type: Optional[int] = None
    #: 消息有效天数（0即永久有效）
    validDays: Optional[int] = None
    #: 是否开启有效天数（1 启用 2 不启用）
    validDaysEnable: Optional[int] = None


class MsgPushHasAttachmentRequestVO(BaseModel):
    """Msg Push Has Attachment Request VO

    .. admonition:: 引用接口

        - **POST** ``/message-service/push-email-message``
        - **POST** ``/message-service/push-station-message``
    """
    #: 附件
    attachment: Optional[List[MsgPushRequestAttachmentVO]] = None
    #: 模板参数
    params: Optional[List[MessageTemplateParamVO]] = None
    #: 接收对象（用户/用户组）
    receiver: List[MessageReceiverVO]
    #: 抄送对象（用户/用户组）
    ccEmail: Optional[List[MessageReceiverVO]] = None
    #: 发送人
    sender: Optional[str] = None
    #: 模板编码
    templateCode: str


class MessageTemplateListVOResp(BaseModel):
    """Page Bean«Message Template List VO»

    .. admonition:: 引用接口

        - **POST** ``/message-template/page`` (Response: 200)
    """
    #: list
    list: Optional[List[MessageTemplateListVO]] = None
    #: 总页数
    pages: Optional[int] = None
    #: 总记录条数
    total: Optional[int] = None


class SmsSendResultVO(BaseModel):
    """Sms Send Result VO

    .. admonition:: 引用接口

        - **POST** ``/message-service/push-sms-message`` (Response: 200)
        - **POST** ``/message-service/send-sms`` (Response: 200)
    """
    #: failure
    failure: Optional[List[SmsSingleSendDTO]] = None
    #: success
    success: Optional[List[SmsSingleSendDTO]] = None


class RegisterModuleElementVO(BaseModel):
    #: 是否应用初始化标识
    appInitTag: Optional[bool] = None
    #: 自动创建协议
    autoUseProtocol: Optional[List['ModuleProtocolVO']] = None
    #: 组件名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 元素版本
    elementVersion: Optional[str] = None
    #: 组件元素id生产规则:0.自定义拼接 1.组件注册登记
    idGenerateType: Optional[int] = None
    #: 组件元素id
    moduleElementId: Optional[str] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 组件标签，系统或者自定义
    moduleTag: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None
    #: 使用协议
    useProtocolList: Optional[List['ModuleProtocolVO']] = None


class ModuleProtocolVO(BaseModel):
    #: 使用的协议是否为强制依赖
    mandatoryDependence: Optional[bool] = None
    #: 当前协议对应有哪些元素支持
    moduleElementList: Optional[List[RegisterModuleElementVO]] = None
    #: 当前协议对应有哪些组件支持
    moduleList: Optional[List['RegisterModuleVO']] = None
    #: 协议号
    protocol: Optional[str] = None
    #: 协议版本号
    protocolVersion: Optional[str] = None


class RegisterModuleVO(BaseModel):
    """Register Module VO

    .. admonition:: 引用接口

        - **POST** ``/module/module-relation`` (Response: 200)
        - **GET** ``/module/space-register-module`` (Response: 200)
    """
    #: 是否应用初始化标识
    appInitTag: Optional[bool] = None
    #: 自动创建协议
    autoUseProtocol: Optional[List[ModuleProtocolVO]] = None
    #: 组件id生产规则:0,自动拼接 1.登记指定
    idGenerateType: Optional[int] = None
    #: 包含的元素类型
    moduleElementInfos: Optional[List[ModuleElementInfoVO]] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 组件名称
    moduleName: Optional[str] = None
    #: 组件标签，系统或者自定义
    moduleTag: Optional[str] = None
    #: 组件类型
    moduleType: Optional[str] = None
    #: 组件版本
    moduleVersion: Optional[str] = None
    #: 使用协议
    useProtocolList: Optional[List[ModuleProtocolVO]] = None


RegisterModuleElementVO.update_forward_refs()
ModuleProtocolVO.update_forward_refs()
