"""
Models used by /variable-server1-0

generated by model_code_gen.py
  - **filename** : ``variable.py``
  - **json timestamp** : ``2021-10-14 15:37:14``
"""


from .base import BaseModel
from typing import List, Optional
from pydantic import Field


__all__ = [
    'BaseElementDetail',
    'ElementDetail',
    'RelationElementVo',
    'ResponseResult',
    'SaveRelationElementDto',
    'ValueTypeMapDTO',
    'VariableApiDTO',
    'VariableMemberVO',
    'VariableNameVO',
    'VariableParamVO',
    'VariableValueBatchDTO',
    'VariableValueDTO',
    'VariableValueVO',
    'SaveVariavlesDTO',
    'UpdateVariavlesDTO',
    'VariableAllParamVO',
    'VariableBatchVO',
    'VariableElementVO',
    'VariableNameListVO',
    'VariableVO'
]


class BaseElementDetail(BaseModel):
    #: 关联元素名称
    elementName: Optional[str] = None
    #: 关联元素类型
    elementType: Optional[str] = None
    #: 错误信息
    errMsg: Optional[str] = None
    #: 错误标识
    errTag: Optional[bool] = None
    #: 关联元素对应的文件夹id
    folderId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None
    #: 服务名
    serverName: Optional[str] = None


class ElementDetail(BaseModel):
    #: 是否绝对路径
    absoluteTag: Optional[bool] = None
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 元素文件夹id
    folderId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None
    #: 相对路径
    relativePath: Optional[str] = None


class RelationElementVo(BaseModel):
    """Relation Element Vo

    .. admonition:: 引用接口

        - **GET** ``/relation`` (Response: 200)
    """
    #: 关联元素信息
    elementDetail: Optional[ElementDetail] = None
    #: 关联元素的key
    relationField: Optional[str] = None
    #: 关联元素的编码
    relationPosition: Optional[str] = None


class ResponseResult(BaseModel):
    """Response Result

    .. admonition:: 引用接口

        - **GET** ``/server-check`` (Response: 200)
    """
    #: code
    code: Optional[int] = None
    #: data
    data: Optional[dict] = None
    #: message
    message: Optional[str] = None
    #: status
    status: Optional[bool] = None


class SaveRelationElementDto(BaseModel):
    """Save Relation Element Dto

    .. admonition:: 引用接口

        - **POST** ``/relation/save``
    """
    #: 关联元素集合list
    elementInfoRelationList: Optional[List[RelationElementVo]] = None
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None


class ValueTypeMapDTO(BaseModel):
    #: decimalDisplayLength
    decimalDisplayLength: Optional[int] = None
    #: 默认值
    defaultValue: Optional[str] = None
    #: defaultValueShow
    defaultValueShow: Optional[str] = None
    #: 数字的小数位数，最大填10
    digitLen: Optional[int] = None
    #: dimensionDisplay
    dimensionDisplay: Optional[int] = None
    #: 维度名称
    dimensionName: Optional[str] = None
    #: 小数显示位数
    displayDigitLen: Optional[int] = None
    #: 元素详情
    elementDetail: Optional[BaseElementDetail] = None
    #: 是否启用维度表达式
    enableDimensionExpression: Optional[bool] = None
    #: 当该字段是维度时允许启用权限控制限制可选的维度成员
    functionCode: Optional[str] = None
    #: 日期格式
    instruction: Optional[str] = None
    #: 文本的长度
    length: Optional[int] = None
    #: 允许等于最大值
    maxEqual: Optional[bool] = None
    #: 数字/文本的最大长度
    maxLen: Optional[int] = None
    #: 最大值
    maximun: Optional[int] = None
    #: 允许等于最小值
    minEqual: Optional[bool] = None
    #: 最小值
    minimun: Optional[float] = None
    #: 多层级显示
    multiLevel: Optional[str] = None
    #: 多选成员上限
    multipleChoiceLimit: Optional[int] = None
    #: multipleLevelInfo
    multipleLevelInfo: Optional[List[dict]] = None
    #: 是否百分比
    percentage: Optional[bool] = None
    #: selectMulti
    selectMulti: Optional[str] = None
    #: 值列表是否多选
    selectedMulti: Optional[bool] = None
    #: 千分位标识
    thousandthSymbol: Optional[bool] = None
    #: 是否树形展示
    treeView: Optional[bool] = None
    #: 值列表的值选择范围
    valueField: Optional[List[str]] = None
    #: valueKey
    valueKey: Optional[str] = None
    #: 值类型
    valueType: Optional[int] = None


class VariableApiDTO(BaseModel):
    """Variable Api DTO

    .. admonition:: 引用接口

        - **POST** ``/variable-element/variable-list``
    """
    #: 元素名称
    elementName: str
    #: 文件夹Id
    folderId: str
    #: 元素路径
    path: Optional[str] = None
    #: 变量类型 (传空查询全部,传1查询全局变量,传2查询用户变量)
    scope: Optional[int] = None


class VariableMemberVO(BaseModel):
    #: 变量描述
    description: Optional[dict] = None
    #: 变量名称
    name: Optional[str] = None
    #: 变量类型 1全局,2用户
    scope: Optional[int] = None
    #: 变量值
    value: Optional[str] = None
    #: 变量类型(字段类型)
    valueType: Optional[int] = None


class VariableNameVO(BaseModel):
    #: 描述
    description: Optional[dict] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 文件夹Id
    path: Optional[str] = None
    #: 状态
    status: Optional[bool] = None
    #: 变量名称
    variableName: Optional[str] = None


class VariableParamVO(BaseModel):
    #: 变量描述
    description: Optional[dict] = None
    #: 变量名称
    name: str
    #: 变量类型 1全局,2用户
    scope: int
    #: 变量值
    value: Optional[str] = None
    #: 变量类型(字段类型)
    valueType: int


class VariableValueBatchDTO(BaseModel):
    """Variable Value Batch DTO

    .. admonition:: 引用接口

        - **POST** ``/variable-api/get/variable-value/batch``
    """
    #: 元素名称
    elementName: Optional[str] = None
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 变量名称
    nameList: List[str]
    #: 元素路径
    path: Optional[str] = None


class VariableValueDTO(BaseModel):
    #: 变量描述
    description: Optional[dict] = None
    #: 维度成员
    dimensionMemberList: Optional[List[str]] = None
    #: 元素的多语言关联标识
    languageKey: Optional[str] = None
    #: 变量名称
    name: Optional[str] = None
    #: 元素的关联关系标识
    relationKey: Optional[str] = None
    #: 角色id
    role: Optional[str] = None
    #: 角色组
    roleGroup: Optional[str] = None
    #: 权限方案表达式
    roleScript: Optional[str] = None
    #: 角色方案下的维度名
    rsDimension: Optional[str] = None
    #: 角色方案详情
    rsElementDetail: Optional[BaseElementDetail] = None
    #: 行号
    rsMapping: Optional[str] = None
    #: 角色方案名称
    rsName: Optional[str] = None
    #: 角色方案关联关系标识
    rsRelationKey: Optional[str] = None
    #: 范围.1全局,2用户
    scope: Optional[int] = None
    #: true启用,false禁用
    status: Optional[bool] = None
    #: 类型.1单个值,2多个值,3维度成员表达式
    type: Optional[int] = None
    #: 用户变量时配置的自定义值
    userValue: Optional[str] = None
    #: 自定义值维度成员的描述
    userValueDesc: Optional[str] = None
    #: scope为1时即为变量的值,scope为2时即为默认值
    value: Optional[str] = None
    #: 维度成员的描述
    valueDesc: Optional[str] = None
    #: 变量类型(字段类型)
    valueType: Optional[int] = None
    #: 变量属性(字段属性)
    valueTypeMap: Optional[ValueTypeMapDTO] = None


class VariableValueVO(BaseModel):
    """Variable Value VO

    .. admonition:: 引用接口

        - **GET** ``/variable-api/variable-value`` (Response: 200)
    """
    #: 变量描述
    description: Optional[dict] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 变量名称
    name: Optional[str] = None
    #: 文件夹Id
    path: Optional[str] = None
    #: 变量类型 1全局,2用户
    scope: Optional[int] = None
    #: 变量值
    value: Optional[str] = None
    #: 变量类型(字段类型)
    valueType: Optional[int] = None
    #: 变量属性(字段属性)
    valueTypeMap: Optional[ValueTypeMapDTO] = None


class SaveVariavlesDTO(BaseModel):
    """Save Variavles DTO

    .. admonition:: 引用接口

        - **POST** ``/variable-element/save-variables``
    """
    #: 变量描述
    description: Optional[dict] = None
    #: 元素名称
    elementName: str
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 全局变量集合
    globalVariables: Optional[List[VariableValueDTO]] = None
    #: 变量元素对应多语言标识
    languageKey: Optional[str] = None
    #: 组件id
    moduleId: str
    #: 元素路径
    path: Optional[str] = None
    #: 全局变量集合
    userVariables: Optional[List[VariableValueDTO]] = None


class UpdateVariavlesDTO(BaseModel):
    """Update Variavles DTO

    .. admonition:: 引用接口

        - **POST** ``/variable-element/update-variables``
    """
    #: description
    description: Optional[dict] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 全局变量集合
    globalVariables: Optional[List[VariableValueDTO]] = None
    #: 组件id
    moduleId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None
    #: 用户变量集合
    userVariables: Optional[List[VariableValueDTO]] = None


class VariableAllParamVO(BaseModel):
    #: 变量描述
    description: Optional[dict] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 文件夹Id
    path: Optional[str] = None
    #: 变量参数列表
    variableParamVOList: List[VariableParamVO]


class VariableBatchVO(BaseModel):
    """Variable Batch VO

    .. admonition:: 引用接口

        - **POST** ``/variable-api/get/variable-value/batch`` (Response: 200)
    """
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 文件夹Id
    path: Optional[str] = None
    #: 变量成员集合
    variableMemberList: Optional[List[VariableMemberVO]] = None


class VariableElementVO(BaseModel):
    """Variable Element VO

    .. admonition:: 引用接口

        - **POST** ``/variable-element/variable-list`` (Response: 200)
    """
    #: 全局变量参数
    global_: List[VariableAllParamVO] = Field(..., alias='global')
    #: 用户变量参数
    user: List[VariableAllParamVO]


class VariableNameListVO(BaseModel):
    """Variable Name List VO

    .. admonition:: 引用接口

        - **GET** ``/variable-api`` (Response: 200)
    """
    #: 全局变量
    global_: List[VariableNameVO] = Field(None, alias='global')
    #: 用户变量
    user: Optional[List[VariableNameVO]] = None


class VariableVO(BaseModel):
    """Variable VO

    .. admonition:: 引用接口

        - **GET** ``/variable-element/variables`` (Response: 200)
    """
    #: 变量元素多语言描述
    description: Optional[dict] = None
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 全局变量列表
    globalVariables: Optional[List[VariableValueDTO]] = None
    #: 文件夹Id
    path: Optional[str] = None
    #: 用户变量列表
    userVariables: Optional[List[VariableValueDTO]] = None



