"""
Models used by /deepflow-server3-0

generated by model_code_gen.py
  - **filename** : ``workflow.py``
  - **json timestamp** : ``2023-05-08 11:11:46``
"""


from deepfos.api.models.base import BaseModel
from typing import List, Optional, Union, Any, Dict
from pydantic import Field
from deepfos.api.models.platform import FileUplodRes


__all__ = [
    'BusinessKey',
    'ElementDetail',
    'ElementDetailBaseVO',
    'ElementDetailDTO',
    'KeyDetail',
    'LaunchParam',
    'LaunchParamsDTO',
    'LaunchReturnForBatchVO',
    'LaunchReturnVO',
    'Message',
    'ProcInstReturnVO',
    'ProcessLaunchParamsVO',
    'ProcessQueryDTO',
    'ProcessStartDTO',
    'ProcessStartMultipleDTO',
    'TaskInstReturnVO',
    'TaskInstanceVO',
    'TaskQueryFilterDTO',
    'UserDetailVO',
    'UserPageParamsVO',
    'UserPageVO',
    'UserTaskQueryDTO',
    'UserTaskVO',
    'Value',
    'TaskCompleteInstance',
    'TaskReqDto',
    'MessageScope',
    'FlowInstanceQueryDto',
    'FlowInstanceDto',
    'MessageInfo',
    'BusinessKeyQueryDTO',
    'GlobalParam',
    'PageInfo',
    'ProcessData',
    'ProcessInstanceVO',
    'ProcessLaunchDTO',
    'ProcessLaunchMultipleDTO',
    'ProcessVersionVO',
    'TodoPageInfo',
    'UnderwayPageInfo',
    'TaskQueryDto',
    'SendMessageParam',
    'FlowQueryResp',
    'TaskCompleteParam',
    'OutComeDto',
]


class BusinessKey(BaseModel):
    #: 比较符
    compareType: str
    #: 业务键
    key: str


class ElementDetail(BaseModel):
    """Element Detail

    .. admonition:: 引用接口

        - **POST** ``/process/api/message/list``
        - **POST** ``/process/message/list``
    """
    #: 是否绝对路径
    absoluteTag: Optional[bool] = None
    #: 元素名称
    elementName: str
    #: 元素类型
    elementType: str
    #: 元素文件夹id
    folderId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None
    #: 相对路径
    relativePath: Optional[str] = None


class ElementDetailBaseVO(BaseModel):
    #: 元素名称
    elementName: Optional[str] = None
    #: 元素类型
    elementType: Optional[str] = None
    #: 文件夹ID
    folderId: Optional[str] = None
    #: 路径
    path: Optional[str] = None


class ElementDetailDTO(BaseModel):
    #: 元素名
    elementName: str
    #: 元素文件ID，path和folderId二选一
    folderId: Optional[str] = None
    #: 元素路径, path和folderId二选一
    path: Optional[str] = None


class KeyDetail(BaseModel):
    #: code
    code: Optional[str] = None
    #: enableList
    enableList: Optional[bool] = None
    #: enableNotNull
    enableNotNull: Optional[bool] = None
    #: type
    type: Optional[str] = None


class LaunchParam(BaseModel):
    #: 编码
    code: str
    #: 是否数组
    enableList: Optional[bool] = None
    #: 是否为空
    enableNull: Optional[bool] = None
    #: id
    id: str
    #: paramsType
    paramsType: Optional[int] = None
    #: 数据类型
    type: str


class LaunchParamsDTO(BaseModel):
    """Launch Params DTO

    .. admonition:: 引用接口

        - **POST** ``/process/api/process-instance/get-by-launch-params``
        - **POST** ``/process/api/task-instance/get-by-launch-params``
    """
    #: 启动参数
    elementDetail: ElementDetailDTO
    #: 启动参数
    paramMap: Any
    #: 版本号，V开头，不填默认最新版本
    version: Optional[str] = None


class LaunchReturnForBatchVO(BaseModel):
    """Launch Return For Batch VO

    .. admonition:: 引用接口

        - **POST** ``/process/api/launch/batch`` (Response: 200)
    """
    #: 标识主键 / 别名
    alias: Optional[str] = None
    #: 业务唯一性键
    businessKey: Optional[str] = None
    #: 失败原因
    errorMsg: Optional[str] = None
    #: 流程启动参数
    paramMap: Optional[Any] = None
    #: 流程实例ID
    procInstId: Optional[str] = None
    #: 是否启动成功
    success: Optional[bool] = None


class LaunchReturnVO(BaseModel):
    """Launch Return VO

    .. admonition:: 引用接口

        - **POST** ``/process/api/launch`` (Response: 200)
    """
    #: 业务唯一性键
    businessKey: Optional[str] = None
    #: 流程启动参数
    paramMap: Optional[Any] = None
    #: 流程实例ID
    procInstId: Optional[str] = None


class Message(BaseModel):
    """message

    .. admonition:: 引用接口

        - **POST** ``/process/message/list`` (Response: 200)
    """
    #: code
    code: Optional[str] = None
    #: context
    context: Optional[List[Any]] = None
    #: id
    id: Optional[str] = None
    #: name
    name: Optional[str] = None
    #: params
    params: Optional[List[KeyDetail]] = None
    #: type
    type: Optional[str] = None


class ProcInstReturnVO(BaseModel):
    """Proc Inst Return VO

    .. admonition:: 引用接口

        - **GET** ``/process/api/process-instance/id`` (Response: 200)
    """
    #: 业务键
    businessKey: Optional[str] = None
    #: 工作流元素
    elementDetail: Optional[ElementDetailBaseVO] = None
    #: 结束时间
    endTime: Optional[str] = None
    #: 工作流唯一标识
    procDefId: Optional[str] = None
    #: 流程实例Id
    procInstId: Optional[str] = None
    #: 流程实例名称
    procInstName: Optional[str] = None
    #: 开始时间
    startTime: Optional[str] = None
    #: 流程发起人Id
    startUserId: Optional[str] = None
    #: 流程状态
    state: Optional[str] = None
    #: 流程状态描述
    stateDesc: Optional[Any] = None
    #: 变量列表
    variables: Optional[Any] = None
    #: 版本号
    version: Optional[str] = None
    #: 版本名称
    versionName: Optional[str] = None


class ProcessLaunchParamsVO(BaseModel):
    """Process Launch Params VO

    .. admonition:: 引用接口

        - **GET** ``/process/api/launch-params`` (Response: 200)
    """
    #: 可否为空
    canIsNull: Optional[bool] = None
    #: 参数编码
    code: Optional[str] = None
    #: 是否数组
    isArray: Optional[bool] = None
    #: 数据类型
    type: Optional[str] = None


class ProcessQueryDTO(BaseModel):
    """Process Query DTO

    .. admonition:: 引用接口

        - **POST** ``/process``
        - **POST** ``/process/instance/global-params``
    """
    #: 元素名称
    elementName: str
    #: 文件id
    folderId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None


class ProcessStartDTO(BaseModel):
    #: 元素名称
    elementName: str
    #: 文件夹id
    folderId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None


class ProcessStartMultipleDTO(BaseModel):
    #: 标识主键 / 别名
    alias: str
    #: 备注
    comment: Optional[str] = None
    #: 附件路径
    filePath: Optional[str] = None
    #: 启动参数
    paramMap: Optional[Any] = None


class TaskInstReturnVO(BaseModel):
    """Task Inst Return VO

    .. admonition:: 引用接口

        - **GET** ``/process/api/task-instance/id`` (Response: 200)
    """
    #: 认领人
    assignee: Optional[str] = None
    #: 认领人类型
    assigneeType: Optional[str] = None
    #: 流程实例业务键
    businessKey: Optional[str] = None
    #: 候选人
    candidate: Optional[Any] = None
    #: 截止时间
    dueDate: Optional[str] = None
    #: 元素信息
    elementDetail: Optional[ElementDetailBaseVO] = None
    #: 结束时间
    endTime: Optional[str] = None
    #: 任务实例名称
    name: Optional[str] = None
    #: 所属人
    owner: Optional[str] = None
    #: 流程定义Id
    procDefId: Optional[str] = None
    #: 流程实例Id
    procInstId: Optional[str] = None
    #: 流程实例名称
    procInstName: Optional[str] = None
    #: 优先级
    proiority: Optional[str] = None
    #: 优先级描述
    proiorityDesc: Optional[Any] = None
    #: 开始时间
    startTime: Optional[str] = None
    #: 任务状态
    state: Optional[str] = None
    #: 状态描述
    stateDesc: Optional[Any] = None
    #: 任务实例Id
    taskId: Optional[str] = None


class TaskInstanceVO(BaseModel):
    """Task Instance VO

    .. admonition:: 引用接口

        - **POST** ``/process/api/task-instance/get-by-business-key`` (Response: 200)
        - **POST** ``/process/api/task-instance/get-by-launch-params`` (Response: 200)
    """
    #: 处理人
    assignee: Optional[str] = None
    #: 处理人类型
    assigneeType: Optional[str] = None
    #: 业务键
    businessKey: Optional[str] = None
    #: 结束时间
    endTime: Optional[str] = None
    #: 所属人
    owner: Optional[str] = None
    #: 优先级
    priority: Optional[str] = None
    #: 工作流版本id
    procDefId: Optional[str] = None
    #: 流程实例展示名称
    procDisplayName: Optional[str] = None
    #: 工作流元素folderId
    procElementFolderId: Optional[str] = None
    #: 工作流元素编码
    procElementName: Optional[str] = None
    #: 工作流元素路径
    procElementPath: Optional[str] = None
    #: 流程实例id
    procInstId: Optional[str] = None
    #: 工作流元素id
    processId: Optional[str] = None
    #: 开始时间
    startTime: Optional[str] = None
    #: 流程状态
    state: Optional[str] = None
    #: 任务CODE
    taskCode: Optional[str] = None
    #: 任务展示名称
    taskDisplayName: Optional[str] = None
    #: 任务实例ID
    taskId: Optional[str] = None
    #: 任务名称
    taskName: Optional[str] = None
    #: 版本号
    version: Optional[str] = None


class TaskQueryFilterDTO(BaseModel):
    #: 类型
    filterType: Optional[str] = None
    #: 筛选字段
    key: Optional[str] = None
    #: 值
    value: Optional[str] = None


class UserDetailVO(BaseModel):
    #: 是否管理员标识
    adminTag: Optional[str] = None
    #: 头像
    avatar: Optional[str] = None
    #: 邮箱
    email: Optional[str] = None
    #: 手机号
    mobilePhone: Optional[str] = None
    #: 昵称
    nickName: Optional[str] = None
    #: 状态
    status: Optional[str] = None
    #: 用户id
    userId: Optional[str] = None
    #: 用户名
    userName: Optional[str] = None


class UserPageParamsVO(BaseModel):
    #: 组件类型
    componentType: Optional[str] = None
    #: 参数
    key: Optional[str] = None
    #: povKey
    povKey: Optional[Any] = None
    #: 值
    value: Optional[str] = None


class UserPageVO(BaseModel):
    #: elementDetail
    elementDetail: Optional[ElementDetail] = None
    #: params
    params: Optional[List[UserPageParamsVO]] = None


class UserTaskQueryDTO(BaseModel):
    """User Task Query DTO

    .. admonition:: 引用接口

        - **POST** ``/process/task/claim/list/page``
        - **POST** ``/process/task/myTask/list/page``
    """
    #: 筛选条件
    filters: Optional[List[TaskQueryFilterDTO]] = None
    #: 相同节点筛选条件
    nodeFilters: Optional[List[TaskQueryFilterDTO]] = None
    #: 页码
    pageNo: Optional[int] = None
    #: 每页大小
    pageSize: Optional[int] = None
    #: 搜索关键字
    search: Optional[str] = None
    #: 任务状态
    status: Optional[str] = None


class UserTaskVO(BaseModel):
    """User Task VO

    .. admonition:: 引用接口

        - **POST** ``/process/task/list`` (Response: 200)
    """
    #: app
    app: Optional[str] = None
    #: 认领状态
    claimStatus: Optional[str] = None
    #: 工作流名称
    definitionName: Optional[str] = None
    #: 多语言描述
    description: Optional[Any] = None
    #: 截止/到期时间
    dueTime: Optional[str] = None
    #: 元素编码
    elementName: Optional[str] = None
    #: 是否允许提交备注
    enableAllowedComment: Optional[bool] = None
    #: 是否可以快速处理
    enableQuickComplete: Optional[bool] = None
    #: 结束时间
    endTime: Optional[str] = None
    #: 执行人
    executor: Optional[UserDetailVO] = None
    #: 过期状态 EXPIRED-已过期,NORMAL-正常
    expiredStatus: Optional[str] = None
    #: 过期状态描述
    expiredStatusDesc: Optional[Any] = None
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 节点编码
    nodeCode: Optional[str] = None
    #: 任务节点
    nodeName: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 负责人
    principal: Optional[str] = None
    #: 优先级 LOW-低,MID-中,HIGH-高
    priority: Optional[str] = None
    #: 优先级描述
    priorityDes: Optional[Any] = None
    #: 流程定义ID
    processDefinitionId: Optional[str] = None
    #: 流程id
    processId: Optional[str] = None
    #: 流程实例ID
    processInstanceId: Optional[str] = None
    #: space
    space: Optional[str] = None
    #: 开始时间
    startTime: Optional[str] = None
    #: 发起人
    startUser: Optional[UserDetailVO] = None
    #: 任务编码
    taskCode: Optional[str] = None
    #: 流程ID
    taskDefinitionKey: Optional[str] = None
    #: 任务ID
    taskId: Optional[str] = None
    #: 任务名称
    taskName: Optional[str] = None
    #: 任务状态
    taskStatus: Optional[str] = None
    #: 查看任务参数
    userPage: Optional[UserPageVO] = None
    #: 查看任务参数状态
    userPageStatus: Optional[str] = None
    #: 查看任务参数跳转路径
    userPageUrl: Optional[str] = None
    #: 任务版本号
    version: Optional[str] = None


class Value(BaseModel):
    """value

    .. admonition:: 引用接口

        - **POST** ``/process/instance/global-params`` (Response: 200)
    """
    #: value
    value: Optional[Any] = None
    #: valueType
    valueType: Optional[str] = None


class TaskCompleteParam(BaseModel):
    """任务完成参数"""
    name: str
    value: Any


class TaskCompleteInstance(BaseModel):
    """任务完成实体

    .. admonition:: 引用接口

        - **POST** ``/process/api/complete``
        - **POST** ``/process/task/express-complete``
    """
    #: 备注
    comment: Optional[str] = None
    #: 附件路径
    filePath: Optional[str] = None
    #: 结果选项
    outcome: Optional[str] = None
    #: 任务id
    taskId: Optional[str] = None
    #: 完成参数
    extraResParams: Optional[List[TaskCompleteParam]] = None
    #: 按钮id
    actionId: Optional[str] = None
    #: 附件文件
    attachments: Optional[List[FileUplodRes]]


class TaskReqDto(BaseModel):
    #: 任务id
    taskId: Optional[str] = None


class MessageScope(BaseModel):
    #: 流程实例ID，发送消息方式为PROCESS_INSTANCE时必填
    processInstanceIds: Optional[List[str]] = None
    #: 发送消息方式：指定流程实例ID/广播
    type: str


class FlowInstanceQueryDto(BaseModel):
    """流程实例查询dto

    .. admonition:: 引用接口

        - **POST** ``/process/instance/monitor/page``
        - **POST** ``/process/instance/started-by-me/page``
    """
    #: 筛选条件
    filters: Optional[List[TaskQueryFilterDTO]] = None
    #: 页码
    pageNo: Optional[int] = None
    #: 每页大小
    pageSize: Optional[int] = None
    #: 搜索关键字
    search: Optional[str] = None
    #: 流程状态
    status: Optional[str] = None


class FlowInstanceDto(BaseModel):
    #: 当前节点
    currTaskName: Optional[str] = None
    #: 流程定义key
    definitionKey: Optional[str] = None
    #: 多语言描述（工作流）
    description: Optional[Any] = None
    #: 工作流名称
    displayName: Optional[str] = None
    #: 结束时间
    endTime: Optional[str] = None
    #: 截止时间
    expireTime: Optional[str] = None
    #: 过期状态
    expiredStatus: Optional[str] = None
    #: 文件夹Id
    folderId: Optional[str] = None
    #: 实例ID
    instanceId: Optional[str] = None
    #: 元素编码
    name: Optional[str] = None
    #: 路径
    path: Optional[str] = None
    #: 负责人
    principals: Optional[List[str]] = None
    #: 流程定义ID
    processDefinitionId: Optional[str] = None
    #: 开始时间
    startTime: Optional[str] = None
    #: 流程发起人
    startUser: Optional[UserDetailVO] = None
    #: 工作流状态 InProgress/进行中 Completed/已完成
    status: Optional[str] = None
    #: 查看参数
    userPage: Optional[UserPageVO] = None
    #: 查看任务参数状态
    userPageStatus: Optional[str] = None
    #: 查看任务参数跳转路径
    userPageUrl: Optional[str] = None
    #: 流程版本号
    version: Optional[str] = None


class MessageInfo(BaseModel):
    #: 消息体，预置字段不用填
    messageBody: Any
    #: 消息编码，需要在消息列表内
    messageCode: str
    #: 关联工作流，根据此元素，读取消息列表
    relateProcess: ElementDetailDTO


class BusinessKeyQueryDTO(BaseModel):
    """Business Key Query DTO

    .. admonition:: 引用接口

        - **POST** ``/process/api/process-instance/get-by-business-key``
        - **POST** ``/process/api/task-instance/get-by-business-key``
    """
    #: 业务键
    businessKey: BusinessKey
    #: 启动参数
    elementDetail: Optional[ElementDetailDTO] = None
    #: 版本号，V开头，不填默认最新版本
    version: Optional[str] = None


class GlobalParam(BaseModel):
    #: 数组类型初始值
    arrayValue: Optional[List[Value]] = None
    #: 编码
    code: str
    #: 初始值开关
    enableInitial: Optional[bool] = None
    #: 是否数组
    enableList: Optional[bool] = None
    #: id
    id: str
    #: paramsType
    paramsType: Optional[int] = None
    #: 基本类型初始值
    primitiveValue: Optional[Value] = None
    #: 数据类型
    type: str
    #: 值
    value: Optional[str] = None


class PageInfo(BaseModel):
    """Page Info«User Task VO»

    .. admonition:: 引用接口

        - **POST** ``/process/task/claim/list/page`` (Response: 200)
    """
    #: 当前页
    currentPage: Optional[int] = None
    #: 数据集
    lists: Optional[List[UserTaskVO]] = None
    #: 页面大小
    pageSize: Optional[int] = None
    #: start
    start: Optional[int] = None
    #: 总数量
    totalCount: Optional[int] = None
    #: totalPage
    totalPage: Optional[int] = None


class ProcessData(BaseModel):
    #: 流程变量列表
    globalParams: Optional[List[GlobalParam]] = None
    #: 启动参数列表
    launchParams: Optional[List[LaunchParam]] = None
    
    #: 工作流唯一ID
    processId: Optional[str] = None
    


class ProcessInstanceVO(BaseModel):
    """Process Instance VO

    .. admonition:: 引用接口

        - **POST** ``/process/api/process-instance/get-by-business-key`` (Response: 200)
        - **POST** ``/process/api/process-instance/get-by-launch-params`` (Response: 200)
    """
    #: 业务键
    businessKey: Optional[str] = None
    #: 过期时间
    dueTime: Optional[str] = None
    #: 结束时间
    endTime: Optional[str] = None
    #: 过期状态
    expiredStatus: Optional[str] = None
    #: 工作流版本id
    procDefId: Optional[str] = None
    #: 流程实例展示名称
    procDisplayName: Optional[str] = None
    #: 工作流元素folderId
    procElementFolderId: Optional[str] = None
    #: 工作流元素编码
    procElementName: Optional[str] = None
    #: 工作流元素路径
    procElementPath: Optional[str] = None
    #: 流程实例id
    procInstId: Optional[str] = None
    #: 工作流元素id
    processId: Optional[str] = None
    #: 开始时间
    startTime: Optional[str] = None
    #: 发起人
    startUser: Optional[UserDetailVO] = None
    #: 发起人ID
    startUserId: Optional[str] = None
    #: 流程状态
    state: Optional[str] = None
    #: 版本号
    version: Optional[str] = None


class ProcessLaunchDTO(BaseModel):
    """Process Launch DTO

    .. admonition:: 引用接口

        - **POST** ``/process/api/launch``
    """
    #: 备注
    comment: Optional[str] = None
    #: 元素信息
    elementDetail: Optional[ProcessStartDTO] = None
    #: 附件路径
    filePath: Optional[str] = None
    #: 启动参数
    paramMap: Optional[Any] = None


class ProcessLaunchMultipleDTO(BaseModel):
    """Process Launch Multiple DTO

    .. admonition:: 引用接口

        - **POST** ``/process/api/launch/batch``
    """
    #: 元素信息
    elementDetail: Optional[ProcessStartDTO] = None
    #: 启动参数集合
    multipleParams: Optional[List[ProcessStartMultipleDTO]] = None


class ProcessVersionVO(BaseModel):
    """Process Version VO

    .. admonition:: 引用接口

        - **POST** ``/process/definition/deploy`` (Response: 200)
        - **GET** ``/version/list`` (Response: 200)
        - **POST** ``/version/temporary-version`` (Response: 200)
    """
    #: 创建时间
    createTime: Optional[str] = None
    #: 创建人
    createUser: Optional[UserDetailVO] = None
    #: 版本名
    name: Optional[str] = None
    #: 实例数量
    procInstNum: Optional[int] = None
    #: 流程ID
    processId: Optional[str] = None
    #: 更新时间
    updateTime: Optional[str] = None
    #: 更新人
    updateUser: Optional[UserDetailVO] = None
    #: 版本号
    version: Optional[str] = None
    #: 状态
    versionStatus: Optional[str] = None


class TodoPageInfo(BaseModel):
    """Todo Page Info«User Task VO»

    .. admonition:: 引用接口

        - **POST** ``/process/task/myTask/list/page`` (Response: 200)
    """
    #: 已完成任务数
    completedCount: Optional[int] = None
    #: 当前页
    currentPage: Optional[int] = None
    #: 进行中任务数
    inProgressCount: Optional[int] = None
    #: 数据集
    lists: Optional[List[UserTaskVO]] = None
    #: 页面大小
    pageSize: Optional[int] = None
    #: start
    start: Optional[int] = None
    #: 已终止任务数
    terminatedCount: Optional[int] = None
    #: 总数量
    totalCount: Optional[int] = None
    #: totalPage
    totalPage: Optional[int] = None
    #: 全部任务数
    totalTaskCount: Optional[int] = None


class UnderwayPageInfo(BaseModel):
    """Underway Page Info«流程实例返回dto»

    .. admonition:: 引用接口

        - **POST** ``/process/instance/monitor/page`` (Response: 200)
        - **POST** ``/process/instance/started-by-me/page`` (Response: 200)
    """
    #: 已完成流程数
    completedCount: Optional[int] = None
    #: 当前页
    currentPage: Optional[int] = None
    #: 进行中流程数
    inProgressCount: Optional[int] = None
    #: 数据集
    lists: Optional[List[FlowInstanceDto]] = None
    #: 页面大小
    pageSize: Optional[int] = None
    #: 暂停流程数
    pausedCount: Optional[int] = None
    #: start
    start: Optional[int] = None
    #: 已终止流程数
    terminatedCount: Optional[int] = None
    #: 总数量
    totalCount: Optional[int] = None
    #: totalPage
    totalPage: Optional[int] = None
    #: 全部流程数
    totalProcessCount: Optional[int] = None


class TaskQueryDto(BaseModel):
    """任务查询dto

    .. admonition:: 引用接口

        - **POST** ``/process/task/getTaskListByTaskIds``
        - **POST** ``/process/task/list``
    """
    #: 任务查询列表
    taskQueryDTOList: Optional[List[TaskReqDto]] = None


class SendMessageParam(BaseModel):
    """发送消息参数

    .. admonition:: 引用接口

        - **POST** ``/process/api/send-message``
    """
    #: 消息
    messageInfo: MessageInfo
    #: 发送消息范围
    scope: MessageScope


class FlowQueryResp(BaseModel):
    """工作流查询返回

    .. admonition:: 引用接口

        - **POST** ``/process`` (Response: 200)
        - **GET** ``/version/select-by-id`` (Response: 200)
    """
    #: 多语言描述
    description: Optional[Any] = None
    #: 元素名称
    elementName: Optional[str] = None
    
    #: 文件id
    folderId: Optional[str] = None
    
    
    #: 消息列表
    messages: Optional[List[Message]] = None
    #: moduleId
    moduleId: Optional[str] = None
    #: 元素路径
    path: Optional[str] = None
    #: 工作流JSON
    processJson: Optional[ProcessData] = None
    #: 版本号
    version: Optional[str] = None
    #: 版本名
    versionName: Optional[str] = None
    #: 版本状态
    versionStatus: Optional[str] = None


class OutComeDto(BaseModel):
    """获取用户任务outcome

    .. admonition:: 引用接口

        - **GET** ``/process/task/outcomes`` (Response: 200)
    """
    code: Optional[str] = None
    id: Optional[str] = None
    name: Optional[Any] = None
