"""
APIs provided by platform-file-server

generated by model_code_gen.py
  - **filename** : ``platform.py``
  - **json timestamp** : ``2022-08-08 13:39:19``
"""
from .base import RootAPI, ChildAPI, get, post
from .models.platform import *
from deepfos.options import OPTION
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable
from aiohttp import FormData

__all__ = ['PlatformAPI']


class StdFileAPI(ChildAPI):
    endpoint = '/files'
    
    @post('delete/file')
    def delete_file(self, fileUplod: FileDelete) -> Union[int, Awaitable[int]]:
        """
        文件删除接口
    
        根据文件路径删除文件信息
        """
        return {'body': fileUplod}
    
    @get('download')
    def download(self, id: str, sendLog: bool = None) -> Union[Any, Awaitable[Any]]:
        """
        文件下载接口
    
        文件id必填，通过id获取文件路径，获取文件内容
        """
        return {'param': {'id': id, 'sendLog': sendLog}}
    
    @get('download-for-system')
    def download_for_system(self, ) -> Union[Any, Awaitable[Any]]:
        """
        文件下载接口-文件信息来源:system
    
        文件id必填，通过id获取文件路径，获取文件内容
        """
        return {}
    
    @post('upload')
    def upload(self, file_type: str, file_name: str, file: Union[str, bytes]) -> Union[
        FileUplodRes, Awaitable[FileUplodRes]]:
        """
        文件上传接口
    
        Args:
            file_type: 文件类型，可用值: ATT(用户上传附件), DL(下载数据时生成的文件), INF(接口导入数据时生成的文件), LOG(日志中的附件), UPL(用户上传数据时的文件)
            file_name: 文件名
            file: 文件内容
    
    
        .. admonition:: 上传文件至下载中心示例
    
            .. code-block:: python
    
                from datetime import datetime
    
                from deepfos.api.platform import PlatformAPI
                from deepfos.api.space import SpaceAPI
                from deepfos.api.models.space import SpFileBusinessRecordSaveDto
                from deepfos.options import OPTION
    
                # . 准备文件上传接口
                file_cli = PlatformAPI().file
    
                # . 准备空间下载中心记录接口
                business_record_cli = SpaceAPI().business
    
                # . 上传文件后，在下载中心生成一条可供下载的记录
                with open('t.txt', 'rb') as fp:
                    res = file_cli.upload(file_type='DL', file_name='t.txt', file=fp.read())
    
                    business_record_cli.save(
                        SpFileBusinessRecordSaveDto(
                            app=OPTION.api.header['app'],
                            space=OPTION.api.header['space'],
                            fileName='t.txt',
                            createTime=datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
                            fileId=res.id,
                            unit='B',
                            fileSize=res.fileSize,
                            status='SUCCESS'
                        )
                    )
    
    
        """
        data = FormData()
        data.add_field('file', file, filename=file_name)
        return {'body': data,
                'param': {
                    'fileType': file_type
                },
                'header': {'Content-Type': 'multipart/form-data', **data._writer.headers}
                }
    
    @post('upload/content')
    def upload_content(self, form: UploadBodyForm) -> Union[FileUplodRes, Awaitable[FileUplodRes]]:
        """
        以内容方式上传文件
    
        以内容方式上传文件：相同文件名不可重复上传
        """
        return {'body': form}


class FileJsAPI(ChildAPI):
    endpoint = '/js'
    
    @post('upload')
    def upload(self, param: McUploadDTO) -> Union[Result, Awaitable[Result]]:
        """
        自定义js文件上传接口
    
        文件上传，针对前端自定义js
        """
        return {'body': param}


class FilePyAPI(ChildAPI):
    endpoint = '/python'
    
    @post('python-file/delete')
    def python_file_delete(self, deleteFileDTOList: List[DeleteFileDTO]) -> Union[List[FileDeleteResultVO], Awaitable[List[FileDeleteResultVO]]]:
        """
        python文件删除接口
    
        文件名称和路径都必填
        """
        return {'body': deleteFileDTOList}
    
    @post('read-file')
    def read_file(self, readFileDto: ReadFileDTO) -> Union[FileReadResultVO, Awaitable[FileReadResultVO]]:
        """
        python文件读取内容接口
    
        文件名称和路径都必填
        """
        return {'body': readFileDto}
    
    @post('upload')
    def upload_file(self, file_upload: FileReadResultVO) -> Union[FileUploadResultVO, Awaitable[FileUploadResultVO]]:
        """
        python文件上传更新接口
    
        上传新的python文件的内容参数不能为空，文件与文件内容不可同时为空
        """
        # todo 文件内容过长时，content传参调不通，暂且这样处理
        if len(file_upload.fileContent) < 1024:
            return {'param': file_upload}
    
        forms = file_upload.dict()
        data = FormData()
        file = forms.pop('fileContent')
        data.add_field('multipartFile', file, filename=file_upload.fileName)
        for k, v in forms.items():
            if v is not None:
                data.add_field(k, v)
        # noinspection PyProtectedMember
        return {
            'body': data,
            'header': {'Content-Type': 'multipart/form-data', **data._writer.headers}
        }


class PlatformAPI(RootAPI):
    """文件上传服务接口"""
    prefix = lambda: OPTION.server.platform_file

    @cached_property
    def file(self) -> StdFileAPI:
        """
        标准文件管理相关接口
        """
        return StdFileAPI(self)

    @cached_property
    def js(self) -> FileJsAPI:
        """
        自定义js文件上传相关接口
        """
        return FileJsAPI(self)

    @cached_property
    def python(self) -> FilePyAPI:
        """
        python文件管理相关接口
        """
        return FilePyAPI(self)


