"""
APIs provided by role-strategy-server1-0

generated by model_code_gen.py
  - **filename** : ``role_strategy.py``
  - **json timestamp** : ``2022-08-08 13:39:19``
"""
from .base import get, post, DynamicRootAPI, ChildAPI
from .models.role_strategy import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['RoleStrategyAPI']


class Extra(ChildAPI):
    endpoint = '/'
    
    @post('batch-query-roles-by-user-seg-members')
    def batch_query_roles_by_user_seg_members(self, dimensionMemberRoleStrategyBatchDto: DimensionMemberRoleStrategyBatchDto = None) -> Union[List[BatchQueryRolesByUserAndSegMembersVO], Awaitable[List[BatchQueryRolesByUserAndSegMembersVO]]]:
        """
        批量根据权限方案、用户id和维度成员查角色、角色组
    
        清单表，业务数据模型权限校验
        """
        return {'body': dimensionMemberRoleStrategyBatchDto}
    
    @post('get-Dimension-Member-by-role-scheme')
    def get_Dimension_Member_by_role_scheme(self, dimMemberCheckDimensionDto: DimMemberCheckDimensionDto = None) -> Union[DimensionMessageVO, Awaitable[DimensionMessageVO]]:
        """
        根据权限方案、角色/角色组、用户、维度查找维度成员
    
        维度权限校验
        """
        return {'body': dimMemberCheckDimensionDto}
    
    @post('get-Dimension-Member-by-role-scheme-batch')
    def get_Dimension_Member_by_role_scheme_batch(self, dimMemberCheckDimensionDtoList: List[DimMemberCheckDimensionDto] = None) -> Union[List[DimensionMessageBatchVO], Awaitable[List[DimensionMessageBatchVO]]]:
        """
        根据权限方案、角色/角色组、用户、维度批量查找维度成员
    
        维度权限校验
        """
        return {'body': dimMemberCheckDimensionDtoList}
    
    @post('get-dim-members-by-user-seg-members')
    def get_dim_members_by_user_seg_members(self, dimensionMembersCheckDto: DimensionMembersCheckDto = None) -> Union[List[DimensionMembersByUserAndSegMembersVO], Awaitable[List[DimensionMembersByUserAndSegMembersVO]]]:
        """
        根据权限方案、角色名称或者角色组名称、维度成员校验当前用户具有的维度成员
    
        清单表权限使用
        """
        return {'body': dimensionMembersCheckDto}
    
    @post('get-dimension-member-by-user-role')
    def get_dimension_member_by_user_role(self, dimensionMemberByRoleDto: DimensionMemberByRoleDto = None) -> Union[DimensionMemberByUserAndRoleVO, Awaitable[DimensionMemberByUserAndRoleVO]]:
        """
        根据权限方案、用户、角色/角色组查找有权限的维度-维度成员
    
        清单表权限校验
        """
        return {'body': dimensionMemberByRoleDto}
    
    @post('get-dimension-member-by-user-role-scripts')
    def get_dimension_member_by_user_role_scripts(self, dimensionScriptsCheckDto: DimensionScriptsCheckDto = None) -> Union[DimensionMemberByUserRoleDimVO, Awaitable[DimensionMemberByUserRoleDimVO]]:
        """
        根据权限方案、用户/用户组、角色/角色组和维度表达式，查找该用户/用户组在对应角色/角色组下，在此表达式中有权限的维度成员
    
        清单表权限校验
        """
        return {'body': dimensionScriptsCheckDto}
    
    @post('get-dimension-script-by-role-scheme')
    def get_dimension_script_by_role_scheme(self, dimMemberCheckDimensionDto: DimMemberCheckDimensionDto = None) -> Union[DimensionScriptMessageVO, Awaitable[DimensionScriptMessageVO]]:
        """
        根据权限方案、角色/角色组、用户、维度查找维度表达式
    
        维度权限校验
        """
        return {'body': dimMemberCheckDimensionDto}
    
    @post('get-rolegroups-by-role-scheme-roles')
    def get_rolegroups_by_role_scheme_roles(self, rolegroupsByRoleScheme: RolegroupsByRoleSchemeDto = None) -> Union[List[RolegroupByRoleSchemeVO], Awaitable[List[RolegroupByRoleSchemeVO]]]:
        """
        根据权限方案、角色查找所属角色组
    
        """
        return {'body': rolegroupsByRoleScheme}
    
    @get('get-roles-by-user')
    def get_roles_by_user(self, folderId: str, elementName: str, path: str = None) -> Union[RolesByUserVO, Awaitable[RolesByUserVO]]:
        """
        根据权限方案获取当前用户具有的角色
    
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}
    
    @post('get-roles-by-user-seg-members')
    def get_roles_by_user_seg_members(self, dimensionMemberRoleStrategyDto: DimensionMemberRoleStrategyDto = None) -> Union[RolesByUserAndSegMembersVO, Awaitable[RolesByUserAndSegMembersVO]]:
        """
        根据权限方案、用户id和维度成员查角色、角色组
    
        清单表权限使用
        """
        return {'body': dimensionMemberRoleStrategyDto}
    
    @post('get-users-by-roles')
    def get_users_by_roles(self, userByRolesBatchDto: UserByRolesBatchDto = None) -> Union[List[UserByRolesAndRoleGroupsVO], Awaitable[List[UserByRolesAndRoleGroupsVO]]]:
        """
        根据角色/角色组查询当前权限方案中匹配的用户
    
        """
        return {'body': userByRolesBatchDto}
    
    @post('role-scheme-data-import')
    def role_scheme_data_import(self, tag: str, importRoleSchemeDto: ImportRoleSchemeDto) -> Union[int, Awaitable[int]]:
        """
        权限方案配置导入
    
        权限方案配置页数据批量（增量/全量）导入
        """
        return {'body': importRoleSchemeDto, 'param': {'tag': tag}}


class RoleStrategy(ChildAPI):
    endpoint = '/role-strategy'
    
    @post('info-list')
    def info_list(self, queryRoleSchemeDTO: QueryRoleSchemeDTO) -> Union[RoleSchemeInfoVO, Awaitable[RoleSchemeInfoVO]]:
        """
        查询权限方案信息
    
        查询权限方案中权限设置tab页的信息
        """
        return {'body': queryRoleSchemeDTO}


class Role(ChildAPI):
    endpoint = '/role'
    
    @get('data')
    def data(self, elementName: str, folderId: str = None, path: str = None, queryCondition: str = None) -> Union[RoleInfoVO, Awaitable[RoleInfoVO]]:
        """
        查询角色信息
    
        查询权限方案中角色tab页中的信息
        """
        return {
          'param': {
              'elementName': elementName,
              'folderId': folderId,
              'path': path,
              'queryCondition': queryCondition,
          },
        }


class Rolegroup(ChildAPI):
    endpoint = '/rolegroup'
    
    @get('data')
    def data(self, folderId: str, elementName: str, path: str = None, queryCondition: str = None) -> Union[RoleGroupVO, Awaitable[RoleGroupVO]]:
        """
        查询角色组信息
    
        查询权限方案中角色组tab页的信息
        """
        return {
          'param': {
              'elementName': elementName,
              'folderId': folderId,
              'path': path,
              'queryCondition': queryCondition,
          },
        }
    
    @post('role-rolegroup/import')
    def role_rolegroup_import(self, memberType: str, increment: str, file: str, elementName: str, folderId: str = None, path: str = None) -> Union[ResultStringDto, Awaitable[ResultStringDto]]:
        """
        角色角色组导入
    
        导入EXCEL文件中角色角色组的信息
        """
        return {
          'param': {
              'elementName': elementName,
              'file': file,
              'folderId': folderId,
              'increment': increment,
              'memberType': memberType,
              'path': path,
          },
        }


class RoleStrategyAPI(DynamicRootAPI, builtin=True):
    """RoleStrategy"""
    module_type = 'ACS'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'RoleStrategyAPI'
    module_name = 'deepfos.api.role_strategy'
    api_version = (1, 0)

    @cached_property
    def extra(self) -> Extra:
        """
        权限方案对外提供接口
        """
        return Extra(self)

    @cached_property
    def rolestrategy(self) -> RoleStrategy:
        """
        权限方案相关操作
        """
        return RoleStrategy(self)

    @cached_property
    def role(self) -> Role:
        """
        角色相关操作
        """
        return Role(self)

    @cached_property
    def rolegroup(self) -> Rolegroup:
        """
        角色组相关操作
        """
        return Rolegroup(self)


