"""
APIs provided by smart-list-server1-0

generated by model_code_gen.py
  - **filename** : ``smart_list.py``
  - **json timestamp** : ``2021-07-28 16:26:08``
"""
from .base import get, post, DynamicRootAPI, ChildAPI
from .models.smartlist import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['SmartListAPI']


class PrimarySMLAPI(ChildAPI):
    endpoint = '/smart-list'

    @get('')
    def data(self, folderId: str = None, name: str = None) -> Union[SmartListDTO, Awaitable[SmartListDTO]]:
        """
        获取值列表数据

        """
        return {'param': {'folderId': folderId, 'name': name}}

    @post('add')
    def add(self, smartListDTO: SmartListDTO) -> Union[ElementFixInfoDTO, Awaitable[ElementFixInfoDTO]]:
        """
        新增值列表

        """
        return {'body': smartListDTO}

    @post('list')
    def list(self, elementBaseInfoParamDTOS: List[ElementBaseInfoParamDTO]) -> Union[List[SmartListDTO], Awaitable[List[SmartListDTO]]]:
        """
        批量获取值列表数据

        """
        return {'body': elementBaseInfoParamDTOS}

    @post('update')
    def update(self, smartListDTO: SmartListDTO) -> Union[ElementFixInfoDTO, Awaitable[ElementFixInfoDTO]]:
        """
        更新值列表

        """
        return {'body': smartListDTO}


class SmartListAPI(DynamicRootAPI, builtin=True):
    """值列表组件接口"""
    module_type = 'SML'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'SmartListAPI'
    module_name = 'deepfos.api.smartlist'
    api_version = (1, 0)

    @cached_property
    def sml(self) -> PrimarySMLAPI:
        """
        值列表相关接口
        """
        return PrimarySMLAPI(self)


