"""
APIs provided by space-server

generated by api_code_gen.py
  - **filename** : ``space.py``
  - **json timestamp** : ``2023-03-02 14:49:01``
"""
from deepfos.api.base import RootAPI, ChildAPI, get, post
from .models.space import *
from deepfos.options import OPTION
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable, Optional


__all__ = ['SpaceAPI']


class SpaceAppAPI(ChildAPI):
    endpoint = '/api/space/app'

    @post('add')
    def add(self, spAppInfoDto: SpAppInfoAddDto) -> Union[str, Awaitable[str]]:
        """
        创建app接口

        在当前空间创建app，如果数据库连接地址、端口、数据库名、数据库用户名
        、密码为空时，使用默认数据源
        """
        return {'body': spAppInfoDto}

    @post('all')
    def all(self, ids: List[str]) -> Union[List[SpAppInfoVo], Awaitable[List[SpAppInfoVo]]]:
        """
        查询应用列表所有应用(含回收站信息)接口(也可通过appIds查询)（已废弃）

        根据空间id和应用名称分页查询应用列表所有应用（已废弃）
        """
        return {'body': ids}

    @get('all/list')
    def all_list(self, recycleBin: int = None) -> Union[List[SpaceAppDto], Awaitable[List[SpaceAppDto]]]:
        """
        查询所有空间内所有应用接口

        查询所有空间及空间下所有应用；可根据参数recycleBin过滤应用
        """
        return {'param': {'recycleBin': recycleBin}}

    @get('query-app-info-list/by-space-id')
    def query_app_info_list_by_space_id(self, ) -> Union[List[AppInfo], Awaitable[List[AppInfo]]]:
        """
        根据空间id查询所有未回收应用信息接口

        """
        return {}

    @post('remove')
    def remove(self, appName: str, appId: str, adminFlag: bool = None, logFlag: bool = None) -> Union[int, Awaitable[int]]:
        """
        根据空间id删除应用信息接口

        根据空间id和应用id调用app应用接口通知应用删除所有应用下元素数据
        ,根据空间id和应用id删除应用信息--2.12.0.0
        """
        return {
          'param': {
              'adminFlag': adminFlag,
              'appId': appId,
              'appName': appName,
              'logFlag': logFlag,
          },
        }

    @post('update')
    def update(self, spAppInfoDto: SpAppInfoUpdateDto) -> Union[int, Awaitable[int]]:
        """
        修改app名称及描述接口

        应用名称和描述修改
        """
        return {'body': spAppInfoDto}

    @post('update-module-register-info/by-module-id')
    def update_module_register_info_by_module_id(self, spModuleRegisterInfoUpdateDto: SpModuleRegisterInfoUpdateDto) -> Union[int, Awaitable[int]]:
        """
        组件安装更新已注册组件的组件名称接口

        根据组件id修改空间组件注册表中组件名称
        """
        return {'body': spModuleRegisterInfoUpdateDto}


class SpaceBusinessRecordAPI(ChildAPI):
    endpoint = '/api/space/file/business/record'

    @post('save')
    def save(self, fileBusinessRecordSaveDao: SpFileBusinessRecordSaveDto) -> Union[str, Awaitable[str]]:
        """
        保存业务文件记录

        保存业务文件记录，用于平台下载中心的文件下载
        """
        return {'body': fileBusinessRecordSaveDao}


class SpaceUserGroupAPI(ChildAPI):
    endpoint = '/api/space/group-info'

    @post('add-group')
    def add_group(self, groupInfo: GroupInfoDto) -> Union[int, Awaitable[int]]:
        """
        新建用户组

        根据用户组名，多语种描述以及需要添加的用户id新建用户组
        """
        return {'body': groupInfo}

    @get('all_enable_group')
    def all_enable_group(self, keyword: str = None) -> Union[List[UserGroupInfoVo], Awaitable[List[UserGroupInfoVo]]]:
        """
        查询企业用户组信息

        查询该企业下所有有效用户组的基本信息
        """
        return {'param': {'keyword': keyword}}

    @get('get-user-group-all')
    def get_user_group_all(self, ) -> Union[UserAndGroupDto, Awaitable[UserAndGroupDto]]:
        """
        获取所有用户组及用户及用户组关系数据

        """
        return {}

    @get('query')
    def query(self, groupInfoId: str, status: str = None) -> Union[SingleGroupVo, Awaitable[SingleGroupVo]]:
        """
        根据id查询单个用户组信息

        根据id查询单个用户组信息,以及该用户组下的所有用户的基本信息
        """
        return {'param': {'groupInfoId': groupInfoId, 'status': status}}

    @get('query/batch')
    def query_batch(self, groupIdList: List[str], filter: bool = None, status: str = None) -> Union[List[GroupInfoVo], Awaitable[List[GroupInfoVo]]]:
        """
        批量根据用户组id列表查询用户组信息

        批量根据用户组id列表查询用户组的基本信息
        """
        return {'param': {'filter': filter, 'groupIdList': groupIdList, 'status': status}}


class SpaceModuleAPI(ChildAPI):
    endpoint = '/api/space/module'

    @get('all/list')
    def all_list(self, ) -> Union[List[SpModuleInfoPageVo], Awaitable[List[SpModuleInfoPageVo]]]:
        """
        查询所有组件列表接口

        """
        return {}

    @post('auto-register-module')
    def auto_register_module(self, moduleIds: List[str]) -> Union[Any, Awaitable[Any]]:
        """
        新建空间组件逐个自动注册接口

        组件逐个注册
        """
        return {'body': moduleIds}

    @post('batch/module-element-register')
    def batch_module_element_register(self, moduleRegisterAndQuoteDto: ModuleRegisterAndQuoteDto) -> Union[SpModuleRegisterResultVo, Awaitable[SpModuleRegisterResultVo]]:
        """
        批量注册组件和组件依赖关系接口

        """
        return {'body': moduleRegisterAndQuoteDto}

    @post('cancellation')
    def cancellation(self, moduleId: str) -> Union[int, Awaitable[int]]:
        """
        组件注销接口

        组件注销,删除组件注册表,调用系统服务删除空间与组件关联关系,更新组件
        强制关联关系状态,删除组件引用信息
        """
        return {'param': {'moduleId': moduleId}}

    @get('detail')
    def detail(self, moduleId: str) -> Union[SpModuleRegisterDetailVo, Awaitable[SpModuleRegisterDetailVo]]:
        """
        根据moduleId查询组件详细信息(含服务名)接口

        该接口迁移至system项目
        """
        return {'param': {'moduleId': moduleId}}

    @get('detail/list')
    def detail_list(self, moduleIds: List[str]) -> Union[List[SpModuleRegisterDetailVo], Awaitable[List[SpModuleRegisterDetailVo]]]:
        """
        根据(批量)moduleId查询组件(批量)详细信息(含服务名)接口

        该接口迁移至system项目
        """
        return {'param': {'moduleIds': moduleIds}}

    @post('quote-relation/add')
    def quote_relation_add(self, moduleQuoteAddDto: ModuleQuoteAddDto) -> Union[int, Awaitable[int]]:
        """
        保存组件创建时使用的默认组件接口

        """
        return {'body': moduleQuoteAddDto}

    @post('quote-relation/batch-add')
    def quote_relation_batch_add(self, moduleQuoteAddDtoList: List[ModuleQuoteAddDto]) -> Union[int, Awaitable[int]]:
        """
        保存组件创建时使用的默认组件批量接口

        """
        return {'body': moduleQuoteAddDtoList}

    @get('quote-relation/server-name')
    def quote_relation_server_name(self, protocolVersion: str, protocol: str, moduleId: str) -> Union[SpModuleAutoCreateRelationVo, Awaitable[SpModuleAutoCreateRelationVo]]:
        """
        根据组件id和协议号查询默认创建的组件服务名接口

        """
        return {
          'param': {
              'moduleId': moduleId,
              'protocol': protocol,
              'protocolVersion': protocolVersion,
          },
        }

    @post('register')
    def register(self, spModuleRegisterInfoDtoList: List[SpModuleRegisterInfoDto]) -> Union[SpModuleRegisterResultVo, Awaitable[SpModuleRegisterResultVo]]:
        """
        组件注册接口

        组件注册,存在后置通知
        """
        return {'body': spModuleRegisterInfoDtoList}

    @post('register-assign-module')
    def register_assign_module(self, moduleTypeVersionInfoDtos: List[ModuleTypeVersionInfoDto]) -> Union[Any, Awaitable[Any]]:
        """
        注册指定的组件接口(指定组件类型和版本)

        """
        return {'body': moduleTypeVersionInfoDtos}

    @get('register-list/usable')
    def get_usable_module(self, ) -> Union[List[SpModuleRegisterDetailVo], Awaitable[List[SpModuleRegisterDetailVo]]]:
        """
        查询已注册的可用组件列表（组）接口

        查询已注册的可用组件列表（组件状态为可用）
        """
        return {}

    @get('register/coercion-lack/check-usable')
    def register_coercion_lack_check_usable(self, moduleId: str) -> Union[bool, Awaitable[bool]]:
        """
        查询组件id查询组件在当前空间的状态是否可用接口

        根据moduleId查询空间注册的组件状态是否可用且强依赖关系是否注册
        """
        return {'param': {'moduleId': moduleId}}

    @get('register/coercion-lack/check-usable-batch')
    def register_coercion_lack_check_usable_batch(self, moduleIds: List[str]) -> Union[List[SpModlueRegisterStausUsableVo], Awaitable[List[SpModlueRegisterStausUsableVo]]]:
        """
        批量查询组件可用状态接口(是否已注册)

        根据空间id和组件id数组批量查询组件可用状态(是否已注册)
        """
        return {'param': {'moduleIds': moduleIds}}

    @get('register/status')
    def register_status(self, moduleId: str) -> Union[ModuleRegisterStatusAndRegisterTimeVo, Awaitable[ModuleRegisterStatusAndRegisterTimeVo]]:
        """
        查询组件注册信息接口

        根据空间id和组件id查询组件注册信息包含状态和注册时间
        """
        return {'param': {'moduleId': moduleId}}

    @get('relation-all')
    def relation_all(self, moduleId: str) -> Union[SpModuleRegisterRelationVo, Awaitable[SpModuleRegisterRelationVo]]:
        """
        根据已注册组件id查询已注册组件关联关系接口

        根据空间id和已注册组件id判断该组件是否已经注册,根据空间id和已注
        册组件id获取组件创建的依赖关系,根据空间id获取该空间已注册的组件
        ,调用系统服务根据未注册组件id获取组件所有的依赖关系,根据已注册组件
        id显示强制依赖和不强制依赖列表未注册的组件不会显示
        """
        return {'param': {'moduleId': moduleId}}

    @post('status')
    def status(self, moduleStatusDto: ModuleStatusDto) -> Union[int, Awaitable[int]]:
        """
        空间组件启用停用接口

        更新空间组件启用停用状态
        """
        return {'body': moduleStatusDto}

    @get('unregister/relation-all')
    def unregister_relation_all(self, moduleId: str) -> Union[SpModuleRegisterRelationVo, Awaitable[SpModuleRegisterRelationVo]]:
        """
        根据未注册组件id查询未注册组件关联关系接口

        根据空间id和未注册组件id判断该组件是否已经注册,根据空间id获取所
        有已注册的组件信息用于显示与未注册组件的关联关系列表,调用系统服务根据
        未注册组件id获取组件所有的依赖关系,根据未注册组件id显示强制依赖和
        不强制依赖列表已经注册的组件不会显示
        """
        return {'param': {'moduleId': moduleId}}

    @get('use/elements')
    def use_elements(self, enableRegister: int = None) -> Union[List[ModuleElementInfoForm], Awaitable[List[ModuleElementInfoForm]]]:
        """
        查询当前空间所有可以使用的元素类型信息

        """
        return {'param': {'enableRegister': enableRegister}}


class SpaceUserAPI(ChildAPI):
    endpoint = '/api/space/user-info'

    @get('all_enable_user')
    def all_enable_user(self, keyword: str = None, status: str = None) -> Union[List[UserInfoVo], Awaitable[List[UserInfoVo]]]:
        """
        查询空间用户信息

        查询该空间下所有有效用户的基本信息
        """
        return {'param': {'keyword': keyword, 'status': status}}

    @post('batch/query/by-user-ids')
    def batch_query_by_user_ids(self, userIdList: str, status: str = None) -> Union[List[UserInfoVo], Awaitable[List[UserInfoVo]]]:
        """
        根据用户id列表批量查询用户信息

        根据用户id列表批量查询用户的个人信息,不过滤当前空间用户,可根据
        status字段筛选查询启用或者禁用的用户信息
        """
        return {'body': userIdList, 'param': {'status': status}}

    @get('check-user-exist/batch')
    def check_user_exist_batch(self, userIdList: List[str], status: str = None) -> Union[List[UserExistVo], Awaitable[List[UserExistVo]]]:
        """
        批量校验用户在当前空间是否存在

        批量校验一组用户在当前空间是否存在，存在返回其状态
        """
        return {'param': {'status': status, 'userIdList': userIdList}}

    @get('get-all-children-user-list/by-group')
    def get_all_children_user_list_by_group(self, groupId: str, status: str = None) -> Union[List[UserVo], Awaitable[List[UserVo]]]:
        """
        获取用户组内所有用户信息接口

        获取用户组内所有用户信息（含子集组用户）
        """
        return {'param': {'groupId': groupId, 'status': status}}

    @post('get-all-children-user-list/by-group-batch')
    def get_all_children_user_list_by_group_batch(self, groupIds: List[str]) -> Union[List[GroupUserDto], Awaitable[List[GroupUserDto]]]:
        """
        批量获取用户组内所有用户信息接口

        批量获取用户组内所有用户信息（含子集组用户）依赖平台版本2.6.7
        """
        return {'body': {'groupIds': groupIds}}

    @get('query')
    def query(self, userId: str, status: str = None) -> Union[SingleUserVo, Awaitable[SingleUserVo]]:
        """
        根据id查询单个用户信息

        根据用户的id查询单个用户的基本信息，包含邮箱，手机号，昵称等个人信息
        """
        return {'param': {'status': status, 'userId': userId}}

    @get('query/batch')
    def query_batch(self, userIdList: List[str], status: str = None) -> List[UserInfoVo]:
        """
        根据用户id列表批量查询用户信息

        根据用户id列表批量查询用户的个人信息,可根据status字段筛选查询
        启用或者禁用的用户信息
        """
        userIds = ','.join(userIdList)
        return {'param': {'status': status, 'userIdList': userIds}}

    @get('query/batch/by-name')
    def query_batch_by_name(self, userNames: List[str], status: str = None) -> Union[List[UserInfoVo], Awaitable[List[UserInfoVo]]]:
        """
        根据用户名批量查询空间用户集合

        """
        return {'param': {'status': status, 'userNames': userNames}}

    @post('query/batch/by-user-ids')
    def query_batch_by_user_ids(self, userIdList: str, status: str = None) -> Union[List[UserInfoVo], Awaitable[List[UserInfoVo]]]:
        """
        根据用户id列表批量查询用户信息

        根据用户id列表批量查询用户的个人信息,可根据status字段筛选查询
        启用或者禁用的用户信息
        """
        return {'body': userIdList, 'param': {'status': status}}

    @post('search')
    def search(self, userSearchDto: UserSearchDto) -> Union[List[UserVo], Awaitable[List[UserVo]]]:
        """
        查询当前空间用户信息（可包含关键字,不分页）

        根据给的作用域匹配对应用户信息
        """
        return {'body': userSearchDto}

    @post('update')
    def update(self, updateInfo: UserUpdateDto) -> Union[str, Awaitable[str]]:
        """
        根据用户id更新用户状态及用户组

        根据用户id更新用户状态为可用或者禁用状态，也可以传入用户组id为该用
        户分配新的用户组
        """
        return {'body': updateInfo}


class Extra(ChildAPI):
    endpoint = '/'

    @post('app-info')
    def app_info(self, appId: str) -> Union[SpAppInfo, Awaitable[SpAppInfo]]:
        """
        查询单个应用信息接口

        """
        return {'param': {'appId': appId}}

    @post('app-list')
    def app_list(self, queryAppRequestDTO: QueryAppRequestDTO) -> Union[List[QueryAppResponseDTO], Awaitable[List[QueryAppResponseDTO]]]:
        """
        应用列表查询接口

        目前日志查询时使用，不输入条件则查所有
        """
        return {'body': queryAppRequestDTO}

    @get('get-all-element')
    def get_all_element(self, app: str = None, appName: str = None, elementType: str = None, space: str = None, spaceName: str = None) -> Union[List[SpaceDto], Awaitable[List[SpaceDto]]]:
        """
        获取当前环境所有空间所有app元素基本信息

        """
        return {
          'param': {
              'app': app,
              'appName': appName,
              'elementType': elementType,
              'space': space,
              'spaceName': spaceName,
          },
        }

    @get('get-app-datasource')
    def get_app_datasource(self, space: str, app: str, decrypt: bool = None) -> Union[DataSourceInfo, Awaitable[DataSourceInfo]]:
        """
        获取应用DB信息接口

        根据空间id和应用id获取应用DB信息
        """
        return {'param': {'app': app, 'decrypt': decrypt, 'space': space}}


class SpaceFileAPI(ChildAPI):
    endpoint = '/file-info'

    @post('add')
    def add(self, fileInfoVo: FileInfoVo) -> Union[int, Awaitable[int]]:
        """
        保存附件信息接口

        保存文件上传附件信息
        """
        return {'body': fileInfoVo}

    @get('find-by-id')
    def find_by_id(self, id: str) -> Union[FileInfoVo, Awaitable[FileInfoVo]]:
        """
        通过id查询附件信息接口

        通过id/空间id查询文件上传附件信息
        """
        return {'param': {'id': id}}


class SpaceInternalAPI(ChildAPI):
    endpoint = '/internal/space/app'

    @get('jdbc')
    def jdbc(self, ) -> Union[SpAppJdbcInfoVo, Awaitable[SpAppJdbcInfoVo]]:
        """
        根据应用id查询单个应用数据库信息（含连接信息）接口

        """
        return {}


class SpaceAPI(RootAPI):
    """空间服务接口"""
    prefix = lambda: OPTION.server.space

    @cached_property
    def app(self) -> SpaceAppAPI:
        """
        空间APP信息接口
        """
        return SpaceAppAPI(self)

    @cached_property
    def business(self) -> SpaceBusinessRecordAPI:
        """
        业务文件记录接口
        """
        return SpaceBusinessRecordAPI(self)

    @cached_property
    def user_group(self) -> SpaceUserGroupAPI:
        """
        用户组管理相关接口
        """
        return SpaceUserGroupAPI(self)

    @cached_property
    def module(self) -> SpaceModuleAPI:
        """
        空间组件注册接口
        """
        return SpaceModuleAPI(self)

    @cached_property
    def user(self) -> SpaceUserAPI:
        """
        用户管理相关接口
        """
        return SpaceUserAPI(self)

    @cached_property
    def extra(self) -> Extra:
        """
        空间应用相关接口
        """
        return Extra(self)

    @cached_property
    def file(self) -> SpaceFileAPI:
        """
        附件信息接口
        """
        return SpaceFileAPI(self)

    @cached_property
    def internal(self) -> SpaceInternalAPI:
        """
        空间APP信息初始化接口
        """
        return SpaceInternalAPI(self)


