"""
APIs provided by system-server

generated by api_code_gen.py
  - **filename** : ``system.py``
  - **json timestamp** : ``2024-04-11 14:48:33``
"""
from deepfos.api.base import RootAPI, ChildAPI, get, post
from .models.system import *
from deepfos.options import OPTION
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable, Optional


__all__ = ['SystemAPI']


class SysDataSourceAPI(ChildAPI):
    endpoint = '/'

    @get('get-space-datasource')
    def get_space_datasource(self, space: str, decrypt: bool = None) -> Union[HikariDataSourceInfo, Awaitable[HikariDataSourceInfo]]:
        """
        获取空间DB信息接口

        获取空间数据库连接信息
        """
        return {'param': {'decrypt': decrypt, 'space': space}}

    @get('space-datasource/detail')
    def space_datasource_detail(self, space: str) -> Union[SpaceJdcbInfoVo, Awaitable[SpaceJdcbInfoVo]]:
        """
        查询空间数据库信息接口

        查询空间数据库信息(对外提供)
        """
        return {'param': {'space': space}}


class JdbcPassword(ChildAPI):
    endpoint = '/jdbc/password'

    @get('decrypt')
    def decrypt(self, password: str, key: str = None) -> Union[str, Awaitable[str]]:
        """
        数据源密码解密接口

        """
        return {'param': {'key': key, 'password': password}}


class Extra(ChildAPI):
    endpoint = '/'

    @post('job-create')
    def job_create(self, jobCurrentDto: JobCurrentDto) -> Union[str, Awaitable[str]]:
        """
        作业创建接口

        1 作业id默认使用uuid，2 作业状态默认等待，3 作业超时时间设
        置低于10秒时则默认10秒，不配置超时时间默认60秒，4 有设置结束时
        间则认为作业执行结束，5 成功返回作业id  --2.8.0版本更新
        """
        return {'body': jobCurrentDto}

    @get('job-status')
    def job_status(self, ) -> Union[Any, Awaitable[Any]]:
        """
        作业状态获取接口

        获取作业状态--2.6.0版本
        """
        return {}

    @post('job-update')
    def job_update(self, jobCurrentDto: UpdateJobCurrentDto) -> Union[int, Awaitable[int]]:
        """
         作业更新接口

        1 增量更新作业明细，作业明细存在则更新，新明细则增量添加，2 主作业
        完成，将数据迁移至es 3 返回作业明细更新条数 --2.8.0版本更
        新
        """
        return {'body': jobCurrentDto}


class MessageCenter(ChildAPI):
    endpoint = '/message-center'
    
    @get('count')
    def count(self, ) -> Union[MessageCountDto, Awaitable[MessageCountDto]]:
        """
        查询当前用户未读消息条数
    
        """
        return {}
    
    @post('delete')
    def delete(self, messageDelDto: MessageDelDto) -> Union[int, Awaitable[int]]:
        """
        删除消息
    
        """
        return {'body': messageDelDto}
    
    @get('get-platform-message')
    def get_platform_message(self, ) -> Union[List[MessageCenter], Awaitable[List[MessageCenter]]]:
        """
        查询未关闭状态的平台公告-不分页
    
        """
        return {}
    
    @get('message-info')
    def message_info(self, id: str) -> Union[MessageCenter, Awaitable[MessageCenter]]:
        """
        查询消息详情
    
        """
        return {'param': {'id': id}}
    
    @get('update-status-all')
    def update_status_all(self, ) -> Union[bool, Awaitable[bool]]:
        """
        全部已读
    
        """
        return {}


class MessageService(ChildAPI):
    endpoint = '/message-service'
    
    @post('push-email-message')
    def push_email_message(self, requestVO: MsgPushHasAttachmentRequestVO) -> Union[SendEmailResultVO, Awaitable[SendEmailResultVO]]:
        """
        邮件消息推送接口
    
        """
        return {'body': requestVO}
    
    @post('push-plat-notice')
    def push_plat_notice(self, requestVO: MsgPushBaseRequestVO) -> Union[SendPlatMsgResultVO, Awaitable[SendPlatMsgResultVO]]:
        """
        平台公告推送接口
    
        """
        return {'body': requestVO}
    
    @post('push-sms-message')
    def push_sms_message(self, requestVO: MsgPushBaseRequestVO) -> Union[SmsSendResultVO, Awaitable[SmsSendResultVO]]:
        """
        短信消息推送接口
    
        """
        return {'body': requestVO}
    
    @post('push-station-message')
    def push_station_message(self, requestVO: MsgPushHasAttachmentRequestVO) -> Union[SendPlatMsgResultVO, Awaitable[SendPlatMsgResultVO]]:
        """
        站内消息推送接口
    
        """
        return {'body': requestVO}
    
    @post('send-email')
    def send_email(self, requestVO: EmailPushRequestVO) -> Union[SendEmailResultVO, Awaitable[SendEmailResultVO]]:
        """
        发送邮件服务接口-传邮箱地址
    
        发送邮件服务接口
        """
        return {'body': requestVO}
    
    @post('send-sms')
    def send_sms(self, requestVO: SmsPushRequestVO) -> Union[SmsSendResultVO, Awaitable[SmsSendResultVO]]:
        """
        发送短信服务接口-传手机号码
    
        发送短信服务接口
        """
        return {'body': requestVO}


class MessageTemplate(ChildAPI):
    endpoint = '/message-template'
    
    @post('add')
    def add(self, messageTemplate: MessageTemplate) -> Union[Any, Awaitable[Any]]:
        """
        消息模板新增接口
    
        """
        return {'body': messageTemplate}
    
    @post('get-template-param')
    def get_template_param(self, queryDto: MessageTemplateParamListQueryDto) -> Union[MessageTemplateParamResp, Awaitable[MessageTemplateParamResp]]:
        """
        消息模板参数分页查询接口
    
        """
        return {'body': queryDto}
    
    @get('info')
    def info(self, id: int = None) -> Union[MessageTemplateDTO, Awaitable[MessageTemplateDTO]]:
        """
        消息模板详情接口
    
        """
        return {'param': {'id': id}}
    
    @post('page')
    def page(self, queryDto: MessageTemplateListQueryDto) -> Union[MessageTemplateListVOResp, Awaitable[MessageTemplateListVOResp]]:
        """
        消息模板分页查询接口
    
        """
        return {'body': queryDto}
    
    @post('update')
    def update(self, messageTemplate: MessageTemplate) -> Union[Any, Awaitable[Any]]:
        """
        消息模板编辑接口
    
        """
        return {'body': messageTemplate}


class SysModuleAPI(ChildAPI):
    endpoint = '/module'

    @post('get-server-name')
    def get_server_name(self, moduleIdList: List[str]) -> Union[List[ModuleServerVO], Awaitable[List[ModuleServerVO]]]:
        """
        根据组件id查询服务名与版本号接口

        根据组件id查询组件对应服务名与版本号
        """
        return {'body': moduleIdList}

    @post('install-module')
    def install_module(self, installModuleDTO: InstallModuleDTO) -> Union[int, Awaitable[int]]:
        """
        组件登记基本信息接口

        组件服务启用时安装组件相关信息，包含组件名称多语言、支持协议信息、使用
        协议信息、自动创建协议信息、组件操作前置和后置通知信息、元素支持和默认
        语言信息、元素升级信息等，注意禁止出现组件依赖本身的情况出现
        """
        return {'body': installModuleDTO}

    @post('judge-module-exist')
    def judge_module_exist(self, moduleIdList: List[str]) -> Union[List[ModuleExistVO], Awaitable[List[ModuleExistVO]]]:
        """
        查询组件id是否存在接口

        根据组件id查询对应组件是否存在
        """
        return {'body': moduleIdList}

    @get('module-elementary-info')
    def module_elementary_info(self, moduleIds: List[str]) -> Union[List[ModuleElementaryInfoVO], Awaitable[List[ModuleElementaryInfoVO]]]:
        """
        根据moduleId查询基本信息接口

        """
        return {'param': {'moduleIds': moduleIds}}

    @get('module-info-list')
    def module_info_list(self, moduleIds: List[str]) -> Union[List[ModuleInfoDTO], Awaitable[List[ModuleInfoDTO]]]:
        """
        批量查询组件信息接口

        批量查询-根据组件id查询组件信息
        """
        return {'param': {'moduleIds': moduleIds}}

    @post('query-module-name')
    def query_module_name(self, elModuleName: str = None, moduleInfoList: List[ModuleInfo] = None) -> Union[List[ModuleInfo], Awaitable[List[ModuleInfo]]]:
        """
        根据不同条件查询组件信息接口

        功能一：根据elModuleName模糊查询组件信息;功能二：根据
        moduleType和moduleVersion精确查询组件信息
        """
        return {'body': moduleInfoList, 'param': {'elModuleName': elModuleName}}

    @get('space-register-module')
    def space_register_module(self, spaceId: str) -> Union[List[RegisterModuleVO], Awaitable[List[RegisterModuleVO]]]:
        """
        获取所有组件列表以及协议关联的其他组件接口

        获取所有组件列表以及组件支持协议、使用协议、自动创建协议关联的其他组件
        ,包含组件所关联的下一层级的组件信息
        """
        return {'param': {'spaceId': spaceId}}


class Space(ChildAPI):
    endpoint = '/space'

    @get('get-tenant-code')
    def get_tenant_code(self, ) -> Union[str, Awaitable[str]]:
        """
        获取空间所属企业编码

        获取空间企业编码
        """
        return {}


class SystemAPI(RootAPI):
    """系统服务接口"""
    prefix = lambda: OPTION.server.system

    @cached_property
    def data_source(self) -> SysDataSourceAPI:
        """
        空间数据源相关接口
        """
        return SysDataSourceAPI(self)

    @cached_property
    def jdbcpassword(self) -> JdbcPassword:
        """
        数据源密码加密解密接口
        """
        return JdbcPassword(self)

    @cached_property
    def extra(self) -> Extra:
        """
        平台作业相关接口
        """
        return Extra(self)

    @cached_property
    def msg_center(self) -> MessageCenter:
        """
        消息中心
        """
        return MessageCenter(self)

    @cached_property
    def msg_service(self) -> MessageService:
        """
        消息推送
        """
        return MessageService(self)

    @cached_property
    def msg_template(self) -> MessageTemplate:
        """
        消息模板
        """
        return MessageTemplate(self)

    @cached_property
    def module(self) -> SysModuleAPI:
        """
        组件相关接口
        """
        return SysModuleAPI(self)

    @cached_property
    def space(self) -> Space:
        """
        空间管理相关接口
        """
        return Space(self)


