"""
APIs provided by variable-server1-0

generated by model_code_gen.py
  - **filename** : ``variable.py``
  - **json timestamp** : ``2021-11-30 17:36:47``
"""
from .base import get, post, DynamicRootAPI, ChildAPI
from .models.variable import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['VariableAPI']


class Extra(ChildAPI):
    endpoint = '/'

    @get('server-check')
    def server_check(self, ) -> Union[Any, Awaitable[Any]]:
        """
        服务可用性校验功能

        项目启动后，校验各个参数，依赖服务等各种依赖是否完整，便于及时查看问题
        """
        return {}

    @get('server-config-params')
    def server_config_params(self, ) -> Union[dict, Awaitable[dict]]:
        """
        serverConfigParams

        """
        return {}


class ExternalAPI(ChildAPI):
    endpoint = '/variable-api'

    @get('')
    def list_variable(self, folderId: str, elementName: str, path: str = None, scope: int = None) -> Union[VariableNameListVO, Awaitable[VariableNameListVO]]:
        """
        对外提供变量名列表接口

        """
        return {
          'param': {
              'elementName': elementName,
              'folderId': folderId,
              'path': path,
              'scope': scope,
          },
        }

    @post('get/variable-value/batch')
    def batch_variable_value(self, variableValueBatchDTOList: List[VariableValueBatchDTO]) -> Union[List[VariableBatchVO], Awaitable[List[VariableBatchVO]]]:
        """
        根据多个变量元素的多个变量名称查询变量对应值

        """
        return {'body': variableValueBatchDTOList}

    @get('variable-value')
    def variable_value(self, name: str, elementName: str = None, folderId: str = None, path: str = None) -> Union[VariableValueVO, Awaitable[VariableValueVO]]:
        """
        根据变量名称获取变量对应值

        """
        return {
          'param': {
              'elementName': elementName,
              'folderId': folderId,
              'name': name,
              'path': path,
          },
        }


class ElementAPI(ChildAPI):
    endpoint = '/variable-element'

    @get('check-table')
    def check_table(self, elementName: str, folderId: str = None, path: str = None) -> Union[bool, Awaitable[bool]]:
        """
        校验变量元素数据表是否存在

        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}

    @post('save-variables')
    def save(self, saveVariavlesDTO: SaveVariavlesDTO) -> Union[bool, Awaitable[bool]]:
        """
        保存变量数据接口

        """
        return {'body': saveVariavlesDTO}

    @post('update-variables')
    def update(self, updateVariavlesDTO: UpdateVariavlesDTO) -> Union[bool, Awaitable[bool]]:
        """
        更新变量数据接口

        """
        return {'body': updateVariavlesDTO}

    @post('variable-list')
    def list(self, variableApiDTOList: List[VariableApiDTO]) -> Union[VariableElementVO, Awaitable[VariableElementVO]]:
        """
        查询变量元素成员接口

        """
        return {'body': variableApiDTOList}

    @get('variables')
    def query(self, elementName: str, folderId: str = None, path: str = None) -> Union[VariableVO, Awaitable[VariableVO]]:
        """
        变量列表接口

        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}


class VariableAPI(DynamicRootAPI, builtin=True):
    """变量组件接口"""
    module_type = 'VAR'
    default_version = (1, 0)
    multi_version = False
    cls_name = 'VariableAPI'
    module_name = 'deepfos.api.variable'
    api_version = (1, 0)

    @cached_property
    def extra(self) -> Extra:
        """
        菜单校验服务可用性
        """
        return Extra(self)

    @cached_property
    def external(self) -> ExternalAPI:
        """
        外部组件访问变量相关接口
        """
        return ExternalAPI(self)

    @cached_property
    def variable(self) -> ElementAPI:
        """
        变量视图
        """
        return ElementAPI(self)


