"""
APIs provided by deepflow-server3-0

generated by api_code_gen.py
  - **filename** : ``workflow.py``
  - **json timestamp** : ``2023-05-08 11:11:46``
"""
from deepfos.api.base import get, post, DynamicRootAPI, ChildAPI
from .models.workflow import *
from deepfos.lib.decorator import cached_property
from typing import List, Dict, Union, Any, Awaitable


__all__ = ['WorkFlowAPI']


class Process(ChildAPI):
    endpoint = '/process/api'
    
    @post('launch')
    def launch(self, processLaunchDTO: ProcessLaunchDTO = None) -> Union[LaunchReturnVO, Awaitable[LaunchReturnVO]]:
        """
        流程启动
    
        """
        return {'body': processLaunchDTO}
    
    @get('launch-params')
    def launch_params(self, elementName: str, folderId: str = None, path: str = None) -> Union[List[ProcessLaunchParamsVO], Awaitable[List[ProcessLaunchParamsVO]]]:
        """
        获取工作流启动参数
    
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}
    
    @post('launch/batch')
    def launch_batch(self, processLaunchMultipleDTO: ProcessLaunchMultipleDTO = None) -> Union[List[LaunchReturnForBatchVO], Awaitable[List[LaunchReturnForBatchVO]]]:
        """
        批量启动流程
    
        """
        return {'body': processLaunchMultipleDTO}
    
    @post('process-instance/get-by-business-key')
    def process_instance_get_by_business_key(self, businessKeyQueryDTO: BusinessKeyQueryDTO) -> Union[List[ProcessInstanceVO], Awaitable[List[ProcessInstanceVO]]]:
        """
        通过【业务键】反查流程实例
    
        """
        return {'body': businessKeyQueryDTO}
    
    @post('process-instance/get-by-launch-params')
    def process_instance_get_by_launch_params(self, launchParamsDTO: LaunchParamsDTO) -> Union[List[ProcessInstanceVO], Awaitable[List[ProcessInstanceVO]]]:
        """
        通过【启动参数】反查流程实例
    
        """
        return {'body': launchParamsDTO}
    
    @get('process-instance/id')
    def process_instance_id(self, procInstId: str) -> Union[ProcInstReturnVO, Awaitable[ProcInstReturnVO]]:
        """
        根据流程实例id查询流程实例信息
    
        """
        return {'param': {'procInstId': procInstId}}
    
    @post('send-message')
    def send_message(self, sendMessageDTO: SendMessageParam) -> Union[Any, Awaitable[Any]]:
        """
        发送消息
    
        """
        return {'body': sendMessageDTO}
    
    @post('task-instance/get-by-business-key')
    def task_instance_get_by_business_key(self, businessKeyQueryDTO: BusinessKeyQueryDTO) -> Union[List[TaskInstanceVO], Awaitable[List[TaskInstanceVO]]]:
        """
        通过【业务键】反查任务实例
    
        """
        return {'body': businessKeyQueryDTO}
    
    @post('task-instance/get-by-launch-params')
    def task_instance_get_by_launch_params(self, launchParamsDTO: LaunchParamsDTO) -> Union[List[TaskInstanceVO], Awaitable[List[TaskInstanceVO]]]:
        """
        通过【启动参数】反查任务实例
    
        """
        return {'body': launchParamsDTO}
    
    @get('task-instance/id')
    def task_instance_id(self, taskId: str) -> Union[TaskInstReturnVO, Awaitable[TaskInstReturnVO]]:
        """
        根据任务实例id查询任务实例信息
    
        """
        return {'param': {'taskId': taskId}}


class ProcessInstance(ChildAPI):
    endpoint = '/process/instance'
    
    @post('global-params')
    def global_params(self, vo: ProcessQueryDTO) -> Union[List[Value], Awaitable[List[Value]]]:
        """
        工作流全局变量查询
    
        """
        return {'body': vo}
    
    @post('monitor/page')
    def monitor_page(self, filters: List[TaskQueryFilterDTO] = None, pageNo: int = None, pageSize: int = None, processInstanceQueryDTO: FlowInstanceQueryDto = None, search: str = None, status: str = None) -> Union[UnderwayPageInfo, Awaitable[UnderwayPageInfo]]:
        """
        流程监控页面
    
        监控页面
        """
        return {
          'body': processInstanceQueryDTO,
          'param': {
              'filters': filters,
              'pageNo': pageNo,
              'pageSize': pageSize,
              'search': search,
              'status': status,
          },
        }
    
    @post('started-by-me/page')
    def started_by_me_page(self, processInstanceQueryDTO: FlowInstanceQueryDto = None) -> Union[UnderwayPageInfo, Awaitable[UnderwayPageInfo]]:
        """
        我发起的流程
    
        """
        return {'body': processInstanceQueryDTO}


class ProcessMessage(ChildAPI):
    endpoint = '/process/message'
    
    @post('list')
    def list(self, elementDetail: ElementDetailDTO) -> Union[List[Message], Awaitable[List[Message]]]:
        """
        根据工作流元素，查询消息列表
    
        """
        return {'body': elementDetail}


class ProcessTask(ChildAPI):
    endpoint = '/process/task'
    
    @post('claim/list/page')
    def claim_list_page(self, userTaskQueryDTO: UserTaskQueryDTO = None) -> Union[PageInfo, Awaitable[PageInfo]]:
        """
        待认领的任务（分页）
    
        待认领的任务
        """
        return {'body': userTaskQueryDTO}
    
    @post('express-complete')
    def express_complete(self, taskCompleteDTO: TaskCompleteInstance) -> Union[bool, Awaitable[bool]]:
        """
        完成任务
    
        """
        return {'body': taskCompleteDTO}
    
    @post('list')
    def list(self, taskQueryDTO: TaskQueryDto, status: str, processInstanceId: str) -> Union[List[UserTaskVO], Awaitable[List[UserTaskVO]]]:
        """
        任务实例列表
    
        """
        return {
          'body': taskQueryDTO,
          'param': {'processInstanceId': processInstanceId, 'status': status},
        }
    
    @post('myTask/list/page')
    def myTask_list_page(self, userTaskQueryDTO: UserTaskQueryDTO = None) -> Union[TodoPageInfo, Awaitable[TodoPageInfo]]:
        """
        待办任务（分页）
    
        待办任务
        """
        return {'body': userTaskQueryDTO}

    @get('outcomes')
    def outcomes(self, taskId: str) -> Union[List[OutComeDto], Awaitable[List[OutComeDto]]]:
        """
        获取用户任务outcome

        """
        return {'param': {'taskId': taskId}}


class Version(ChildAPI):
    endpoint = '/version'
    
    @get('list')
    def list(self, elementName: str, folderId: str = None, path: str = None) -> Union[List[ProcessVersionVO], Awaitable[List[ProcessVersionVO]]]:
        """
        查询流程版本列表
    
        """
        return {'param': {'elementName': elementName, 'folderId': folderId, 'path': path}}
    
    @get('select-by-id')
    def select_by_id(self, version: str, processId: str, elementName: str, folderId: str = None, path: str = None) -> Union[FlowQueryResp, Awaitable[FlowQueryResp]]:
        """
        根据流程ID，版本号查询流程版本
    
        """
        return {
          'param': {
              'elementName': elementName,
              'folderId': folderId,
              'path': path,
              'processId': processId,
              'version': version,
          },
        }


class WorkFlowAPI(DynamicRootAPI, builtin=True):
    """工作流组件接口"""
    module_type = 'WKFL'
    default_version = (3, 0)
    multi_version = False
    cls_name = 'WorkFlowAPI'
    module_name = 'deepfos.api.workflow'
    api_version = (3, 0)

    @cached_property
    def process(self) -> Process:
        """
        工作流对外接口
        """
        return Process(self)

    @cached_property
    def instance(self) -> ProcessInstance:
        """
        流程实例相关接口
        """
        return ProcessInstance(self)

    @cached_property
    def message(self) -> ProcessMessage:
        """
        流程消息相关接口
        """
        return ProcessMessage(self)

    @cached_property
    def task(self) -> ProcessTask:
        """
        流程任务相关接口
        """
        return ProcessTask(self)

    @cached_property
    def version_control(self) -> Version:
        """
        版本管理相关接口
        """
        return Version(self)


