import re

from .typing_utils import areinstances


def re_bool_search(p: re.Pattern[str], s: str) -> bool:
    return bool(re.search(p, s))


def re_split(expr: str | re.Pattern[str], s: str) -> list[str]:
    segments = re.split(expr, s)
    if not areinstances(segments, str):
        raise TypeError("Function 're_split' may only return a list of strings.")
    return segments


def escape_character(s: str) -> str:
    return {
        ".": "\\.",
        "?": "\\?",
        "|": "\\|",
        "*": "\\*",
        "+": "\\+",
        "^": "\\^",
        "[": "\\[",
        "]": "\\]",
        "{": "\\{",
        "}": "\\}",
        "(": "\\(",
        ")": "\\)",
    }.get(s, s)
