# coding: utf-8

# flake8: noqa

"""
    MultiBaas API

    MultiBaas API provides a unified interface for interacting with blockchain networks. It enables applications to deploy and manage smart contracts, call contract methods, and query blockchain data through standard REST endpoints. The API also includes features for authentication, role-based access control, and integration with existing systems, allowing developers to build blockchain-powered applications without needing deep protocol-level expertise.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.0.1"

# Define package exports
__all__ = [
    "AddressesApi",
    "AdminApi",
    "ChainsApi",
    "ContractsApi",
    "EventQueriesApi",
    "EventsApi",
    "HsmApi",
    "TxmApi",
    "WebhooksApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "APIKey",
    "APIKeyWithSecret",
    "AcceptInvite200Response",
    "AcceptInviteRequest",
    "AccessTuple",
    "AddKey",
    "Address",
    "AddressAlias",
    "AuditLog",
    "AuthorizationExtraInfo",
    "AzureAccount",
    "AzureHardwareWallet",
    "AzureWallet",
    "BaseAPIKey",
    "BaseAzureAccount",
    "BaseContract",
    "BaseResponse",
    "BaseUser",
    "BaseWebhookEndpoint",
    "Block",
    "CORSOrigin",
    "CallContractFunction200Response",
    "CallContractFunction200ResponseAllOfResult",
    "ChainName",
    "ChainStatus",
    "CloudWalletTXToSign",
    "CloudWalletTXToSignTx",
    "Contract",
    "ContractABI",
    "ContractABIError",
    "ContractABIErrorArgument",
    "ContractABIEvent",
    "ContractABIEventArgument",
    "ContractABIMethod",
    "ContractABIMethodArgument",
    "ContractABIType",
    "ContractABITypeConversion",
    "ContractEventOptions",
    "ContractInformation",
    "ContractInstance",
    "ContractLookup",
    "ContractMetadata",
    "ContractMethodInformation",
    "ContractMethodOptions",
    "ContractOverview",
    "ContractParameter",
    "CountEventQueryRecords200Response",
    "CountWalletTransactions200Response",
    "CountWebhookEvents200Response",
    "CountWebhooks200Response",
    "CreateApiKey200Response",
    "CreateApiKeyRequest",
    "CreateHsmKey200Response",
    "CreateKey",
    "CreateWebhook200Response",
    "DeployContract200Response",
    "DeployContractTransaction",
    "EIP712Domain",
    "EIP712DomainChainId",
    "EIP712TypeEntry",
    "EIP712TypedData",
    "EIP712Types",
    "Error",
    "Event",
    "EventField",
    "EventInformation",
    "EventMonitorStatus",
    "EventQuery",
    "EventQueryEvent",
    "EventQueryField",
    "EventQueryFilter",
    "EventQueryResults",
    "EventTypeConversionOptions",
    "ExecuteArbitraryEventQuery200Response",
    "FieldType",
    "GasParams",
    "GetApiKey200Response",
    "GetBlock200Response",
    "GetChainStatus200Response",
    "GetContract200Response",
    "GetContractVersions200Response",
    "GetEventCount200Response",
    "GetEventMonitorStatus200Response",
    "GetEventQuery200Response",
    "GetEventTypeConversions200Response",
    "GetFunctionTypeConversions200Response",
    "GetPlan200Response",
    "GetTransaction200Response",
    "GetTransactionReceipt200Response",
    "Group",
    "HSMData",
    "HSMSignRequest",
    "HSMSignRequestPersonalSign",
    "HSMSignRequestPersonalSignChainId",
    "HSMSignRequestTypedData",
    "HSMSignResponse",
    "Invite",
    "InviteRequest",
    "LinkAddressContractRequest",
    "ListAddresses200Response",
    "ListApiKeys200Response",
    "ListAuditLogs200Response",
    "ListContractVersions200Response",
    "ListContractVersions200ResponseAllOfResult",
    "ListContracts200Response",
    "ListCorsOrigins200Response",
    "ListEventQueries200Response",
    "ListEvents200Response",
    "ListGroups200Response",
    "ListHsm200Response",
    "ListHsmWallets200Response",
    "ListInvites200Response",
    "ListUserSigners200Response",
    "ListUsers200Response",
    "ListWalletTransactions200Response",
    "ListWebhookEvents200Response",
    "ListWebhooks200Response",
    "Log",
    "MethodArg",
    "MethodCallResponse",
    "MethodTypeConversionOptions",
    "Plan",
    "PlanFeature",
    "PlanLimit",
    "PostMethodArgs",
    "PostMethodResponse",
    "Role",
    "SavedEventQuery",
    "SetAddress201Response",
    "SetCodeAuthorization",
    "SetNonceRequest",
    "SignData200Response",
    "SignedTransactionResponse",
    "SignedTransactionSubmission",
    "SignerLabel",
    "SignerWallet",
    "StandaloneWallet",
    "SubmitSignedTransaction200Response",
    "Transaction",
    "TransactionData",
    "TransactionInformation",
    "TransactionReceipt",
    "TransactionReceiptData",
    "TransactionStatus",
    "TransactionToSign",
    "TransactionToSignResponse",
    "TransactionToSignTx",
    "TransferEth200Response",
    "TypeConversionOptions",
    "User",
    "WalletTransaction",
    "WebhookEndpoint",
    "WebhookEvent",
    "WebhookEventsType",
]

# import apis into sdk package
from multibaas_sdk.api.addresses_api import AddressesApi as AddressesApi
from multibaas_sdk.api.admin_api import AdminApi as AdminApi
from multibaas_sdk.api.chains_api import ChainsApi as ChainsApi
from multibaas_sdk.api.contracts_api import ContractsApi as ContractsApi
from multibaas_sdk.api.event_queries_api import EventQueriesApi as EventQueriesApi
from multibaas_sdk.api.events_api import EventsApi as EventsApi
from multibaas_sdk.api.hsm_api import HsmApi as HsmApi
from multibaas_sdk.api.txm_api import TxmApi as TxmApi
from multibaas_sdk.api.webhooks_api import WebhooksApi as WebhooksApi

# import ApiClient
from multibaas_sdk.api_response import ApiResponse as ApiResponse
from multibaas_sdk.api_client import ApiClient as ApiClient
from multibaas_sdk.configuration import Configuration as Configuration
from multibaas_sdk.exceptions import OpenApiException as OpenApiException
from multibaas_sdk.exceptions import ApiTypeError as ApiTypeError
from multibaas_sdk.exceptions import ApiValueError as ApiValueError
from multibaas_sdk.exceptions import ApiKeyError as ApiKeyError
from multibaas_sdk.exceptions import ApiAttributeError as ApiAttributeError
from multibaas_sdk.exceptions import ApiException as ApiException

# import models into sdk package
from multibaas_sdk.models.api_key import APIKey as APIKey
from multibaas_sdk.models.api_key_with_secret import APIKeyWithSecret as APIKeyWithSecret
from multibaas_sdk.models.accept_invite200_response import AcceptInvite200Response as AcceptInvite200Response
from multibaas_sdk.models.accept_invite_request import AcceptInviteRequest as AcceptInviteRequest
from multibaas_sdk.models.access_tuple import AccessTuple as AccessTuple
from multibaas_sdk.models.add_key import AddKey as AddKey
from multibaas_sdk.models.address import Address as Address
from multibaas_sdk.models.address_alias import AddressAlias as AddressAlias
from multibaas_sdk.models.audit_log import AuditLog as AuditLog
from multibaas_sdk.models.authorization_extra_info import AuthorizationExtraInfo as AuthorizationExtraInfo
from multibaas_sdk.models.azure_account import AzureAccount as AzureAccount
from multibaas_sdk.models.azure_hardware_wallet import AzureHardwareWallet as AzureHardwareWallet
from multibaas_sdk.models.azure_wallet import AzureWallet as AzureWallet
from multibaas_sdk.models.base_api_key import BaseAPIKey as BaseAPIKey
from multibaas_sdk.models.base_azure_account import BaseAzureAccount as BaseAzureAccount
from multibaas_sdk.models.base_contract import BaseContract as BaseContract
from multibaas_sdk.models.base_response import BaseResponse as BaseResponse
from multibaas_sdk.models.base_user import BaseUser as BaseUser
from multibaas_sdk.models.base_webhook_endpoint import BaseWebhookEndpoint as BaseWebhookEndpoint
from multibaas_sdk.models.block import Block as Block
from multibaas_sdk.models.cors_origin import CORSOrigin as CORSOrigin
from multibaas_sdk.models.call_contract_function200_response import CallContractFunction200Response as CallContractFunction200Response
from multibaas_sdk.models.call_contract_function200_response_all_of_result import CallContractFunction200ResponseAllOfResult as CallContractFunction200ResponseAllOfResult
from multibaas_sdk.models.chain_name import ChainName as ChainName
from multibaas_sdk.models.chain_status import ChainStatus as ChainStatus
from multibaas_sdk.models.cloud_wallet_txto_sign import CloudWalletTXToSign as CloudWalletTXToSign
from multibaas_sdk.models.cloud_wallet_txto_sign_tx import CloudWalletTXToSignTx as CloudWalletTXToSignTx
from multibaas_sdk.models.contract import Contract as Contract
from multibaas_sdk.models.contract_abi import ContractABI as ContractABI
from multibaas_sdk.models.contract_abi_error import ContractABIError as ContractABIError
from multibaas_sdk.models.contract_abi_error_argument import ContractABIErrorArgument as ContractABIErrorArgument
from multibaas_sdk.models.contract_abi_event import ContractABIEvent as ContractABIEvent
from multibaas_sdk.models.contract_abi_event_argument import ContractABIEventArgument as ContractABIEventArgument
from multibaas_sdk.models.contract_abi_method import ContractABIMethod as ContractABIMethod
from multibaas_sdk.models.contract_abi_method_argument import ContractABIMethodArgument as ContractABIMethodArgument
from multibaas_sdk.models.contract_abi_type import ContractABIType as ContractABIType
from multibaas_sdk.models.contract_abi_type_conversion import ContractABITypeConversion as ContractABITypeConversion
from multibaas_sdk.models.contract_event_options import ContractEventOptions as ContractEventOptions
from multibaas_sdk.models.contract_information import ContractInformation as ContractInformation
from multibaas_sdk.models.contract_instance import ContractInstance as ContractInstance
from multibaas_sdk.models.contract_lookup import ContractLookup as ContractLookup
from multibaas_sdk.models.contract_metadata import ContractMetadata as ContractMetadata
from multibaas_sdk.models.contract_method_information import ContractMethodInformation as ContractMethodInformation
from multibaas_sdk.models.contract_method_options import ContractMethodOptions as ContractMethodOptions
from multibaas_sdk.models.contract_overview import ContractOverview as ContractOverview
from multibaas_sdk.models.contract_parameter import ContractParameter as ContractParameter
from multibaas_sdk.models.count_event_query_records200_response import CountEventQueryRecords200Response as CountEventQueryRecords200Response
from multibaas_sdk.models.count_wallet_transactions200_response import CountWalletTransactions200Response as CountWalletTransactions200Response
from multibaas_sdk.models.count_webhook_events200_response import CountWebhookEvents200Response as CountWebhookEvents200Response
from multibaas_sdk.models.count_webhooks200_response import CountWebhooks200Response as CountWebhooks200Response
from multibaas_sdk.models.create_api_key200_response import CreateApiKey200Response as CreateApiKey200Response
from multibaas_sdk.models.create_api_key_request import CreateApiKeyRequest as CreateApiKeyRequest
from multibaas_sdk.models.create_hsm_key200_response import CreateHsmKey200Response as CreateHsmKey200Response
from multibaas_sdk.models.create_key import CreateKey as CreateKey
from multibaas_sdk.models.create_webhook200_response import CreateWebhook200Response as CreateWebhook200Response
from multibaas_sdk.models.deploy_contract200_response import DeployContract200Response as DeployContract200Response
from multibaas_sdk.models.deploy_contract_transaction import DeployContractTransaction as DeployContractTransaction
from multibaas_sdk.models.eip712_domain import EIP712Domain as EIP712Domain
from multibaas_sdk.models.eip712_domain_chain_id import EIP712DomainChainId as EIP712DomainChainId
from multibaas_sdk.models.eip712_type_entry import EIP712TypeEntry as EIP712TypeEntry
from multibaas_sdk.models.eip712_typed_data import EIP712TypedData as EIP712TypedData
from multibaas_sdk.models.eip712_types import EIP712Types as EIP712Types
from multibaas_sdk.models.error import Error as Error
from multibaas_sdk.models.event import Event as Event
from multibaas_sdk.models.event_field import EventField as EventField
from multibaas_sdk.models.event_information import EventInformation as EventInformation
from multibaas_sdk.models.event_monitor_status import EventMonitorStatus as EventMonitorStatus
from multibaas_sdk.models.event_query import EventQuery as EventQuery
from multibaas_sdk.models.event_query_event import EventQueryEvent as EventQueryEvent
from multibaas_sdk.models.event_query_field import EventQueryField as EventQueryField
from multibaas_sdk.models.event_query_filter import EventQueryFilter as EventQueryFilter
from multibaas_sdk.models.event_query_results import EventQueryResults as EventQueryResults
from multibaas_sdk.models.event_type_conversion_options import EventTypeConversionOptions as EventTypeConversionOptions
from multibaas_sdk.models.execute_arbitrary_event_query200_response import ExecuteArbitraryEventQuery200Response as ExecuteArbitraryEventQuery200Response
from multibaas_sdk.models.field_type import FieldType as FieldType
from multibaas_sdk.models.gas_params import GasParams as GasParams
from multibaas_sdk.models.get_api_key200_response import GetApiKey200Response as GetApiKey200Response
from multibaas_sdk.models.get_block200_response import GetBlock200Response as GetBlock200Response
from multibaas_sdk.models.get_chain_status200_response import GetChainStatus200Response as GetChainStatus200Response
from multibaas_sdk.models.get_contract200_response import GetContract200Response as GetContract200Response
from multibaas_sdk.models.get_contract_versions200_response import GetContractVersions200Response as GetContractVersions200Response
from multibaas_sdk.models.get_event_count200_response import GetEventCount200Response as GetEventCount200Response
from multibaas_sdk.models.get_event_monitor_status200_response import GetEventMonitorStatus200Response as GetEventMonitorStatus200Response
from multibaas_sdk.models.get_event_query200_response import GetEventQuery200Response as GetEventQuery200Response
from multibaas_sdk.models.get_event_type_conversions200_response import GetEventTypeConversions200Response as GetEventTypeConversions200Response
from multibaas_sdk.models.get_function_type_conversions200_response import GetFunctionTypeConversions200Response as GetFunctionTypeConversions200Response
from multibaas_sdk.models.get_plan200_response import GetPlan200Response as GetPlan200Response
from multibaas_sdk.models.get_transaction200_response import GetTransaction200Response as GetTransaction200Response
from multibaas_sdk.models.get_transaction_receipt200_response import GetTransactionReceipt200Response as GetTransactionReceipt200Response
from multibaas_sdk.models.group import Group as Group
from multibaas_sdk.models.hsm_data import HSMData as HSMData
from multibaas_sdk.models.hsm_sign_request import HSMSignRequest as HSMSignRequest
from multibaas_sdk.models.hsm_sign_request_personal_sign import HSMSignRequestPersonalSign as HSMSignRequestPersonalSign
from multibaas_sdk.models.hsm_sign_request_personal_sign_chain_id import HSMSignRequestPersonalSignChainId as HSMSignRequestPersonalSignChainId
from multibaas_sdk.models.hsm_sign_request_typed_data import HSMSignRequestTypedData as HSMSignRequestTypedData
from multibaas_sdk.models.hsm_sign_response import HSMSignResponse as HSMSignResponse
from multibaas_sdk.models.invite import Invite as Invite
from multibaas_sdk.models.invite_request import InviteRequest as InviteRequest
from multibaas_sdk.models.link_address_contract_request import LinkAddressContractRequest as LinkAddressContractRequest
from multibaas_sdk.models.list_addresses200_response import ListAddresses200Response as ListAddresses200Response
from multibaas_sdk.models.list_api_keys200_response import ListApiKeys200Response as ListApiKeys200Response
from multibaas_sdk.models.list_audit_logs200_response import ListAuditLogs200Response as ListAuditLogs200Response
from multibaas_sdk.models.list_contract_versions200_response import ListContractVersions200Response as ListContractVersions200Response
from multibaas_sdk.models.list_contract_versions200_response_all_of_result import ListContractVersions200ResponseAllOfResult as ListContractVersions200ResponseAllOfResult
from multibaas_sdk.models.list_contracts200_response import ListContracts200Response as ListContracts200Response
from multibaas_sdk.models.list_cors_origins200_response import ListCorsOrigins200Response as ListCorsOrigins200Response
from multibaas_sdk.models.list_event_queries200_response import ListEventQueries200Response as ListEventQueries200Response
from multibaas_sdk.models.list_events200_response import ListEvents200Response as ListEvents200Response
from multibaas_sdk.models.list_groups200_response import ListGroups200Response as ListGroups200Response
from multibaas_sdk.models.list_hsm200_response import ListHsm200Response as ListHsm200Response
from multibaas_sdk.models.list_hsm_wallets200_response import ListHsmWallets200Response as ListHsmWallets200Response
from multibaas_sdk.models.list_invites200_response import ListInvites200Response as ListInvites200Response
from multibaas_sdk.models.list_user_signers200_response import ListUserSigners200Response as ListUserSigners200Response
from multibaas_sdk.models.list_users200_response import ListUsers200Response as ListUsers200Response
from multibaas_sdk.models.list_wallet_transactions200_response import ListWalletTransactions200Response as ListWalletTransactions200Response
from multibaas_sdk.models.list_webhook_events200_response import ListWebhookEvents200Response as ListWebhookEvents200Response
from multibaas_sdk.models.list_webhooks200_response import ListWebhooks200Response as ListWebhooks200Response
from multibaas_sdk.models.log import Log as Log
from multibaas_sdk.models.method_arg import MethodArg as MethodArg
from multibaas_sdk.models.method_call_response import MethodCallResponse as MethodCallResponse
from multibaas_sdk.models.method_type_conversion_options import MethodTypeConversionOptions as MethodTypeConversionOptions
from multibaas_sdk.models.plan import Plan as Plan
from multibaas_sdk.models.plan_feature import PlanFeature as PlanFeature
from multibaas_sdk.models.plan_limit import PlanLimit as PlanLimit
from multibaas_sdk.models.post_method_args import PostMethodArgs as PostMethodArgs
from multibaas_sdk.models.post_method_response import PostMethodResponse as PostMethodResponse
from multibaas_sdk.models.role import Role as Role
from multibaas_sdk.models.saved_event_query import SavedEventQuery as SavedEventQuery
from multibaas_sdk.models.set_address201_response import SetAddress201Response as SetAddress201Response
from multibaas_sdk.models.set_code_authorization import SetCodeAuthorization as SetCodeAuthorization
from multibaas_sdk.models.set_nonce_request import SetNonceRequest as SetNonceRequest
from multibaas_sdk.models.sign_data200_response import SignData200Response as SignData200Response
from multibaas_sdk.models.signed_transaction_response import SignedTransactionResponse as SignedTransactionResponse
from multibaas_sdk.models.signed_transaction_submission import SignedTransactionSubmission as SignedTransactionSubmission
from multibaas_sdk.models.signer_label import SignerLabel as SignerLabel
from multibaas_sdk.models.signer_wallet import SignerWallet as SignerWallet
from multibaas_sdk.models.standalone_wallet import StandaloneWallet as StandaloneWallet
from multibaas_sdk.models.submit_signed_transaction200_response import SubmitSignedTransaction200Response as SubmitSignedTransaction200Response
from multibaas_sdk.models.transaction import Transaction as Transaction
from multibaas_sdk.models.transaction_data import TransactionData as TransactionData
from multibaas_sdk.models.transaction_information import TransactionInformation as TransactionInformation
from multibaas_sdk.models.transaction_receipt import TransactionReceipt as TransactionReceipt
from multibaas_sdk.models.transaction_receipt_data import TransactionReceiptData as TransactionReceiptData
from multibaas_sdk.models.transaction_status import TransactionStatus as TransactionStatus
from multibaas_sdk.models.transaction_to_sign import TransactionToSign as TransactionToSign
from multibaas_sdk.models.transaction_to_sign_response import TransactionToSignResponse as TransactionToSignResponse
from multibaas_sdk.models.transaction_to_sign_tx import TransactionToSignTx as TransactionToSignTx
from multibaas_sdk.models.transfer_eth200_response import TransferEth200Response as TransferEth200Response
from multibaas_sdk.models.type_conversion_options import TypeConversionOptions as TypeConversionOptions
from multibaas_sdk.models.user import User as User
from multibaas_sdk.models.wallet_transaction import WalletTransaction as WalletTransaction
from multibaas_sdk.models.webhook_endpoint import WebhookEndpoint as WebhookEndpoint
from multibaas_sdk.models.webhook_event import WebhookEvent as WebhookEvent
from multibaas_sdk.models.webhook_events_type import WebhookEventsType as WebhookEventsType
