# coding: utf-8

"""
    MultiBaas API

    MultiBaas API provides a unified interface for interacting with blockchain networks. It enables applications to deploy and manage smart contracts, call contract methods, and query blockchain data through standard REST endpoints. The API also includes features for authentication, role-based access control, and integration with existing systems, allowing developers to build blockchain-powered applications without needing deep protocol-level expertise.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, field_validator
from typing import Optional
from typing_extensions import Annotated
from multibaas_sdk.models.chain_name import ChainName
from multibaas_sdk.models.count_wallet_transactions200_response import CountWalletTransactions200Response
from multibaas_sdk.models.gas_params import GasParams
from multibaas_sdk.models.list_wallet_transactions200_response import ListWalletTransactions200Response
from multibaas_sdk.models.transaction_status import TransactionStatus
from multibaas_sdk.models.transfer_eth200_response import TransferEth200Response

from multibaas_sdk.api_client import ApiClient, RequestSerialized
from multibaas_sdk.api_response import ApiResponse
from multibaas_sdk.rest import RESTResponseType


class TxmApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def cancel_transaction(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        nonce: Annotated[StrictInt, Field(description="Transaction nonce.")],
        gas_params: GasParams,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TransferEth200Response:
        """Cancel transaction

        Cancels a transaction by resubmitting it as no-op transaction and with a higher gas price.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param nonce: Transaction nonce. (required)
        :type nonce: int
        :param gas_params: (required)
        :type gas_params: GasParams
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._cancel_transaction_serialize(
            chain=chain,
            wallet_address=wallet_address,
            nonce=nonce,
            gas_params=gas_params,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransferEth200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def cancel_transaction_with_http_info(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        nonce: Annotated[StrictInt, Field(description="Transaction nonce.")],
        gas_params: GasParams,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TransferEth200Response]:
        """Cancel transaction

        Cancels a transaction by resubmitting it as no-op transaction and with a higher gas price.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param nonce: Transaction nonce. (required)
        :type nonce: int
        :param gas_params: (required)
        :type gas_params: GasParams
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._cancel_transaction_serialize(
            chain=chain,
            wallet_address=wallet_address,
            nonce=nonce,
            gas_params=gas_params,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransferEth200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def cancel_transaction_without_preload_content(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        nonce: Annotated[StrictInt, Field(description="Transaction nonce.")],
        gas_params: GasParams,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Cancel transaction

        Cancels a transaction by resubmitting it as no-op transaction and with a higher gas price.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param nonce: Transaction nonce. (required)
        :type nonce: int
        :param gas_params: (required)
        :type gas_params: GasParams
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._cancel_transaction_serialize(
            chain=chain,
            wallet_address=wallet_address,
            nonce=nonce,
            gas_params=gas_params,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransferEth200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _cancel_transaction_serialize(
        self,
        chain,
        wallet_address,
        nonce,
        gas_params,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if chain is not None:
            _path_params['chain'] = chain.value
        if wallet_address is not None:
            _path_params['wallet_address'] = wallet_address
        if nonce is not None:
            _path_params['nonce'] = nonce
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if gas_params is not None:
            _body_params = gas_params


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'cookie', 
            'bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/chains/{chain}/txm/{wallet_address}/nonce/{nonce}/cancel',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def count_wallet_transactions(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CountWalletTransactions200Response:
        """Count all transactions for a wallet

        Count all transactions for the given wallet address.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._count_wallet_transactions_serialize(
            chain=chain,
            wallet_address=wallet_address,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CountWalletTransactions200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def count_wallet_transactions_with_http_info(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CountWalletTransactions200Response]:
        """Count all transactions for a wallet

        Count all transactions for the given wallet address.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._count_wallet_transactions_serialize(
            chain=chain,
            wallet_address=wallet_address,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CountWalletTransactions200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def count_wallet_transactions_without_preload_content(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Count all transactions for a wallet

        Count all transactions for the given wallet address.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._count_wallet_transactions_serialize(
            chain=chain,
            wallet_address=wallet_address,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CountWalletTransactions200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _count_wallet_transactions_serialize(
        self,
        chain,
        wallet_address,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if chain is not None:
            _path_params['chain'] = chain.value
        if wallet_address is not None:
            _path_params['wallet_address'] = wallet_address
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'cookie', 
            'bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/chains/{chain}/txm/{wallet_address}/count',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_wallet_transactions(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter transactions by transaction hash. To filter for multiple hashes, use ampersands: `?hash=HASH1&hash=HASH2&hash=HASH3`")] = None,
        nonce: Annotated[Optional[StrictInt], Field(description="Filter transactions by nonce")] = None,
        status: Annotated[Optional[TransactionStatus], Field(description="Filter transactions by status")] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListWalletTransactions200Response:
        """List transactions for a wallet

        List the transactions submitted by the given wallet address.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param hash: Filter transactions by transaction hash. To filter for multiple hashes, use ampersands: `?hash=HASH1&hash=HASH2&hash=HASH3`
        :type hash: str
        :param nonce: Filter transactions by nonce
        :type nonce: int
        :param status: Filter transactions by status
        :type status: TransactionStatus
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_wallet_transactions_serialize(
            chain=chain,
            wallet_address=wallet_address,
            hash=hash,
            nonce=nonce,
            status=status,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWalletTransactions200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_wallet_transactions_with_http_info(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter transactions by transaction hash. To filter for multiple hashes, use ampersands: `?hash=HASH1&hash=HASH2&hash=HASH3`")] = None,
        nonce: Annotated[Optional[StrictInt], Field(description="Filter transactions by nonce")] = None,
        status: Annotated[Optional[TransactionStatus], Field(description="Filter transactions by status")] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListWalletTransactions200Response]:
        """List transactions for a wallet

        List the transactions submitted by the given wallet address.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param hash: Filter transactions by transaction hash. To filter for multiple hashes, use ampersands: `?hash=HASH1&hash=HASH2&hash=HASH3`
        :type hash: str
        :param nonce: Filter transactions by nonce
        :type nonce: int
        :param status: Filter transactions by status
        :type status: TransactionStatus
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_wallet_transactions_serialize(
            chain=chain,
            wallet_address=wallet_address,
            hash=hash,
            nonce=nonce,
            status=status,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWalletTransactions200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_wallet_transactions_without_preload_content(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        hash: Annotated[Optional[Annotated[str, Field(min_length=66, strict=True, max_length=66)]], Field(description="Filter transactions by transaction hash. To filter for multiple hashes, use ampersands: `?hash=HASH1&hash=HASH2&hash=HASH3`")] = None,
        nonce: Annotated[Optional[StrictInt], Field(description="Filter transactions by nonce")] = None,
        status: Annotated[Optional[TransactionStatus], Field(description="Filter transactions by status")] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List transactions for a wallet

        List the transactions submitted by the given wallet address.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param hash: Filter transactions by transaction hash. To filter for multiple hashes, use ampersands: `?hash=HASH1&hash=HASH2&hash=HASH3`
        :type hash: str
        :param nonce: Filter transactions by nonce
        :type nonce: int
        :param status: Filter transactions by status
        :type status: TransactionStatus
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_wallet_transactions_serialize(
            chain=chain,
            wallet_address=wallet_address,
            hash=hash,
            nonce=nonce,
            status=status,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWalletTransactions200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_wallet_transactions_serialize(
        self,
        chain,
        wallet_address,
        hash,
        nonce,
        status,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if chain is not None:
            _path_params['chain'] = chain.value
        if wallet_address is not None:
            _path_params['wallet_address'] = wallet_address
        # process the query parameters
        if hash is not None:
            
            _query_params.append(('hash', hash))
            
        if nonce is not None:
            
            _query_params.append(('nonce', nonce))
            
        if status is not None:
            
            _query_params.append(('status', status.value))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'cookie', 
            'bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/chains/{chain}/txm/{wallet_address}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def speed_up_transaction(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        nonce: Annotated[StrictInt, Field(description="Transaction nonce.")],
        gas_params: GasParams,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TransferEth200Response:
        """Speed up transaction

        Speeds up a transaction by resubmitting it with a higher gas price.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param nonce: Transaction nonce. (required)
        :type nonce: int
        :param gas_params: (required)
        :type gas_params: GasParams
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._speed_up_transaction_serialize(
            chain=chain,
            wallet_address=wallet_address,
            nonce=nonce,
            gas_params=gas_params,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransferEth200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def speed_up_transaction_with_http_info(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        nonce: Annotated[StrictInt, Field(description="Transaction nonce.")],
        gas_params: GasParams,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TransferEth200Response]:
        """Speed up transaction

        Speeds up a transaction by resubmitting it with a higher gas price.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param nonce: Transaction nonce. (required)
        :type nonce: int
        :param gas_params: (required)
        :type gas_params: GasParams
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._speed_up_transaction_serialize(
            chain=chain,
            wallet_address=wallet_address,
            nonce=nonce,
            gas_params=gas_params,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransferEth200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def speed_up_transaction_without_preload_content(
        self,
        chain: Annotated[ChainName, Field(description="The blockchain chain label.")],
        wallet_address: Annotated[str, Field(strict=True, description="An Ethereum address.")],
        nonce: Annotated[StrictInt, Field(description="Transaction nonce.")],
        gas_params: GasParams,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Speed up transaction

        Speeds up a transaction by resubmitting it with a higher gas price.

        :param chain: The blockchain chain label. (required)
        :type chain: ChainName
        :param wallet_address: An Ethereum address. (required)
        :type wallet_address: str
        :param nonce: Transaction nonce. (required)
        :type nonce: int
        :param gas_params: (required)
        :type gas_params: GasParams
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._speed_up_transaction_serialize(
            chain=chain,
            wallet_address=wallet_address,
            nonce=nonce,
            gas_params=gas_params,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransferEth200Response",
            '4XX': "Error",
            '5XX': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _speed_up_transaction_serialize(
        self,
        chain,
        wallet_address,
        nonce,
        gas_params,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if chain is not None:
            _path_params['chain'] = chain.value
        if wallet_address is not None:
            _path_params['wallet_address'] = wallet_address
        if nonce is not None:
            _path_params['nonce'] = nonce
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if gas_params is not None:
            _body_params = gas_params


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'cookie', 
            'bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/chains/{chain}/txm/{wallet_address}/nonce/{nonce}/speed_up',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


