# coding: utf-8

"""
    MultiBaas API

    MultiBaas API provides a unified interface for interacting with blockchain networks. It enables applications to deploy and manage smart contracts, call contract methods, and query blockchain data through standard REST endpoints. The API also includes features for authentication, role-based access control, and integration with existing systems, allowing developers to build blockchain-powered applications without needing deep protocol-level expertise.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBytes, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from multibaas_sdk.models.transaction import Transaction
from typing import Optional, Set
from typing_extensions import Self

class Block(BaseModel):
    """
    A block in the Ethereum blockchain.
    """ # noqa: E501
    hash: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.")
    difficulty: StrictStr
    gas_limit: Annotated[int, Field(strict=True, ge=0)] = Field(alias="gasLimit")
    number: StrictStr
    timestamp: StrictInt
    transactions: List[Transaction]
    receipts_root: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="receiptsRoot")
    parent_hash: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="parentHash")
    sha3_uncles: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="sha3Uncles")
    miner: Annotated[str, Field(strict=True)] = Field(description="An ethereum address.")
    state_root: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="stateRoot")
    transactions_root: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="transactionsRoot")
    logs_bloom: Annotated[str, Field(strict=True)] = Field(description="A hex string.", alias="logsBloom")
    gas_used: Annotated[int, Field(strict=True, ge=0)] = Field(alias="gasUsed")
    nonce: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    mix_hash: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="mixHash")
    extra_data: Union[StrictBytes, StrictStr] = Field(alias="extraData")
    base_fee_per_gas: Optional[StrictStr] = Field(default=None, alias="baseFeePerGas")
    __properties: ClassVar[List[str]] = ["hash", "difficulty", "gasLimit", "number", "timestamp", "transactions", "receiptsRoot", "parentHash", "sha3Uncles", "miner", "stateRoot", "transactionsRoot", "logsBloom", "gasUsed", "nonce", "mixHash", "extraData", "baseFeePerGas"]

    @field_validator('hash')
    def hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    @field_validator('receipts_root')
    def receipts_root_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    @field_validator('parent_hash')
    def parent_hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    @field_validator('sha3_uncles')
    def sha3_uncles_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    @field_validator('miner')
    def miner_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('state_root')
    def state_root_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    @field_validator('transactions_root')
    def transactions_root_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    @field_validator('logs_bloom')
    def logs_bloom_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('nonce')
    def nonce_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    @field_validator('mix_hash')
    def mix_hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Block from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in transactions (list)
        _items = []
        if self.transactions:
            for _item_transactions in self.transactions:
                if _item_transactions:
                    _items.append(_item_transactions.to_dict())
            _dict['transactions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Block from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hash": obj.get("hash"),
            "difficulty": obj.get("difficulty"),
            "gasLimit": obj.get("gasLimit"),
            "number": obj.get("number"),
            "timestamp": obj.get("timestamp"),
            "transactions": [Transaction.from_dict(_item) for _item in obj["transactions"]] if obj.get("transactions") is not None else None,
            "receiptsRoot": obj.get("receiptsRoot"),
            "parentHash": obj.get("parentHash"),
            "sha3Uncles": obj.get("sha3Uncles"),
            "miner": obj.get("miner"),
            "stateRoot": obj.get("stateRoot"),
            "transactionsRoot": obj.get("transactionsRoot"),
            "logsBloom": obj.get("logsBloom"),
            "gasUsed": obj.get("gasUsed"),
            "nonce": obj.get("nonce"),
            "mixHash": obj.get("mixHash"),
            "extraData": obj.get("extraData"),
            "baseFeePerGas": obj.get("baseFeePerGas")
        })
        return _obj


