# coding: utf-8

"""
    MultiBaas API

    MultiBaas API provides a unified interface for interacting with blockchain networks. It enables applications to deploy and manage smart contracts, call contract methods, and query blockchain data through standard REST endpoints. The API also includes features for authentication, role-based access control, and integration with existing systems, allowing developers to build blockchain-powered applications without needing deep protocol-level expertise.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from multibaas_sdk.models.method_call_response import MethodCallResponse
from multibaas_sdk.models.transaction_to_sign_response import TransactionToSignResponse
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

CALLCONTRACTFUNCTION200RESPONSEALLOFRESULT_ONE_OF_SCHEMAS = ["MethodCallResponse", "TransactionToSignResponse"]

class CallContractFunction200ResponseAllOfResult(BaseModel):
    """
    CallContractFunction200ResponseAllOfResult
    """
    # data type: TransactionToSignResponse
    oneof_schema_1_validator: Optional[TransactionToSignResponse] = None
    # data type: MethodCallResponse
    oneof_schema_2_validator: Optional[MethodCallResponse] = None
    actual_instance: Optional[Union[MethodCallResponse, TransactionToSignResponse]] = None
    one_of_schemas: Set[str] = { "MethodCallResponse", "TransactionToSignResponse" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = CallContractFunction200ResponseAllOfResult.model_construct()
        error_messages = []
        match = 0
        # validate data type: TransactionToSignResponse
        if not isinstance(v, TransactionToSignResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TransactionToSignResponse`")
        else:
            match += 1
        # validate data type: MethodCallResponse
        if not isinstance(v, MethodCallResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MethodCallResponse`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in CallContractFunction200ResponseAllOfResult with oneOf schemas: MethodCallResponse, TransactionToSignResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in CallContractFunction200ResponseAllOfResult with oneOf schemas: MethodCallResponse, TransactionToSignResponse. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into TransactionToSignResponse
        try:
            instance.actual_instance = TransactionToSignResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MethodCallResponse
        try:
            instance.actual_instance = MethodCallResponse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into CallContractFunction200ResponseAllOfResult with oneOf schemas: MethodCallResponse, TransactionToSignResponse. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CallContractFunction200ResponseAllOfResult with oneOf schemas: MethodCallResponse, TransactionToSignResponse. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], MethodCallResponse, TransactionToSignResponse]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


