# coding: utf-8

"""
    MultiBaas API

    MultiBaas API provides a unified interface for interacting with blockchain networks. It enables applications to deploy and manage smart contracts, call contract methods, and query blockchain data through standard REST endpoints. The API also includes features for authentication, role-based access control, and integration with existing systems, allowing developers to build blockchain-powered applications without needing deep protocol-level expertise.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from multibaas_sdk.models.contract_abi_type import ContractABIType
from multibaas_sdk.models.contract_abi_type_conversion import ContractABITypeConversion
from typing import Optional, Set
from typing_extensions import Self

class ContractABIMethodArgument(BaseModel):
    """
    A contract function argument.
    """ # noqa: E501
    name: StrictStr
    type: ContractABIType
    type_name: StrictStr = Field(alias="typeName")
    type_conversion: Optional[ContractABITypeConversion] = Field(alias="typeConversion")
    notes: StrictStr
    __properties: ClassVar[List[str]] = ["name", "type", "typeName", "typeConversion", "notes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContractABIMethodArgument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type_conversion
        if self.type_conversion:
            _dict['typeConversion'] = self.type_conversion.to_dict()
        # set to None if type_conversion (nullable) is None
        # and model_fields_set contains the field
        if self.type_conversion is None and "type_conversion" in self.model_fields_set:
            _dict['typeConversion'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContractABIMethodArgument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "type": ContractABIType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "typeName": obj.get("typeName"),
            "typeConversion": ContractABITypeConversion.from_dict(obj["typeConversion"]) if obj.get("typeConversion") is not None else None,
            "notes": obj.get("notes")
        })
        return _obj


