# coding: utf-8

"""
    MultiBaas API

    MultiBaas API provides a unified interface for interacting with blockchain networks. It enables applications to deploy and manage smart contracts, call contract methods, and query blockchain data through standard REST endpoints. The API also includes features for authentication, role-based access control, and integration with existing systems, allowing developers to build blockchain-powered applications without needing deep protocol-level expertise.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class EventMonitorStatus(BaseModel):
    """
    Status of an Event Monitor
    """ # noqa: E501
    contract_id: Optional[StrictInt] = Field(default=None, alias="contractId")
    address_id: Optional[StrictInt] = Field(default=None, alias="addressId")
    is_processing_past_logs: StrictBool = Field(alias="isProcessingPastLogs")
    ideal_block_range: Optional[StrictInt] = Field(default=None, alias="idealBlockRange")
    latest_block_number: StrictInt = Field(alias="latestBlockNumber")
    latest_block_hash: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="latestBlockHash")
    start_block_number: StrictInt = Field(alias="startBlockNumber")
    start_block_hash: Annotated[str, Field(min_length=66, strict=True, max_length=66)] = Field(description="The keccak256 hash as a hex string of 256 bits.", alias="startBlockHash")
    updated_at: StrictStr = Field(alias="updatedAt")
    __properties: ClassVar[List[str]] = ["contractId", "addressId", "isProcessingPastLogs", "idealBlockRange", "latestBlockNumber", "latestBlockHash", "startBlockNumber", "startBlockHash", "updatedAt"]

    @field_validator('latest_block_hash')
    def latest_block_hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    @field_validator('start_block_hash')
    def start_block_hash_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]{64}|0X[0-9A-F]{64})$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventMonitorStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventMonitorStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "contractId": obj.get("contractId"),
            "addressId": obj.get("addressId"),
            "isProcessingPastLogs": obj.get("isProcessingPastLogs"),
            "idealBlockRange": obj.get("idealBlockRange"),
            "latestBlockNumber": obj.get("latestBlockNumber"),
            "latestBlockHash": obj.get("latestBlockHash"),
            "startBlockNumber": obj.get("startBlockNumber"),
            "startBlockHash": obj.get("startBlockHash"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


