# coding: utf-8

"""
    MultiBaas API

    MultiBaas API provides a unified interface for interacting with blockchain networks. It enables applications to deploy and manage smart contracts, call contract methods, and query blockchain data through standard REST endpoints. The API also includes features for authentication, role-based access control, and integration with existing systems, allowing developers to build blockchain-powered applications without needing deep protocol-level expertise.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from multibaas_sdk.models.field_type import FieldType
from typing import Optional, Set
from typing_extensions import Self

class EventQueryField(BaseModel):
    """
    A single event field's query information.
    """ # noqa: E501
    type: FieldType
    name: Optional[StrictStr] = Field(default=None, description="The field name. Either `name` or `inputIndex` is required if `fieldType == \"input\"`.")
    input_index: Optional[StrictInt] = Field(default=None, description="The field's index, can be used in place of `name`.", alias="inputIndex")
    alias: Optional[StrictStr] = Field(default=None, description="The name that will be used to return the field.")
    aggregator: Optional[StrictStr] = Field(default=None, description="The type of aggregation to perform on the field.")
    __properties: ClassVar[List[str]] = ["type", "name", "inputIndex", "alias", "aggregator"]

    @field_validator('aggregator')
    def aggregator_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['add', 'subtract', 'last', 'first', 'min', 'max']):
            raise ValueError("must be one of enum values ('add', 'subtract', 'last', 'first', 'min', 'max')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventQueryField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if input_index (nullable) is None
        # and model_fields_set contains the field
        if self.input_index is None and "input_index" in self.model_fields_set:
            _dict['inputIndex'] = None

        # set to None if aggregator (nullable) is None
        # and model_fields_set contains the field
        if self.aggregator is None and "aggregator" in self.model_fields_set:
            _dict['aggregator'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventQueryField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "name": obj.get("name"),
            "inputIndex": obj.get("inputIndex"),
            "alias": obj.get("alias"),
            "aggregator": obj.get("aggregator")
        })
        return _obj


