# coding: utf-8

"""
    MultiBaas API

    MultiBaas API provides a unified interface for interacting with blockchain networks. It enables applications to deploy and manage smart contracts, call contract methods, and query blockchain data through standard REST endpoints. The API also includes features for authentication, role-based access control, and integration with existing systems, allowing developers to build blockchain-powered applications without needing deep protocol-level expertise.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from multibaas_sdk.models.hsm_sign_request_personal_sign_chain_id import HSMSignRequestPersonalSignChainId
from typing import Optional, Set
from typing_extensions import Self

class HSMSignRequestPersonalSign(BaseModel):
    """
    Request to sign a message using a cloud wallet.
    """ # noqa: E501
    method: StrictStr = Field(description="The signing method to use.")
    address: Annotated[str, Field(strict=True)] = Field(description="An ethereum address.")
    data: Annotated[str, Field(strict=True)] = Field(description="A hex string.")
    chain_id: Optional[HSMSignRequestPersonalSignChainId] = Field(default=None, alias="chainId")
    __properties: ClassVar[List[str]] = ["method", "address", "data", "chainId"]

    @field_validator('address')
    def address_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^0[xX][a-fA-F0-9]{40}$", value):
            raise ValueError(r"must validate the regular expression /^0[xX][a-fA-F0-9]{40}$/")
        return value

    @field_validator('data')
    def data_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(0x[0-9a-f]*|0X[0-9A-F]*)$", value):
            raise ValueError(r"must validate the regular expression /^(0x[0-9a-f]*|0X[0-9A-F]*)$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HSMSignRequestPersonalSign from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chain_id
        if self.chain_id:
            _dict['chainId'] = self.chain_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HSMSignRequestPersonalSign from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "method": obj.get("method"),
            "address": obj.get("address"),
            "data": obj.get("data"),
            "chainId": HSMSignRequestPersonalSignChainId.from_dict(obj["chainId"]) if obj.get("chainId") is not None else None
        })
        return _obj


