# coding: utf-8

"""
    MultiBaas API

    MultiBaas API provides a unified interface for interacting with blockchain networks. It enables applications to deploy and manage smart contracts, call contract methods, and query blockchain data through standard REST endpoints. The API also includes features for authentication, role-based access control, and integration with existing systems, allowing developers to build blockchain-powered applications without needing deep protocol-level expertise.

    The version of the OpenAPI document: 0.0
    Contact: contact@curvegrid.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class PostMethodArgs(BaseModel):
    """
    Arguments to be passed into a contract function.
    """ # noqa: E501
    signature: Optional[StrictStr] = None
    args: Optional[List[Any]] = Field(default=None, description="List of the function arguments.")
    var_from: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="An Ethereum address (0x prefixed hex) or an address alias.", alias="from")
    nonce: Optional[StrictInt] = Field(default=None, description="Nonce to use for the transaction execution.")
    gas_price: Optional[StrictInt] = Field(default=None, description="Gas price to use for the transaction execution.", alias="gasPrice")
    gas_fee_cap: Optional[StrictInt] = Field(default=None, description="Gas fee cap to use for the 1559 transaction execution.", alias="gasFeeCap")
    gas_tip_cap: Optional[StrictInt] = Field(default=None, description="Gas priority fee cap to use for the 1559 transaction execution.", alias="gasTipCap")
    gas: Optional[StrictInt] = Field(default=None, description="Gas limit to set for the transaction execution.")
    to: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="An Ethereum address (0x prefixed hex) or an address alias.")
    value: Optional[StrictStr] = Field(default=None, description="Amount (in wei) to send with the transaction.")
    sign_and_submit: Optional[StrictBool] = Field(default=False, description="If the `from` address is an HSM address and this flag is set to `true`, the transaction will be automatically signed and submitted to the blockchain.", alias="signAndSubmit")
    nonce_management: Optional[StrictBool] = Field(default=False, description="If the `from` address is an HSM address and this flag is set to `true`, MultiBaas will keep track of the nonce and set it accordingly. This is particularly useful when submitting multiple transactions concurrently or in a very short period of time. If this flag is set to `true` and a `nonce` is provided, it will reset the nonce tracker to the given nonce (useful if the nonce tracker is out of sync).", alias="nonceManagement")
    pre_eip1559: Optional[StrictBool] = Field(default=False, description="If set to `true`, forces a legacy type transaction. Otherwise an EIP-1559 transaction will created if the network supports it.", alias="preEIP1559")
    signer: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="An Ethereum address (0x prefixed hex) or an address alias.")
    format_ints: Optional[StrictStr] = Field(default='auto', description="Mode to format integer outputs in the function call's responses. There are 3 possible modes:   - `auto` (the default option), where number format is decided by its type:     - If the type has size at most 32 bits, then the number is returned verbatim.     - If the type has size larger than 32 bits, then the number is returned as a string.   - `as_numbers`, where all numbers are returned verbatim.   - `as_strings`, where all numbers are returned as strings. ", alias="formatInts")
    timestamp: Optional[StrictStr] = Field(default=None, description="Call the function at a specific timestamp. Only available for read functions calls and if the `historical_blocks_feature` is enabled (see the plan endpoint). Mutually exclusive with the `blockNumber` parameter.")
    block_number: Optional[StrictStr] = Field(default=None, description="Call the function at a specific block. Only available for read functions calls and if the `historical_blocks_feature` is enabled (see the plan endpoint). Mutually exclusive with the `timestamp` parameter.", alias="blockNumber")
    contract_override: Optional[StrictBool] = Field(default=None, description="If set to true the given address and contract don't need to be linked for the function to be called.", alias="contractOverride")
    __properties: ClassVar[List[str]] = ["signature", "args", "from", "nonce", "gasPrice", "gasFeeCap", "gasTipCap", "gas", "to", "value", "signAndSubmit", "nonceManagement", "preEIP1559", "signer", "formatInts", "timestamp", "blockNumber", "contractOverride"]

    @field_validator('var_from')
    def var_from_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(:?0[xX][a-fA-F0-9]{40}|[a-z1-9_-][a-z0-9_-]*|0(?:[a-wyz0-9_-][a-z0-9_-]*)?)$", value):
            raise ValueError(r"must validate the regular expression /^(:?0[xX][a-fA-F0-9]{40}|[a-z1-9_-][a-z0-9_-]*|0(?:[a-wyz0-9_-][a-z0-9_-]*)?)$/")
        return value

    @field_validator('to')
    def to_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(:?0[xX][a-fA-F0-9]{40}|[a-z1-9_-][a-z0-9_-]*|0(?:[a-wyz0-9_-][a-z0-9_-]*)?)$", value):
            raise ValueError(r"must validate the regular expression /^(:?0[xX][a-fA-F0-9]{40}|[a-z1-9_-][a-z0-9_-]*|0(?:[a-wyz0-9_-][a-z0-9_-]*)?)$/")
        return value

    @field_validator('signer')
    def signer_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(:?0[xX][a-fA-F0-9]{40}|[a-z1-9_-][a-z0-9_-]*|0(?:[a-wyz0-9_-][a-z0-9_-]*)?)$", value):
            raise ValueError(r"must validate the regular expression /^(:?0[xX][a-fA-F0-9]{40}|[a-z1-9_-][a-z0-9_-]*|0(?:[a-wyz0-9_-][a-z0-9_-]*)?)$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostMethodArgs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostMethodArgs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "signature": obj.get("signature"),
            "args": obj.get("args"),
            "from": obj.get("from"),
            "nonce": obj.get("nonce"),
            "gasPrice": obj.get("gasPrice"),
            "gasFeeCap": obj.get("gasFeeCap"),
            "gasTipCap": obj.get("gasTipCap"),
            "gas": obj.get("gas"),
            "to": obj.get("to"),
            "value": obj.get("value"),
            "signAndSubmit": obj.get("signAndSubmit") if obj.get("signAndSubmit") is not None else False,
            "nonceManagement": obj.get("nonceManagement") if obj.get("nonceManagement") is not None else False,
            "preEIP1559": obj.get("preEIP1559") if obj.get("preEIP1559") is not None else False,
            "signer": obj.get("signer"),
            "formatInts": obj.get("formatInts") if obj.get("formatInts") is not None else 'auto',
            "timestamp": obj.get("timestamp"),
            "blockNumber": obj.get("blockNumber"),
            "contractOverride": obj.get("contractOverride")
        })
        return _obj


