# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AgentServiceArgs', 'AgentService']

@pulumi.input_type
class AgentServiceArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AgentService resource.
        :param pulumi.Input[_builtins.str] address: The address of the service. Defaults to the
               address of the agent.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.int] port: The port of the service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of values that are opaque to Consul,
               but can be used to distinguish between services or nodes.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the service. Defaults to the
        address of the agent.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the service.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of values that are opaque to Consul,
        but can be used to distinguish between services or nodes.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AgentServiceState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AgentService resources.
        :param pulumi.Input[_builtins.str] address: The address of the service. Defaults to the
               address of the agent.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.int] port: The port of the service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of values that are opaque to Consul,
               but can be used to distinguish between services or nodes.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the service. Defaults to the
        address of the agent.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the service.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of values that are opaque to Consul,
        but can be used to distinguish between services or nodes.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("consul:index/agentService:AgentService")
class AgentService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        !> The `AgentService` resource has been deprecated in version 2.0.0 of the provider
        and will be removed in a future release. Please read the [upgrade guide](https://www.terraform.io/docs/providers/consul/guides/upgrading.html#deprecation-of-consul_agent_service)
        for more information.

        Provides access to the agent service data in Consul. This can be used to
        define a service associated with a particular agent. Currently, defining
        health checks for an agent service is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        app = consul.AgentService("app",
            address="www.google.com",
            name="google",
            port=80,
            tags=[
                "tag0",
                "tag1",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The address of the service. Defaults to the
               address of the agent.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.int] port: The port of the service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of values that are opaque to Consul,
               but can be used to distinguish between services or nodes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AgentServiceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> The `AgentService` resource has been deprecated in version 2.0.0 of the provider
        and will be removed in a future release. Please read the [upgrade guide](https://www.terraform.io/docs/providers/consul/guides/upgrading.html#deprecation-of-consul_agent_service)
        for more information.

        Provides access to the agent service data in Consul. This can be used to
        define a service associated with a particular agent. Currently, defining
        health checks for an agent service is not supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        app = consul.AgentService("app",
            address="www.google.com",
            name="google",
            port=80,
            tags=[
                "tag0",
                "tag1",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param AgentServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentServiceArgs.__new__(AgentServiceArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["name"] = name
            __props__.__dict__["port"] = port
            __props__.__dict__["tags"] = tags
        super(AgentService, __self__).__init__(
            'consul:index/agentService:AgentService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AgentService':
        """
        Get an existing AgentService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The address of the service. Defaults to the
               address of the agent.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.int] port: The port of the service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of values that are opaque to Consul,
               but can be used to distinguish between services or nodes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentServiceState.__new__(_AgentServiceState)

        __props__.__dict__["address"] = address
        __props__.__dict__["name"] = name
        __props__.__dict__["port"] = port
        __props__.__dict__["tags"] = tags
        return AgentService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The address of the service. Defaults to the
        address of the agent.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The port of the service.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of values that are opaque to Consul,
        but can be used to distinguish between services or nodes.
        """
        return pulumi.get(self, "tags")

