# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceHealthResult',
    'AwaitableGetServiceHealthResult',
    'get_service_health',
    'get_service_health_output',
]

@pulumi.output_type
class GetServiceHealthResult:
    """
    A collection of values returned by getServiceHealth.
    """
    def __init__(__self__, datacenter=None, filter=None, id=None, name=None, near=None, node_meta=None, passing=None, results=None, tag=None, wait_for=None):
        if datacenter and not isinstance(datacenter, str):
            raise TypeError("Expected argument 'datacenter' to be a str")
        pulumi.set(__self__, "datacenter", datacenter)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if near and not isinstance(near, str):
            raise TypeError("Expected argument 'near' to be a str")
        pulumi.set(__self__, "near", near)
        if node_meta and not isinstance(node_meta, dict):
            raise TypeError("Expected argument 'node_meta' to be a dict")
        pulumi.set(__self__, "node_meta", node_meta)
        if passing and not isinstance(passing, bool):
            raise TypeError("Expected argument 'passing' to be a bool")
        pulumi.set(__self__, "passing", passing)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if wait_for and not isinstance(wait_for, str):
            raise TypeError("Expected argument 'wait_for' to be a str")
        pulumi.set(__self__, "wait_for", wait_for)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[_builtins.str]:
        """
        The datacenter in which the node is running.
        * [`tagged_addresses`](https://www.consul.io/docs/agent/http/catalog.html#TaggedAddresses) -
        List of explicit LAN and WAN IP addresses for the agent.
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this health-check.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def near(self) -> Optional[_builtins.str]:
        """
        The node to which the result must be sorted to.
        """
        return pulumi.get(self, "near")

    @_builtins.property
    @pulumi.getter(name="nodeMeta")
    def node_meta(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The list of metadata to filter the nodes.
        """
        return pulumi.get(self, "node_meta")

    @_builtins.property
    @pulumi.getter
    def passing(self) -> Optional[_builtins.bool]:
        """
        Whether to return only nodes with all checks in the
        passing state.
        """
        return pulumi.get(self, "passing")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetServiceHealthResultResult']:
        """
        A list of entries and details about each endpoint advertising a
        service.  Each element in the list has three attributes: `node`, `service` and
        `checks`.  The list of the attributes of each one is detailed below.
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        The name of the tag used to filter the list.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "wait_for")


class AwaitableGetServiceHealthResult(GetServiceHealthResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceHealthResult(
            datacenter=self.datacenter,
            filter=self.filter,
            id=self.id,
            name=self.name,
            near=self.near,
            node_meta=self.node_meta,
            passing=self.passing,
            results=self.results,
            tag=self.tag,
            wait_for=self.wait_for)


def get_service_health(datacenter: Optional[_builtins.str] = None,
                       filter: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       near: Optional[_builtins.str] = None,
                       node_meta: Optional[Mapping[str, _builtins.str]] = None,
                       passing: Optional[_builtins.bool] = None,
                       tag: Optional[_builtins.str] = None,
                       wait_for: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceHealthResult:
    """
    `get_service_health` can be used to get the list of the instances that
    are currently healthy, according to their associated  health-checks.
    The result includes the list of service instances, the node associated to each
    instance and its health-checks.

    This resource is likely to change as frequently as the health-checks are being
    updated, you should expect different results in a frequent basis.


    :param _builtins.str datacenter: The Consul datacenter to query.
    :param _builtins.str filter: A filter expression to refine the list of results, see
           https://www.consul.io/api-docs/features/filtering and https://www.consul.io/api-docs/health#filtering-2.
    :param _builtins.str name: The service name to select.
    :param _builtins.str near: Specifies a node name to sort the node list in ascending order
           based on the estimated round trip time from that node.
    :param Mapping[str, _builtins.str] node_meta: Filter the results to nodes with the specified key/value
           pairs.
    :param _builtins.bool passing: Whether to return only nodes with all checks in the
           passing state. Defaults to `true`.
    :param _builtins.str tag: A single tag that can be used to filter the list to return
           based on a single matching tag.
    """
    __args__ = dict()
    __args__['datacenter'] = datacenter
    __args__['filter'] = filter
    __args__['name'] = name
    __args__['near'] = near
    __args__['nodeMeta'] = node_meta
    __args__['passing'] = passing
    __args__['tag'] = tag
    __args__['waitFor'] = wait_for
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getServiceHealth:getServiceHealth', __args__, opts=opts, typ=GetServiceHealthResult).value

    return AwaitableGetServiceHealthResult(
        datacenter=pulumi.get(__ret__, 'datacenter'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        near=pulumi.get(__ret__, 'near'),
        node_meta=pulumi.get(__ret__, 'node_meta'),
        passing=pulumi.get(__ret__, 'passing'),
        results=pulumi.get(__ret__, 'results'),
        tag=pulumi.get(__ret__, 'tag'),
        wait_for=pulumi.get(__ret__, 'wait_for'))
def get_service_health_output(datacenter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              name: Optional[pulumi.Input[_builtins.str]] = None,
                              near: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              node_meta: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                              passing: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              tag: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              wait_for: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceHealthResult]:
    """
    `get_service_health` can be used to get the list of the instances that
    are currently healthy, according to their associated  health-checks.
    The result includes the list of service instances, the node associated to each
    instance and its health-checks.

    This resource is likely to change as frequently as the health-checks are being
    updated, you should expect different results in a frequent basis.


    :param _builtins.str datacenter: The Consul datacenter to query.
    :param _builtins.str filter: A filter expression to refine the list of results, see
           https://www.consul.io/api-docs/features/filtering and https://www.consul.io/api-docs/health#filtering-2.
    :param _builtins.str name: The service name to select.
    :param _builtins.str near: Specifies a node name to sort the node list in ascending order
           based on the estimated round trip time from that node.
    :param Mapping[str, _builtins.str] node_meta: Filter the results to nodes with the specified key/value
           pairs.
    :param _builtins.bool passing: Whether to return only nodes with all checks in the
           passing state. Defaults to `true`.
    :param _builtins.str tag: A single tag that can be used to filter the list to return
           based on a single matching tag.
    """
    __args__ = dict()
    __args__['datacenter'] = datacenter
    __args__['filter'] = filter
    __args__['name'] = name
    __args__['near'] = near
    __args__['nodeMeta'] = node_meta
    __args__['passing'] = passing
    __args__['tag'] = tag
    __args__['waitFor'] = wait_for
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('consul:index/getServiceHealth:getServiceHealth', __args__, opts=opts, typ=GetServiceHealthResult)
    return __ret__.apply(lambda __response__: GetServiceHealthResult(
        datacenter=pulumi.get(__response__, 'datacenter'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        near=pulumi.get(__response__, 'near'),
        node_meta=pulumi.get(__response__, 'node_meta'),
        passing=pulumi.get(__response__, 'passing'),
        results=pulumi.get(__response__, 'results'),
        tag=pulumi.get(__response__, 'tag'),
        wait_for=pulumi.get(__response__, 'wait_for')))
